-- All In One WP Security & Firewall 4.4.9
-- MySQL dump
-- 2022-08-24 01:51:28

SET NAMES utf8;
SET foreign_key_checks = 0;

DROP TABLE IF EXISTS `wp_actionscheduler_actions`;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=749 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `wp_actionscheduler_claims`;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=12668 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `wp_actionscheduler_groups`;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_actionscheduler_groups` VALUES("1","action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2","wp_mail_smtp");


DROP TABLE IF EXISTS `wp_actionscheduler_logs`;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=118 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `wp_aiowps_events`;

CREATE TABLE `wp_aiowps_events` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `event_type` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `event_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `ip_or_host` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `referer_info` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `country_code` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `event_data` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `wp_aiowps_failed_logins`;

CREATE TABLE `wp_aiowps_failed_logins` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `failed_login_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `login_attempt_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_aiowps_failed_logins` VALUES("1","1","amrelarabi","2021-08-29 07:21:56","197.63.144.217");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2","1","amrelarabi","2021-08-29 07:30:18","197.63.144.217");


DROP TABLE IF EXISTS `wp_aiowps_global_meta`;

CREATE TABLE `wp_aiowps_global_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_time` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `meta_key1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key3` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key4` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key5` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value2` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value3` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value4` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value5` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `wp_aiowps_login_activity`;

CREATE TABLE `wp_aiowps_login_activity` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `login_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `logout_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `login_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `login_country` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `browser_type` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_aiowps_login_activity` VALUES("1","1","amrelarabi","2021-11-16 01:59:06","1000-10-10 10:00:00","102.40.26.15","","");
INSERT INTO `wp_aiowps_login_activity` VALUES("2","1","amrelarabi","2022-01-04 15:23:26","1000-10-10 10:00:00","41.44.92.194","","");


DROP TABLE IF EXISTS `wp_aiowps_login_lockdown`;

CREATE TABLE `wp_aiowps_login_lockdown` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `lockdown_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `release_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `failed_login_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `lock_reason` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `unlock_key` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `wp_aiowps_permanent_block`;

CREATE TABLE `wp_aiowps_permanent_block` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `blocked_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `block_reason` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `country_origin` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `blocked_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `unblock` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `wp_commentmeta`;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `wp_comments`;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `wp_links`;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `wp_litespeed_url`;

CREATE TABLE `wp_litespeed_url` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cache_tags` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`(191)),
  KEY `cache_tags` (`cache_tags`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS `wp_litespeed_url_file`;

CREATE TABLE `wp_litespeed_url_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url_id` bigint(20) NOT NULL,
  `vary` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of final vary',
  `filename` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of file content',
  `type` tinyint(4) NOT NULL COMMENT 'css=1,js=2,ccss=3,ucss=4',
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `type` (`type`),
  KEY `url_id_2` (`url_id`,`vary`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS `wp_options`;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=20720 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_options` VALUES("1","siteurl","https://amrelarabi.com","yes");
INSERT INTO `wp_options` VALUES("2","home","https://amrelarabi.com","yes");
INSERT INTO `wp_options` VALUES("3","blogname","Amr Elarabi","yes");
INSERT INTO `wp_options` VALUES("4","blogdescription","","yes");
INSERT INTO `wp_options` VALUES("5","users_can_register","0","yes");
INSERT INTO `wp_options` VALUES("6","admin_email","amr.elarabi.egy@gmail.com","yes");
INSERT INTO `wp_options` VALUES("7","start_of_week","1","yes");
INSERT INTO `wp_options` VALUES("8","use_balanceTags","0","yes");
INSERT INTO `wp_options` VALUES("9","use_smilies","1","yes");
INSERT INTO `wp_options` VALUES("10","require_name_email","1","yes");
INSERT INTO `wp_options` VALUES("11","comments_notify","1","yes");
INSERT INTO `wp_options` VALUES("12","posts_per_rss","10","yes");
INSERT INTO `wp_options` VALUES("13","rss_use_excerpt","0","yes");
INSERT INTO `wp_options` VALUES("14","mailserver_url","mail.example.com","yes");
INSERT INTO `wp_options` VALUES("15","mailserver_login","login@example.com","yes");
INSERT INTO `wp_options` VALUES("16","mailserver_pass","password","yes");
INSERT INTO `wp_options` VALUES("17","mailserver_port","110","yes");
INSERT INTO `wp_options` VALUES("18","default_category","1","yes");
INSERT INTO `wp_options` VALUES("19","default_comment_status","open","yes");
INSERT INTO `wp_options` VALUES("20","default_ping_status","open","yes");
INSERT INTO `wp_options` VALUES("21","default_pingback_flag","1","yes");
INSERT INTO `wp_options` VALUES("22","posts_per_page","10","yes");
INSERT INTO `wp_options` VALUES("23","date_format","F j, Y","yes");
INSERT INTO `wp_options` VALUES("24","time_format","g:i a","yes");
INSERT INTO `wp_options` VALUES("25","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO `wp_options` VALUES("26","comment_moderation","0","yes");
INSERT INTO `wp_options` VALUES("27","moderation_notify","1","yes");
INSERT INTO `wp_options` VALUES("28","permalink_structure","/%postname%/","yes");
INSERT INTO `wp_options` VALUES("30","hack_file","0","yes");
INSERT INTO `wp_options` VALUES("31","blog_charset","UTF-8","yes");
INSERT INTO `wp_options` VALUES("32","moderation_keys","","no");
INSERT INTO `wp_options` VALUES("33","active_plugins","a:12:{i:0;s:19:\"akismet/akismet.php\";i:1;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:2;s:47:\"better-search-replace/better-search-replace.php\";i:3;s:29:\"cocobasic-elementor/index.php\";i:4;s:43:\"cocobasic-shortcode/cocobasic-shortcode.php\";i:5;s:36:\"contact-form-7/wp-contact-form-7.php\";i:6;s:23:\"elementor/elementor.php\";i:7;s:35:\"litespeed-cache/litespeed-cache.php\";i:8;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";i:9;s:41:\"wordpress-importer/wordpress-importer.php\";i:10;s:24:\"wordpress-seo/wp-seo.php\";i:11;s:29:\"wp-mail-smtp/wp_mail_smtp.php\";}","yes");
INSERT INTO `wp_options` VALUES("34","category_base","","yes");
INSERT INTO `wp_options` VALUES("35","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO `wp_options` VALUES("36","comment_max_links","2","yes");
INSERT INTO `wp_options` VALUES("37","gmt_offset","0","yes");
INSERT INTO `wp_options` VALUES("38","default_email_category","1","yes");
INSERT INTO `wp_options` VALUES("39","recently_edited","a:2:{i:0;s:66:\"/home/motwzkdp/amrelarabi.tech/wp-content/themes/resumee/style.css\";i:2;s:0:\"\";}","no");
INSERT INTO `wp_options` VALUES("40","template","teoro-wp","yes");
INSERT INTO `wp_options` VALUES("41","stylesheet","teoro-wp","yes");
INSERT INTO `wp_options` VALUES("42","comment_registration","0","yes");
INSERT INTO `wp_options` VALUES("43","html_type","text/html","yes");
INSERT INTO `wp_options` VALUES("44","use_trackback","0","yes");
INSERT INTO `wp_options` VALUES("45","default_role","subscriber","yes");
INSERT INTO `wp_options` VALUES("46","db_version","49752","yes");
INSERT INTO `wp_options` VALUES("47","uploads_use_yearmonth_folders","1","yes");
INSERT INTO `wp_options` VALUES("48","upload_path","","yes");
INSERT INTO `wp_options` VALUES("49","blog_public","1","yes");
INSERT INTO `wp_options` VALUES("50","default_link_category","2","yes");
INSERT INTO `wp_options` VALUES("51","show_on_front","page","yes");
INSERT INTO `wp_options` VALUES("52","tag_base","","yes");
INSERT INTO `wp_options` VALUES("53","show_avatars","1","yes");
INSERT INTO `wp_options` VALUES("54","avatar_rating","G","yes");
INSERT INTO `wp_options` VALUES("55","upload_url_path","","yes");
INSERT INTO `wp_options` VALUES("56","thumbnail_size_w","150","yes");
INSERT INTO `wp_options` VALUES("57","thumbnail_size_h","150","yes");
INSERT INTO `wp_options` VALUES("58","thumbnail_crop","1","yes");
INSERT INTO `wp_options` VALUES("59","medium_size_w","300","yes");
INSERT INTO `wp_options` VALUES("60","medium_size_h","300","yes");
INSERT INTO `wp_options` VALUES("61","avatar_default","mystery","yes");
INSERT INTO `wp_options` VALUES("62","large_size_w","1024","yes");
INSERT INTO `wp_options` VALUES("63","large_size_h","1024","yes");
INSERT INTO `wp_options` VALUES("64","image_default_link_type","none","yes");
INSERT INTO `wp_options` VALUES("65","image_default_size","","yes");
INSERT INTO `wp_options` VALUES("66","image_default_align","","yes");
INSERT INTO `wp_options` VALUES("67","close_comments_for_old_posts","0","yes");
INSERT INTO `wp_options` VALUES("68","close_comments_days_old","14","yes");
INSERT INTO `wp_options` VALUES("69","thread_comments","1","yes");
INSERT INTO `wp_options` VALUES("70","thread_comments_depth","5","yes");
INSERT INTO `wp_options` VALUES("71","page_comments","0","yes");
INSERT INTO `wp_options` VALUES("72","comments_per_page","50","yes");
INSERT INTO `wp_options` VALUES("73","default_comments_page","newest","yes");
INSERT INTO `wp_options` VALUES("74","comment_order","asc","yes");
INSERT INTO `wp_options` VALUES("75","sticky_posts","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("76","widget_categories","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("77","widget_text","a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("78","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("79","uninstall_plugins","a:2:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";}","no");
INSERT INTO `wp_options` VALUES("80","timezone_string","","yes");
INSERT INTO `wp_options` VALUES("81","page_for_posts","216","yes");
INSERT INTO `wp_options` VALUES("82","page_on_front","181","yes");
INSERT INTO `wp_options` VALUES("83","default_post_format","0","yes");
INSERT INTO `wp_options` VALUES("84","link_manager_enabled","0","yes");
INSERT INTO `wp_options` VALUES("85","finished_splitting_shared_terms","1","yes");
INSERT INTO `wp_options` VALUES("86","site_icon","593","yes");
INSERT INTO `wp_options` VALUES("87","medium_large_size_w","768","yes");
INSERT INTO `wp_options` VALUES("88","medium_large_size_h","0","yes");
INSERT INTO `wp_options` VALUES("89","wp_page_for_privacy_policy","3","yes");
INSERT INTO `wp_options` VALUES("90","show_comments_cookies_opt_in","1","yes");
INSERT INTO `wp_options` VALUES("91","admin_email_lifespan","1652579949","yes");
INSERT INTO `wp_options` VALUES("92","disallowed_keys","","no");
INSERT INTO `wp_options` VALUES("93","comment_previously_approved","1","yes");
INSERT INTO `wp_options` VALUES("94","auto_plugin_theme_update_emails","a:0:{}","no");
INSERT INTO `wp_options` VALUES("95","initial_db_version","48748","yes");
INSERT INTO `wp_options` VALUES("96","wp_user_roles","a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:62:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}","yes");
INSERT INTO `wp_options` VALUES("97","fresh_site","0","yes");
INSERT INTO `wp_options` VALUES("98","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("99","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("100","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("101","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("102","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("103","sidebars_widgets","a:3:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:6:\"text-2\";}s:14:\"footer-sidebar\";a:1:{i:0;s:7:\"pages-2\";}s:13:\"array_version\";i:3;}","yes");
INSERT INTO `wp_options` VALUES("220","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:25:\"amr.elarabi.egy@gmail.com\";s:7:\"version\";s:5:\"5.8.4\";s:9:\"timestamp\";i:1647002954;}","no");
INSERT INTO `wp_options` VALUES("104","cron","a:14:{i:1661305934;a:4:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}s:27:\"litespeed_task_imgoptm_pull\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}s:19:\"litespeed_task_ccss\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}s:19:\"litespeed_task_lqip\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1661306372;a:1:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1661308812;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1661309367;a:1:{s:24:\"aiowps_hourly_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1661334920;a:2:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1661337612;a:4:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1661337621;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1661337622;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1661338167;a:1:{s:23:\"aiowps_daily_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1661350522;a:1:{s:24:\"akismet_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1661365007;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1661594120;a:1:{s:16:\"wpseo_ryte_fetch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1661596812;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO `wp_options` VALUES("105","widget_pages","a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:6:\"sortby\";s:2:\"ID\";s:7:\"exclude\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("106","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("107","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("108","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("109","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("110","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("111","nonce_key","dFa !f:db$]{5Lr?Q<F|633^{@v <5RNaS|Z4FQ)GOr+bSEFIbz.Z$1AvR|rFOu#","no");
INSERT INTO `wp_options` VALUES("112","nonce_salt","=a~N*M7|v,=aKC2,vge4Rqwod(f;=*nO:t/,t3y+NKR.vWG$i;a}3*f#m)k%gr+:","no");
INSERT INTO `wp_options` VALUES("113","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("114","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("115","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("124","theme_mods_twentytwenty","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1604080491;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}","yes");
INSERT INTO `wp_options` VALUES("117","recovery_keys","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("227","_transient_health-check-site-status-result","{\"good\":15,\"recommended\":5,\"critical\":0}","yes");
INSERT INTO `wp_options` VALUES("151","recently_activated","a:1:{s:67:\"real-time-auto-find-and-replace/real-time-auto-find-and-replace.php\";i:1641310023;}","yes");
INSERT INTO `wp_options` VALUES("152","rlrsssl_options","a:16:{s:12:\"site_has_ssl\";b:1;s:4:\"hsts\";b:0;s:22:\"htaccess_warning_shown\";b:0;s:19:\"review_notice_shown\";b:1;s:25:\"ssl_success_message_shown\";b:1;s:26:\"autoreplace_insecure_links\";b:1;s:17:\"plugin_db_version\";s:5:\"5.1.3\";s:20:\"do_not_edit_htaccess\";b:0;s:17:\"htaccess_redirect\";b:1;s:11:\"ssl_enabled\";b:1;s:19:\"javascript_redirect\";b:0;s:11:\"wp_redirect\";b:1;s:31:\"switch_mixed_content_fixer_hook\";b:0;s:19:\"dismiss_all_notices\";b:0;s:13:\"high_contrast\";b:0;s:21:\"dismiss_review_notice\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("161","widget_akismet_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("165","akismet_strictness","0","yes");
INSERT INTO `wp_options` VALUES("166","akismet_show_user_comments_approved","0","yes");
INSERT INTO `wp_options` VALUES("167","akismet_comment_form_privacy_notice","hide","yes");
INSERT INTO `wp_options` VALUES("168","wordpress_api_key","ab89090f962d","yes");
INSERT INTO `wp_options` VALUES("175","secure_auth_key","_4Q`Un1~n$.|!^2g.e,a0]>3q@JV6~GVCcZ2>lpM838{(45AY9C77-vs+k;tE%NC","no");
INSERT INTO `wp_options` VALUES("170","akismet_spam_count","4","yes");
INSERT INTO `wp_options` VALUES("20714","_site_transient_timeout_theme_roots","1661298483","no");
INSERT INTO `wp_options` VALUES("20715","_site_transient_theme_roots","a:6:{s:14:\"teoro-wp-child\";s:7:\"/themes\";s:8:\"teoro-wp\";s:7:\"/themes\";s:14:\"twentynineteen\";s:7:\"/themes\";s:15:\"twentyseventeen\";s:7:\"/themes\";s:12:\"twentytwenty\";s:7:\"/themes\";s:15:\"twentytwentyone\";s:7:\"/themes\";}","no");
INSERT INTO `wp_options` VALUES("13049","wp_mail_smtp_debug_events_db_version","1","yes");
INSERT INTO `wp_options` VALUES("125","auth_key","V`IJ*y:Z^i/n3Gv]G,AIAS]J%{H`M.DgP0neXSA8xQU0_9`+R<Jqk<9wa+0M|vv>","no");
INSERT INTO `wp_options` VALUES("126","auth_salt","3e{`zx>*raEmYUh3zV`Rpiqi5P>vRCc{oXscGd)GFFIeL,Y^rxdS2_9}OEb]pSp ","no");
INSERT INTO `wp_options` VALUES("127","logged_in_key","**ADC<OC${(xeAl86>VC>5c=;%1W&} YEU3ga;nlN@>m_([&Ra~ZMg(&I4?}g)nQ","no");
INSERT INTO `wp_options` VALUES("128","logged_in_salt","fPzWQN1^/o}0;=x=Au.Yd?uF@iLz>[PHeX6$u~>t}?$JAUksLeQIw&kO60rSth0-","no");
INSERT INTO `wp_options` VALUES("158","finished_updating_comment_type","1","yes");
INSERT INTO `wp_options` VALUES("1333","cocobasic_body_background_color","#10141b","yes");
INSERT INTO `wp_options` VALUES("922","wpcf7","a:2:{s:7:\"version\";s:5:\"5.5.2\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1607019407;s:7:\"version\";s:3:\"5.3\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}","yes");
INSERT INTO `wp_options` VALUES("928","elementor_active_kit","10","yes");
INSERT INTO `wp_options` VALUES("929","_elementor_installed_time","1607019440","yes");
INSERT INTO `wp_options` VALUES("925","elementor_version","3.1.4","yes");
INSERT INTO `wp_options` VALUES("926","elementor_install_history","a:4:{s:6:\"3.0.14\";i:1607019422;s:6:\"3.0.15\";i:1609801582;s:5:\"3.1.1\";i:1612537271;s:5:\"3.1.4\";i:1615469931;}","yes");
INSERT INTO `wp_options` VALUES("2726","db_upgraded","","yes");
INSERT INTO `wp_options` VALUES("931","elementor_remote_info_feed_data","a:5:{i:0;a:5:{s:5:\"title\";s:66:\"A Look at Your Favorite Elementor Features and Offerings From 2021\";s:7:\"excerpt\";s:250:\"Back in November, we asked you which of the features or offerings released in 2021 were your favorite. As we reviewed the results we also took the time to reflect on what we’ve done in the past year to see how far we’ve come, let’s take a look.\";s:7:\"created\";i:1641715922;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:132:\"https://elementor.com/blog/your-top-features-offerings-2021/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:41:\"End-of-Year Showcase 2021 — the Winners\";s:7:\"excerpt\";s:189:\"From an initial pool of over 100 hopefuls to a shortlist of 30, we’ve finally arrived at the moment you’ve all been waiting for — announcing the Top 10 Elementor Websites of the Year!\";s:7:\"created\";i:1641387548;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:137:\"https://elementor.com/blog/end-of-year-showcase-2021-the-winners/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:38:\"10 Web Design Trends To Expect in 2022\";s:7:\"excerpt\";s:236:\"2021 was a crazy year to say the least. Let’s pause for a moment to wrap things up and see what the future holds by taking a sneak peek into next year’s top design fads. We’ve selected upcoming 10 trends to spark your imagination.\";s:7:\"created\";i:1640049600;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:117:\"https://elementor.com/blog/web-design-trends/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:3;a:5:{s:5:\"title\";s:35:\"Elementor Websites of November 2021\";s:7:\"excerpt\";s:292:\"Helping us close out the year is a monthly showpiece that demonstrates many of web creation’s finest trends and leading design innovations. It’s time to heat up your beverage of creative ideas and get cozy with these ten delightful websites to round off our last monthly showcase of 2021.\";s:7:\"created\";i:1639996273;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:122:\"https://elementor.com/blog/showcase-november-2021/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:4;a:5:{s:5:\"title\";s:46:\"Welcoming 25 New Page Templates to the Library\";s:7:\"excerpt\";s:272:\"The New Year calls for new beginnings and fresh starts, so we did a little refreshing too. The Library just got 25 new Template Pages to replace some of the older ones. They’re modern, sleek, and everything you’ll be looking for when it’s time to work on new pages. \";s:7:\"created\";i:1639379750;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/new-page-templates-december-21/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}","no");
INSERT INTO `wp_options` VALUES("2729","can_compress_scripts","0","no");
INSERT INTO `wp_options` VALUES("935","elementor_library_category_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("20716","_site_transient_update_themes","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1661296683;s:7:\"checked\";a:6:{s:14:\"teoro-wp-child\";s:0:\"\";s:8:\"teoro-wp\";s:3:\"1.0\";s:14:\"twentynineteen\";s:3:\"1.7\";s:15:\"twentyseventeen\";s:3:\"2.4\";s:12:\"twentytwenty\";s:3:\"1.5\";s:15:\"twentytwentyone\";s:3:\"1.0\";}s:8:\"response\";a:4:{s:14:\"twentynineteen\";a:6:{s:5:\"theme\";s:14:\"twentynineteen\";s:11:\"new_version\";s:3:\"2.3\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentynineteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentynineteen.2.3.zip\";s:8:\"requires\";s:5:\"4.9.6\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:15:\"twentyseventeen\";a:6:{s:5:\"theme\";s:15:\"twentyseventeen\";s:11:\"new_version\";s:3:\"3.0\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentyseventeen/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentyseventeen.3.0.zip\";s:8:\"requires\";s:3:\"4.7\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:12:\"twentytwenty\";a:6:{s:5:\"theme\";s:12:\"twentytwenty\";s:11:\"new_version\";s:3:\"2.0\";s:3:\"url\";s:42:\"https://wordpress.org/themes/twentytwenty/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/twentytwenty.2.0.zip\";s:8:\"requires\";s:3:\"4.7\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:15:\"twentytwentyone\";a:6:{s:5:\"theme\";s:15:\"twentytwentyone\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentyone/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentyone.1.6.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"5.6\";}}s:9:\"no_update\";a:0:{}s:12:\"translations\";a:0:{}}","no");
INSERT INTO `wp_options` VALUES("20717","_site_transient_update_plugins","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1661296683;s:8:\"response\";a:9:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:3:\"5.0\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/akismet.5.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";s:2:\"1x\";s:59:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.0.1\";s:12:\"requires_php\";b:0;}s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:49:\"w.org/plugins/all-in-one-wp-security-and-firewall\";s:4:\"slug\";s:35:\"all-in-one-wp-security-and-firewall\";s:6:\"plugin\";s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";s:11:\"new_version\";s:6:\"4.4.12\";s:3:\"url\";s:66:\"https://wordpress.org/plugins/all-in-one-wp-security-and-firewall/\";s:7:\"package\";s:85:\"https://downloads.wordpress.org/plugin/all-in-one-wp-security-and-firewall.4.4.12.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:88:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/icon-128x128.png?rev=1232826\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:91:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/banner-1544x500.png?rev=1914011\";s:2:\"1x\";s:90:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/banner-772x250.png?rev=1914013\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.0.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:47:\"better-search-replace/better-search-replace.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:35:\"w.org/plugins/better-search-replace\";s:4:\"slug\";s:21:\"better-search-replace\";s:6:\"plugin\";s:47:\"better-search-replace/better-search-replace.php\";s:11:\"new_version\";s:5:\"1.4.1\";s:3:\"url\";s:52:\"https://wordpress.org/plugins/better-search-replace/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/better-search-replace.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/better-search-replace/assets/icon-256x256.png?rev=2706527\";s:2:\"1x\";s:74:\"https://ps.w.org/better-search-replace/assets/icon-128x128.png?rev=2706527\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:77:\"https://ps.w.org/better-search-replace/assets/banner-1544x500.png?rev=2706527\";s:2:\"1x\";s:76:\"https://ps.w.org/better-search-replace/assets/banner-772x250.png?rev=1238934\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"3.0.1\";s:6:\"tested\";s:5:\"6.0.1\";s:12:\"requires_php\";b:0;}s:23:\"elementor/elementor.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:5:\"3.7.2\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.2.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.png?rev=2622511\";s:2:\"1x\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=2597493\";s:3:\"svg\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=2597493\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=2597493\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=2597493\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.0.1\";s:12:\"requires_php\";s:3:\"7.0\";}s:65:\"essential-addons-for-elementor-lite/essential_adons_elementor.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:49:\"w.org/plugins/essential-addons-for-elementor-lite\";s:4:\"slug\";s:35:\"essential-addons-for-elementor-lite\";s:6:\"plugin\";s:65:\"essential-addons-for-elementor-lite/essential_adons_elementor.php\";s:11:\"new_version\";s:5:\"5.2.3\";s:3:\"url\";s:66:\"https://wordpress.org/plugins/essential-addons-for-elementor-lite/\";s:7:\"package\";s:84:\"https://downloads.wordpress.org/plugin/essential-addons-for-elementor-lite.5.2.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:88:\"https://ps.w.org/essential-addons-for-elementor-lite/assets/icon-256x256.png?rev=2598498\";s:2:\"1x\";s:88:\"https://ps.w.org/essential-addons-for-elementor-lite/assets/icon-128x128.png?rev=2598498\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:91:\"https://ps.w.org/essential-addons-for-elementor-lite/assets/banner-1544x500.gif?rev=2771534\";s:2:\"1x\";s:90:\"https://ps.w.org/essential-addons-for-elementor-lite/assets/banner-772x250.gif?rev=2771534\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.0.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:35:\"litespeed-cache/litespeed-cache.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:29:\"w.org/plugins/litespeed-cache\";s:4:\"slug\";s:15:\"litespeed-cache\";s:6:\"plugin\";s:35:\"litespeed-cache/litespeed-cache.php\";s:11:\"new_version\";s:3:\"5.2\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/litespeed-cache/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/litespeed-cache.5.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/litespeed-cache/assets/icon-256x256.png?rev=2554181\";s:2:\"1x\";s:68:\"https://ps.w.org/litespeed-cache/assets/icon-128x128.png?rev=2554181\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/litespeed-cache/assets/banner-1544x500.png?rev=2554181\";s:2:\"1x\";s:70:\"https://ps.w.org/litespeed-cache/assets/banner-772x250.png?rev=2554181\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";s:6:\"tested\";s:5:\"6.0.1\";s:12:\"requires_php\";b:0;}s:61:\"premium-addons-for-elementor/premium-addons-for-elementor.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:42:\"w.org/plugins/premium-addons-for-elementor\";s:4:\"slug\";s:28:\"premium-addons-for-elementor\";s:6:\"plugin\";s:61:\"premium-addons-for-elementor/premium-addons-for-elementor.php\";s:11:\"new_version\";s:6:\"4.9.29\";s:3:\"url\";s:59:\"https://wordpress.org/plugins/premium-addons-for-elementor/\";s:7:\"package\";s:78:\"https://downloads.wordpress.org/plugin/premium-addons-for-elementor.4.9.29.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:81:\"https://ps.w.org/premium-addons-for-elementor/assets/icon-256x256.png?rev=2421900\";s:2:\"1x\";s:73:\"https://ps.w.org/premium-addons-for-elementor/assets/icon.svg?rev=2421900\";s:3:\"svg\";s:73:\"https://ps.w.org/premium-addons-for-elementor/assets/icon.svg?rev=2421900\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:84:\"https://ps.w.org/premium-addons-for-elementor/assets/banner-1544x500.jpg?rev=2628103\";s:2:\"1x\";s:83:\"https://ps.w.org/premium-addons-for-elementor/assets/banner-772x250.jpg?rev=2628103\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.0.1\";s:12:\"requires_php\";s:3:\"5.4\";}s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:31:\"w.org/plugins/really-simple-ssl\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:6:\"plugin\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:11:\"new_version\";s:5:\"5.3.3\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/really-simple-ssl/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/really-simple-ssl.5.3.3.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-128x128.png?rev=1782452\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/really-simple-ssl/assets/banner-1544x500.png?rev=2594863\";s:2:\"1x\";s:72:\"https://ps.w.org/really-simple-ssl/assets/banner-772x250.png?rev=2594863\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";s:6:\"tested\";s:5:\"6.0.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:29:\"wp-mail-smtp/wp_mail_smtp.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:26:\"w.org/plugins/wp-mail-smtp\";s:4:\"slug\";s:12:\"wp-mail-smtp\";s:6:\"plugin\";s:29:\"wp-mail-smtp/wp_mail_smtp.php\";s:11:\"new_version\";s:5:\"3.5.2\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/wp-mail-smtp/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wp-mail-smtp.3.5.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/wp-mail-smtp/assets/icon-256x256.png?rev=1755440\";s:2:\"1x\";s:65:\"https://ps.w.org/wp-mail-smtp/assets/icon-128x128.png?rev=1755440\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/wp-mail-smtp/assets/banner-1544x500.png?rev=2468655\";s:2:\"1x\";s:67:\"https://ps.w.org/wp-mail-smtp/assets/banner-772x250.png?rev=2468655\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.2\";s:6:\"tested\";s:5:\"6.0.1\";s:12:\"requires_php\";s:6:\"5.6.20\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:3:{s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"5.6.2\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.6.2.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:67:\"https://ps.w.org/contact-form-7/assets/icon-256x256.png?rev=2279696\";s:2:\"1x\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";s:3:\"svg\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.9\";s:6:\"tested\";s:5:\"6.0.1\";s:12:\"requires_php\";b:0;}s:41:\"wordpress-importer/wordpress-importer.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:32:\"w.org/plugins/wordpress-importer\";s:4:\"slug\";s:18:\"wordpress-importer\";s:6:\"plugin\";s:41:\"wordpress-importer/wordpress-importer.php\";s:11:\"new_version\";s:3:\"0.7\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/wordpress-importer/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/wordpress-importer.0.7.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:71:\"https://ps.w.org/wordpress-importer/assets/icon-256x256.png?rev=1908375\";s:2:\"1x\";s:63:\"https://ps.w.org/wordpress-importer/assets/icon.svg?rev=1908375\";s:3:\"svg\";s:63:\"https://ps.w.org/wordpress-importer/assets/icon.svg?rev=1908375\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-importer/assets/banner-772x250.png?rev=547654\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.7\";}s:24:\"wordpress-seo/wp-seo.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:27:\"w.org/plugins/wordpress-seo\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:4:\"19.6\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.6.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-256x256.png?rev=2643727\";s:2:\"1x\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=2363699\";s:3:\"svg\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=2363699\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=2643727\";s:2:\"1x\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=2643727\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=2643727\";s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=2643727\";}s:8:\"requires\";s:3:\"5.9\";s:6:\"tested\";s:5:\"6.0.1\";s:12:\"requires_php\";s:6:\"5.6.20\";}}s:7:\"checked\";a:14:{s:19:\"akismet/akismet.php\";s:5:\"4.2.1\";s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";s:5:\"4.4.9\";s:47:\"better-search-replace/better-search-replace.php\";s:5:\"1.3.4\";s:29:\"cocobasic-elementor/index.php\";s:3:\"1.0\";s:43:\"cocobasic-shortcode/cocobasic-shortcode.php\";s:3:\"1.0\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"5.5.2\";s:23:\"elementor/elementor.php\";s:5:\"3.1.4\";s:65:\"essential-addons-for-elementor-lite/essential_adons_elementor.php\";s:5:\"4.9.6\";s:35:\"litespeed-cache/litespeed-cache.php\";s:5:\"4.4.3\";s:61:\"premium-addons-for-elementor/premium-addons-for-elementor.php\";s:5:\"4.6.1\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:5:\"5.1.3\";s:41:\"wordpress-importer/wordpress-importer.php\";s:3:\"0.7\";s:29:\"wp-mail-smtp/wp_mail_smtp.php\";s:5:\"3.2.0\";s:24:\"wordpress-seo/wp-seo.php\";s:4:\"17.5\";}}","no");
INSERT INTO `wp_options` VALUES("1679","eael_editor_updated_at","1607157964","yes");
INSERT INTO `wp_options` VALUES("9978","litespeed.conf.img_optm-webp_replace","","yes");
INSERT INTO `wp_options` VALUES("9979","litespeed.conf.img_optm-webp_attr","a:7:{i:0;s:7:\"img.src\";i:1;s:14:\"div.data-thumb\";i:2;s:12:\"img.data-src\";i:3;s:20:\"div.data-large_image\";i:4;s:19:\"img.retina_logo_url\";i:5;s:23:\"div.data-parallax-image\";i:6;s:12:\"video.poster\";}","yes");
INSERT INTO `wp_options` VALUES("9980","litespeed.conf.img_optm-webp_replace_srcset","","yes");
INSERT INTO `wp_options` VALUES("9960","litespeed.conf.media-lqip_min_h","150","yes");
INSERT INTO `wp_options` VALUES("9961","litespeed.conf.media-placeholder_resp_async","1","yes");
INSERT INTO `wp_options` VALUES("9962","litespeed.conf.media-iframe_lazy","","yes");
INSERT INTO `wp_options` VALUES("9963","litespeed.conf.media-lazyjs_inline","","yes");
INSERT INTO `wp_options` VALUES("9964","litespeed.conf.media-lazy_exc","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9965","litespeed.conf.media-lazy_cls_exc","a:1:{i:0;s:15:\"wmu-preview-img\";}","yes");
INSERT INTO `wp_options` VALUES("9966","litespeed.conf.media-lazy_parent_cls_exc","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9967","litespeed.conf.media-iframe_lazy_cls_exc","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9968","litespeed.conf.media-iframe_lazy_parent_cls_exc","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9969","litespeed.conf.media-lazy_uri_exc","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9970","litespeed.conf.media-lqip_exc","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9971","litespeed.conf.img_optm-auto","","yes");
INSERT INTO `wp_options` VALUES("9972","litespeed.conf.img_optm-cron","1","yes");
INSERT INTO `wp_options` VALUES("9973","litespeed.conf.img_optm-ori","1","yes");
INSERT INTO `wp_options` VALUES("9974","litespeed.conf.img_optm-rm_bkup","","yes");
INSERT INTO `wp_options` VALUES("9952","litespeed.conf.media-lazy","","yes");
INSERT INTO `wp_options` VALUES("9953","litespeed.conf.media-lazy_placeholder","","yes");
INSERT INTO `wp_options` VALUES("9954","litespeed.conf.media-placeholder_resp","","yes");
INSERT INTO `wp_options` VALUES("9955","litespeed.conf.media-placeholder_resp_color","#cfd4db","yes");
INSERT INTO `wp_options` VALUES("13033","litespeed.conf.optm-ucss_inline","","yes");
INSERT INTO `wp_options` VALUES("13034","litespeed.conf.optm-ucss_whitelist","[]","yes");
INSERT INTO `wp_options` VALUES("13035","litespeed.conf.optm-ucss_exc","[]","yes");
INSERT INTO `wp_options` VALUES("13036","litespeed.conf.optm-html_lazy","[]","yes");
INSERT INTO `wp_options` VALUES("13037","litespeed.conf.optm-ccss_per_url","","yes");
INSERT INTO `wp_options` VALUES("13038","litespeed.conf.optm-gm_js_exc","[]","yes");
INSERT INTO `wp_options` VALUES("13039","litespeed.conf.optm-guest_only","1","yes");
INSERT INTO `wp_options` VALUES("13040","litespeed.conf.media-add_missing_sizes","","yes");
INSERT INTO `wp_options` VALUES("9859","litespeed.conf.cache-ttl_priv","1800","yes");
INSERT INTO `wp_options` VALUES("9860","litespeed.conf.cache-ttl_frontpage","604800","yes");
INSERT INTO `wp_options` VALUES("9861","litespeed.conf.cache-ttl_feed","604800","yes");
INSERT INTO `wp_options` VALUES("9862","litespeed.conf.cache-ttl_rest","604800","yes");
INSERT INTO `wp_options` VALUES("9863","litespeed.conf.cache-ttl_browser","31557600","yes");
INSERT INTO `wp_options` VALUES("9864","litespeed.conf.cache-ttl_status","a:3:{i:0;s:8:\"403 3600\";i:1;s:8:\"404 3600\";i:2;s:8:\"500 3600\";}","yes");
INSERT INTO `wp_options` VALUES("9865","litespeed.conf.cache-login_cookie","","yes");
INSERT INTO `wp_options` VALUES("9866","litespeed.conf.cache-vary_group","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9867","litespeed.conf.purge-upgrade","1","yes");
INSERT INTO `wp_options` VALUES("9868","litespeed.conf.purge-stale","","yes");
INSERT INTO `wp_options` VALUES("9869","litespeed.conf.purge-post_all","","yes");
INSERT INTO `wp_options` VALUES("9870","litespeed.conf.purge-post_f","1","yes");
INSERT INTO `wp_options` VALUES("9871","litespeed.conf.purge-post_h","1","yes");
INSERT INTO `wp_options` VALUES("9872","litespeed.conf.purge-post_p","1","yes");
INSERT INTO `wp_options` VALUES("9873","litespeed.conf.purge-post_pwrp","1","yes");
INSERT INTO `wp_options` VALUES("9874","litespeed.conf.purge-post_a","1","yes");
INSERT INTO `wp_options` VALUES("9875","litespeed.conf.purge-post_y","","yes");
INSERT INTO `wp_options` VALUES("9876","litespeed.conf.purge-post_m","1","yes");
INSERT INTO `wp_options` VALUES("9877","litespeed.conf.purge-post_d","","yes");
INSERT INTO `wp_options` VALUES("9878","litespeed.conf.purge-post_t","1","yes");
INSERT INTO `wp_options` VALUES("9879","litespeed.conf.purge-post_pt","1","yes");
INSERT INTO `wp_options` VALUES("9880","litespeed.conf.purge-timed_urls","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9881","litespeed.conf.purge-timed_urls_time","","yes");
INSERT INTO `wp_options` VALUES("9882","litespeed.conf.purge-hook_all","a:10:{i:0;s:12:\"switch_theme\";i:1;s:18:\"wp_create_nav_menu\";i:2;s:18:\"wp_update_nav_menu\";i:3;s:18:\"wp_delete_nav_menu\";i:4;s:11:\"create_term\";i:5;s:10:\"edit_terms\";i:6;s:11:\"delete_term\";i:7;s:8:\"add_link\";i:8;s:9:\"edit_link\";i:9;s:11:\"delete_link\";}","yes");
INSERT INTO `wp_options` VALUES("9883","litespeed.conf.esi","","yes");
INSERT INTO `wp_options` VALUES("9884","litespeed.conf.esi-cache_admbar","1","yes");
INSERT INTO `wp_options` VALUES("9885","litespeed.conf.esi-cache_commform","1","yes");
INSERT INTO `wp_options` VALUES("9886","litespeed.conf.esi-nonce","a:2:{i:0;s:11:\"stats_nonce\";i:1;s:15:\"subscribe_nonce\";}","yes");
INSERT INTO `wp_options` VALUES("9887","litespeed.conf.util-instant_click","","yes");
INSERT INTO `wp_options` VALUES("9888","litespeed.conf.util-no_https_vary","","yes");
INSERT INTO `wp_options` VALUES("9889","litespeed.conf.debug-disable_all","","yes");
INSERT INTO `wp_options` VALUES("9890","litespeed.conf.debug","","yes");
INSERT INTO `wp_options` VALUES("9891","litespeed.conf.debug-ips","a:1:{i:0;s:9:\"127.0.0.1\";}","yes");
INSERT INTO `wp_options` VALUES("9892","litespeed.conf.debug-level","","yes");
INSERT INTO `wp_options` VALUES("9893","litespeed.conf.debug-filesize","3","yes");
INSERT INTO `wp_options` VALUES("9894","litespeed.conf.debug-cookie","","yes");
INSERT INTO `wp_options` VALUES("9895","litespeed.conf.debug-collaps_qs","","yes");
INSERT INTO `wp_options` VALUES("9896","litespeed.conf.debug-inc","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9897","litespeed.conf.debug-exc","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9898","litespeed.conf.db_optm-revisions_max","0","yes");
INSERT INTO `wp_options` VALUES("9899","litespeed.conf.db_optm-revisions_age","0","yes");
INSERT INTO `wp_options` VALUES("9900","litespeed.conf.optm-css_min","","yes");
INSERT INTO `wp_options` VALUES("9901","litespeed.conf.optm-css_comb","","yes");
INSERT INTO `wp_options` VALUES("9902","litespeed.conf.optm-css_comb_ext_inl","","yes");
INSERT INTO `wp_options` VALUES("9903","litespeed.conf.optm-ucss","","yes");
INSERT INTO `wp_options` VALUES("9904","litespeed.conf.optm-ucss_async","","yes");
INSERT INTO `wp_options` VALUES("9905","litespeed.conf.optm-css_http2","","yes");
INSERT INTO `wp_options` VALUES("9906","litespeed.conf.optm-css_exc","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9907","litespeed.conf.optm-js_min","","yes");
INSERT INTO `wp_options` VALUES("9908","litespeed.conf.optm-js_comb","","yes");
INSERT INTO `wp_options` VALUES("9909","litespeed.conf.optm-js_comb_ext_inl","","yes");
INSERT INTO `wp_options` VALUES("9910","litespeed.conf.optm-js_http2","","yes");
INSERT INTO `wp_options` VALUES("9911","litespeed.conf.optm-js_exc","a:2:{i:0;s:9:\"jquery.js\";i:1;s:13:\"jquery.min.js\";}","yes");
INSERT INTO `wp_options` VALUES("9912","litespeed.conf.optm-ttl","604800","yes");
INSERT INTO `wp_options` VALUES("9913","litespeed.conf.optm-html_min","","yes");
INSERT INTO `wp_options` VALUES("9914","litespeed.conf.optm-qs_rm","","yes");
INSERT INTO `wp_options` VALUES("9915","litespeed.conf.optm-ggfonts_rm","","yes");
INSERT INTO `wp_options` VALUES("9916","litespeed.conf.optm-css_async","","yes");
INSERT INTO `wp_options` VALUES("9917","litespeed.conf.optm-ccss_gen","1","yes");
INSERT INTO `wp_options` VALUES("9918","litespeed.conf.optm-ccss_async","1","yes");
INSERT INTO `wp_options` VALUES("9919","litespeed.conf.optm-css_async_inline","1","yes");
INSERT INTO `wp_options` VALUES("9920","litespeed.conf.optm-css_font_display","","yes");
INSERT INTO `wp_options` VALUES("9921","litespeed.conf.optm-js_defer","","yes");
INSERT INTO `wp_options` VALUES("9922","litespeed.conf.optm-js_inline_defer","","yes");
INSERT INTO `wp_options` VALUES("9923","litespeed.conf.optm-emoji_rm","","yes");
INSERT INTO `wp_options` VALUES("9924","litespeed.conf.optm-noscript_rm","","yes");
INSERT INTO `wp_options` VALUES("9925","litespeed.conf.optm-ggfonts_async","","yes");
INSERT INTO `wp_options` VALUES("9926","litespeed.conf.optm-exc_roles","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9927","litespeed.conf.optm-ccss_con","","yes");
INSERT INTO `wp_options` VALUES("9928","litespeed.conf.optm-js_defer_exc","a:2:{i:0;s:9:\"jquery.js\";i:1;s:13:\"jquery.min.js\";}","yes");
INSERT INTO `wp_options` VALUES("9929","litespeed.conf.optm-dns_prefetch","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9930","litespeed.conf.optm-dns_prefetch_ctrl","","yes");
INSERT INTO `wp_options` VALUES("9931","litespeed.conf.optm-exc","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9932","litespeed.conf.optm-ccss_sep_posttype","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9933","litespeed.conf.optm-ccss_sep_uri","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9934","litespeed.conf.object","","yes");
INSERT INTO `wp_options` VALUES("9935","litespeed.conf.object-kind","","yes");
INSERT INTO `wp_options` VALUES("9936","litespeed.conf.object-host","localhost","yes");
INSERT INTO `wp_options` VALUES("9937","litespeed.conf.object-port","11211","yes");
INSERT INTO `wp_options` VALUES("9938","litespeed.conf.object-life","360","yes");
INSERT INTO `wp_options` VALUES("9939","litespeed.conf.object-persistent","1","yes");
INSERT INTO `wp_options` VALUES("9940","litespeed.conf.object-admin","1","yes");
INSERT INTO `wp_options` VALUES("9941","litespeed.conf.object-transients","1","yes");
INSERT INTO `wp_options` VALUES("9942","litespeed.conf.object-db_id","0","yes");
INSERT INTO `wp_options` VALUES("9943","litespeed.conf.object-user","","yes");
INSERT INTO `wp_options` VALUES("9944","litespeed.conf.object-pswd","","yes");
INSERT INTO `wp_options` VALUES("9945","litespeed.conf.object-global_groups","a:12:{i:0;s:5:\"users\";i:1;s:10:\"userlogins\";i:2;s:8:\"usermeta\";i:3;s:9:\"user_meta\";i:4;s:14:\"site-transient\";i:5;s:12:\"site-options\";i:6;s:11:\"site-lookup\";i:7;s:11:\"blog-lookup\";i:8;s:12:\"blog-details\";i:9;s:3:\"rss\";i:10;s:12:\"global-posts\";i:11;s:13:\"blog-id-cache\";}","yes");
INSERT INTO `wp_options` VALUES("2738","rsssl_upgraded_to_four_dismissed","1","yes");
INSERT INTO `wp_options` VALUES("942","elementor_scheme_color","a:4:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";}","yes");
INSERT INTO `wp_options` VALUES("943","elementor_scheme_typography","a:4:{i:1;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"600\";}i:2;a:2:{s:11:\"font_family\";s:11:\"Roboto Slab\";s:11:\"font_weight\";s:3:\"400\";}i:3;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"400\";}i:4;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"500\";}}","yes");
INSERT INTO `wp_options` VALUES("944","elementor_scheme_color-picker","a:8:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";i:5;s:7:\"#4054b2\";i:6;s:7:\"#23a455\";i:7;s:4:\"#000\";i:8;s:4:\"#fff\";}","yes");
INSERT INTO `wp_options` VALUES("945","elementor_controls_usage","a:2:{s:7:\"wp-post\";a:1:{s:16:\"coco-imageslider\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:17:\"section_process_1\";a:1:{s:5:\"items\";i:1;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:12:\"_css_classes\";i:1;}}}}}s:7:\"wp-page\";a:13:{s:5:\"image\";a:2:{s:5:\"count\";i:15;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:13:\"section_image\";a:5:{s:5:\"image\";i:15;s:10:\"image_size\";i:15;s:12:\"align_mobile\";i:1;s:7:\"link_to\";i:4;s:4:\"link\";i:1;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:2:{s:12:\"width_mobile\";i:1;s:5:\"width\";i:4;}}s:8:\"advanced\";a:3:{s:14:\"_section_style\";a:1:{s:12:\"_css_classes\";i:10;}s:17:\"_section_position\";a:9:{s:14:\"_element_width\";i:10;s:21:\"_element_custom_width\";i:10;s:9:\"_position\";i:10;s:21:\"_offset_orientation_h\";i:7;s:13:\"_offset_x_end\";i:10;s:21:\"_offset_orientation_v\";i:6;s:13:\"_offset_y_end\";i:10;s:9:\"_offset_x\";i:7;s:9:\"_offset_y\";i:7;}s:19:\"_section_responsive\";a:1:{s:11:\"hide_mobile\";i:9;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:36;s:8:\"controls\";a:3:{s:6:\"layout\";a:1:{s:6:\"layout\";a:5:{s:12:\"_inline_size\";i:36;s:19:\"_inline_size_tablet\";i:4;s:16:\"content_position\";i:14;s:12:\"align_mobile\";i:1;s:28:\"space_between_widgets_mobile\";i:7;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:5:{s:7:\"padding\";i:23;s:13:\"margin_mobile\";i:1;s:14:\"padding_tablet\";i:20;s:14:\"padding_mobile\";i:20;s:13:\"margin_tablet\";i:1;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:2:{s:21:\"background_background\";i:23;s:16:\"background_color\";i:22;}}}}s:7:\"heading\";a:2:{s:5:\"count\";i:25;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:13:\"section_title\";a:5:{s:5:\"title\";i:25;s:11:\"header_size\";i:5;s:12:\"align_mobile\";i:1;s:5:\"align\";i:24;s:4:\"link\";i:1;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:11:{s:21:\"typography_typography\";i:25;s:20:\"typography_font_size\";i:25;s:22:\"typography_font_weight\";i:25;s:22:\"typography_line_height\";i:1;s:27:\"typography_font_size_mobile\";i:1;s:29:\"typography_line_height_mobile\";i:1;s:25:\"typography_letter_spacing\";i:13;s:27:\"typography_font_size_tablet\";i:9;s:29:\"typography_line_height_tablet\";i:1;s:11:\"title_color\";i:25;s:22:\"typography_font_family\";i:12;}}s:8:\"advanced\";a:3:{s:17:\"_section_position\";a:1:{s:21:\"_element_custom_width\";i:1;}s:15:\"section_effects\";a:1:{s:10:\"_animation\";i:13;}s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:4;}}}}s:11:\"text-editor\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:3;}}s:8:\"advanced\";a:2:{s:17:\"_section_position\";a:2:{s:14:\"_element_width\";i:1;s:21:\"_element_custom_width\";i:3;}s:14:\"_section_style\";a:2:{s:7:\"_margin\";i:2;s:8:\"_padding\";i:2;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:5:{s:10:\"text_color\";i:3;s:21:\"typography_typography\";i:1;s:20:\"typography_font_size\";i:1;s:22:\"typography_font_weight\";i:1;s:22:\"typography_line_height\";i:1;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:16;s:8:\"controls\";a:3:{s:8:\"advanced\";a:2:{s:16:\"section_advanced\";a:5:{s:7:\"padding\";i:11;s:11:\"css_classes\";i:11;s:6:\"margin\";i:15;s:13:\"margin_tablet\";i:11;s:11:\"_element_id\";i:8;}s:19:\"_section_responsive\";a:1:{s:20:\"reverse_order_mobile\";i:5;}}s:6:\"layout\";a:2:{s:14:\"section_layout\";a:6:{s:6:\"_title\";i:11;s:3:\"gap\";i:2;s:13:\"content_width\";i:11;s:6:\"layout\";i:1;s:13:\"custom_height\";i:10;s:15:\"column_position\";i:10;}s:17:\"section_structure\";a:1:{s:9:\"structure\";i:15;}}s:5:\"style\";a:1:{s:18:\"section_background\";a:1:{s:21:\"background_background\";i:11;}}}}s:14:\"coco-portfolio\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:5:\"style\";a:1:{s:23:\"section_loadmore_button\";a:2:{s:19:\"loadmore_text_color\";i:1;s:25:\"loadmore_text_hover_color\";i:1;}}s:8:\"advanced\";a:1:{s:15:\"_section_border\";a:2:{s:13:\"_border_width\";i:1;s:13:\"_border_color\";i:1;}}}}s:17:\"coco-skills-lines\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:17:\"section_process_1\";a:1:{s:5:\"items\";i:1;}}s:8:\"advanced\";a:1:{s:17:\"_section_position\";a:1:{s:21:\"_element_custom_width\";i:1;}}}}s:13:\"coco-timeline\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:17:\"section_process_1\";a:1:{s:5:\"items\";i:1;}}s:5:\"style\";a:1:{s:15:\"section_general\";a:1:{s:13:\"content_color\";i:1;}}}}s:4:\"icon\";a:2:{s:5:\"count\";i:12;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:12:\"section_icon\";a:1:{s:13:\"selected_icon\";i:12;}}s:5:\"style\";a:1:{s:18:\"section_style_icon\";a:2:{s:13:\"primary_color\";i:12;s:4:\"size\";i:12;}}}}s:9:\"icon-list\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:12:\"section_icon\";a:1:{s:9:\"icon_list\";i:1;}}s:5:\"style\";a:2:{s:18:\"section_icon_style\";a:1:{s:10:\"icon_color\";i:1;}s:18:\"section_text_style\";a:4:{s:26:\"icon_typography_typography\";i:1;s:27:\"icon_typography_font_family\";i:1;s:25:\"icon_typography_font_size\";i:1;s:27:\"icon_typography_font_weight\";i:1;}}}}s:6:\"toggle\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:14:\"section_toggle\";a:2:{s:4:\"tabs\";i:1;s:13:\"selected_icon\";i:1;}}s:5:\"style\";a:4:{s:20:\"section_toggle_style\";a:2:{s:12:\"border_width\";i:1;s:13:\"space_between\";i:1;}s:26:\"section_toggle_style_title\";a:3:{s:16:\"title_background\";i:1;s:11:\"title_color\";i:1;s:16:\"tab_active_color\";i:1;}s:25:\"section_toggle_style_icon\";a:1:{s:10:\"icon_align\";i:1;}s:28:\"section_toggle_style_content\";a:4:{s:24:\"content_background_color\";i:1;s:30:\"content_typography_line_height\";i:1;s:15:\"content_padding\";i:1;s:13:\"content_color\";i:1;}}}}s:16:\"coco-contactform\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:17:\"section_process_1\";a:1:{s:11:\"contactform\";i:1;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:2:{s:7:\"_margin\";i:1;s:14:\"_margin_mobile\";i:1;}}s:5:\"style\";a:1:{s:15:\"section_general\";a:2:{s:13:\"content_color\";i:1;s:23:\"send_button_hover_color\";i:1;}}}}s:12:\"social-icons\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:19:\"section_social_icon\";a:1:{s:16:\"social_icon_list\";i:1;}}}}}}","no");
INSERT INTO `wp_options` VALUES("947","elementor_unfiltered_files_upload","1","yes");
INSERT INTO `wp_options` VALUES("963","secret_key","b2qI~@=NzMl ;2U=J}+ 19.<V+S2/5W#MK]s&}YfVdvP%~Kf mYF#$^S>n>}4r`N","no");
INSERT INTO `wp_options` VALUES("1334","cocobasic_body_color","#ffffff","yes");
INSERT INTO `wp_options` VALUES("1335","cocobasic_body_link_color","#f393a4","yes");
INSERT INTO `wp_options` VALUES("1336","cocobasic_menu_color","#ffffff","yes");
INSERT INTO `wp_options` VALUES("1337","cocobasic_menu_hover_color","#f393a4","yes");
INSERT INTO `wp_options` VALUES("1338","cocobasic_single_portfolio_background_color","#eae0e9","yes");
INSERT INTO `wp_options` VALUES("1339","cocobasic_comments_background_color","#333a48","yes");
INSERT INTO `wp_options` VALUES("10011","litespeed.conf.cdn-cloudflare_name","","yes");
INSERT INTO `wp_options` VALUES("10012","litespeed.conf.cdn-cloudflare_zone","","yes");
INSERT INTO `wp_options` VALUES("10013","litespeed.conf.cdn-mapping","a:1:{i:0;a:5:{s:3:\"url\";b:0;s:7:\"inc_img\";s:1:\"1\";s:7:\"inc_css\";s:1:\"1\";s:6:\"inc_js\";s:1:\"1\";s:8:\"filetype\";a:17:{i:0;s:4:\".aac\";i:1;s:4:\".css\";i:2;s:4:\".eot\";i:3;s:4:\".gif\";i:4;s:5:\".jpeg\";i:5;s:3:\".js\";i:6;s:4:\".jpg\";i:7;s:5:\".less\";i:8;s:4:\".mp3\";i:9;s:4:\".mp4\";i:10;s:4:\".ogg\";i:11;s:4:\".otf\";i:12;s:4:\".pdf\";i:13;s:4:\".png\";i:14;s:4:\".svg\";i:15;s:4:\".ttf\";i:16;s:5:\".woff\";}}}","yes");
INSERT INTO `wp_options` VALUES("10014","litespeed.conf.cdn-attr","a:5:{i:0;s:4:\".src\";i:1;s:9:\".data-src\";i:2;s:5:\".href\";i:3;s:7:\".poster\";i:4;s:13:\"source.srcset\";}","yes");
INSERT INTO `wp_options` VALUES("13057","rewrite_rules","a:114:{s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:39:\"index.php?yoast-sitemap-xsl=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=181&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes");
INSERT INTO `wp_options` VALUES("13029","litespeed.conf.guest","","yes");
INSERT INTO `wp_options` VALUES("13030","litespeed.conf.guest_optm","","yes");
INSERT INTO `wp_options` VALUES("13031","litespeed.conf.guest_uas","[\"Lighthouse\",\"GTmetrix\",\"Google\",\"Pingdom\",\"bot\",\"PTST\",\"HeadlessChrome\"]","yes");
INSERT INTO `wp_options` VALUES("13032","litespeed.conf.guest_ips","[\"208.70.247.157\",\"172.255.48.130\",\"172.255.48.131\",\"172.255.48.132\",\"172.255.48.133\",\"172.255.48.134\",\"172.255.48.135\",\"172.255.48.136\",\"172.255.48.137\",\"172.255.48.138\",\"172.255.48.139\",\"172.255.48.140\",\"172.255.48.141\",\"172.255.48.142\",\"172.255.48.143\",\"172.255.48.144\",\"172.255.48.145\",\"172.255.48.146\",\"172.255.48.147\",\"52.229.122.240\",\"104.214.72.101\",\"13.66.7.11\",\"13.85.24.83\",\"13.85.24.90\",\"13.85.82.26\",\"40.74.242.253\",\"40.74.243.13\",\"40.74.243.176\",\"104.214.48.247\",\"157.55.189.189\",\"104.214.110.135\",\"70.37.83.240\",\"65.52.36.250\",\"13.78.216.56\",\"52.162.212.163\",\"23.96.34.105\",\"65.52.113.236\",\"172.255.61.34\",\"172.255.61.35\",\"172.255.61.36\",\"172.255.61.37\",\"172.255.61.38\",\"172.255.61.39\",\"172.255.61.40\",\"104.41.2.19\",\"191.235.98.164\",\"191.235.99.221\",\"191.232.194.51\",\"52.237.235.185\",\"52.237.250.73\",\"52.237.236.145\",\"104.211.143.8\",\"104.211.165.53\",\"52.172.14.87\",\"40.83.89.214\",\"52.175.57.81\",\"20.188.63.151\",\"20.52.36.49\",\"52.246.165.153\",\"51.144.102.233\",\"13.76.97.224\",\"102.133.169.66\",\"52.231.199.170\",\"13.53.162.7\",\"40.123.218.94\"]","yes");
INSERT INTO `wp_options` VALUES("13018","wp_force_deactivated_plugins","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("13017","https_detection_errors","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9985","litespeed.conf.crawler-run_interval","600","yes");
INSERT INTO `wp_options` VALUES("9986","litespeed.conf.crawler-crawl_interval","302400","yes");
INSERT INTO `wp_options` VALUES("9987","litespeed.conf.crawler-threads","3","yes");
INSERT INTO `wp_options` VALUES("9988","litespeed.conf.crawler-timeout","30","yes");
INSERT INTO `wp_options` VALUES("9989","litespeed.conf.crawler-load_limit","1","yes");
INSERT INTO `wp_options` VALUES("1005","rsssl_upgraded_to_four","1","yes");
INSERT INTO `wp_options` VALUES("1006","rsssl_mixed_content_scan_dismissed","1","yes");
INSERT INTO `wp_options` VALUES("1007","rsssl_google_analytics_dismissed","1","yes");
INSERT INTO `wp_options` VALUES("968","wp_mail_smtp_initial_version","2.5.1","no");
INSERT INTO `wp_options` VALUES("969","wp_mail_smtp_version","2.5.1","no");
INSERT INTO `wp_options` VALUES("970","wp_mail_smtp","a:8:{s:4:\"mail\";a:6:{s:10:\"from_email\";s:25:\"amr.elarabi.egy@gmail.com\";s:9:\"from_name\";s:11:\"Amr Elarabi\";s:6:\"mailer\";s:7:\"mailgun\";s:11:\"return_path\";b:0;s:16:\"from_email_force\";b:1;s:15:\"from_name_force\";b:0;}s:4:\"smtp\";a:7:{s:7:\"autotls\";s:3:\"yes\";s:4:\"auth\";s:3:\"yes\";s:4:\"host\";s:0:\"\";s:10:\"encryption\";s:4:\"none\";s:4:\"port\";s:0:\"\";s:4:\"user\";s:0:\"\";s:4:\"pass\";s:0:\"\";}s:7:\"smtpcom\";a:2:{s:7:\"api_key\";s:0:\"\";s:7:\"channel\";s:0:\"\";}s:10:\"sendinblue\";a:1:{s:7:\"api_key\";s:0:\"\";}s:7:\"mailgun\";a:3:{s:7:\"api_key\";s:50:\"5295fbf2bf55287be85e25f81269b91d-af6c0cec-1a305590\";s:6:\"domain\";s:14:\"mail.motwr.com\";s:6:\"region\";s:2:\"US\";}s:8:\"sendgrid\";a:1:{s:7:\"api_key\";s:0:\"\";}s:5:\"gmail\";a:2:{s:9:\"client_id\";s:0:\"\";s:13:\"client_secret\";s:0:\"\";}s:7:\"general\";a:1:{s:29:\"summary_report_email_disabled\";b:1;}}","no");
INSERT INTO `wp_options` VALUES("971","wp_mail_smtp_activated_time","1607036714","no");
INSERT INTO `wp_options` VALUES("972","wp_mail_smtp_activated","a:1:{s:4:\"lite\";i:1607036714;}","yes");
INSERT INTO `wp_options` VALUES("973","action_scheduler_hybrid_store_demarkation","709","yes");
INSERT INTO `wp_options` VALUES("974","schema-ActionScheduler_StoreSchema","4.0.1637028023","yes");
INSERT INTO `wp_options` VALUES("975","schema-ActionScheduler_LoggerSchema","2.0.1607036715","yes");
INSERT INTO `wp_options` VALUES("986","wp_mail_smtp_notifications","a:4:{s:6:\"update\";i:1642225676;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("1328","cocobasic_preloader","https://amrelarabi.com/wp-content/uploads/2020/12/loading.gif","yes");
INSERT INTO `wp_options` VALUES("9990","litespeed.conf.crawler-sitemap","","yes");
INSERT INTO `wp_options` VALUES("9991","litespeed.conf.crawler-drop_domain","1","yes");
INSERT INTO `wp_options` VALUES("9992","litespeed.conf.crawler-map_timeout","120","yes");
INSERT INTO `wp_options` VALUES("9993","litespeed.conf.crawler-roles","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9994","litespeed.conf.crawler-cookies","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9995","litespeed.conf.misc-htaccess_front","","yes");
INSERT INTO `wp_options` VALUES("9996","litespeed.conf.misc-htaccess_back","","yes");
INSERT INTO `wp_options` VALUES("9997","litespeed.conf.misc-heartbeat_front","","yes");
INSERT INTO `wp_options` VALUES("9998","litespeed.conf.misc-heartbeat_front_ttl","60","yes");
INSERT INTO `wp_options` VALUES("9999","litespeed.conf.misc-heartbeat_back","","yes");
INSERT INTO `wp_options` VALUES("10000","litespeed.conf.misc-heartbeat_back_ttl","60","yes");
INSERT INTO `wp_options` VALUES("10001","litespeed.conf.misc-heartbeat_editor","","yes");
INSERT INTO `wp_options` VALUES("10002","litespeed.conf.misc-heartbeat_editor_ttl","15","yes");
INSERT INTO `wp_options` VALUES("10003","litespeed.conf.cdn","","yes");
INSERT INTO `wp_options` VALUES("10004","litespeed.conf.cdn-ori","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("10005","litespeed.conf.cdn-ori_dir","a:2:{i:0;s:10:\"wp-content\";i:1;s:11:\"wp-includes\";}","yes");
INSERT INTO `wp_options` VALUES("10006","litespeed.conf.cdn-exc","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("10007","litespeed.conf.cdn-quic","","yes");
INSERT INTO `wp_options` VALUES("10008","litespeed.conf.cdn-cloudflare","","yes");
INSERT INTO `wp_options` VALUES("9975","litespeed.conf.img_optm-webp","","yes");
INSERT INTO `wp_options` VALUES("9976","litespeed.conf.img_optm-lossless","","yes");
INSERT INTO `wp_options` VALUES("9977","litespeed.conf.img_optm-exif","","yes");
INSERT INTO `wp_options` VALUES("9959","litespeed.conf.media-lqip_min_w","150","yes");
INSERT INTO `wp_options` VALUES("9956","litespeed.conf.media-placeholder_resp_svg","<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"{width}\" height=\"{height}\" viewBox=\"0 0 {width} {height}\"><rect width=\"100%\" height=\"100%\" fill=\"{color}\"/></svg>","yes");
INSERT INTO `wp_options` VALUES("9957","litespeed.conf.media-lqip","","yes");
INSERT INTO `wp_options` VALUES("1665","elementor_allow_tracking","no","yes");
INSERT INTO `wp_options` VALUES("1666","elementor_tracker_notice","1","yes");
INSERT INTO `wp_options` VALUES("1674","eael_save_settings","a:49:{s:9:\"post-grid\";i:1;s:13:\"post-timeline\";i:1;s:10:\"fancy-text\";i:1;s:12:\"creative-btn\";i:1;s:10:\"count-down\";i:1;s:12:\"team-members\";i:1;s:12:\"testimonials\";i:1;s:8:\"info-box\";i:1;s:8:\"flip-box\";i:1;s:14:\"call-to-action\";i:1;s:11:\"dual-header\";i:1;s:11:\"price-table\";i:1;s:12:\"twitter-feed\";i:1;s:13:\"facebook-feed\";i:1;s:19:\"advanced-data-table\";i:1;s:10:\"data-table\";i:1;s:14:\"filter-gallery\";i:1;s:15:\"image-accordion\";i:1;s:14:\"content-ticker\";i:1;s:7:\"tooltip\";i:1;s:13:\"adv-accordion\";i:1;s:8:\"adv-tabs\";i:1;s:12:\"progress-bar\";i:1;s:12:\"feature-list\";i:1;s:12:\"product-grid\";i:1;s:14:\"contact-form-7\";i:1;s:7:\"weforms\";i:1;s:10:\"ninja-form\";i:1;s:9:\"formstack\";i:1;s:12:\"gravity-form\";i:1;s:12:\"caldera-form\";i:1;s:7:\"wpforms\";i:1;s:10:\"fluentform\";i:1;s:8:\"typeform\";i:1;s:24:\"betterdocs-category-grid\";i:1;s:23:\"betterdocs-category-box\";i:1;s:22:\"betterdocs-search-form\";i:1;s:12:\"sticky-video\";i:1;s:14:\"event-calendar\";i:1;s:10:\"embedpress\";i:1;s:12:\"woo-checkout\";i:1;s:14:\"login-register\";i:1;s:18:\"woocommerce-review\";i:1;s:11:\"career-page\";i:1;s:9:\"promotion\";i:1;s:9:\"custom-js\";i:1;s:16:\"reading-progress\";i:1;s:16:\"table-of-content\";i:1;s:15:\"post-duplicator\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("1676","eael_version","4.3.7","yes");
INSERT INTO `wp_options` VALUES("1677","wpins_essential_adons_elementor_force_tracked","1","yes");
INSERT INTO `wp_options` VALUES("1680","temp_count","a:2:{s:11:\"Default Kit\";s:11:\"Default Kit\";s:6:\"Footer\";s:6:\"Footer\";}","yes");
INSERT INTO `wp_options` VALUES("1682","elementor_log","a:4:{s:32:\"2bad528cf886aad8a487b93d374b8c4d\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:3:\"233\";s:7:\"\0*\0file\";s:117:\"https://amrelarabi.tech/wp-content/plugins/premium-addons-for-elementor/assets/frontend/min-js/typed.min.js?ver=4.0.9\";s:7:\"\0*\0line\";s:1:\"1\";s:7:\"\0*\0date\";s:19:\"2020-12-05 08:38:12\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:59:\"Cannot read property \\&#039;toLowerCase\\&#039; of undefined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:19;s:14:\"\0*\0times_dates\";a:19:{i:0;s:19:\"2020-12-05 08:38:12\";i:1;s:19:\"2020-12-05 08:38:29\";i:2;s:19:\"2020-12-05 08:38:41\";i:3;s:19:\"2020-12-05 08:38:51\";i:4;s:19:\"2020-12-05 08:39:33\";i:5;s:19:\"2020-12-05 08:39:41\";i:6;s:19:\"2020-12-05 08:39:44\";i:7;s:19:\"2020-12-05 08:39:51\";i:8;s:19:\"2020-12-05 08:40:19\";i:9;s:19:\"2020-12-05 08:40:35\";i:10;s:19:\"2020-12-05 08:40:39\";i:11;s:19:\"2020-12-05 08:40:41\";i:12;s:19:\"2020-12-05 08:40:45\";i:13;s:19:\"2020-12-05 08:40:52\";i:14;s:19:\"2020-12-05 08:40:55\";i:15;s:19:\"2020-12-05 08:40:59\";i:16;s:19:\"2020-12-05 08:41:27\";i:17;s:19:\"2020-12-05 08:42:39\";i:18;s:19:\"2020-12-05 08:42:42\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1607157492\";s:7:\"message\";s:49:\"Cannot read property \\\'toLowerCase\\\' of undefined\";s:3:\"url\";s:117:\"https://amrelarabi.tech/wp-content/plugins/premium-addons-for-elementor/assets/frontend/min-js/typed.min.js?ver=4.0.9\";s:4:\"line\";s:1:\"1\";s:6:\"column\";s:3:\"233\";}}s:32:\"26a774ce8bd9eaaba6210f06dfaf2841\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-01-04 23:06:22\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.0.14\";s:2:\"to\";s:6:\"3.0.15\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-01-04 23:06:22\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.0.14\";s:2:\"to\";s:6:\"3.0.15\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"e43de19b2f7d46cc3e8c2d0c93abc055\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-02-05 15:01:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.0.15\";s:2:\"to\";s:5:\"3.1.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-02-05 15:01:11\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.0.15\";s:2:\"to\";s:5:\"3.1.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"32b2ea5fc94e6e3de409483067c70222\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-03-11 13:38:51\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.1.1\";s:2:\"to\";s:5:\"3.1.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-03-11 13:38:51\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.1.1\";s:2:\"to\";s:5:\"3.1.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}}","no");
INSERT INTO `wp_options` VALUES("1683","cb70d11b8_elements","a:1:{i:1;s:10:\"fancy-text\";}","yes");
INSERT INTO `wp_options` VALUES("1684","cb70d11b8_custom_js","","yes");
INSERT INTO `wp_options` VALUES("1685","cb70d11b8_updated_at","1607157964","yes");
INSERT INTO `wp_options` VALUES("1689","ea1d43322_elements","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("1690","ea1d43322_custom_js","","yes");
INSERT INTO `wp_options` VALUES("1691","ea1d43322_updated_at","1607157695","yes");
INSERT INTO `wp_options` VALUES("13082","wp_mail_smtp_lite_sent_email_counter","335","yes");
INSERT INTO `wp_options` VALUES("13083","wp_mail_smtp_lite_weekly_sent_email_counter","a:12:{i:22;i:42;i:23;i:1;i:24;i:1;i:25;i:1;i:26;i:2;i:27;i:1;i:28;i:1;i:29;i:1;i:30;i:2;i:31;i:1;i:32;i:1;i:33;i:1;}","yes");
INSERT INTO `wp_options` VALUES("5972","rsssl_current_version","5.1.3","yes");
INSERT INTO `wp_options` VALUES("12999","litespeed.admin_display._summary","{\"new_version\":1630308674,\"score\":1630654274,\"new_version.last_check\":1642130536,\"new_version.v\":\"4.4.7\"}","yes");
INSERT INTO `wp_options` VALUES("5983","_elementor_global_css","a:6:{s:4:\"time\";i:1615473220;s:5:\"fonts\";a:0:{}s:5:\"icons\";a:0:{}s:20:\"dynamic_elements_ids\";a:0:{}s:6:\"status\";s:4:\"file\";i:0;b:0;}","yes");
INSERT INTO `wp_options` VALUES("1772","wpseo","a:45:{s:8:\"tracking\";b:0;s:22:\"license_server_version\";b:0;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:0;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:23:\"home_url_option_changed\";s:29:\"indexables_indexing_completed\";b:1;s:7:\"version\";s:4:\"17.5\";s:16:\"previous_version\";s:6:\"15.9.2\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:1;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1607162120;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:12:\"/%postname%/\";s:8:\"home_url\";s:22:\"https://amrelarabi.com\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:2:{s:22:\"elementor_library_type\";s:22:\"elementor_library_type\";s:26:\"elementor_library_category\";s:26:\"elementor_library_category\";}s:29:\"enable_enhanced_slack_sharing\";b:1;s:25:\"zapier_integration_active\";b:0;s:19:\"zapier_subscription\";a:0:{}s:14:\"zapier_api_key\";s:0:\"\";s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("1773","yoast_migrations_free","a:1:{s:7:\"version\";s:4:\"17.5\";}","yes");
INSERT INTO `wp_options` VALUES("10009","litespeed.conf.cdn-cloudflare_email","","yes");
INSERT INTO `wp_options` VALUES("10010","litespeed.conf.cdn-cloudflare_key","","yes");
INSERT INTO `wp_options` VALUES("1774","wpseo_titles","a:131:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-pipe\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:1;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:86:\"https://amrelarabi.com/wp-content/uploads/2020/12/4233171cc00d9e46d3ff26822e17e6b0.png\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:6:\"person\";s:25:\"company_or_person_user_id\";i:1;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:23:\"title-elementor_library\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-elementor_library\";s:0:\"\";s:25:\"noindex-elementor_library\";b:1;s:36:\"display-metabox-pt-elementor_library\";b:1;s:36:\"post_types-elementor_library-maintax\";i:0;s:34:\"schema-page-type-elementor_library\";s:7:\"WebPage\";s:37:\"schema-article-type-elementor_library\";s:4:\"None\";s:30:\"social-title-elementor_library\";s:9:\"%%title%%\";s:36:\"social-description-elementor_library\";s:0:\"\";s:34:\"social-image-url-elementor_library\";s:0:\"\";s:33:\"social-image-id-elementor_library\";i:0;s:15:\"title-portfolio\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:18:\"metadesc-portfolio\";s:0:\"\";s:17:\"noindex-portfolio\";b:1;s:28:\"display-metabox-pt-portfolio\";b:0;s:28:\"post_types-portfolio-maintax\";i:0;s:26:\"schema-page-type-portfolio\";s:7:\"WebPage\";s:29:\"schema-article-type-portfolio\";s:4:\"None\";s:22:\"social-title-portfolio\";s:9:\"%%title%%\";s:28:\"social-description-portfolio\";s:0:\"\";s:26:\"social-image-url-portfolio\";s:0:\"\";s:25:\"social-image-id-portfolio\";i:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:23:\"%%term_title%% Archives\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:14:\"person_logo_id\";i:592;s:15:\"company_logo_id\";i:0;s:17:\"company_logo_meta\";b:0;s:16:\"person_logo_meta\";a:9:{s:5:\"width\";i:64;s:6:\"height\";i:64;s:3:\"url\";s:86:\"https://amrelarabi.com/wp-content/uploads/2020/12/4233171cc00d9e46d3ff26822e17e6b0.png\";s:4:\"path\";s:93:\"/home/motwzkdp/amrelarabi.com/wp-content/uploads/2020/12/4233171cc00d9e46d3ff26822e17e6b0.png\";s:4:\"size\";s:4:\"full\";s:2:\"id\";i:592;s:3:\"alt\";s:0:\"\";s:6:\"pixels\";i:4096;s:4:\"type\";s:9:\"image/png\";}s:29:\"open_graph_frontpage_image_id\";i:0;s:26:\"taxonomy-category-ptparent\";s:1:\"0\";s:26:\"taxonomy-post_tag-ptparent\";s:1:\"0\";s:29:\"taxonomy-post_format-ptparent\";s:1:\"0\";}","yes");
INSERT INTO `wp_options` VALUES("1775","wpseo_social","a:18:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("1776","wpseo_flush_rewrite","1","yes");
INSERT INTO `wp_options` VALUES("9981","litespeed.conf.img_optm-jpg_quality","82","yes");
INSERT INTO `wp_options` VALUES("9982","litespeed.conf.crawler","","yes");
INSERT INTO `wp_options` VALUES("9983","litespeed.conf.crawler-usleep","500","yes");
INSERT INTO `wp_options` VALUES("9984","litespeed.conf.crawler-run_duration","400","yes");
INSERT INTO `wp_options` VALUES("9958","litespeed.conf.media-lqip_qual","4","yes");
INSERT INTO `wp_options` VALUES("9946","litespeed.conf.object-non_persistent_groups","a:4:{i:0;s:7:\"comment\";i:1;s:6:\"counts\";i:2;s:7:\"plugins\";i:3;s:13:\"wc_session_id\";}","yes");
INSERT INTO `wp_options` VALUES("9947","litespeed.conf.discuss-avatar_cache","","yes");
INSERT INTO `wp_options` VALUES("9948","litespeed.conf.discuss-avatar_cron","","yes");
INSERT INTO `wp_options` VALUES("9949","litespeed.conf.discuss-avatar_cache_ttl","604800","yes");
INSERT INTO `wp_options` VALUES("9950","litespeed.conf.optm-localize","","yes");
INSERT INTO `wp_options` VALUES("9951","litespeed.conf.optm-localize_domains","a:7:{i:0;s:23:\"### Popular scripts ###\";i:1;s:39:\"https://platform.twitter.com/widgets.js\";i:2;s:39:\"https://www.google.com/recaptcha/api.js\";i:3;s:45:\"https://www.google-analytics.com/analytics.js\";i:4;s:39:\"https://www.googletagmanager.com/gtm.js\";i:5;s:47:\"https://www.googletagservices.com/tag/js/gpt.js\";i:6;s:46:\"https://connect.facebook.net/en_US/fbevents.js\";}","yes");
INSERT INTO `wp_options` VALUES("9830","litespeed.cloud._summary","{\"curr_request.wp\\/ver\":0,\"last_request.wp\\/ver\":1637027978,\"news.utime\":1641309987,\"curr_request.wp\\/news\":0,\"last_request.wp\\/news\":1637027979,\"curr_request.ver\":0,\"last_request.ver\":1642130536,\"curr_request.news\":0,\"last_request.news\":1641309987}","yes");
INSERT INTO `wp_options` VALUES("13028","litespeed.conf._version","4.4.3","yes");
INSERT INTO `wp_options` VALUES("9832","litespeed.conf.hash","Aq74M198hSz6beEK2q2zezfkkr0X65Dz","yes");
INSERT INTO `wp_options` VALUES("9833","litespeed.conf.auto_upgrade","","yes");
INSERT INTO `wp_options` VALUES("9834","litespeed.conf.api_key","","yes");
INSERT INTO `wp_options` VALUES("9835","litespeed.conf.server_ip","","yes");
INSERT INTO `wp_options` VALUES("9836","litespeed.conf.news","1","yes");
INSERT INTO `wp_options` VALUES("9837","litespeed.conf.cache","1","yes");
INSERT INTO `wp_options` VALUES("9838","litespeed.conf.cache-priv","1","yes");
INSERT INTO `wp_options` VALUES("9839","litespeed.conf.cache-commenter","1","yes");
INSERT INTO `wp_options` VALUES("9840","litespeed.conf.cache-rest","1","yes");
INSERT INTO `wp_options` VALUES("9841","litespeed.conf.cache-page_login","1","yes");
INSERT INTO `wp_options` VALUES("9842","litespeed.conf.cache-favicon","1","yes");
INSERT INTO `wp_options` VALUES("9843","litespeed.conf.cache-resources","1","yes");
INSERT INTO `wp_options` VALUES("9844","litespeed.conf.cache-mobile","","yes");
INSERT INTO `wp_options` VALUES("9845","litespeed.conf.cache-mobile_rules","a:7:{i:0;s:6:\"Mobile\";i:1;s:7:\"Android\";i:2;s:5:\"Silk/\";i:3;s:6:\"Kindle\";i:4;s:10:\"BlackBerry\";i:5;s:10:\"Opera Mini\";i:6;s:10:\"Opera Mobi\";}","yes");
INSERT INTO `wp_options` VALUES("9846","litespeed.conf.cache-browser","","yes");
INSERT INTO `wp_options` VALUES("9847","litespeed.conf.cache-exc_useragents","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9848","litespeed.conf.cache-exc_cookies","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9849","litespeed.conf.cache-exc_qs","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9850","litespeed.conf.cache-exc_cat","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9851","litespeed.conf.cache-exc_tag","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9852","litespeed.conf.cache-force_uri","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9853","litespeed.conf.cache-force_pub_uri","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9854","litespeed.conf.cache-priv_uri","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9855","litespeed.conf.cache-exc","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9856","litespeed.conf.cache-exc_roles","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("9857","litespeed.conf.cache-drop_qs","a:4:{i:0;s:6:\"fbclid\";i:1;s:5:\"gclid\";i:2;s:4:\"utm*\";i:3;s:3:\"_ga\";}","yes");
INSERT INTO `wp_options` VALUES("1789","wpseo_ryte","a:2:{s:6:\"status\";i:1;s:10:\"last_fetch\";i:1660992925;}","yes");
INSERT INTO `wp_options` VALUES("9858","litespeed.conf.cache-ttl_pub","604800","yes");
INSERT INTO `wp_options` VALUES("954","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("904","theme_mods_teoro-wp","a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:11:\"custom_menu\";i:4;}s:18:\"custom_css_post_id\";i:-1;s:25:\"cocobasic_preloader_width\";s:4:\"50px\";s:31:\"cocobasic_color_scheme_selector\";s:5:\"demo1\";}","yes");
INSERT INTO `wp_options` VALUES("1332","cocobasic_preloader_background_color","#1b212c","yes");
INSERT INTO `wp_options` VALUES("1008","rsssl_remaining_tasks","1","yes");
INSERT INTO `wp_options` VALUES("197","current_theme","Teoro WP","yes");
INSERT INTO `wp_options` VALUES("198","theme_mods_resumee","a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1607019296;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:11:\"frontpage-1\";a:1:{i:0;s:6:\"text-2\";}s:8:\"footer-1\";a:0:{}}}}","yes");
INSERT INTO `wp_options` VALUES("199","theme_switched","","yes");
INSERT INTO `wp_options` VALUES("200","widget_resumee_intro_one_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("201","widget_experience_one_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("176","secure_auth_salt","vQ,$yewSr1l:v#nC H-[VW+KJMY4%i-$OVzb_I#{*E;FW @3R}1x%P#~o-_%i:w]","no");
INSERT INTO `wp_options` VALUES("182","rsssl_activation_timestamp","1604055977","yes");
INSERT INTO `wp_options` VALUES("930","elementor_remote_info_library","a:3:{s:10:\"types_data\";a:3:{s:5:\"block\";a:1:{s:10:\"categories\";a:22:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:14:\"call to action\";i:4;s:7:\"clients\";i:5;s:7:\"contact\";i:6;s:3:\"faq\";i:7;s:8:\"features\";i:8;s:6:\"footer\";i:9;s:6:\"header\";i:10;s:4:\"hero\";i:11;s:9:\"portfolio\";i:12;s:7:\"pricing\";i:13;s:15:\"product archive\";i:14;s:8:\"services\";i:15;s:11:\"single page\";i:16;s:11:\"single post\";i:17;s:14:\"single product\";i:18;s:5:\"stats\";i:19;s:9:\"subscribe\";i:20;s:4:\"team\";i:21;s:12:\"testimonials\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:14:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:5:\"Ebook\";i:3;s:9:\"eCommerce\";i:4;s:9:\"Education\";i:5;s:6:\"Events\";i:6;s:18:\"Health and Fitness\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";}}}s:10:\"categories\";a:22:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:14:\"call to action\";i:4;s:7:\"clients\";i:5;s:7:\"contact\";i:6;s:3:\"faq\";i:7;s:8:\"features\";i:8;s:6:\"footer\";i:9;s:6:\"header\";i:10;s:4:\"hero\";i:11;s:9:\"portfolio\";i:12;s:7:\"pricing\";i:13;s:15:\"product archive\";i:14;s:8:\"services\";i:15;s:11:\"single page\";i:16;s:11:\"single post\";i:17;s:14:\"single product\";i:18;s:5:\"stats\";i:19;s:9:\"subscribe\";i:20;s:4:\"team\";i:21;s:12:\"testimonials\";}s:9:\"templates\";a:735:{i:0;a:16:{s:4:\"tmpl\";i:768;s:2:\"id\";i:10107;s:5:\"title\";s:34:\"Classic | Promotion | Announcement\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/balls_small.png\";s:12:\"tmpl_created\";i:1547851373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-promotion-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:206;s:11:\"trend_index\";i:207;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:16:{s:4:\"tmpl\";i:1028;s:2:\"id\";i:14827;s:5:\"title\";s:39:\"Slide-In | Contact | Luxury Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png\";s:12:\"tmpl_created\";i:1595323523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:559;s:11:\"trend_index\";i:284;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:16:{s:4:\"tmpl\";i:773;s:2:\"id\";i:10158;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/coco_small.png\";s:12:\"tmpl_created\";i:1547852227;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:255;s:11:\"trend_index\";i:295;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:16:{s:4:\"tmpl\";i:776;s:2:\"id\";i:10190;s:5:\"title\";s:30:\"Classic | Register | Subscribe\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/engage_small.png\";s:12:\"tmpl_created\";i:1547885703;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:214;s:11:\"trend_index\";i:151;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:16:{s:4:\"tmpl\";i:1034;s:2:\"id\";i:15075;s:5:\"title\";s:34:\"Slide-In | Menu | Flooring Company\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png\";s:12:\"tmpl_created\";i:1597739605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:383;s:11:\"trend_index\";i:162;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:16:{s:4:\"tmpl\";i:1035;s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:625;s:11:\"trend_index\";i:309;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:16:{s:4:\"tmpl\";i:782;s:2:\"id\";i:10256;s:5:\"title\";s:20:\"Classic | Sale | Pop\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/fruit_small.png\";s:12:\"tmpl_created\";i:1547888909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:458;s:11:\"trend_index\";i:597;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:16:{s:4:\"tmpl\";i:783;s:2:\"id\";i:10267;s:5:\"title\";s:29:\"Classic | Contact | Christmas\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/christmas_small.png\";s:12:\"tmpl_created\";i:1547889047;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-contact-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:281;s:11:\"trend_index\";i:233;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:16:{s:4:\"tmpl\";i:787;s:2:\"id\";i:10307;s:5:\"title\";s:43:\"Fly In | Promotion | Christmas | Teddy Bear\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/teddy_small.png\";s:12:\"tmpl_created\";i:1547893266;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/fly-in-promotion-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:641;s:11:\"trend_index\";i:689;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:16:{s:4:\"tmpl\";i:788;s:2:\"id\";i:10318;s:5:\"title\";s:27:\"Classic | Contact | Bicycle\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/01/by_small.png\";s:12:\"tmpl_created\";i:1547893367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/classic-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:327;s:11:\"trend_index\";i:326;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:16:{s:4:\"tmpl\";i:790;s:2:\"id\";i:10339;s:5:\"title\";s:22:\"Fly In | Contact | Spa\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/spa_small.png\";s:12:\"tmpl_created\";i:1547893603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/fly-in-contact-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:390;s:11:\"trend_index\";i:393;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:16:{s:4:\"tmpl\";i:791;s:2:\"id\";i:10352;s:5:\"title\";s:23:\"Fly In | Contact | Wine\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_wine_small.png\";s:12:\"tmpl_created\";i:1547915335;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/fly-in-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:445;s:11:\"trend_index\";i:525;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:16:{s:4:\"tmpl\";i:793;s:2:\"id\";i:10372;s:5:\"title\";s:29:\"Fly In | Register | Subscribe\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/phone_small.png\";s:12:\"tmpl_created\";i:1547915554;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fly-in-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:638;s:11:\"trend_index\";i:636;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:16:{s:4:\"tmpl\";i:794;s:2:\"id\";i:10382;s:5:\"title\";s:35:\"Bottom Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/bottom_pink_small.png\";s:12:\"tmpl_created\";i:1547916616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/bottom-bar-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:242;s:11:\"trend_index\";i:258;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:16:{s:4:\"tmpl\";i:1052;s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:739;s:11:\"trend_index\";i:583;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:16:{s:4:\"tmpl\";i:1053;s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:312;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:16:{s:4:\"tmpl\";i:1054;s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:762;s:11:\"trend_index\";i:650;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:16:{s:4:\"tmpl\";i:799;s:2:\"id\";i:10434;s:5:\"title\";s:27:\"Classic | Sale | Headphones\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/head_small.png\";s:12:\"tmpl_created\";i:1547961950;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:359;s:11:\"trend_index\";i:353;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:16:{s:4:\"tmpl\";i:800;s:2:\"id\";i:10444;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/plant_small.png\";s:12:\"tmpl_created\";i:1547962029;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/classic-contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:385;s:11:\"trend_index\";i:298;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:16:{s:4:\"tmpl\";i:802;s:2:\"id\";i:10467;s:5:\"title\";s:27:\"Bottom Bar | Contact | Lego\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/tro_small.png\";s:12:\"tmpl_created\";i:1547962277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/bottom-bar-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:722;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:16:{s:4:\"tmpl\";i:804;s:2:\"id\";i:10487;s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/acc_small.png\";s:12:\"tmpl_created\";i:1547964527;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:554;s:11:\"trend_index\";i:618;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:16:{s:4:\"tmpl\";i:805;s:2:\"id\";i:10498;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/pink_small-1.png\";s:12:\"tmpl_created\";i:1547964616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:421;s:11:\"trend_index\";i:382;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:16:{s:4:\"tmpl\";i:807;s:2:\"id\";i:10519;s:5:\"title\";s:27:\"Hello Bar | Promotion | App\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/app_small-1.png\";s:12:\"tmpl_created\";i:1547964801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/hello-bar-promotion-app-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:585;s:11:\"trend_index\";i:629;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:16:{s:4:\"tmpl\";i:1064;s:2:\"id\";i:15580;s:5:\"title\";s:31:\"Fullscreen | Menu | Travel Blog\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1606215358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:673;s:11:\"trend_index\";i:348;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:16:{s:4:\"tmpl\";i:1065;s:2:\"id\";i:15570;s:5:\"title\";s:33:\"Classic | Subscribe | Travel Blog\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg\";s:12:\"tmpl_created\";i:1606215555;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:709;s:11:\"trend_index\";i:459;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:16:{s:4:\"tmpl\";i:812;s:2:\"id\";i:10569;s:5:\"title\";s:15:\"Slide In | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/off_small.png\";s:12:\"tmpl_created\";i:1547967812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/popups/slide-in-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:529;s:11:\"trend_index\";i:485;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:16:{s:4:\"tmpl\";i:814;s:2:\"id\";i:10590;s:5:\"title\";s:19:\"Full Screen | Login\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/pass1_small.png\";s:12:\"tmpl_created\";i:1547967978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:466;s:11:\"trend_index\";i:356;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:16:{s:4:\"tmpl\";i:815;s:2:\"id\";i:10600;s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/orange_small.png\";s:12:\"tmpl_created\";i:1547968080;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:483;s:11:\"trend_index\";i:494;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:16:{s:4:\"tmpl\";i:817;s:2:\"id\";i:10622;s:5:\"title\";s:34:\"Full Screen | Contact | Headphones\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/full_hear_small.png\";s:12:\"tmpl_created\";i:1547969678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/full-screen-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:543;s:11:\"trend_index\";i:456;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:16:{s:4:\"tmpl\";i:818;s:2:\"id\";i:10633;s:5:\"title\";s:23:\"Slide In | Login | Lego\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/tro_small-1.png\";s:12:\"tmpl_created\";i:1547969858;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/slide-in-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:675;s:11:\"trend_index\";i:722;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:16:{s:4:\"tmpl\";i:819;s:2:\"id\";i:10644;s:5:\"title\";s:26:\"Fly In | Contact | Webinar\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/blue_small-1.png\";s:12:\"tmpl_created\";i:1547970814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/fly-in-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:484;s:11:\"trend_index\";i:440;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:16:{s:4:\"tmpl\";i:820;s:2:\"id\";i:10654;s:5:\"title\";s:31:\"Full Screen | Login | Christmas\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/full_login_small.png\";s:12:\"tmpl_created\";i:1547970917;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/full-screen-login-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:658;s:11:\"trend_index\";i:676;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:16:{s:4:\"tmpl\";i:821;s:2:\"id\";i:10664;s:5:\"title\";s:34:\"Slide In | Contact | Gym | Fitness\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/slide_gym_small.png\";s:12:\"tmpl_created\";i:1547973928;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:552;s:11:\"trend_index\";i:384;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:16:{s:4:\"tmpl\";i:822;s:2:\"id\";i:10675;s:5:\"title\";s:35:\"Full Screen | Login | Gym | Fitness\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/gym_full_small.png\";s:12:\"tmpl_created\";i:1547974110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-login-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:519;s:11:\"trend_index\";i:477;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:16:{s:4:\"tmpl\";i:824;s:2:\"id\";i:9719;s:5:\"title\";s:30:\"Classic | Subscribe | Register\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/register_small.png\";s:12:\"tmpl_created\";i:1547976107;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-subscribe-register/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:398;s:11:\"trend_index\";i:282;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:16:{s:4:\"tmpl\";i:827;s:2:\"id\";i:10137;s:5:\"title\";s:34:\"Full Screen | Contact | Restaurant\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/rest_small.png\";s:12:\"tmpl_created\";i:1547976342;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:570;s:11:\"trend_index\";i:589;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:16:{s:4:\"tmpl\";i:828;s:2:\"id\";i:10244;s:5:\"title\";s:17:\"Bottom Bar | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/wow_small.png\";s:12:\"tmpl_created\";i:1547976402;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/bottom-bar-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:623;s:11:\"trend_index\";i:660;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:16:{s:4:\"tmpl\";i:830;s:2:\"id\";i:10127;s:5:\"title\";s:35:\"Fly In | Announcement | Maintenance\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/pizza_small.png\";s:12:\"tmpl_created\";i:1547984061;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-announcement-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:700;s:11:\"trend_index\";i:738;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:16:{s:4:\"tmpl\";i:835;s:2:\"id\";i:10776;s:5:\"title\";s:33:\"Fly In | Contact | Social | Share\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/social1_small.png\";s:12:\"tmpl_created\";i:1548047055;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fly-in-contact-social-share/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:694;s:11:\"trend_index\";i:694;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:16:{s:4:\"tmpl\";i:836;s:2:\"id\";i:10785;s:5:\"title\";s:33:\"Fly In | Contact | Social | Share\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/social2_small.png\";s:12:\"tmpl_created\";i:1548047593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/fly-in-contact-social-share-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:468;s:11:\"trend_index\";i:442;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:16:{s:4:\"tmpl\";i:854;s:2:\"id\";i:10794;s:5:\"title\";s:34:\"Classic | Contact | Social | Share\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/01/s_small.png\";s:12:\"tmpl_created\";i:1548067619;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-social-share/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:430;s:11:\"trend_index\";i:475;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:16:{s:4:\"tmpl\";i:857;s:2:\"id\";i:10871;s:5:\"title\";s:20:\"Bottom Bar | Contact\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/01/m_small.png\";s:12:\"tmpl_created\";i:1548074396;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/bottom-bar-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:706;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:16:{s:4:\"tmpl\";i:858;s:2:\"id\";i:10936;s:5:\"title\";s:25:\"Full Screen | Toggle Menu\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/menu_small.png\";s:12:\"tmpl_created\";i:1548874587;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/full-screen-toggle-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:478;s:11:\"trend_index\";i:572;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:16:{s:4:\"tmpl\";i:861;s:2:\"id\";i:10964;s:5:\"title\";s:59:\"Classic | Promotion | Coupon | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/02/love_small.png\";s:12:\"tmpl_created\";i:1550039106;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/classic-promotion-coupon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:598;s:11:\"trend_index\";i:664;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:16:{s:4:\"tmpl\";i:862;s:2:\"id\";i:10992;s:5:\"title\";s:59:\"Classic | Promotion | Coupon | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/02/h_small.png\";s:12:\"tmpl_created\";i:1550072007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-promotion-coupon-love-valentines-day/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:668;s:11:\"trend_index\";i:668;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:16:{s:4:\"tmpl\";i:863;s:2:\"id\";i:11005;s:5:\"title\";s:50:\"Classic | Promotion | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/02/bear_small.png\";s:12:\"tmpl_created\";i:1550073303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-promotion-love-valentines-day/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:680;s:11:\"trend_index\";i:615;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:16:{s:4:\"tmpl\";i:1132;s:2:\"id\";i:16553;s:5:\"title\";s:31:\"Fly-In | Contact | Beauty Salon\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/12/PopUp.jpg\";s:12:\"tmpl_created\";i:1608622602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fly-in-contact-beauty-salon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:428;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:16:{s:4:\"tmpl\";i:883;s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:696;s:11:\"trend_index\";i:740;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:16:{s:4:\"tmpl\";i:893;s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:654;s:11:\"trend_index\";i:626;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:16:{s:4:\"tmpl\";i:899;s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:20;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:16:{s:4:\"tmpl\";i:923;s:2:\"id\";i:12229;s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";i:1572847842;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:547;s:11:\"trend_index\";i:413;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:16:{s:4:\"tmpl\";i:924;s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:754;s:11:\"trend_index\";i:791;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:16:{s:4:\"tmpl\";i:925;s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:690;s:11:\"trend_index\";i:714;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:16:{s:4:\"tmpl\";i:1199;s:2:\"id\";i:18839;s:5:\"title\";s:27:\"Hello Bar | CTA | eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png\";s:12:\"tmpl_created\";i:1621870603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:41:\"[\"Ecommerce\",\"online shop\",\"Sale\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:16:{s:4:\"tmpl\";i:951;s:2:\"id\";i:12736;s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";i:1579060978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:734;s:11:\"trend_index\";i:686;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:16:{s:4:\"tmpl\";i:952;s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:357;s:11:\"trend_index\";i:281;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:56;a:16:{s:4:\"tmpl\";i:958;s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:521;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:57;a:16:{s:4:\"tmpl\";i:719;s:2:\"id\";i:9611;s:5:\"title\";s:16:\"Hello Bar | Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2019/01/Top-Bar_Sale_small_01.png\";s:12:\"tmpl_created\";i:1546965350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/hello-bar-sale-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:605;s:11:\"trend_index\";i:603;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:58;a:16:{s:4:\"tmpl\";i:720;s:2:\"id\";i:9622;s:5:\"title\";s:19:\"Classic | Promotion\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_promotion_small_02.png\";s:12:\"tmpl_created\";i:1546965896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-promotion-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:607;s:11:\"trend_index\";i:460;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:59;a:16:{s:4:\"tmpl\";i:721;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1546968270;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/slide-in-sale-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:661;s:11:\"trend_index\";i:705;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:60;a:16:{s:4:\"tmpl\";i:724;s:2:\"id\";i:9662;s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2019/01/Bottom-Bar_Register_small_01.png\";s:12:\"tmpl_created\";i:1547009087;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/popups/bottom-bar-register-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:684;s:11:\"trend_index\";i:658;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:61;a:16:{s:4:\"tmpl\";i:981;s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:763;s:11:\"trend_index\";i:679;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:62;a:16:{s:4:\"tmpl\";i:727;s:2:\"id\";i:9690;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Contact_small_01.png\";s:12:\"tmpl_created\";i:1547011716;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/classic-contact-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:393;s:11:\"trend_index\";i:571;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:63;a:16:{s:4:\"tmpl\";i:728;s:2:\"id\";i:9699;s:5:\"title\";s:33:\"Classic | Contact | Gym | Fitness\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Contact_small_02.png\";s:12:\"tmpl_created\";i:1547015827;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/classic-contact-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:475;s:11:\"trend_index\";i:527;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:64;a:16:{s:4:\"tmpl\";i:730;s:2:\"id\";i:9571;s:5:\"title\";s:14:\"Fly In | Login\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/FlyIn_Login_01_small.png\";s:12:\"tmpl_created\";i:1547726151;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/fly-in-login-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:622;s:11:\"trend_index\";i:538;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:65;a:16:{s:4:\"tmpl\";i:733;s:2:\"id\";i:9740;s:5:\"title\";s:25:\"Classic | Promotion | App\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/app_small.png\";s:12:\"tmpl_created\";i:1547822836;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/classic-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:624;s:11:\"trend_index\";i:691;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:66;a:16:{s:4:\"tmpl\";i:1245;s:2:\"id\";i:21546;s:5:\"title\";s:28:\"Interior Design &#8211; Home\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/1-Home-Interior-Design-1.jpg\";s:12:\"tmpl_created\";i:1639046269;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/interior-design-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Design\",\"Form\",\"Furniture Design\",\"Interior Design\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:67;a:16:{s:4:\"tmpl\";i:735;s:2:\"id\";i:9762;s:5:\"title\";s:36:\"Classic | Register | Subscribe | Spa\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/spa_small_classic.png\";s:12:\"tmpl_created\";i:1547824145;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-register-subscribe-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:463;s:11:\"trend_index\";i:436;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:68;a:16:{s:4:\"tmpl\";i:991;s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:369;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:69;a:16:{s:4:\"tmpl\";i:736;s:2:\"id\";i:9772;s:5:\"title\";s:27:\"Hello bar | Promotion | App\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/app_hello_small.png\";s:12:\"tmpl_created\";i:1547824279;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/hello-bar-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:760;s:11:\"trend_index\";i:781;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:70;a:16:{s:4:\"tmpl\";i:992;s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:582;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:71;a:16:{s:4:\"tmpl\";i:993;s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:516;s:11:\"trend_index\";i:432;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:72;a:16:{s:4:\"tmpl\";i:738;s:2:\"id\";i:9793;s:5:\"title\";s:13:\"Fly In | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_black_small.png\";s:12:\"tmpl_created\";i:1547831151;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/popups/fly-in-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:670;s:11:\"trend_index\";i:742;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:73;a:16:{s:4:\"tmpl\";i:742;s:2:\"id\";i:9836;s:5:\"title\";s:21:\"Classic | Login | Pop\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/login_b_small.png\";s:12:\"tmpl_created\";i:1547835635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/popups/classic-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:634;s:11:\"trend_index\";i:669;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:74;a:16:{s:4:\"tmpl\";i:743;s:2:\"id\";i:9847;s:5:\"title\";s:25:\"Fly In | Promotion | Lego\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_in_promotion_tro.png\";s:12:\"tmpl_created\";i:1547836956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/fly-in-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:751;s:11:\"trend_index\";i:838;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:75;a:16:{s:4:\"tmpl\";i:744;s:2:\"id\";i:9858;s:5:\"title\";s:27:\"Slide In | Promotion | Wine\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/slide-in_promotion_wine_small.png\";s:12:\"tmpl_created\";i:1547837100;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:769;s:11:\"trend_index\";i:684;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:76;a:16:{s:4:\"tmpl\";i:1004;s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:710;s:11:\"trend_index\";i:667;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:77;a:16:{s:4:\"tmpl\";i:752;s:2:\"id\";i:9944;s:5:\"title\";s:33:\"Slide In | Promotion | Headphones\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_head_small.png\";s:12:\"tmpl_created\";i:1547841939;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/slide-in-promotion-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:757;s:11:\"trend_index\";i:700;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:78;a:16:{s:4:\"tmpl\";i:753;s:2:\"id\";i:9955;s:5:\"title\";s:14:\"Fly In | Login\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_login_lock_small.png\";s:12:\"tmpl_created\";i:1547842065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/popups/fly-in-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:551;s:11:\"trend_index\";i:627;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:79;a:16:{s:4:\"tmpl\";i:754;s:2:\"id\";i:9965;s:5:\"title\";s:30:\"Classic | Register | Subscribe\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_moon_small.png\";s:12:\"tmpl_created\";i:1547842174;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:588;s:11:\"trend_index\";i:591;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:80;a:16:{s:4:\"tmpl\";i:757;s:2:\"id\";i:9995;s:5:\"title\";s:27:\"Slide In | Sale | Christmas\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_christmas_small.png\";s:12:\"tmpl_created\";i:1547844802;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/slide-in-sale-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:772;s:11:\"trend_index\";i:817;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:81;a:16:{s:4:\"tmpl\";i:759;s:2:\"id\";i:10016;s:5:\"title\";s:16:\"Hello Bar | Sale\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/Hello-Bar_Promotion_bag_small.png\";s:12:\"tmpl_created\";i:1547845062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/hello-bar-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:792;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:82;a:16:{s:4:\"tmpl\";i:1015;s:2:\"id\";i:14067;s:5:\"title\";s:37:\"Slide In | Japanese restaurant | Menu\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg\";s:12:\"tmpl_created\";i:1592290352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:650;s:11:\"trend_index\";i:565;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:83;a:16:{s:4:\"tmpl\";i:760;s:2:\"id\";i:10026;s:5:\"title\";s:46:\"Classic | Register | Subscribe | Gym | Fitness\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_register_small.png\";s:12:\"tmpl_created\";i:1547845205;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:616;s:11:\"trend_index\";i:587;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:84;a:16:{s:4:\"tmpl\";i:761;s:2:\"id\";i:10036;s:5:\"title\";s:43:\"Full Screen | Sale | Promotion | Headphones\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/full_sale_head_small.png\";s:12:\"tmpl_created\";i:1547845409;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:614;s:11:\"trend_index\";i:717;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:85;a:16:{s:4:\"tmpl\";i:1017;s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:717;s:11:\"trend_index\";i:697;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:86;a:16:{s:4:\"tmpl\";i:763;s:2:\"id\";i:10057;s:5:\"title\";s:48:\"Hello Bar | Register | Subscribe | Gym | Fitness\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2019/01/hello-bar_register_sport_small.png\";s:12:\"tmpl_created\";i:1547847938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/hello-bar-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:764;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:87;a:16:{s:4:\"tmpl\";i:766;s:2:\"id\";i:10087;s:5:\"title\";s:25:\"Full Screen | Login | Spa\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2019/01/full-screen_login_spa_small.png\";s:12:\"tmpl_created\";i:1547848301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/full-screen-login-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:644;s:11:\"trend_index\";i:632;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:88;a:16:{s:4:\"tmpl\";i:767;s:2:\"id\";i:10097;s:5:\"title\";s:37:\"Classic | Register | Subscribe | Lego\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_lego_small.png\";s:12:\"tmpl_created\";i:1547848411;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:689;s:11:\"trend_index\";i:758;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:89;a:16:{s:4:\"tmpl\";i:831;s:2:\"id\";i:9816;s:5:\"title\";s:30:\"Classic | Sale | Gym | Fitness\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_sale_sport_small.png\";s:12:\"tmpl_created\";i:1547991876;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:720;s:11:\"trend_index\";i:823;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:90;a:16:{s:4:\"tmpl\";i:674;s:2:\"id\";i:8505;s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";i:1526415501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:533;s:11:\"trend_index\";i:222;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:91;a:16:{s:4:\"tmpl\";i:1218;s:2:\"id\";i:20792;s:5:\"title\";s:26:\"Luxury Car &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/11/250x280-1.jpg\";s:12:\"tmpl_created\";i:1636903770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/lp/luxury-car-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:54:\"[\"car\",\"Ecommerce\",\"Landing Pages\",\"luxury\",\"Product\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:92;a:16:{s:4:\"tmpl\";i:718;s:2:\"id\";i:9602;s:5:\"title\";s:35:\"Bottom Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2019/01/Bottombar_Announcement_small_01.png\";s:12:\"tmpl_created\";i:1546964559;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/bottom-bar-announcement-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:600;s:11:\"trend_index\";i:604;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:93;a:16:{s:4:\"tmpl\";i:1233;s:2:\"id\";i:21205;s:5:\"title\";s:29:\"Photographer &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/25-Projects-Photographer.jpg\";s:12:\"tmpl_created\";i:1638818372;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/photographer-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Black and white\",\"Photography\",\"project\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:94;a:16:{s:4:\"tmpl\";i:675;s:2:\"id\";i:8511;s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";i:1526415528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:347;s:11:\"trend_index\";i:155;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:95;a:16:{s:4:\"tmpl\";i:1204;s:2:\"id\";i:20208;s:5:\"title\";s:49:\"Alternative Medicine Acupuncture &#8211; Business\";s:9:\"thumbnail\";s:112:\"https://library.elementor.com/wp-content/uploads/2021/10/Alternative-Medicine-Acupuncture-Business-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633880557;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/alternative-medicine-acupuncture-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:47:\"[\"Health\",\"Landing Pages\",\"medical\",\"Services\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:96;a:16:{s:4:\"tmpl\";i:1224;s:2:\"id\";i:21013;s:5:\"title\";s:24:\"Restaurant &#8211; About\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/12/7-About-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638795588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/restaurant-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:36:\"[\"About\",\"Chef\",\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:97;a:16:{s:4:\"tmpl\";i:842;s:2:\"id\";i:10277;s:5:\"title\";s:36:\"Bottom Bar | Promotion | Sale | Book\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/book_small.png\";s:12:\"tmpl_created\";i:1548055999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/bottom-bar-promotion-book/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:729;s:11:\"trend_index\";i:802;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:98;a:16:{s:4:\"tmpl\";i:875;s:2:\"id\";i:11241;s:5:\"title\";s:36:\"Classic | Digital Agency | Marketing\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg\";s:12:\"tmpl_created\";i:1564643043;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:362;s:11:\"trend_index\";i:315;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:99;a:16:{s:4:\"tmpl\";i:672;s:2:\"id\";i:8512;s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";i:1526415449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:450;s:11:\"trend_index\";i:375;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:100;a:16:{s:4:\"tmpl\";i:1205;s:2:\"id\";i:20233;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633881371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/lp/art-magazine-coming-soon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:101;a:16:{s:4:\"tmpl\";i:1235;s:2:\"id\";i:21281;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/16-Services-Law-firm.jpg\";s:12:\"tmpl_created\";i:1638819128;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/law-firm-services-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Consulting\",\"Law\",\"Law Firm\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:102;a:16:{s:4:\"tmpl\";i:671;s:2:\"id\";i:8513;s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";i:1526415417;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:420;s:11:\"trend_index\";i:176;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:103;a:16:{s:4:\"tmpl\";i:1214;s:2:\"id\";i:20539;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/design-blog-coming-soon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:104;a:16:{s:4:\"tmpl\";i:1239;s:2:\"id\";i:21373;s:5:\"title\";s:28:\"Photographer &#8211; Gallery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/18-Gallery-Photographer.jpg\";s:12:\"tmpl_created\";i:1638821177;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/photographer-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:44:\"[\"Gallery\",\"Photography\",\"Project\",\"Travel\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:105;a:16:{s:4:\"tmpl\";i:748;s:2:\"id\";i:9903;s:5:\"title\";s:34:\"Bottom Bar | Promotion | Olive Oil\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2019/01/bottom-bar_promotion_olive_small.png\";s:12:\"tmpl_created\";i:1547838896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/bottom-bar-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:765;s:11:\"trend_index\";i:840;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:106;a:16:{s:4:\"tmpl\";i:676;s:2:\"id\";i:8514;s:5:\"title\";s:11:\"404 Page 05\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg\";s:12:\"tmpl_created\";i:1526415558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-05/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:419;s:11:\"trend_index\";i:220;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:107;a:16:{s:4:\"tmpl\";i:1206;s:2:\"id\";i:20254;s:5:\"title\";s:41:\"Digital Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Digital-Marketing-Agency-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/digital-marketing-agency-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:65:\"[\"Agency\",\"Business\",\"Digital Agency\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:108;a:16:{s:4:\"tmpl\";i:1238;s:2:\"id\";i:21349;s:5:\"title\";s:29:\"Architecture &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/23-Projects-Architecture.jpg\";s:12:\"tmpl_created\";i:1638820870;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/architecture-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:70:\"[\"Architecture\",\"Creative\",\"creative portfolio\",\"portfolio\",\"Project\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:109;a:16:{s:4:\"tmpl\";i:810;s:2:\"id\";i:10549;s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/com_small.png\";s:12:\"tmpl_created\";i:1547967595;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/bottom-bar-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:713;s:11:\"trend_index\";i:666;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:110;a:16:{s:4:\"tmpl\";i:668;s:2:\"id\";i:8523;s:5:\"title\";s:11:\"404 page 06\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg\";s:12:\"tmpl_created\";i:1526415291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-06/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:298;s:11:\"trend_index\";i:268;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:111;a:16:{s:4:\"tmpl\";i:1213;s:2:\"id\";i:20509;s:5:\"title\";s:40:\"Dogs Adoption &#8211; Social Involvement\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/10/Dog-Adoption-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/dogs-adoption-social-involvement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:49:\"[\"Adoption\",\"Involvement\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:112;a:16:{s:4:\"tmpl\";i:1242;s:2:\"id\";i:21473;s:5:\"title\";s:40:\"Architecture Photography &#8211; Gallery\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/20-Gallery-Architecture-Photography.jpg\";s:12:\"tmpl_created\";i:1638822115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/architecture-photography-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:52:\"[\"Architecture\",\"Gallery\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:113;a:16:{s:4:\"tmpl\";i:669;s:2:\"id\";i:8524;s:5:\"title\";s:11:\"404 page 07\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg\";s:12:\"tmpl_created\";i:1526415337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-07/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:303;s:11:\"trend_index\";i:171;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:114;a:16:{s:4:\"tmpl\";i:1208;s:2:\"id\";i:20361;s:5:\"title\";s:51:\"Exercise &#038; Fitness Equipment &#8211; eCommerce\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2021/10/Exercise-Fitness-Equipment-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633883766;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/lp/exercise-fitness-equipment-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Fitness\",\"Health\",\"Landing Pages\",\"online shop\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:115;a:16:{s:4:\"tmpl\";i:1236;s:2:\"id\";i:21259;s:5:\"title\";s:28:\"3D Designer &#8211; Projects\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/24-Projects-3D-Designer.jpg\";s:12:\"tmpl_created\";i:1638819185;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/3d-designer-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"3D\",\"creative portfolio\",\"Design\",\"Designer\",\"portfolio\",\"Project\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:116;a:16:{s:4:\"tmpl\";i:673;s:2:\"id\";i:8526;s:5:\"title\";s:11:\"404 page 09\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg\";s:12:\"tmpl_created\";i:1526415474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-09/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:477;s:11:\"trend_index\";i:285;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:117;a:16:{s:4:\"tmpl\";i:1215;s:2:\"id\";i:20556;s:5:\"title\";s:41:\"Faroe Islands Trip Planner &#8211; Travel\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2021/10/Faroe-Islands-Trip-Planner-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634026480;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/faroe-islands-trip-planner-travel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:26:\"[\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:118;a:16:{s:4:\"tmpl\";i:1225;s:2:\"id\";i:21041;s:5:\"title\";s:41:\"Business Consulting Company &#8211; About\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/8-About-Business-Consulting-Company.jpg\";s:12:\"tmpl_created\";i:1638797560;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/business-consulting-company-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Coach\",\"Collaboration\",\"Consulting\",\"Life Coach\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:119;a:16:{s:4:\"tmpl\";i:834;s:2:\"id\";i:10529;s:5:\"title\";s:36:\"Classic | Announcement | Maintenance\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/icon_small.png\";s:12:\"tmpl_created\";i:1548046309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:474;s:11:\"trend_index\";i:398;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:120;a:16:{s:4:\"tmpl\";i:670;s:2:\"id\";i:8525;s:5:\"title\";s:11:\"404 page 08\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg\";s:12:\"tmpl_created\";i:1526415374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-08/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:510;s:11:\"trend_index\";i:575;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:121;a:16:{s:4:\"tmpl\";i:1207;s:2:\"id\";i:20299;s:5:\"title\";s:51:\"Interior Design Consultation &#8211; Online Service\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/10/Interior-Design-Consultation-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/interior-design-consultation-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:65:\"[\"Consulting\",\"interior design\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:122;a:16:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:21083;s:5:\"title\";s:26:\"Conference &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/10-Contact-Conference.jpg\";s:12:\"tmpl_created\";i:1638799208;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/conference-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:37:\"[\"Conference\",\"Contact\",\"Info\",\"Map\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:123;a:16:{s:4:\"tmpl\";i:1216;s:2:\"id\";i:20623;s:5:\"title\";s:57:\"Luxurious Camping Accommodation For Events &#8211; Events\";s:9:\"thumbnail\";s:113:\"https://library.elementor.com/wp-content/uploads/2021/10/Luxurious-Camping-Accommodation-For-Events-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634041681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/lp/luxurious-camping-accommodation-for-events-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:43:\"[\"Event\",\"Events\",\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:124;a:16:{s:4:\"tmpl\";i:1243;s:2:\"id\";i:21135;s:5:\"title\";s:28:\"Construction &#8211; Service\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/13-Service-Construction.jpg\";s:12:\"tmpl_created\";i:1638823202;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/construction-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Architecture\",\"Construction\",\"Faq\",\"Services\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:125;a:16:{s:4:\"tmpl\";i:502;s:2:\"id\";i:5438;s:5:\"title\";s:7:\"About 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png\";s:12:\"tmpl_created\";i:1520443512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:147;s:11:\"trend_index\";i:9;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:126;a:16:{s:4:\"tmpl\";i:557;s:2:\"id\";i:6135;s:5:\"title\";s:8:\"About 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png\";s:12:\"tmpl_created\";i:1520443663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:77;s:11:\"trend_index\";i:47;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:127;a:16:{s:4:\"tmpl\";i:1210;s:2:\"id\";i:20414;s:5:\"title\";s:45:\"Online English Courses &#8211; Online Service\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Online-English-Courses-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/online-english-courses-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Course Online\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:128;a:16:{s:4:\"tmpl\";i:1229;s:2:\"id\";i:21118;s:5:\"title\";s:28:\"Contact &#8211; Plants Store\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/12-Contact-Plants-Store.jpg\";s:12:\"tmpl_created\";i:1638802472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/contact-plants-store/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:40:\"[\"Contact\",\"Info\",\"Plant\",\"Testimonial\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:129;a:16:{s:4:\"tmpl\";i:1217;s:2:\"id\";i:20333;s:5:\"title\";s:40:\"Plant Pots Online Shop &#8211; eCommerce\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Plant-Pots-Online-Shop-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634042184;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/plant-pots-online-shop-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Ecommerce\",\"Landing Pages\",\"online shop\",\"Shop\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:130;a:16:{s:4:\"tmpl\";i:1223;s:2:\"id\";i:20981;s:5:\"title\";s:37:\"Creative Digital Agency &#8211; About\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2021/12/6-About-Creative-Digital-Agency.jpg\";s:12:\"tmpl_created\";i:1638789303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/creative-digital-agency-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"About\",\"Advisor\",\"Creative\",\"Creative Portfolio\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:131;a:16:{s:4:\"tmpl\";i:497;s:2:\"id\";i:5397;s:5:\"title\";s:8:\"About 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png\";s:12:\"tmpl_created\";i:1520443503;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:148;s:11:\"trend_index\";i:43;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:132;a:16:{s:4:\"tmpl\";i:1211;s:2:\"id\";i:20447;s:5:\"title\";s:33:\"Shared Workspace &#8211; Business\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Shared-Workspace.jpg\";s:12:\"tmpl_created\";i:1633884934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/shared-workspace-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:28:\"[\"Business\",\"Landing Pages\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:133;a:16:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:21184;s:5:\"title\";s:28:\"Dental Care &#8211; Services\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/14-Services-Dental-Care.jpg\";s:12:\"tmpl_created\";i:1638807148;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/dental-care-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:45:\"[\"Dental\",\"Medical\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:134;a:16:{s:4:\"tmpl\";i:498;s:2:\"id\";i:5405;s:5:\"title\";s:8:\"About 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png\";s:12:\"tmpl_created\";i:1520443505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:216;s:11:\"trend_index\";i:50;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:135;a:16:{s:4:\"tmpl\";i:1212;s:2:\"id\";i:20479;s:5:\"title\";s:49:\"Teeth Straightening &#8211; Health &#038; Fitness\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Teeth-Whitening.jpg\";s:12:\"tmpl_created\";i:1633886115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/teeth-straightening-health-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:46:\"[\"Business\",\"Dental\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:136;a:16:{s:4:\"tmpl\";i:1221;s:2:\"id\";i:20926;s:5:\"title\";s:33:\"Doctors Online Consultation -Home\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/12/4-Home-Doctors-Online-Consultation.jpg\";s:12:\"tmpl_created\";i:1638787371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/doctors-online-consultation-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:35:\"[\"App\",\"Health\",\"medical\",\"Online\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:137;a:16:{s:4:\"tmpl\";i:500;s:2:\"id\";i:5421;s:5:\"title\";s:8:\"About 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png\";s:12:\"tmpl_created\";i:1520443509;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:215;s:11:\"trend_index\";i:77;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:138;a:16:{s:4:\"tmpl\";i:513;s:2:\"id\";i:5533;s:5:\"title\";s:8:\"About 15\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png\";s:12:\"tmpl_created\";i:1520443534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:21;s:11:\"trend_index\";i:57;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:139;a:16:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:20394;s:5:\"title\";s:30:\"Time Management &#8211; Events\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/10/Time-Management-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884077;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/lp/time-management-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:140;a:16:{s:4:\"tmpl\";i:1241;s:2:\"id\";i:21451;s:5:\"title\";s:26:\"Exhibition &#8211; Gallery\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/21-Gallery-Exhibition.jpg\";s:12:\"tmpl_created\";i:1638821855;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/exhibition-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"Art\",\"Creative\",\"creative portfolio\",\"Exhibition\",\"Gallery\",\"portfolio\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:141;a:16:{s:4:\"tmpl\";i:512;s:2:\"id\";i:5525;s:5:\"title\";s:8:\"About 14\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png\";s:12:\"tmpl_created\";i:1520443532;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:9;s:11:\"trend_index\";i:29;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:142;a:16:{s:4:\"tmpl\";i:1203;s:2:\"id\";i:18591;s:5:\"title\";s:28:\"Coffee Sale &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280-7.png\";s:12:\"tmpl_created\";i:1633877319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/lp/coffee-sale-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:33:\"[\"Coffee\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:143;a:16:{s:4:\"tmpl\";i:797;s:2:\"id\";i:10413;s:5:\"title\";s:28:\"Classic | Content Lock | Pop\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/hot_small.png\";s:12:\"tmpl_created\";i:1547961774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-content-lock/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:752;s:11:\"trend_index\";i:813;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:144;a:16:{s:4:\"tmpl\";i:1133;s:2:\"id\";i:16645;s:5:\"title\";s:28:\"Headphones &#8211; eCommerce\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_headphones.png\";s:12:\"tmpl_created\";i:1609944115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/lp/commerce-headphones/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:39:\"[\"Ecommerce\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:633;s:11:\"trend_index\";i:87;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:145;a:16:{s:4:\"tmpl\";i:1226;s:2:\"id\";i:21069;s:5:\"title\";s:21:\"Hotel &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/12/9-Contact-Hotel.jpg\";s:12:\"tmpl_created\";i:1638798545;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/hotel-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Contact\",\"Info\",\"Vacation\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:146;a:16:{s:4:\"tmpl\";i:501;s:2:\"id\";i:5429;s:5:\"title\";s:8:\"About 16\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png\";s:12:\"tmpl_created\";i:1520443510;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:59;s:11:\"trend_index\";i:8;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:147;a:16:{s:4:\"tmpl\";i:1138;s:2:\"id\";i:16762;s:5:\"title\";s:25:\"Conference &#8211; Events\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Conference.png\";s:12:\"tmpl_created\";i:1610455119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/lp/conference-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:60:\"[\"Conference\",\"Convention\",\"Event\",\"Events\",\"Landing Pages\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:705;s:11:\"trend_index\";i:216;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:148;a:16:{s:4:\"tmpl\";i:1234;s:2:\"id\";i:21234;s:5:\"title\";s:34:\"Insurance Company &#8211; Services\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/15-Services-Insurance-Company.jpg\";s:12:\"tmpl_created\";i:1638818688;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/insurance-company-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Faq\",\"Form\",\"Insurance\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:149;a:16:{s:4:\"tmpl\";i:505;s:2:\"id\";i:5464;s:5:\"title\";s:8:\"About 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_6.png\";s:12:\"tmpl_created\";i:1520443518;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:220;s:11:\"trend_index\";i:142;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:150;a:16:{s:4:\"tmpl\";i:779;s:2:\"id\";i:10223;s:5:\"title\";s:15:\"Classic | Login\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/welcome_small.png\";s:12:\"tmpl_created\";i:1547887343;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:497;s:11:\"trend_index\";i:503;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:151;a:16:{s:4:\"tmpl\";i:811;s:2:\"id\";i:10559;s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_small.png\";s:12:\"tmpl_created\";i:1547967711;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/bottom-bar-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:714;s:11:\"trend_index\";i:729;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:152;a:16:{s:4:\"tmpl\";i:1194;s:2:\"id\";i:18701;s:5:\"title\";s:32:\"Digital Course &#8211; eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280.jpg\";s:12:\"tmpl_created\";i:1618995134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/lp/digital-course-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Ecommerce\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:153;a:16:{s:4:\"tmpl\";i:510;s:2:\"id\";i:5504;s:5:\"title\";s:8:\"About 18\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_9.png\";s:12:\"tmpl_created\";i:1520443528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:104;s:11:\"trend_index\";i:46;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:154;a:16:{s:4:\"tmpl\";i:846;s:2:\"id\";i:10403;s:5:\"title\";s:15:\"Classic | Login\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/hello_small.png\";s:12:\"tmpl_created\";i:1548056371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:627;s:11:\"trend_index\";i:659;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:155;a:16:{s:4:\"tmpl\";i:1192;s:2:\"id\";i:18612;s:5:\"title\";s:34:\"Bag Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bag-Product.jpeg\";s:12:\"tmpl_created\";i:1618395406;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/bag-product-sale-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:61:\"[\"Bag\",\"Ecommerce\",\"Landing Pages\",\"Product\",\"Sale\",\"Travel\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:875;s:11:\"trend_index\";i:605;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:156;a:16:{s:4:\"tmpl\";i:1244;s:2:\"id\";i:21393;s:5:\"title\";s:34:\"Interior Designer &#8211; Projects\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/12/big-22-Projects-Interior-Designer-New.jpeg\";s:12:\"tmpl_created\";i:1638823945;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/interior-designer-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:93:\"[\"Creative\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Interior Design\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:157;a:16:{s:4:\"tmpl\";i:511;s:2:\"id\";i:5515;s:5:\"title\";s:8:\"About 19\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_9.png\";s:12:\"tmpl_created\";i:1520443530;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:268;s:11:\"trend_index\";i:161;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:158;a:16:{s:4:\"tmpl\";i:1193;s:2:\"id\";i:18644;s:5:\"title\";s:37:\"Camera Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/camera_sale_featured-img.jpg\";s:12:\"tmpl_created\";i:1618396388;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/camera-product-sale-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Camera\",\"Ecommerce\",\"Landing Pages\",\"Photography\",\"Sale\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:873;s:11:\"trend_index\";i:535;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:159;a:16:{s:4:\"tmpl\";i:1219;s:2:\"id\";i:20886;s:5:\"title\";s:28:\"Online Training &#8211; Home\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/12/2-Home-Online-Training.jpg\";s:12:\"tmpl_created\";i:1638784769;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/online-training-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Online\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:160;a:16:{s:4:\"tmpl\";i:749;s:2:\"id\";i:9913;s:5:\"title\";s:27:\"Classic | Login | Christmas\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/log_small.png\";s:12:\"tmpl_created\";i:1547841430;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:542;s:11:\"trend_index\";i:417;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:161;a:16:{s:4:\"tmpl\";i:506;s:2:\"id\";i:5472;s:5:\"title\";s:7:\"About 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_7.png\";s:12:\"tmpl_created\";i:1520443520;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:210;s:11:\"trend_index\";i:116;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:162;a:16:{s:4:\"tmpl\";i:1196;s:2:\"id\";i:18815;s:5:\"title\";s:25:\"Car Wash &#8211; Business\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Car-Wash.png\";s:12:\"tmpl_created\";i:1621336431;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/lp/car-wash-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:45:\"[\"Business\",\"car\",\"Discount\",\"Landing Pages\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:163;a:16:{s:4:\"tmpl\";i:1220;s:2:\"id\";i:20908;s:5:\"title\";s:42:\"Packing &#038; Moving Company &#8211; Home\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/3-Home-Packing-Moving-Company.jpg\";s:12:\"tmpl_created\";i:1638786127;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/packing-moving-company-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Movers\",\"moving\",\"Storge\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:164;a:16:{s:4:\"tmpl\";i:504;s:2:\"id\";i:5455;s:5:\"title\";s:8:\"About 20\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_6.png\";s:12:\"tmpl_created\";i:1520443516;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:134;s:11:\"trend_index\";i:70;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:165;a:16:{s:4:\"tmpl\";i:1198;s:2:\"id\";i:18824;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1621336756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/design-school-coming-soon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:166;a:16:{s:4:\"tmpl\";i:1228;s:2:\"id\";i:21104;s:5:\"title\";s:26:\"Restaurant &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/11-Contact-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638800146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/restaurant-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:46:\"[\"Contact\",\"Food\",\"form\",\"Google Maps\",\"Info\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:167;a:16:{s:4:\"tmpl\";i:499;s:2:\"id\";i:5413;s:5:\"title\";s:8:\"About 21\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2.png\";s:12:\"tmpl_created\";i:1520443507;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:83;s:11:\"trend_index\";i:52;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:168;a:16:{s:4:\"tmpl\";i:1197;s:2:\"id\";i:18819;s:5:\"title\";s:27:\"Dog Walker &#8211; Business\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Dog-Walker.png\";s:12:\"tmpl_created\";i:1621336601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/lp/dog-walker-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:41:\"[\"Business\",\"Dog\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:169;a:16:{s:4:\"tmpl\";i:1237;s:2:\"id\";i:21313;s:5:\"title\";s:34:\"Spa &#038; Beauty &#8211; Services\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/12/Spa-Beauty-Treatments-page-1.jpg\";s:12:\"tmpl_created\";i:1638819709;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/spa-beauty-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:55:\"[\"Beauty\",\"Hair\",\"Health\",\"Services\",\"Spa\",\"Treatment\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:170;a:16:{s:4:\"tmpl\";i:503;s:2:\"id\";i:5447;s:5:\"title\";s:7:\"About 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_5.png\";s:12:\"tmpl_created\";i:1520443514;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:48;s:11:\"trend_index\";i:12;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:171;a:16:{s:4:\"tmpl\";i:1195;s:2:\"id\";i:18761;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1621336146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/fashion-store-coming-soon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:172;a:16:{s:4:\"tmpl\";i:1222;s:2:\"id\";i:20960;s:5:\"title\";s:26:\"Travel Agency &#8211; Home\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/5-Home-Travel-Agency.jpg\";s:12:\"tmpl_created\";i:1638788432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/travel-agency-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Adventures\",\"Experience\",\"Explore\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:173;a:16:{s:4:\"tmpl\";i:507;s:2:\"id\";i:5480;s:5:\"title\";s:7:\"About 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_7-1.png\";s:12:\"tmpl_created\";i:1520443522;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-4-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:428;s:11:\"trend_index\";i:303;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:174;a:16:{s:4:\"tmpl\";i:545;s:2:\"id\";i:6027;s:5:\"title\";s:7:\"About 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1-1.png\";s:12:\"tmpl_created\";i:1520443639;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-5-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:40;s:11:\"trend_index\";i:40;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:175;a:16:{s:4:\"tmpl\";i:1153;s:2:\"id\";i:17060;s:5:\"title\";s:36:\"Private Tutor &#8211; Online Service\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Tutor-2.png\";s:12:\"tmpl_created\";i:1610631042;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/private-tutor-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:64:\"[\"Education\",\"Landing Pages\",\"Online Service\",\"Teacher\",\"Tutor\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:780;s:11:\"trend_index\";i:628;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:176;a:16:{s:4:\"tmpl\";i:717;s:2:\"id\";i:9592;s:5:\"title\";s:26:\"Classic | Promotion | Sale\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Promotion_small_01.png\";s:12:\"tmpl_created\";i:1546963720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-promotion-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:663;s:11:\"trend_index\";i:807;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:177;a:16:{s:4:\"tmpl\";i:1240;s:2:\"id\";i:21430;s:5:\"title\";s:30:\"Travel Blogger &#8211; Gallery\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/12/19-Gallery-Travel-Blogger.jpg\";s:12:\"tmpl_created\";i:1638821592;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/travel-blogger-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Gallery\",\"Photography\",\"Slider\",\"Travel\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:178;a:16:{s:4:\"tmpl\";i:778;s:2:\"id\";i:10210;s:5:\"title\";s:29:\"Classic | Promotion | Webinar\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/web_small-1.png\";s:12:\"tmpl_created\";i:1547886103;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-promotion-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:784;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:179;a:16:{s:4:\"tmpl\";i:546;s:2:\"id\";i:6036;s:5:\"title\";s:7:\"About 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1-1.png\";s:12:\"tmpl_created\";i:1520443641;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-6-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:90;s:11:\"trend_index\";i:123;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:180;a:16:{s:4:\"tmpl\";i:1158;s:2:\"id\";i:17232;s:5:\"title\";s:33:\"Life Coach &#8211; Online Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Life-Coach.png\";s:12:\"tmpl_created\";i:1610902793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/life-coach-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:38:\"[\"Coach\",\"Landing Pages\",\"Life Coach\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:787;s:11:\"trend_index\";i:751;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:181;a:16:{s:4:\"tmpl\";i:1146;s:2:\"id\";i:16932;s:5:\"title\";s:35:\"Finance Consulting &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Finance-Consulting.png\";s:12:\"tmpl_created\";i:1610532170;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/finance-consulting-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:80:\"[\"Advisor\",\"Business\",\"Consulting\",\"Finance\",\"Investment\",\"Landing Pages\",\"Tax\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:790;s:11:\"trend_index\";i:630;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:182;a:16:{s:4:\"tmpl\";i:508;s:2:\"id\";i:5488;s:5:\"title\";s:7:\"About 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_8.png\";s:12:\"tmpl_created\";i:1520443524;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:307;s:11:\"trend_index\";i:169;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:183;a:16:{s:4:\"tmpl\";i:556;s:2:\"id\";i:6122;s:5:\"title\";s:7:\"About 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2-1.png\";s:12:\"tmpl_created\";i:1520443661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:38;s:11:\"trend_index\";i:26;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:184;a:16:{s:4:\"tmpl\";i:1136;s:2:\"id\";i:16721;s:5:\"title\";s:35:\"Dental &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Dental.jpg\";s:12:\"tmpl_created\";i:1610448567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/lp/dental-health-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:44:\"[\"Dental\",\"Doctor\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:801;s:11:\"trend_index\";i:655;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:185;a:16:{s:4:\"tmpl\";i:1161;s:2:\"id\";i:17269;s:5:\"title\";s:34:\"Electronics Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Electronic-Products.png\";s:12:\"tmpl_created\";i:1610903298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/electronics-sale-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:800;s:11:\"trend_index\";i:556;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:186;a:16:{s:4:\"tmpl\";i:762;s:2:\"id\";i:10047;s:5:\"title\";s:15:\"Classic | Login\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/yellow_small.png\";s:12:\"tmpl_created\";i:1547847757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:522;s:11:\"trend_index\";i:513;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:187;a:16:{s:4:\"tmpl\";i:509;s:2:\"id\";i:5496;s:5:\"title\";s:7:\"About 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_8-1.png\";s:12:\"tmpl_created\";i:1520443526;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:523;s:11:\"trend_index\";i:453;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:188;a:16:{s:4:\"tmpl\";i:1152;s:2:\"id\";i:17032;s:5:\"title\";s:42:\"Donate Computer &#8211; Social Involvement\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Donation-2.png\";s:12:\"tmpl_created\";i:1610630585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/donate-computer-social-involvement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:67:\"[\"Computer\",\"Donate\",\"Donation\",\"Kids\",\"Landing Pages\",\"Nonprofit\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:718;s:11:\"trend_index\";i:278;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:189;a:16:{s:4:\"tmpl\";i:684;s:2:\"id\";i:8961;s:5:\"title\";s:9:\"archive 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.1.jpg\";s:12:\"tmpl_created\";i:1528639909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:79;s:11:\"trend_index\";i:15;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:190;a:16:{s:4:\"tmpl\";i:746;s:2:\"id\";i:9879;s:5:\"title\";s:38:\"Classic | Register | Subscribe | Leads\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/dog_small.png\";s:12:\"tmpl_created\";i:1547838416;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:676;s:11:\"trend_index\";i:761;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:191;a:16:{s:4:\"tmpl\";i:1135;s:2:\"id\";i:16684;s:5:\"title\";s:34:\"SaaS HR Management &#8211; Product\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_hr.png\";s:12:\"tmpl_created\";i:1609945486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/saas-hr-management-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:39:\"[\"HR\",\"Landing Pages\",\"Product\",\"SaaS\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:708;s:11:\"trend_index\";i:292;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:192;a:16:{s:4:\"tmpl\";i:685;s:2:\"id\";i:8969;s:5:\"title\";s:9:\"archive 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.2.jpg\";s:12:\"tmpl_created\";i:1528700014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:250;s:11:\"trend_index\";i:124;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:193;a:16:{s:4:\"tmpl\";i:1201;s:2:\"id\";i:19144;s:5:\"title\";s:25:\"Birthday Party Invitation\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/06/250x280.png\";s:12:\"tmpl_created\";i:1623848691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/birthday-party-invitation/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Birthday\",\"Event\",\"Landing Pages\",\"Party\",\"RSVD\",\"Save the Date\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:194;a:16:{s:4:\"tmpl\";i:1124;s:2:\"id\";i:16473;s:5:\"title\";s:26:\"Beauty Salon &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/about-1.jpg\";s:12:\"tmpl_created\";i:1608622373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/beauty-salon-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"Hair\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:615;s:11:\"trend_index\";i:184;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:195;a:16:{s:4:\"tmpl\";i:1134;s:2:\"id\";i:16660;s:5:\"title\";s:37:\"Medical center &#8211; Online service\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-medical-cosultation-250_280.png\";s:12:\"tmpl_created\";i:1609945122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/medical-center-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:44:\"[\"Landing Pages\",\"medical\",\"Online Service\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:750;s:11:\"trend_index\";i:332;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:196;a:16:{s:4:\"tmpl\";i:686;s:2:\"id\";i:8973;s:5:\"title\";s:9:\"archive 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.3.jpg\";s:12:\"tmpl_created\";i:1528700205;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:176;s:11:\"trend_index\";i:54;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:197;a:16:{s:4:\"tmpl\";i:1125;s:2:\"id\";i:16488;s:5:\"title\";s:28:\"Beauty Salon &#8211; Contact\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/contact.jpg\";s:12:\"tmpl_created\";i:1608622374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/beauty-salon-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"Hair\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:548;s:11:\"trend_index\";i:101;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:198;a:16:{s:4:\"tmpl\";i:1150;s:2:\"id\";i:17001;s:5:\"title\";s:36:\"Parental Counseling &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/Parenting-Coach-2.png\";s:12:\"tmpl_created\";i:1610534999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/parental-counseling-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:99:\"[\"Advisor\",\"Business\",\"Coach\",\"Counseling\",\"Landing Pages\",\"Online Service\",\"Parental\",\"Parenting\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:817;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:199;a:16:{s:4:\"tmpl\";i:687;s:2:\"id\";i:8977;s:5:\"title\";s:9:\"archive 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.4.jpg\";s:12:\"tmpl_created\";i:1528700326;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:354;s:11:\"trend_index\";i:396;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:200;a:16:{s:4:\"tmpl\";i:843;s:2:\"id\";i:10297;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/s_yellow_small.png\";s:12:\"tmpl_created\";i:1548056099;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:590;s:11:\"trend_index\";i:607;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:201;a:16:{s:4:\"tmpl\";i:1126;s:2:\"id\";i:16496;s:5:\"title\";s:28:\"Beauty Salon &#8211; Gallery\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/12/gallery-1.jpg\";s:12:\"tmpl_created\";i:1608622379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/beauty-salon-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"Hair\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:491;s:11:\"trend_index\";i:90;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:202;a:16:{s:4:\"tmpl\";i:1137;s:2:\"id\";i:16742;s:5:\"title\";s:31:\"Online Course &#8211; Education\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Course.png\";s:12:\"tmpl_created\";i:1610454122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/online-course-education/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:55:\"[\"Academy\",\"Course Online\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:777;s:11:\"trend_index\";i:776;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:203;a:16:{s:4:\"tmpl\";i:688;s:2:\"id\";i:8981;s:5:\"title\";s:9:\"archive 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.5.jpg\";s:12:\"tmpl_created\";i:1528700484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:333;s:11:\"trend_index\";i:195;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:204;a:16:{s:4:\"tmpl\";i:847;s:2:\"id\";i:10393;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/blue_small.png\";s:12:\"tmpl_created\";i:1548056682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:678;s:11:\"trend_index\";i:837;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:205;a:16:{s:4:\"tmpl\";i:1127;s:2:\"id\";i:16457;s:5:\"title\";s:25:\"Beauty Salon &#8211; Home\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/home-1.jpg\";s:12:\"tmpl_created\";i:1608622383;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/beauty-salon-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"Hair\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:408;s:11:\"trend_index\";i:56;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:206;a:16:{s:4:\"tmpl\";i:1162;s:2:\"id\";i:17284;s:5:\"title\";s:38:\"Dietitian &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/01/Dietitian.png\";s:12:\"tmpl_created\";i:1610903484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/lp/dietitian-health-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Health\",\"landscape design\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:814;s:11:\"trend_index\";i:800;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:207;a:16:{s:4:\"tmpl\";i:689;s:2:\"id\";i:8985;s:5:\"title\";s:9:\"archive 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.6.jpg\";s:12:\"tmpl_created\";i:1528700612;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:204;s:11:\"trend_index\";i:95;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:208;a:16:{s:4:\"tmpl\";i:1128;s:2:\"id\";i:16518;s:5:\"title\";s:29:\"Beauty Salon &#8211; Services\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/12/services-1.jpg\";s:12:\"tmpl_created\";i:1608622386;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/beauty-salon-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"Hair\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:664;s:11:\"trend_index\";i:261;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:209;a:16:{s:4:\"tmpl\";i:1144;s:2:\"id\";i:16897;s:5:\"title\";s:30:\"Personal Chef &#8211; Business\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Personal-Chef.png\";s:12:\"tmpl_created\";i:1610466247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/lp/personal-chef-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:53:\"[\"Business\",\"Chef\",\"Food\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:795;s:11:\"trend_index\";i:617;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:210;a:16:{s:4:\"tmpl\";i:690;s:2:\"id\";i:8989;s:5:\"title\";s:9:\"archive 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.7.jpg\";s:12:\"tmpl_created\";i:1528701063;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:208;s:11:\"trend_index\";i:111;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:211;a:16:{s:4:\"tmpl\";i:813;s:2:\"id\";i:10579;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/sale1_small.png\";s:12:\"tmpl_created\";i:1547967887;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:712;s:11:\"trend_index\";i:782;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:212;a:16:{s:4:\"tmpl\";i:1073;s:2:\"id\";i:15486;s:5:\"title\";s:25:\"Travel Blog &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/About.jpg\";s:12:\"tmpl_created\";i:1606215720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/travel-blog-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:608;s:11:\"trend_index\";i:343;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:213;a:16:{s:4:\"tmpl\";i:1147;s:2:\"id\";i:16946;s:5:\"title\";s:52:\"Online Full-Stack Developer Course &#8211; Education\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Full-Stack-Developer-Course.png\";s:12:\"tmpl_created\";i:1610532778;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/lp/online-full-stack-developer-course-education/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:76:\"[\"Academy\",\"Coding\",\"Course Online\",\"Developer\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:805;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:214;a:16:{s:4:\"tmpl\";i:691;s:2:\"id\";i:8996;s:5:\"title\";s:9:\"archive 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.8.jpg\";s:12:\"tmpl_created\";i:1528701290;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:227;s:11:\"trend_index\";i:153;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:215;a:16:{s:4:\"tmpl\";i:1074;s:2:\"id\";i:15478;s:5:\"title\";s:27:\"Travel Blog &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1606215735;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-blog-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:687;s:11:\"trend_index\";i:564;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:216;a:16:{s:4:\"tmpl\";i:1143;s:2:\"id\";i:16868;s:5:\"title\";s:40:\"Virtual Assistant &#8211; Online Service\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/01/Virtual-Assistant-250x280-1.png\";s:12:\"tmpl_created\";i:1610465656;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/virtual-assistant-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:46:\"[\"Assistant\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:793;s:11:\"trend_index\";i:757;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:217;a:16:{s:4:\"tmpl\";i:692;s:2:\"id\";i:9001;s:5:\"title\";s:9:\"archive 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.9.jpg\";s:12:\"tmpl_created\";i:1528701433;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:265;s:11:\"trend_index\";i:208;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:218;a:16:{s:4:\"tmpl\";i:1075;s:2:\"id\";i:15467;s:5:\"title\";s:24:\"Travel Blog &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/11/Home.jpg\";s:12:\"tmpl_created\";i:1606215756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/travel-blog-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:567;s:11:\"trend_index\";i:224;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:219;a:16:{s:4:\"tmpl\";i:1140;s:2:\"id\";i:16812;s:5:\"title\";s:40:\"Construction Project &#8211; Real Estate\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Construction-Project.png\";s:12:\"tmpl_created\";i:1610463582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/construction-project-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:59:\"[\"Construction\",\"Landing Pages\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:796;s:11:\"trend_index\";i:724;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:220;a:16:{s:4:\"tmpl\";i:997;s:2:\"id\";i:13528;s:5:\"title\";s:22:\"Barbershop &#8211; 404\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/05/404-Page.jpg\";s:12:\"tmpl_created\";i:1589893152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/barbershop-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:34:\"[\"404\",\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:768;s:11:\"trend_index\";i:681;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:221;a:16:{s:4:\"tmpl\";i:1056;s:2:\"id\";i:15317;s:5:\"title\";s:25:\"Dance Studio &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/10/Home.jpg\";s:12:\"tmpl_created\";i:1603181291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/dance-studio-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:596;s:11:\"trend_index\";i:301;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:222;a:16:{s:4:\"tmpl\";i:1148;s:2:\"id\";i:16960;s:5:\"title\";s:44:\"Dog &amp; Cat Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2021/01/Dog-Food.png\";s:12:\"tmpl_created\";i:1610533581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/dog-cat-food-delivery-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:71:\"[\"Business\",\"Cat\",\"Delivery\",\"Dog\",\"Food\",\"Landing Pages\",\"Pet\",\"Pets\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:782;s:11:\"trend_index\";i:510;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:223;a:16:{s:4:\"tmpl\";i:998;s:2:\"id\";i:13518;s:5:\"title\";s:26:\"Barbershop &#8211; Archive\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/05/Blog-Page.jpg\";s:12:\"tmpl_created\";i:1589893157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/barbershop-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:737;s:11:\"trend_index\";i:523;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:224;a:16:{s:4:\"tmpl\";i:1057;s:2:\"id\";i:15334;s:5:\"title\";s:26:\"Dance Studio &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/About.jpg\";s:12:\"tmpl_created\";i:1603181364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/dance-studio-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:626;s:11:\"trend_index\";i:373;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:225;a:16:{s:4:\"tmpl\";i:1155;s:2:\"id\";i:17095;s:5:\"title\";s:36:\"Mobile Pet Grooming &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Mobile-Pet-Grooming.png\";s:12:\"tmpl_created\";i:1610632115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/mobile-pet-grooming-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:38:\"[\"Dog\",\"Groom\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:786;s:11:\"trend_index\";i:731;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:226;a:16:{s:4:\"tmpl\";i:996;s:2:\"id\";i:13604;s:5:\"title\";s:25:\"Barbershop &#8211; Footer\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/05/Footer-Small.jpg\";s:12:\"tmpl_created\";i:1589893147;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/barbershop-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"Footer\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:555;s:11:\"trend_index\";i:267;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:227;a:16:{s:4:\"tmpl\";i:1058;s:2:\"id\";i:15349;s:5:\"title\";s:28:\"Dance Studio &#8211; Classes\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes.jpg\";s:12:\"tmpl_created\";i:1603181425;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/dance-studio-classes/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:629;s:11:\"trend_index\";i:458;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:228;a:16:{s:4:\"tmpl\";i:833;s:2:\"id\";i:10180;s:5:\"title\";s:21:\"Fly In | Announcement\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/glass_small.png\";s:12:\"tmpl_created\";i:1548045309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-announcement-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:686;s:11:\"trend_index\";i:788;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:229;a:16:{s:4:\"tmpl\";i:1159;s:2:\"id\";i:17245;s:5:\"title\";s:34:\"Marketing Course &#8211; Education\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2021/01/PPC.png\";s:12:\"tmpl_created\";i:1610902958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/marketing-course-education/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:45:\"[\"Course Online\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:770;s:11:\"trend_index\";i:430;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:230;a:16:{s:4:\"tmpl\";i:995;s:2:\"id\";i:13612;s:5:\"title\";s:25:\"Barbershop &#8211; Header\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/06/barber-shop-header.jpg\";s:12:\"tmpl_created\";i:1589893142;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/barbershop-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"Header\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:343;s:11:\"trend_index\";i:137;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:231;a:16:{s:4:\"tmpl\";i:1055;s:2:\"id\";i:15366;s:5:\"title\";s:29:\"Dance Studio &#8211; Schedule\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes-Schedule.jpg\";s:12:\"tmpl_created\";i:1603181056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/dance-studio-schedule/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:698;s:11:\"trend_index\";i:602;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:232;a:16:{s:4:\"tmpl\";i:1149;s:2:\"id\";i:16983;s:5:\"title\";s:41:\"Pilates Instructor &#8211; Online Service\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Pilates-Instructor.png\";s:12:\"tmpl_created\";i:1610534138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/pilates-instructor-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:70:\"[\"Free Trial\",\"Instructor\",\"Landing Pages\",\"Online Service\",\"Pilates\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:778;s:11:\"trend_index\";i:412;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:233;a:16:{s:4:\"tmpl\";i:994;s:2:\"id\";i:13621;s:5:\"title\";s:30:\"Barbershop &#8211; Single Post\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/05/Single-Page.jpg\";s:12:\"tmpl_created\";i:1589893137;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/barbershop-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:736;s:11:\"trend_index\";i:580;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:234;a:16:{s:4:\"tmpl\";i:1059;s:2:\"id\";i:15373;s:5:\"title\";s:28:\"Dance Studio &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Pricing.jpg\";s:12:\"tmpl_created\";i:1603181678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/dance-studio-pricing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:731;s:11:\"trend_index\";i:661;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:235;a:16:{s:4:\"tmpl\";i:1131;s:2:\"id\";i:16527;s:5:\"title\";s:24:\"Beauty Salon &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/12/404.jpg\";s:12:\"tmpl_created\";i:1608622517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/beauty-salon-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:29:\"[\"404\",\"Beauty salon\",\"Hair\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:742;s:11:\"trend_index\";i:563;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:236;a:16:{s:4:\"tmpl\";i:1190;s:2:\"id\";i:18568;s:5:\"title\";s:32:\"Flower Delivery &#8211; Business\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/04/Flower-Delivery.png\";s:12:\"tmpl_created\";i:1617546716;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/lp/flower-delivery-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:37:\"[\"Delivery\",\"Flower\",\"Landing Pages\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:874;s:11:\"trend_index\";i:763;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:237;a:16:{s:4:\"tmpl\";i:1060;s:2:\"id\";i:15384;s:5:\"title\";s:28:\"Dance Studio &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/10/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1603181738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/dance-studio-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:741;s:11:\"trend_index\";i:721;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:238;a:16:{s:4:\"tmpl\";i:825;s:2:\"id\";i:9731;s:5:\"title\";s:26:\"Classic | Sale | Promotion\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/icecream_small.png\";s:12:\"tmpl_created\";i:1547976166;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/popups/classic-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:635;s:11:\"trend_index\";i:648;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:239;a:16:{s:4:\"tmpl\";i:1130;s:2:\"id\";i:16535;s:5:\"title\";s:27:\"Beauty Salon &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/Footer.jpg\";s:12:\"tmpl_created\";i:1608622498;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/beauty-salon-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:32:\"[\"Beauty salon\",\"Footer\",\"Hair\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:524;s:11:\"trend_index\";i:126;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:240;a:16:{s:4:\"tmpl\";i:1145;s:2:\"id\";i:16917;s:5:\"title\";s:22:\"Webinar &#8211; Events\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Webinar-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610466822;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/lp/webinar-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:36:\"[\"Events\",\"Landing Pages\",\"Webinar\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:821;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:241;a:16:{s:4:\"tmpl\";i:1042;s:2:\"id\";i:15158;s:5:\"title\";s:26:\"Psychologist &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/About.jpg\";s:12:\"tmpl_created\";i:1600157561;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/psychologist-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:618;s:11:\"trend_index\";i:426;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:242;a:16:{s:4:\"tmpl\";i:1129;s:2:\"id\";i:16545;s:5:\"title\";s:27:\"Beauty Salon &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/Header.jpg\";s:12:\"tmpl_created\";i:1608622495;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/beauty-salon-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:32:\"[\"Beauty salon\",\"Hair\",\"Header\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:356;s:11:\"trend_index\";i:49;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:243;a:16:{s:4:\"tmpl\";i:1154;s:2:\"id\";i:17079;s:5:\"title\";s:42:\"Calls Volunteer &#8211; Social Involvement\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Calls-Volunteer.png\";s:12:\"tmpl_created\";i:1610631774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/calls-volunteer-social-involvement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:68:\"[\"Care\",\"Covid-19\",\"Help\",\"Involvement\",\"Landing Pages\",\"Volunteer\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:854;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:244;a:16:{s:4:\"tmpl\";i:1045;s:2:\"id\";i:15197;s:5:\"title\";s:28:\"Psychologist &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1600160499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/psychologist-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:666;s:11:\"trend_index\";i:558;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:245;a:16:{s:4:\"tmpl\";i:1142;s:2:\"id\";i:16836;s:5:\"title\";s:33:\"Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/01/Marketing-Agency-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610464490;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/marketing-agency-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:74:\"[\"Agency\",\"Business\",\"Landing Pages\",\"Marketing\",\"Marketing Landing Page\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:816;s:11:\"trend_index\";i:787;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:246;a:16:{s:4:\"tmpl\";i:641;s:2:\"id\";i:7686;s:5:\"title\";s:12:\"Blog Posts 1\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2018/03/blog_posts.png\";s:12:\"tmpl_created\";i:1521558047;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/blog-posts-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:26:\"[\"Archive\",\"Blog\",\"posts\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:131;s:11:\"trend_index\";i:152;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:247;a:16:{s:4:\"tmpl\";i:1041;s:2:\"id\";i:15142;s:5:\"title\";s:25:\"Psychologist &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/09/Home.jpg\";s:12:\"tmpl_created\";i:1600156308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/psychologist-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:464;s:11:\"trend_index\";i:297;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:248;a:16:{s:4:\"tmpl\";i:1139;s:2:\"id\";i:16785;s:5:\"title\";s:42:\"Gym Promotion &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Gym-LP.jpg\";s:12:\"tmpl_created\";i:1610455496;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/gym-promotion-health-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:42:\"[\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:820;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:249;a:16:{s:4:\"tmpl\";i:484;s:2:\"id\";i:5283;s:5:\"title\";s:9:\"Clients 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_2.png\";s:12:\"tmpl_created\";i:1520443478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-1-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:294;s:11:\"trend_index\";i:202;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:250;a:16:{s:4:\"tmpl\";i:1044;s:2:\"id\";i:15188;s:5:\"title\";s:28:\"Psychologist &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/09/Pricing.jpg\";s:12:\"tmpl_created\";i:1600159731;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/psychologist-pricing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:732;s:11:\"trend_index\";i:537;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:251;a:16:{s:4:\"tmpl\";i:1185;s:2:\"id\";i:18492;s:5:\"title\";s:34:\"Bicycle Pre-Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bike-Landing-Page.png\";s:12:\"tmpl_created\";i:1617535552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/bicycle-pre-sale-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:34:\"[\"Bicycle\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:871;s:11:\"trend_index\";i:826;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:252;a:16:{s:4:\"tmpl\";i:487;s:2:\"id\";i:5306;s:5:\"title\";s:10:\"Clients 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_3.png\";s:12:\"tmpl_created\";i:1520443484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:657;s:11:\"trend_index\";i:581;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:253;a:16:{s:4:\"tmpl\";i:1043;s:2:\"id\";i:15167;s:5:\"title\";s:29:\"Psychologist &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/09/Services.jpg\";s:12:\"tmpl_created\";i:1600158206;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/psychologist-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:606;s:11:\"trend_index\";i:379;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:254;a:16:{s:4:\"tmpl\";i:1181;s:2:\"id\";i:18349;s:5:\"title\";s:39:\"Virtual try-on glasses &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-8.png\";s:12:\"tmpl_created\";i:1614772569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/virtual-try-on-glasses-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:64:\"[\"Fashion\",\"Glasses\",\"Landing Pages\",\"Online Service\",\"Virtual\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:848;s:11:\"trend_index\";i:803;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:255;a:16:{s:4:\"tmpl\";i:491;s:2:\"id\";i:5341;s:5:\"title\";s:10:\"Clients 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_4.png\";s:12:\"tmpl_created\";i:1520443491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:603;s:11:\"trend_index\";i:633;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:256;a:16:{s:4:\"tmpl\";i:1036;s:2:\"id\";i:14932;s:5:\"title\";s:30:\"Flooring Company &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/About.png\";s:12:\"tmpl_created\";i:1597740110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/flooring-company-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:488;s:11:\"trend_index\";i:319;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:257;a:16:{s:4:\"tmpl\";i:1172;s:2:\"id\";i:17458;s:5:\"title\";s:31:\"Moving Company &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Moving-Company.png\";s:12:\"tmpl_created\";i:1612727025;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/moving-company-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"Landing Pages\",\"Movers\",\"moving\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:826;s:11:\"trend_index\";i:767;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:258;a:16:{s:4:\"tmpl\";i:488;s:2:\"id\";i:5315;s:5:\"title\";s:10:\"Clients 12\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4-1.png\";s:12:\"tmpl_created\";i:1520443486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:485;s:11:\"trend_index\";i:263;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:259;a:16:{s:4:\"tmpl\";i:1037;s:2:\"id\";i:14998;s:5:\"title\";s:32:\"Flooring Company &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/08/Contact-Us.png\";s:12:\"tmpl_created\";i:1597740222;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/flooring-company-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:553;s:11:\"trend_index\";i:380;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:260;a:16:{s:4:\"tmpl\";i:1186;s:2:\"id\";i:18517;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Food-Blog.png\";s:12:\"tmpl_created\";i:1617539897;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/lp/food-blog-coming-soon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:45:\"[\"Blog\",\"Coming Soon\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:844;s:11:\"trend_index\";i:672;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:261;a:16:{s:4:\"tmpl\";i:490;s:2:\"id\";i:5333;s:5:\"title\";s:10:\"Clients 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_6.png\";s:12:\"tmpl_created\";i:1520443489;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:234;s:11:\"trend_index\";i:128;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:262;a:16:{s:4:\"tmpl\";i:1038;s:2:\"id\";i:14965;s:5:\"title\";s:32:\"Flooring Company &#8211; Gallery\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/Gallery.png\";s:12:\"tmpl_created\";i:1597740353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/flooring-company-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:371;s:11:\"trend_index\";i:291;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:263;a:16:{s:4:\"tmpl\";i:1167;s:2:\"id\";i:17379;s:5:\"title\";s:33:\"IT Service &#8211; Online Service\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-IT-Service.png\";s:12:\"tmpl_created\";i:1612713022;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/it-service-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:41:\"[\"IT\",\"Landing Pages\",\"Remote\",\"Support\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:806;s:11:\"trend_index\";i:634;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:264;a:16:{s:4:\"tmpl\";i:496;s:2:\"id\";i:5389;s:5:\"title\";s:10:\"Clients 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_9.png\";s:12:\"tmpl_created\";i:1520443501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:407;s:11:\"trend_index\";i:307;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:265;a:16:{s:4:\"tmpl\";i:758;s:2:\"id\";i:10005;s:5:\"title\";s:38:\"Fly In | Promotion | Spa | Body Lotion\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/Flyin_lotion_small.png\";s:12:\"tmpl_created\";i:1547844909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/fly-in-promotion-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:755;s:11:\"trend_index\";i:760;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:266;a:16:{s:4:\"tmpl\";i:1040;s:2:\"id\";i:14947;s:5:\"title\";s:33:\"Flooring company &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/08/Services.png\";s:12:\"tmpl_created\";i:1597740551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/flooring-company-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:538;s:11:\"trend_index\";i:392;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:267;a:16:{s:4:\"tmpl\";i:798;s:2:\"id\";i:10424;s:5:\"title\";s:21:\"Fly In | Announcement\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/flower_small.png\";s:12:\"tmpl_created\";i:1547961866;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-announcement-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:677;s:11:\"trend_index\";i:753;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:268;a:16:{s:4:\"tmpl\";i:1189;s:2:\"id\";i:18560;s:5:\"title\";s:52:\"Finance Learning Platform &#8211; Under Construction\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png\";s:12:\"tmpl_created\";i:1617542761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/lp/finance-learning-platform-under-construction/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:27:\"[\"Finance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:843;s:11:\"trend_index\";i:561;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:269;a:16:{s:4:\"tmpl\";i:486;s:2:\"id\";i:5298;s:5:\"title\";s:10:\"Clients 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_3.png\";s:12:\"tmpl_created\";i:1520443482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:465;s:11:\"trend_index\";i:520;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:270;a:16:{s:4:\"tmpl\";i:755;s:2:\"id\";i:9975;s:5:\"title\";s:24:\"Fly In | Promotion | App\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_webinar_app_small.png\";s:12:\"tmpl_created\";i:1547842284;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/fly-in-promotion-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:774;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:271;a:16:{s:4:\"tmpl\";i:1039;s:2:\"id\";i:14901;s:5:\"title\";s:29:\"Flooring Company &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/08/Home.png\";s:12:\"tmpl_created\";i:1597740474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/flooring-company-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:387;s:11:\"trend_index\";i:185;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:272;a:16:{s:4:\"tmpl\";i:1187;s:2:\"id\";i:18528;s:5:\"title\";s:36:\"Home Decor Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png\";s:12:\"tmpl_created\";i:1617541784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/home-decor-store-coming-soon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:57:\"[\"Coming Soon\",\"Decor\",\"interior design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:872;s:11:\"trend_index\";i:819;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:273;a:16:{s:4:\"tmpl\";i:495;s:2:\"id\";i:5381;s:5:\"title\";s:10:\"Clients 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_9.png\";s:12:\"tmpl_created\";i:1520443499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:198;s:11:\"trend_index\";i:168;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:274;a:16:{s:4:\"tmpl\";i:764;s:2:\"id\";i:10067;s:5:\"title\";s:31:\"Fly In | Announcement | Cookies\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/fly-in_cookie_yellow_small.png\";s:12:\"tmpl_created\";i:1547848075;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/fly-in-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:582;s:11:\"trend_index\";i:619;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:275;a:16:{s:4:\"tmpl\";i:1174;s:2:\"id\";i:17504;s:5:\"title\";s:29:\"Hair Stylist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-3.png\";s:12:\"tmpl_created\";i:1612883014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/lp/hair-stylist-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:59:\"[\"Business\",\"Hair\",\"hairdresser\",\"Landing Pages\",\"stylist\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:840;s:11:\"trend_index\";i:806;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:276;a:16:{s:4:\"tmpl\";i:493;s:2:\"id\";i:5357;s:5:\"title\";s:9:\"Clients 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_7.png\";s:12:\"tmpl_created\";i:1520443495;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:341;s:11:\"trend_index\";i:232;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:277;a:16:{s:4:\"tmpl\";i:1021;s:2:\"id\";i:14737;s:5:\"title\";s:32:\"Luxury Real Estate &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/About.png\";s:12:\"tmpl_created\";i:1595313527;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/luxury-real-estate-about-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:150;s:11:\"trend_index\";i:447;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:278;a:16:{s:4:\"tmpl\";i:1184;s:2:\"id\";i:18449;s:5:\"title\";s:46:\"Aesthetic Clinic &#8211; Health &#038; Fitness\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/03/Aesthetic-Clinic.png\";s:12:\"tmpl_created\";i:1616682181;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/aesthetic-clinic-health-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:57:\"[\"Aesthetic\",\"Beauty\",\"Fitness\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:859;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:279;a:16:{s:4:\"tmpl\";i:485;s:2:\"id\";i:5290;s:5:\"title\";s:9:\"Clients 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_2.png\";s:12:\"tmpl_created\";i:1520443480;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:545;s:11:\"trend_index\";i:502;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:280;a:16:{s:4:\"tmpl\";i:1020;s:2:\"id\";i:14756;s:5:\"title\";s:34:\"Luxury Real Estate &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/07/Contact-Us.png\";s:12:\"tmpl_created\";i:1595313519;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/luxury-real-estate-contact-us-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:610;s:11:\"trend_index\";i:569;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:281;a:16:{s:4:\"tmpl\";i:789;s:2:\"id\";i:10329;s:5:\"title\";s:25:\"Fly In | Sale | Promotion\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/organic_small.png\";s:12:\"tmpl_created\";i:1547893478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:781;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:282;a:16:{s:4:\"tmpl\";i:1165;s:2:\"id\";i:17353;s:5:\"title\";s:44:\"Online Cooking Course &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-2.png\";s:12:\"tmpl_created\";i:1612705144;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/lp/online-cooking-course-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Cooking\",\"Course Online\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:845;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:283;a:16:{s:4:\"tmpl\";i:482;s:2:\"id\";i:5266;s:5:\"title\";s:9:\"Clients 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_1.png\";s:12:\"tmpl_created\";i:1520443474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:95;s:11:\"trend_index\";i:134;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:284;a:16:{s:4:\"tmpl\";i:1019;s:2:\"id\";i:14716;s:5:\"title\";s:31:\"Luxury Real Estate &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/07/Home.png\";s:12:\"tmpl_created\";i:1595313512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/luxury-real-estate-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:394;s:11:\"trend_index\";i:165;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:285;a:16:{s:4:\"tmpl\";i:1188;s:2:\"id\";i:18550;s:5:\"title\";s:39:\"Online Store &#8211; Under Construction\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png\";s:12:\"tmpl_created\";i:1617542506;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/online-store-under-construction/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:59:\"[\"Landing Pages\",\"online shop\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:832;s:11:\"trend_index\";i:600;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:286;a:16:{s:4:\"tmpl\";i:723;s:2:\"id\";i:9650;s:5:\"title\";s:36:\"Fly In | Register | Subscribe | Sale\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2019/01/Fly-In_Register_small_01a.png\";s:12:\"tmpl_created\";i:1547007598;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/popups/fly-in-register_big-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:771;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:287;a:16:{s:4:\"tmpl\";i:483;s:2:\"id\";i:5275;s:5:\"title\";s:9:\"Clients 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_1.png\";s:12:\"tmpl_created\";i:1520443476;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:334;s:11:\"trend_index\";i:321;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:288;a:16:{s:4:\"tmpl\";i:1018;s:2:\"id\";i:14763;s:5:\"title\";s:31:\"Luxury Real Estate &#8211; News\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/07/news-Archive.png\";s:12:\"tmpl_created\";i:1595313273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/luxury-real-estate-news-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:404;s:11:\"trend_index\";i:167;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:289;a:16:{s:4:\"tmpl\";i:1191;s:2:\"id\";i:18539;s:5:\"title\";s:40:\"Travel Agency &#8211; Under Construction\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png\";s:12:\"tmpl_created\";i:1617610273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/travel-agency-under-construction/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:56:\"[\"Agency\",\"Landing Pages\",\"Travel\",\"Under Construction\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:876;s:11:\"trend_index\";i:652;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:290;a:16:{s:4:\"tmpl\";i:492;s:2:\"id\";i:5349;s:5:\"title\";s:9:\"Clients 7\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_7.png\";s:12:\"tmpl_created\";i:1520443493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:233;s:11:\"trend_index\";i:92;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:291;a:16:{s:4:\"tmpl\";i:1010;s:2:\"id\";i:13960;s:5:\"title\";s:32:\"Japanese restaurant &#8211; Home\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/06/Home-Page.jpg\";s:12:\"tmpl_created\";i:1592289775;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/japanese-restaurant-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:537;s:11:\"trend_index\";i:287;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:292;a:16:{s:4:\"tmpl\";i:1175;s:2:\"id\";i:18270;s:5:\"title\";s:24:\"Open week &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280.png\";s:12:\"tmpl_created\";i:1614767186;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/lp/open-week-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:59:\"[\"Education\",\"Event\",\"Events\",\"Landing Pages\",\"University\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:831;s:11:\"trend_index\";i:673;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:293;a:16:{s:4:\"tmpl\";i:489;s:2:\"id\";i:5324;s:5:\"title\";s:9:\"Clients 8\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5-1.png\";s:12:\"tmpl_created\";i:1520443488;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:526;s:11:\"trend_index\";i:381;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:294;a:16:{s:4:\"tmpl\";i:1007;s:2:\"id\";i:13993;s:5:\"title\";s:45:\"Japanese restaurant &#8211; Chef&#8217;s Menu\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/06/Chef_s-Menu-Page.jpg\";s:12:\"tmpl_created\";i:1592289691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/japanese-restaurant-chefs-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:651;s:11:\"trend_index\";i:675;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:295;a:16:{s:4:\"tmpl\";i:840;s:2:\"id\";i:10200;s:5:\"title\";s:33:\"Full Screen | Content Lock | Wine\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/lock_wine_small.png\";s:12:\"tmpl_created\";i:1548055635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/full-screen-content-lock/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:719;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:296;a:16:{s:4:\"tmpl\";i:1177;s:2:\"id\";i:18300;s:5:\"title\";s:30:\"Makeup Artist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-2.png\";s:12:\"tmpl_created\";i:1614768608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/lp/makeup-artist-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Beauty\",\"Business\",\"Course Online\",\"Landing Pages\",\"Makeup\",\"Online Service\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:861;s:11:\"trend_index\";i:783;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:297;a:16:{s:4:\"tmpl\";i:494;s:2:\"id\";i:5368;s:5:\"title\";s:9:\"Clients 9\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_8.png\";s:12:\"tmpl_created\";i:1520443497;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:253;s:11:\"trend_index\";i:273;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:298;a:16:{s:4:\"tmpl\";i:1006;s:2:\"id\";i:14012;s:5:\"title\";s:36:\"Japanese restaurant &#8211; Bar Menu\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/06/Bar-Menu-Page.jpg\";s:12:\"tmpl_created\";i:1592289665;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/japanese-restaurant-bar-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:735;s:11:\"trend_index\";i:829;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:299;a:16:{s:4:\"tmpl\";i:832;s:2:\"id\";i:10287;s:5:\"title\";s:34:\"Full Screen | Register | Subscribe\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/glass_pink_small.png\";s:12:\"tmpl_created\";i:1547994301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-login-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:602;s:11:\"trend_index\";i:439;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:300;a:16:{s:4:\"tmpl\";i:1179;s:2:\"id\";i:18329;s:5:\"title\";s:63:\"Online Real Estate Investment Conference &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-5.png\";s:12:\"tmpl_created\";i:1614770404;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/lp/online-real-estate-investment-conference-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:76:\"[\"Conference\",\"Event\",\"Events\",\"Landing Pages\",\"Online Event\",\"Real estate\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:866;s:11:\"trend_index\";i:779;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:301;a:16:{s:4:\"tmpl\";i:425;s:2:\"id\";i:4436;s:5:\"title\";s:11:\"Contact  16\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_2.png\";s:12:\"tmpl_created\";i:1520443293;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:161;s:11:\"trend_index\";i:68;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:302;a:16:{s:4:\"tmpl\";i:1005;s:2:\"id\";i:13917;s:5:\"title\";s:33:\"Japanese restaurant &#8211; About\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/06/About-Page.jpg\";s:12:\"tmpl_created\";i:1592289629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/japanese-restaurant-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:640;s:11:\"trend_index\";i:389;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:303;a:16:{s:4:\"tmpl\";i:1183;s:2:\"id\";i:18391;s:5:\"title\";s:45:\"Children&#8217;s Optometrist &#8211; Business\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Childrens-Optometrist.png\";s:12:\"tmpl_created\";i:1614773564;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/childrens-optometrist-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:85:\"[\"Business\",\"Children\",\"Eye\",\"Glasses\",\"Health\",\"Kids\",\"Landing Pages\",\"Optometrist\"]\";s:10:\"menu_order\";i:65;s:16:\"popularity_index\";i:877;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:304;a:16:{s:4:\"tmpl\";i:423;s:2:\"id\";i:4420;s:5:\"title\";s:9:\"Contact 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_1.png\";s:12:\"tmpl_created\";i:1520443289;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-1-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:65;s:16:\"popularity_index\";i:196;s:11:\"trend_index\";i:127;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:305;a:16:{s:4:\"tmpl\";i:1009;s:2:\"id\";i:13937;s:5:\"title\";s:35:\"Japanese restaurant &#8211; Gallery\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/Gallery-Page.jpg\";s:12:\"tmpl_created\";i:1592289748;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/japanese-restaurant-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:65;s:16:\"popularity_index\";i:648;s:11:\"trend_index\";i:551;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:306;a:16:{s:4:\"tmpl\";i:534;s:2:\"id\";i:5836;s:5:\"title\";s:10:\"Contact 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_2.png\";s:12:\"tmpl_created\";i:1520443597;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:114;s:11:\"trend_index\";i:76;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:307;a:16:{s:4:\"tmpl\";i:1182;s:2:\"id\";i:18366;s:5:\"title\";s:30:\"Car Insurance &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Car-Insurance.png\";s:12:\"tmpl_created\";i:1614773263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/lp/car-insurance-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"car\",\"Insurance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:869;s:11:\"trend_index\";i:797;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:308;a:16:{s:4:\"tmpl\";i:747;s:2:\"id\";i:9889;s:5:\"title\";s:28:\"Full Screen | Login | Cactus\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/cac_small.png\";s:12:\"tmpl_created\";i:1547838722;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/full-screen-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:743;s:11:\"trend_index\";i:713;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:309;a:16:{s:4:\"tmpl\";i:1008;s:2:\"id\";i:14030;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Events\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/06/Events-Page.jpg\";s:12:\"tmpl_created\";i:1592289713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/japanese-restaurant-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:723;s:11:\"trend_index\";i:711;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:310;a:16:{s:4:\"tmpl\";i:535;s:2:\"id\";i:5844;s:5:\"title\";s:10:\"Contact 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_2.png\";s:12:\"tmpl_created\";i:1520443599;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:289;s:11:\"trend_index\";i:313;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:311;a:16:{s:4:\"tmpl\";i:1176;s:2:\"id\";i:18291;s:5:\"title\";s:47:\"Grill Restaurant Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Food-Delivery-LP.png\";s:12:\"tmpl_created\";i:1614767830;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/grill-restaurant-food-delivery-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Delivery\",\"Delivery Service\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:819;s:11:\"trend_index\";i:685;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:312;a:16:{s:4:\"tmpl\";i:1016;s:2:\"id\";i:13984;s:5:\"title\";s:40:\"Japanese restaurant &#8211; Reservations\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/reservations.jpg\";s:12:\"tmpl_created\";i:1592294757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/japanese-restaurant-reservations/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:715;s:11:\"trend_index\";i:727;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:313;a:16:{s:4:\"tmpl\";i:765;s:2:\"id\";i:10077;s:5:\"title\";s:29:\"Fly In | Register | Subscribe\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_register_blue_small.png\";s:12:\"tmpl_created\";i:1547848197;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/fly-in-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:540;s:11:\"trend_index\";i:574;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:314;a:16:{s:4:\"tmpl\";i:1180;s:2:\"id\";i:18340;s:5:\"title\";s:30:\"Restaurant &#8211; Coming Soon\";s:9:\"thumbnail\";s:98:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Restuarant-Coming-Soon-LP.png\";s:12:\"tmpl_created\";i:1614772183;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/lp/restaurant-coming-soon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:51:\"[\"Coming Soon\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:810;s:11:\"trend_index\";i:809;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:315;a:16:{s:4:\"tmpl\";i:430;s:2:\"id\";i:4476;s:5:\"title\";s:10:\"Contact 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_4.png\";s:12:\"tmpl_created\";i:1520443303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:229;s:11:\"trend_index\";i:187;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:316;a:16:{s:4:\"tmpl\";i:999;s:2:\"id\";i:13479;s:5:\"title\";s:23:\"Barbershop &#8211; Home\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/05/Home-Page.jpg\";s:12:\"tmpl_created\";i:1589893275;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/barbershop-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:683;s:11:\"trend_index\";i:832;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:317;a:16:{s:4:\"tmpl\";i:844;s:2:\"id\";i:10362;s:5:\"title\";s:32:\"Full Screen | Login | Restaurant\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/vip_small.png\";s:12:\"tmpl_created\";i:1548056253;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-login-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:587;s:11:\"trend_index\";i:560;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:318;a:16:{s:4:\"tmpl\";i:1173;s:2:\"id\";i:17480;s:5:\"title\";s:42:\"At-home Massage Therapist &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/02/At-Home-Massage-Therapist.jpg\";s:12:\"tmpl_created\";i:1612879264;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/at-home-massage-therapist-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:60:\"[\"Business\",\"Health\",\"Landing Pages\",\"Services\",\"Therapist\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:856;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:319;a:16:{s:4:\"tmpl\";i:476;s:2:\"id\";i:5214;s:5:\"title\";s:10:\"Contact 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_2.png\";s:12:\"tmpl_created\";i:1520443462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/contact-16-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:194;s:11:\"trend_index\";i:106;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:320;a:16:{s:4:\"tmpl\";i:1000;s:2:\"id\";i:13503;s:5:\"title\";s:24:\"Barbershop &#8211; About\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/05/About-Page.jpg\";s:12:\"tmpl_created\";i:1589893289;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/barbershop-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:744;s:11:\"trend_index\";i:739;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:321;a:16:{s:4:\"tmpl\";i:1178;s:2:\"id\";i:18317;s:5:\"title\";s:26:\"Insurance &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Life-Insirance.png\";s:12:\"tmpl_created\";i:1614769488;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/lp/insurance-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:61:\"[\"Business\",\"Family\",\"Financial\",\"Insurance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:870;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:322;a:16:{s:4:\"tmpl\";i:478;s:2:\"id\";i:5230;s:5:\"title\";s:10:\"Contact 17\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_3.png\";s:12:\"tmpl_created\";i:1520443466;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:339;s:11:\"trend_index\";i:335;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:323;a:16:{s:4:\"tmpl\";i:1001;s:2:\"id\";i:13548;s:5:\"title\";s:27:\"Barbershop &#8211; Services\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/05/Services-Page.jpg\";s:12:\"tmpl_created\";i:1589893298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/barbershop-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:761;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:324;a:16:{s:4:\"tmpl\";i:849;s:2:\"id\";i:10454;s:5:\"title\";s:29:\"Full Screen | Promotion | App\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/appy_small.png\";s:12:\"tmpl_created\";i:1548056896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/full-screen-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:776;s:11:\"trend_index\";i:804;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:325;a:16:{s:4:\"tmpl\";i:1168;s:2:\"id\";i:17401;s:5:\"title\";s:40:\"Conference Thank You Page &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280.png\";s:12:\"tmpl_created\";i:1612724753;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/conference-thank-you-page-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:59:\"[\"Conference\",\"Event\",\"Events\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:799;s:11:\"trend_index\";i:540;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:326;a:16:{s:4:\"tmpl\";i:481;s:2:\"id\";i:5257;s:5:\"title\";s:10:\"Contact 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5.png\";s:12:\"tmpl_created\";i:1520443472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:438;s:11:\"trend_index\";i:490;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:327;a:16:{s:4:\"tmpl\";i:1002;s:2:\"id\";i:13560;s:5:\"title\";s:26:\"Barbershop &#8211; Gallery\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/05/Gallery-Page.jpg\";s:12:\"tmpl_created\";i:1589893307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/barbershop-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:756;s:11:\"trend_index\";i:822;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:328;a:16:{s:4:\"tmpl\";i:532;s:2:\"id\";i:5820;s:5:\"title\";s:9:\"Contact 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_1.png\";s:12:\"tmpl_created\";i:1520443593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:183;s:11:\"trend_index\";i:357;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:329;a:16:{s:4:\"tmpl\";i:1166;s:2:\"id\";i:17368;s:5:\"title\";s:38:\"Real Estate Agency &#8211; Real-Estate\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Real-Estate.png\";s:12:\"tmpl_created\";i:1612711814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/real-estate-agency-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:73:\"[\"Landing Pages\",\"listing\",\"Real estate\",\"Realestate\",\"realtor\",\"realty\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:858;s:11:\"trend_index\";i:777;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:330;a:16:{s:4:\"tmpl\";i:739;s:2:\"id\";i:9803;s:5:\"title\";s:41:\"Full Screen | Register | Contact | Meetup\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2019/01/designme_full_small.png\";s:12:\"tmpl_created\";i:1547831298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/full-screen-register-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:701;s:11:\"trend_index\";i:808;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:331;a:16:{s:4:\"tmpl\";i:1003;s:2:\"id\";i:13587;s:5:\"title\";s:26:\"Barbershop &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/05/Contact-Us-Page.jpg\";s:12:\"tmpl_created\";i:1589893315;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/barbershop-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:753;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:332;a:16:{s:4:\"tmpl\";i:816;s:2:\"id\";i:10611;s:5:\"title\";s:18:\"Full Screen | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/fla_small.png\";s:12:\"tmpl_created\";i:1547968868;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/full-screen-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:779;s:11:\"trend_index\";i:792;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:333;a:16:{s:4:\"tmpl\";i:1170;s:2:\"id\";i:17423;s:5:\"title\";s:57:\"Volunteer Calls Thank You Page &#8211; Social Involvement\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/02/Volunteer-Calls-TYP.jpg\";s:12:\"tmpl_created\";i:1612726058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/lp/volunteer-calls-thank-you-page-social-involvement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:62:\"[\"Care\",\"Involvement\",\"Landing Pages\",\"Thank You\",\"Volunteer\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:857;s:11:\"trend_index\";i:818;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:334;a:16:{s:4:\"tmpl\";i:422;s:2:\"id\";i:4411;s:5:\"title\";s:9:\"Contact 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_1.png\";s:12:\"tmpl_created\";i:1520443287;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:113;s:11:\"trend_index\";i:217;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:335;a:16:{s:4:\"tmpl\";i:982;s:2:\"id\";i:13307;s:5:\"title\";s:26:\"Online Course &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Home.jpg\";s:12:\"tmpl_created\";i:1587474541;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/online-course-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:230;s:11:\"trend_index\";i:125;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:336;a:16:{s:4:\"tmpl\";i:533;s:2:\"id\";i:5828;s:5:\"title\";s:9:\"Contact 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_1.png\";s:12:\"tmpl_created\";i:1520443595;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:312;s:11:\"trend_index\";i:495;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:337;a:16:{s:4:\"tmpl\";i:1169;s:2:\"id\";i:17409;s:5:\"title\";s:37:\"Webinar Thank You Page &#8211; Events\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Webinar-TYP.png\";s:12:\"tmpl_created\";i:1612725644;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/webinar-thank-you-page-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:56:\"[\"Event\",\"Events\",\"Landing Pages\",\"Thank You\",\"Webinar\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:868;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:338;a:16:{s:4:\"tmpl\";i:983;s:2:\"id\";i:13328;s:5:\"title\";s:27:\"Online Course &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/About.jpg\";s:12:\"tmpl_created\";i:1587474558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/online-course-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:508;s:11:\"trend_index\";i:429;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:339;a:16:{s:4:\"tmpl\";i:806;s:2:\"id\";i:10508;s:5:\"title\";s:25:\"Full Screen | Welcome Mat\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/hand_small-1.png\";s:12:\"tmpl_created\";i:1547964711;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/full-screen-welcome-mat-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:711;s:11:\"trend_index\";i:793;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:340;a:16:{s:4:\"tmpl\";i:1160;s:2:\"id\";i:17258;s:5:\"title\";s:32:\"Beauty Product &#8211; eCommerce\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Beauty-Product.png\";s:12:\"tmpl_created\";i:1610903153;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/lp/beauty-product-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:38:\"[\"beauty\",\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:797;s:11:\"trend_index\";i:703;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:341;a:16:{s:4:\"tmpl\";i:424;s:2:\"id\";i:4428;s:5:\"title\";s:9:\"Contact 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_2.png\";s:12:\"tmpl_created\";i:1520443291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:118;s:11:\"trend_index\";i:131;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:342;a:16:{s:4:\"tmpl\";i:984;s:2:\"id\";i:13338;s:5:\"title\";s:33:\"Online Course &#8211; Course Page\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Course-Page.png\";s:12:\"tmpl_created\";i:1587474574;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/online-course-course-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:337;s:11:\"trend_index\";i:310;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:343;a:16:{s:4:\"tmpl\";i:1171;s:2:\"id\";i:17435;s:5:\"title\";s:39:\"Gym &#8211; App Service &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-4.png\";s:12:\"tmpl_created\";i:1612726462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/gym-app-service-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:58:\"[\"App\",\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:767;s:11:\"trend_index\";i:577;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:344;a:16:{s:4:\"tmpl\";i:426;s:2:\"id\";i:4444;s:5:\"title\";s:9:\"Contact 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_1.png\";s:12:\"tmpl_created\";i:1520443295;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:84;s:11:\"trend_index\";i:93;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:345;a:16:{s:4:\"tmpl\";i:985;s:2:\"id\";i:13352;s:5:\"title\";s:29:\"Online Course &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1587474591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/online-course-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:565;s:11:\"trend_index\";i:533;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:346;a:16:{s:4:\"tmpl\";i:751;s:2:\"id\";i:9934;s:5:\"title\";s:38:\"Full Screen | Welcome Mat | Teddy Bear\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/full_mat_teddy_small.png\";s:12:\"tmpl_created\";i:1547841787;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/full-screen-welcome-mat/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:681;s:11:\"trend_index\";i:752;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:347;a:16:{s:4:\"tmpl\";i:1156;s:2:\"id\";i:17111;s:5:\"title\";s:33:\"Sunglasses Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/01/Sunglasses-LP-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610632408;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/sunglasses-sale-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Ecommerce\",\"Fashion\",\"Landing Pages\",\"Sale\",\"Sunglasses\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:812;s:11:\"trend_index\";i:732;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:348;a:16:{s:4:\"tmpl\";i:432;s:2:\"id\";i:4492;s:5:\"title\";s:9:\"Contact 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_3.png\";s:12:\"tmpl_created\";i:1520443307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-5-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:37;s:11:\"trend_index\";i:31;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:349;a:16:{s:4:\"tmpl\";i:971;s:2:\"id\";i:13187;s:5:\"title\";s:33:\"Interior Design &#8211; Home Page\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Home.png\";s:12:\"tmpl_created\";i:1586148661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/interior-design-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"interior design\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:331;s:11:\"trend_index\";i:264;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:350;a:16:{s:4:\"tmpl\";i:1157;s:2:\"id\";i:17223;s:5:\"title\";s:25:\"Fashion &#8211; eCommerce\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/01/Commerce-Fashion.png\";s:12:\"tmpl_created\";i:1610902553;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/lp/fashion-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:808;s:11:\"trend_index\";i:745;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:351;a:16:{s:4:\"tmpl\";i:427;s:2:\"id\";i:4452;s:5:\"title\";s:9:\"Contact 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_1.png\";s:12:\"tmpl_created\";i:1520443296;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:139;s:11:\"trend_index\";i:150;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:352;a:16:{s:4:\"tmpl\";i:972;s:2:\"id\";i:13199;s:5:\"title\";s:29:\"Interior Design &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/About.png\";s:12:\"tmpl_created\";i:1586148666;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/interior-design-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"interior design\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:316;s:11:\"trend_index\";i:334;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:353;a:16:{s:4:\"tmpl\";i:729;s:2:\"id\";i:9709;s:5:\"title\";s:25:\"Full Screen | Welcome Mat\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2019/01/Full-Screen_Welcome-Mat_01_small-1.png\";s:12:\"tmpl_created\";i:1547023834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-welcome-mat-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:728;s:11:\"trend_index\";i:728;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:354;a:16:{s:4:\"tmpl\";i:1151;s:2:\"id\";i:17017;s:5:\"title\";s:28:\"Shoes Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Shoes-LP-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610535361;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/lp/shoes-sale-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:55:\"[\"Discount\",\"Ecommerce\",\"Landing Pages\",\"Sale\",\"Shoes\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:803;s:11:\"trend_index\";i:642;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:355;a:16:{s:4:\"tmpl\";i:429;s:2:\"id\";i:4468;s:5:\"title\";s:9:\"Contact 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_3.png\";s:12:\"tmpl_created\";i:1520443301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:127;s:11:\"trend_index\";i:72;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:356;a:16:{s:4:\"tmpl\";i:973;s:2:\"id\";i:13214;s:5:\"title\";s:32:\"Interior Design &#8211; Projects\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/portfolio_s.jpg\";s:12:\"tmpl_created\";i:1586148672;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/interior-design-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"interior design\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:367;s:11:\"trend_index\";i:323;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:357;a:16:{s:4:\"tmpl\";i:725;s:2:\"id\";i:9671;s:5:\"title\";s:34:\"Hello Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/Top-Bar_Announcement_small_01.png\";s:12:\"tmpl_created\";i:1547010259;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/hello-bar-announcement-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:639;s:11:\"trend_index\";i:598;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:358;a:16:{s:4:\"tmpl\";i:838;s:2:\"id\";i:10234;s:5:\"title\";s:38:\"Hello Bar | Announcement | Maintenance\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/pink_small.png\";s:12:\"tmpl_created\";i:1548055049;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/popups/hello-bar-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:746;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:359;a:16:{s:4:\"tmpl\";i:1163;s:2:\"id\";i:17301;s:5:\"title\";s:53:\"Personal Chef &#8211; Thank You Page &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/TYP-Personal-Chef.jpg\";s:12:\"tmpl_created\";i:1610903622;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/personal-chef-thank-you-page-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:43:\"[\"Chef\",\"Food\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:823;s:11:\"trend_index\";i:754;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:360;a:16:{s:4:\"tmpl\";i:431;s:2:\"id\";i:4484;s:5:\"title\";s:9:\"Contact 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_3.png\";s:12:\"tmpl_created\";i:1520443305;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:328;s:11:\"trend_index\";i:260;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:361;a:16:{s:4:\"tmpl\";i:974;s:2:\"id\";i:13229;s:5:\"title\";s:31:\"Interior Design &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.png\";s:12:\"tmpl_created\";i:1586148677;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/interior-design-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"interior design\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:395;s:11:\"trend_index\";i:337;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:362;a:16:{s:4:\"tmpl\";i:1164;s:2:\"id\";i:17313;s:5:\"title\";s:60:\"Development Course  &#8211; Thank You Page &#8211; Education\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Dev-Course-TYP-.png\";s:12:\"tmpl_created\";i:1610903776;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/development-course-thank-you-page-education/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Education\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:834;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:363;a:16:{s:4:\"tmpl\";i:428;s:2:\"id\";i:4460;s:5:\"title\";s:9:\"Contact 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_2.png\";s:12:\"tmpl_created\";i:1520443298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:99;s:11:\"trend_index\";i:80;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:364;a:16:{s:4:\"tmpl\";i:959;s:2:\"id\";i:12948;s:5:\"title\";s:29:\"Photography &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Home_s.png\";s:12:\"tmpl_created\";i:1582093442;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/photography-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:241;s:11:\"trend_index\";i:201;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:365;a:16:{s:4:\"tmpl\";i:613;s:2:\"id\";i:5558;s:5:\"title\";s:5:\"CTA 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_2.png\";s:12:\"tmpl_created\";i:1520520684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:82;s:16:\"popularity_index\";i:129;s:11:\"trend_index\";i:69;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:366;a:16:{s:4:\"tmpl\";i:960;s:2:\"id\";i:12798;s:5:\"title\";s:25:\"Photography &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/About_s.png\";s:12:\"tmpl_created\";i:1582093446;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/photography-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:82;s:16:\"popularity_index\";i:499;s:11:\"trend_index\";i:374;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:367;a:16:{s:4:\"tmpl\";i:634;s:2:\"id\";i:5939;s:5:\"title\";s:6:\"CTA 10\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_13-1.png\";s:12:\"tmpl_created\";i:1520520760;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:83;s:16:\"popularity_index\";i:190;s:11:\"trend_index\";i:118;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:368;a:16:{s:4:\"tmpl\";i:961;s:2:\"id\";i:12868;s:5:\"title\";s:27:\"Photography &#8211; Contact\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Contact_s.png\";s:12:\"tmpl_created\";i:1582093450;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/photography-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:83;s:16:\"popularity_index\";i:531;s:11:\"trend_index\";i:350;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:369;a:16:{s:4:\"tmpl\";i:745;s:2:\"id\";i:9869;s:5:\"title\";s:28:\"Hello Bar | Promotion | Sale\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/01/ru_small.png\";s:12:\"tmpl_created\";i:1547837269;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/hello-bar-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:83;s:16:\"popularity_index\";i:766;s:11:\"trend_index\";i:820;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:370;a:16:{s:4:\"tmpl\";i:850;s:2:\"id\";i:10539;s:5:\"title\";s:19:\"Hello Bar | Contact\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/hello_pink_small.png\";s:12:\"tmpl_created\";i:1548056994;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/hello-bar-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:726;s:11:\"trend_index\";i:810;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:371;a:16:{s:4:\"tmpl\";i:633;s:2:\"id\";i:5930;s:5:\"title\";s:6:\"CTA 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_15.png\";s:12:\"tmpl_created\";i:1520520758;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:76;s:11:\"trend_index\";i:84;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:372;a:16:{s:4:\"tmpl\";i:962;s:2:\"id\";i:13056;s:5:\"title\";s:28:\"Photography &#8211; Wildlife\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/02/Wildlife_s.png\";s:12:\"tmpl_created\";i:1582093454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/photography-wildlife/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:579;s:11:\"trend_index\";i:656;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:373;a:16:{s:4:\"tmpl\";i:632;s:2:\"id\";i:5921;s:5:\"title\";s:6:\"CTA 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_14.png\";s:12:\"tmpl_created\";i:1520520757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:85;s:16:\"popularity_index\";i:278;s:11:\"trend_index\";i:234;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:374;a:16:{s:4:\"tmpl\";i:963;s:2:\"id\";i:12922;s:5:\"title\";s:37:\"Photography &#8211; Glowing Jellyfish\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/02/Jellyfish_S.png\";s:12:\"tmpl_created\";i:1582093457;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photography-glowing-jellyfish/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:85;s:16:\"popularity_index\";i:628;s:11:\"trend_index\";i:532;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:375;a:16:{s:4:\"tmpl\";i:618;s:2:\"id\";i:5607;s:5:\"title\";s:6:\"CTA 13\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_5.png\";s:12:\"tmpl_created\";i:1520520695;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:86;s:16:\"popularity_index\";i:42;s:11:\"trend_index\";i:11;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:376;a:16:{s:4:\"tmpl\";i:964;s:2:\"id\";i:12875;s:5:\"title\";s:36:\"Photography &#8211; Fluttering Birds\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/Birds_s.png\";s:12:\"tmpl_created\";i:1582093461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/photography-fluttering-birds/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:86;s:16:\"popularity_index\";i:693;s:11:\"trend_index\";i:766;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:377;a:16:{s:4:\"tmpl\";i:574;s:2:\"id\";i:6017;s:5:\"title\";s:6:\"CTA 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_14.png\";s:12:\"tmpl_created\";i:1520520331;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:87;s:16:\"popularity_index\";i:152;s:11:\"trend_index\";i:122;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:378;a:16:{s:4:\"tmpl\";i:965;s:2:\"id\";i:12962;s:5:\"title\";s:26:\"Photography &#8211; Nature\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Nature_s.png\";s:12:\"tmpl_created\";i:1582093465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/photography-nature/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:87;s:16:\"popularity_index\";i:592;s:11:\"trend_index\";i:778;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:379;a:16:{s:4:\"tmpl\";i:628;s:2:\"id\";i:5885;s:5:\"title\";s:6:\"CTA 15\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_11.png\";s:12:\"tmpl_created\";i:1520520751;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:88;s:16:\"popularity_index\";i:274;s:11:\"trend_index\";i:256;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:380;a:16:{s:4:\"tmpl\";i:966;s:2:\"id\";i:12833;s:5:\"title\";s:38:\"Photography &#8211; Blossoming Flowers\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Flowers_s.png\";s:12:\"tmpl_created\";i:1582093469;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photography-blossoming-flowers/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:88;s:16:\"popularity_index\";i:597;s:11:\"trend_index\";i:750;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:381;a:16:{s:4:\"tmpl\";i:839;s:2:\"id\";i:10147;s:5:\"title\";s:34:\"Hello Bar | Sale | Promotion | Pop\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/donut_small.png\";s:12:\"tmpl_created\";i:1548055522;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/hello-bar-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:89;s:16:\"popularity_index\";i:775;s:11:\"trend_index\";i:824;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:382;a:16:{s:4:\"tmpl\";i:627;s:2:\"id\";i:5877;s:5:\"title\";s:6:\"CTA 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_10.png\";s:12:\"tmpl_created\";i:1520520749;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:89;s:16:\"popularity_index\";i:564;s:11:\"trend_index\";i:677;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:383;a:16:{s:4:\"tmpl\";i:967;s:2:\"id\";i:12898;s:5:\"title\";s:36:\"Photography &#8211; Forest Mushrooms\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/02/Mushrooms_s.png\";s:12:\"tmpl_created\";i:1582093473;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/photography-forest-mushrooms/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:89;s:16:\"popularity_index\";i:667;s:11:\"trend_index\";i:649;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:384;a:16:{s:4:\"tmpl\";i:625;s:2:\"id\";i:5860;s:5:\"title\";s:6:\"CTA 17\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_9.png\";s:12:\"tmpl_created\";i:1520520746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:90;s:16:\"popularity_index\";i:120;s:11:\"trend_index\";i:63;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:385;a:16:{s:4:\"tmpl\";i:968;s:2:\"id\";i:12994;s:5:\"title\";s:24:\"Photography &#8211; Pets\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Pets_s.png\";s:12:\"tmpl_created\";i:1582093477;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/photography-pets/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:90;s:16:\"popularity_index\";i:612;s:11:\"trend_index\";i:508;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:386;a:16:{s:4:\"tmpl\";i:750;s:2:\"id\";i:9923;s:5:\"title\";s:23:\"Slide In | Announcement\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/slide-in_ann_italian_small.png\";s:12:\"tmpl_created\";i:1547841537;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/slide-in-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:90;s:16:\"popularity_index\";i:699;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:387;a:16:{s:4:\"tmpl\";i:852;s:2:\"id\";i:10117;s:5:\"title\";s:23:\"Slide In | Announcement\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/white_small.png\";s:12:\"tmpl_created\";i:1548066998;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/slide-in-announcement-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:727;s:11:\"trend_index\";i:662;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:388;a:16:{s:4:\"tmpl\";i:626;s:2:\"id\";i:5869;s:5:\"title\";s:6:\"CTA 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_10.png\";s:12:\"tmpl_created\";i:1520520747;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:345;s:11:\"trend_index\";i:486;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:389;a:16:{s:4:\"tmpl\";i:969;s:2:\"id\";i:12805;s:5:\"title\";s:37:\"Photography &#8211; B&amp;W Portraits\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/Black_s.png\";s:12:\"tmpl_created\";i:1582093481;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/photography-bw-portraits/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:695;s:11:\"trend_index\";i:735;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:390;a:16:{s:4:\"tmpl\";i:611;s:2:\"id\";i:5542;s:5:\"title\";s:6:\"CTA 19\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_1.png\";s:12:\"tmpl_created\";i:1520520681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:92;s:16:\"popularity_index\";i:169;s:11:\"trend_index\";i:270;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:391;a:16:{s:4:\"tmpl\";i:970;s:2:\"id\";i:13031;s:5:\"title\";s:33:\"Photography &#8211; Vivid Parrots\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Parrots_s.png\";s:12:\"tmpl_created\";i:1582093484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/photography-vivid-parrots/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:92;s:16:\"popularity_index\";i:660;s:11:\"trend_index\";i:643;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:392;a:16:{s:4:\"tmpl\";i:741;s:2:\"id\";i:9826;s:5:\"title\";s:33:\"Slide In | Announcement | webinar\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/web_small-2.png\";s:12:\"tmpl_created\";i:1547835513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/slide-in-announcement-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:92;s:16:\"popularity_index\";i:745;s:11:\"trend_index\";i:831;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:393;a:16:{s:4:\"tmpl\";i:848;s:2:\"id\";i:10478;s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/slide_wow_small.png\";s:12:\"tmpl_created\";i:1548056829;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/slide-in-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:595;s:11:\"trend_index\";i:559;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:394;a:16:{s:4:\"tmpl\";i:614;s:2:\"id\";i:5567;s:5:\"title\";s:5:\"CTA 2\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_2.png\";s:12:\"tmpl_created\";i:1520520685;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:143;s:11:\"trend_index\";i:225;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:395;a:16:{s:4:\"tmpl\";i:940;s:2:\"id\";i:12621;s:5:\"title\";s:26:\"Magazine &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/01/Home_s.png\";s:12:\"tmpl_created\";i:1579060604;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/magazine-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:167;s:11:\"trend_index\";i:121;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:396;a:16:{s:4:\"tmpl\";i:629;s:2:\"id\";i:5893;s:5:\"title\";s:6:\"CTA 21\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_12.png\";s:12:\"tmpl_created\";i:1520520752;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:94;s:16:\"popularity_index\";i:259;s:11:\"trend_index\";i:457;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:397;a:16:{s:4:\"tmpl\";i:936;s:2:\"id\";i:12352;s:5:\"title\";s:24:\"Travel &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/12/Home_s.png\";s:12:\"tmpl_created\";i:1575960464;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/travel-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:94;s:16:\"popularity_index\";i:291;s:11:\"trend_index\";i:194;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:398;a:16:{s:4:\"tmpl\";i:619;s:2:\"id\";i:5634;s:5:\"title\";s:6:\"CTA 24\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_6.png\";s:12:\"tmpl_created\";i:1520520699;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:95;s:16:\"popularity_index\";i:188;s:11:\"trend_index\";i:255;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:399;a:16:{s:4:\"tmpl\";i:932;s:2:\"id\";i:12400;s:5:\"title\";s:20:\"Travel &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/12/About.png\";s:12:\"tmpl_created\";i:1575960441;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/travel-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:95;s:16:\"popularity_index\";i:444;s:11:\"trend_index\";i:445;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:400;a:16:{s:4:\"tmpl\";i:823;s:2:\"id\";i:10685;s:5:\"title\";s:32:\"Hello Bar | Register | Subscribe\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/env_small.png\";s:12:\"tmpl_created\";i:1547974729;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/hello-bar-register-subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:721;s:11:\"trend_index\";i:814;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:401;a:16:{s:4:\"tmpl\";i:620;s:2:\"id\";i:5642;s:5:\"title\";s:6:\"CTA 25\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_6.png\";s:12:\"tmpl_created\";i:1520520701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-25/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:226;s:11:\"trend_index\";i:262;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:402;a:16:{s:4:\"tmpl\";i:938;s:2:\"id\";i:12479;s:5:\"title\";s:20:\"Travel &#8211; Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/Tours_s.png\";s:12:\"tmpl_created\";i:1575960474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/travel-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:539;s:11:\"trend_index\";i:726;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:403;a:16:{s:4:\"tmpl\";i:615;s:2:\"id\";i:5583;s:5:\"title\";s:6:\"CTA 26\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_3.png\";s:12:\"tmpl_created\";i:1520520689;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:97;s:16:\"popularity_index\";i:117;s:11:\"trend_index\";i:117;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:404;a:16:{s:4:\"tmpl\";i:937;s:2:\"id\";i:12466;s:5:\"title\";s:27:\"Travel &#8211; Testimonials\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/Testimonials.png\";s:12:\"tmpl_created\";i:1575960469;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-testimonials/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:97;s:16:\"popularity_index\";i:527;s:11:\"trend_index\";i:481;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:405;a:16:{s:4:\"tmpl\";i:630;s:2:\"id\";i:5904;s:5:\"title\";s:6:\"CTA 27\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_13.png\";s:12:\"tmpl_created\";i:1520520754;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:528;s:11:\"trend_index\";i:517;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:406;a:16:{s:4:\"tmpl\";i:935;s:2:\"id\";i:12443;s:5:\"title\";s:22:\"Travel &#8211; Gallery\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/Gallery.png\";s:12:\"tmpl_created\";i:1575960459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/travel-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:467;s:11:\"trend_index\";i:501;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:407;a:16:{s:4:\"tmpl\";i:756;s:2:\"id\";i:9985;s:5:\"title\";s:20:\"Slide In | Promotion\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_promotion_av_small.png\";s:12:\"tmpl_created\";i:1547844661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/slide-in-promotion-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:758;s:11:\"trend_index\";i:815;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:408;a:16:{s:4:\"tmpl\";i:631;s:2:\"id\";i:5912;s:5:\"title\";s:6:\"CTA 28\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_11.png\";s:12:\"tmpl_created\";i:1520520755;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-28/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:99;s:16:\"popularity_index\";i:665;s:11:\"trend_index\";i:702;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:409;a:16:{s:4:\"tmpl\";i:934;s:2:\"id\";i:12431;s:5:\"title\";s:18:\"Travel &#8211; FAQ\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/12/FAQ.png\";s:12:\"tmpl_created\";i:1575960453;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:100:\"https://library.elementor.com/travel-faq/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:99;s:16:\"popularity_index\";i:501;s:11:\"trend_index\";i:387;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:410;a:16:{s:4:\"tmpl\";i:933;s:2:\"id\";i:12421;s:5:\"title\";s:27:\"Travel &#8211; Contact Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/12/Contsct-Us.png\";s:12:\"tmpl_created\";i:1575960445;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-contact-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:100;s:16:\"popularity_index\";i:571;s:11:\"trend_index\";i:536;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:411;a:16:{s:4:\"tmpl\";i:473;s:2:\"id\";i:5189;s:5:\"title\";s:6:\"CTA 29\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_1.png\";s:12:\"tmpl_created\";i:1520443456;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:100;s:16:\"popularity_index\";i:472;s:11:\"trend_index\";i:631;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:412;a:16:{s:4:\"tmpl\";i:623;s:2:\"id\";i:5667;s:5:\"title\";s:5:\"CTA 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_8.png\";s:12:\"tmpl_created\";i:1520520705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:101;s:16:\"popularity_index\";i:171;s:11:\"trend_index\";i:250;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:413;a:16:{s:4:\"tmpl\";i:892;s:2:\"id\";i:11763;s:5:\"title\";s:27:\"Portfolio &#8211; Home Page\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Homepage_small.png\";s:12:\"tmpl_created\";i:1569428959;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/portfolio-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:101;s:16:\"popularity_index\";i:280;s:11:\"trend_index\";i:241;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:414;a:16:{s:4:\"tmpl\";i:891;s:2:\"id\";i:11781;s:5:\"title\";s:23:\"Portfolio &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/About_small.png\";s:12:\"tmpl_created\";i:1569428955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/portfolio-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:102;s:16:\"popularity_index\";i:349;s:11:\"trend_index\";i:290;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:415;a:16:{s:4:\"tmpl\";i:474;s:2:\"id\";i:5198;s:5:\"title\";s:6:\"CTA 30\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_1.png\";s:12:\"tmpl_created\";i:1520443458;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-30/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:102;s:16:\"popularity_index\";i:572;s:11:\"trend_index\";i:511;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:416;a:16:{s:4:\"tmpl\";i:890;s:2:\"id\";i:11793;s:5:\"title\";s:26:\"Portfolio &#8211; Projects\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Projects_small.png\";s:12:\"tmpl_created\";i:1569428951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/portfolio-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:103;s:16:\"popularity_index\";i:448;s:11:\"trend_index\";i:467;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:417;a:16:{s:4:\"tmpl\";i:475;s:2:\"id\";i:5206;s:5:\"title\";s:6:\"CTA 31\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_2.png\";s:12:\"tmpl_created\";i:1520443459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-31/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:103;s:16:\"popularity_index\";i:593;s:11:\"trend_index\";i:611;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:418;a:16:{s:4:\"tmpl\";i:889;s:2:\"id\";i:11800;s:5:\"title\";s:25:\"Portfolio &#8211; Contact\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/09/Contact_small.png\";s:12:\"tmpl_created\";i:1569428946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/portfolio-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:104;s:16:\"popularity_index\";i:494;s:11:\"trend_index\";i:449;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:419;a:16:{s:4:\"tmpl\";i:480;s:2:\"id\";i:5249;s:5:\"title\";s:6:\"CTA 32\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_4.png\";s:12:\"tmpl_created\";i:1520443470;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-32/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:104;s:16:\"popularity_index\";i:512;s:11:\"trend_index\";i:409;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:420;a:16:{s:4:\"tmpl\";i:866;s:2:\"id\";i:11163;s:5:\"title\";s:32:\"Digital Agency &#8211; Home Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/07/Home_small.png\";s:12:\"tmpl_created\";i:1564641877;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/digital-agency-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:57;s:11:\"trend_index\";i:32;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:421;a:16:{s:4:\"tmpl\";i:612;s:2:\"id\";i:5550;s:5:\"title\";s:6:\"CTA 33\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_1.png\";s:12:\"tmpl_created\";i:1520520682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-33/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:260;s:11:\"trend_index\";i:562;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:422;a:16:{s:4:\"tmpl\";i:714;s:2:\"id\";i:9559;s:5:\"title\";s:16:\"Slide In | Login\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_login_01_small.png\";s:12:\"tmpl_created\";i:1546946547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/slide-in-login-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:617;s:11:\"trend_index\";i:839;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:423;a:16:{s:4:\"tmpl\";i:536;s:2:\"id\";i:5852;s:5:\"title\";s:6:\"CTA 34\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2018/03/form_1.png\";s:12:\"tmpl_created\";i:1520443600;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-34/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:106;s:16:\"popularity_index\";i:563;s:11:\"trend_index\";i:828;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:424;a:16:{s:4:\"tmpl\";i:624;s:2:\"id\";i:5675;s:5:\"title\";s:5:\"CTA 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_8.png\";s:12:\"tmpl_created\";i:1520520707;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:107;s:16:\"popularity_index\";i:391;s:11:\"trend_index\";i:484;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:425;a:16:{s:4:\"tmpl\";i:734;s:2:\"id\";i:9752;s:5:\"title\";s:27:\"Slide In | Sale | Promotion\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/rush_small.png\";s:12:\"tmpl_created\";i:1547823982;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/slide-in-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:107;s:16:\"popularity_index\";i:740;s:11:\"trend_index\";i:801;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:426;a:16:{s:4:\"tmpl\";i:616;s:2:\"id\";i:5591;s:5:\"title\";s:5:\"CTA 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_4.png\";s:12:\"tmpl_created\";i:1520520691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:108;s:16:\"popularity_index\";i:133;s:11:\"trend_index\";i:130;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:427;a:16:{s:4:\"tmpl\";i:916;s:2:\"id\";i:12143;s:5:\"title\";s:22:\"Law Firm &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/about.png\";s:12:\"tmpl_created\";i:1572847069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/law-firm-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:108;s:16:\"popularity_index\";i:350;s:11:\"trend_index\";i:344;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:428;a:16:{s:4:\"tmpl\";i:617;s:2:\"id\";i:5599;s:5:\"title\";s:5:\"CTA 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_4.png\";s:12:\"tmpl_created\";i:1520520693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:109;s:16:\"popularity_index\";i:252;s:11:\"trend_index\";i:362;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:429;a:16:{s:4:\"tmpl\";i:920;s:2:\"id\";i:12091;s:5:\"title\";s:21:\"Law Firm &#8211; Team\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2019/11/team.png\";s:12:\"tmpl_created\";i:1572847113;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/law-firm-team/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:109;s:16:\"popularity_index\";i:318;s:11:\"trend_index\";i:314;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:430;a:16:{s:4:\"tmpl\";i:514;s:2:\"id\";i:5575;s:5:\"title\";s:5:\"CTA 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_3.png\";s:12:\"tmpl_created\";i:1520443543;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:110;s:16:\"popularity_index\";i:13;s:11:\"trend_index\";i:586;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:431;a:16:{s:4:\"tmpl\";i:869;s:2:\"id\";i:11129;s:5:\"title\";s:28:\"Digital Agency &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/About_small.png\";s:12:\"tmpl_created\";i:1564641889;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/digital-agency-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:110;s:16:\"popularity_index\";i:182;s:11:\"trend_index\";i:166;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:432;a:16:{s:4:\"tmpl\";i:622;s:2:\"id\";i:5658;s:5:\"title\";s:5:\"CTA 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_7.png\";s:12:\"tmpl_created\";i:1520520704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:111;s:16:\"popularity_index\";i:187;s:11:\"trend_index\";i:235;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:433;a:16:{s:4:\"tmpl\";i:880;s:2:\"id\";i:11572;s:5:\"title\";s:19:\"Gym &#8211; Trainer\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Trainer_Small.png\";s:12:\"tmpl_created\";i:1567392934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-trainer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:111;s:16:\"popularity_index\";i:521;s:11:\"trend_index\";i:590;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:434;a:16:{s:4:\"tmpl\";i:774;s:2:\"id\";i:10169;s:5:\"title\";s:37:\"Slide In | Register | Subscribe | App\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/slideinapp_small.png\";s:12:\"tmpl_created\";i:1547852334;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/slide-in-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:112;s:16:\"popularity_index\";i:546;s:11:\"trend_index\";i:701;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:435;a:16:{s:4:\"tmpl\";i:621;s:2:\"id\";i:5650;s:5:\"title\";s:5:\"CTA 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_7.png\";s:12:\"tmpl_created\";i:1520520702;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:112;s:16:\"popularity_index\";i:94;s:11:\"trend_index\";i:148;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:436;a:16:{s:4:\"tmpl\";i:1061;s:2:\"id\";i:15407;s:5:\"title\";s:24:\"Dance Studio &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/10/404.jpg\";s:12:\"tmpl_created\";i:1603181958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/dance-studio-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:22:\"[\"404\",\"Dance Studio\"]\";s:10:\"menu_order\";i:113;s:16:\"popularity_index\";i:783;s:11:\"trend_index\";i:710;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:437;a:16:{s:4:\"tmpl\";i:917;s:2:\"id\";i:12133;s:5:\"title\";s:24:\"Law Firm &#8211; Careers\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/11/careers.png\";s:12:\"tmpl_created\";i:1572847078;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-careers/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:113;s:16:\"popularity_index\";i:583;s:11:\"trend_index\";i:640;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:438;a:16:{s:4:\"tmpl\";i:1062;s:2:\"id\";i:15400;s:5:\"title\";s:27:\"Dance Studio &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/10/Footer.jpg\";s:12:\"tmpl_created\";i:1603181989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/dance-studio-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:25:\"[\"Dance Studio\",\"Footer\"]\";s:10:\"menu_order\";i:114;s:16:\"popularity_index\";i:586;s:11:\"trend_index\";i:243;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:439;a:16:{s:4:\"tmpl\";i:915;s:2:\"id\";i:12155;s:5:\"title\";s:26:\"Law Firm &#8211; Home Page\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2019/11/home.png\";s:12:\"tmpl_created\";i:1572847054;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/law-firm-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:114;s:16:\"popularity_index\";i:193;s:11:\"trend_index\";i:110;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:440;a:16:{s:4:\"tmpl\";i:1063;s:2:\"id\";i:15391;s:5:\"title\";s:27:\"Dance Studio &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/10/Header.jpg\";s:12:\"tmpl_created\";i:1603182011;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/dance-studio-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:25:\"[\"Dance Studio\",\"Header\"]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:352;s:11:\"trend_index\";i:67;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:441;a:16:{s:4:\"tmpl\";i:921;s:2:\"id\";i:12080;s:5:\"title\";s:24:\"Law Firm &#8211; Partner\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/11/partner-1.png\";s:12:\"tmpl_created\";i:1572847120;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-partner/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:556;s:11:\"trend_index\";i:471;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:442;a:16:{s:4:\"tmpl\";i:726;s:2:\"id\";i:9680;s:5:\"title\";s:23:\"Slide In | Content Lock\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2019/01/Slide-in_Content-lock_small_01.png\";s:12:\"tmpl_created\";i:1547010967;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/slide-in-content-lock-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:725;s:11:\"trend_index\";i:725;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:443;a:16:{s:4:\"tmpl\";i:865;s:2:\"id\";i:11074;s:5:\"title\";s:31:\"Digital Agency &#8211; Services\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/07/Services_small.png\";s:12:\"tmpl_created\";i:1564641872;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/digital-agency-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:116;s:16:\"popularity_index\";i:163;s:11:\"trend_index\";i:170;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:444;a:16:{s:4:\"tmpl\";i:874;s:2:\"id\";i:11192;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/07/Footer_small.jpg\";s:12:\"tmpl_created\";i:1564642399;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:39:\"[\"Digital Agency\",\"Footer\",\"Marketing\"]\";s:10:\"menu_order\";i:116;s:16:\"popularity_index\";i:172;s:11:\"trend_index\";i:105;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:445;a:16:{s:4:\"tmpl\";i:873;s:2:\"id\";i:11198;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-digital-marketing-agency.png\";s:12:\"tmpl_created\";i:1564642395;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:39:\"[\"Digital Agency\",\"Header\",\"Marketing\"]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:34;s:11:\"trend_index\";i:10;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:446;a:16:{s:4:\"tmpl\";i:879;s:2:\"id\";i:11506;s:5:\"title\";s:19:\"Gym &#8211; Classes\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Classes_Small.png\";s:12:\"tmpl_created\";i:1567392930;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-classes/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:514;s:11:\"trend_index\";i:554;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:447;a:16:{s:4:\"tmpl\";i:737;s:2:\"id\";i:9783;s:5:\"title\";s:31:\"Slide In | Register | Subscribe\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_yellow_small.png\";s:12:\"tmpl_created\";i:1547831059;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/slide-in-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:534;s:11:\"trend_index\";i:415;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:448;a:16:{s:4:\"tmpl\";i:872;s:2:\"id\";i:11204;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/07/404_small.jpg\";s:12:\"tmpl_created\";i:1564642389;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:36:\"[\"404\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:118;s:16:\"popularity_index\";i:301;s:11:\"trend_index\";i:239;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:449;a:16:{s:4:\"tmpl\";i:871;s:2:\"id\";i:11220;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/08/Archive_small1.png\";s:12:\"tmpl_created\";i:1564642385;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:119;s:16:\"popularity_index\";i:116;s:11:\"trend_index\";i:73;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:450;a:16:{s:4:\"tmpl\";i:922;s:2:\"id\";i:12044;s:5:\"title\";s:24:\"Law Firm &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/11/contsct_us.png\";s:12:\"tmpl_created\";i:1572847130;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:119;s:16:\"popularity_index\";i:437;s:11:\"trend_index\";i:304;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:451;a:16:{s:4:\"tmpl\";i:870;s:2:\"id\";i:11231;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/Post_small1.png\";s:12:\"tmpl_created\";i:1564642380;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/digital-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:120;s:16:\"popularity_index\";i:145;s:11:\"trend_index\";i:71;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:452;a:16:{s:4:\"tmpl\";i:918;s:2:\"id\";i:12124;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/11/services.png\";s:12:\"tmpl_created\";i:1572847096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/law-firm-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:120;s:16:\"popularity_index\";i:433;s:11:\"trend_index\";i:296;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:453;a:16:{s:4:\"tmpl\";i:520;s:2:\"id\";i:5711;s:5:\"title\";s:5:\"FAQ 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_2.png\";s:12:\"tmpl_created\";i:1520443571;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:121;s:16:\"popularity_index\";i:200;s:11:\"trend_index\";i:231;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:454;a:16:{s:4:\"tmpl\";i:864;s:2:\"id\";i:11056;s:5:\"title\";s:35:\"Digital Agency &#8211; Social Media\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/07/Social-Media_small.png\";s:12:\"tmpl_created\";i:1564641867;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/digital-agency-social-media/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:121;s:16:\"popularity_index\";i:297;s:11:\"trend_index\";i:361;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:455;a:16:{s:4:\"tmpl\";i:523;s:2:\"id\";i:5737;s:5:\"title\";s:6:\"FAQ 10\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_4.png\";s:12:\"tmpl_created\";i:1520443576;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:122;s:16:\"popularity_index\";i:155;s:11:\"trend_index\";i:112;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:456;a:16:{s:4:\"tmpl\";i:878;s:2:\"id\";i:11536;s:5:\"title\";s:19:\"Gym &#8211; Fitness\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Fitness_Small.png\";s:12:\"tmpl_created\";i:1567392927;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:122;s:16:\"popularity_index\";i:621;s:11:\"trend_index\";i:674;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:457;a:16:{s:4:\"tmpl\";i:524;s:2:\"id\";i:5746;s:5:\"title\";s:6:\"FAQ 11\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_4.png\";s:12:\"tmpl_created\";i:1520443578;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:123;s:16:\"popularity_index\";i:212;s:11:\"trend_index\";i:305;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:458;a:16:{s:4:\"tmpl\";i:882;s:2:\"id\";i:11545;s:5:\"title\";s:21:\"Gym &#8211; Home Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/08/Home_Small.png\";s:12:\"tmpl_created\";i:1567392943;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/gym-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:123;s:16:\"popularity_index\";i:310;s:11:\"trend_index\";i:229;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:459;a:16:{s:4:\"tmpl\";i:519;s:2:\"id\";i:5703;s:5:\"title\";s:6:\"FAQ 13\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_2.png\";s:12:\"tmpl_created\";i:1520443569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:124;s:16:\"popularity_index\";i:29;s:11:\"trend_index\";i:38;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:460;a:16:{s:4:\"tmpl\";i:919;s:2:\"id\";i:12116;s:5:\"title\";s:24:\"Law Firm &#8211; Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/11/family_law.png\";s:12:\"tmpl_created\";i:1572847105;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:124;s:16:\"popularity_index\";i:489;s:11:\"trend_index\";i:339;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:461;a:16:{s:4:\"tmpl\";i:521;s:2:\"id\";i:5719;s:5:\"title\";s:5:\"FAQ 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_3.png\";s:12:\"tmpl_created\";i:1520443573;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:125;s:16:\"popularity_index\";i:125;s:11:\"trend_index\";i:251;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:462;a:16:{s:4:\"tmpl\";i:868;s:2:\"id\";i:11094;s:5:\"title\";s:30:\"Digital Agency &#8211; Clients\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/07/Clients_small.png\";s:12:\"tmpl_created\";i:1564641885;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/digital-agency-clients/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:125;s:16:\"popularity_index\";i:424;s:11:\"trend_index\";i:424;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:463;a:16:{s:4:\"tmpl\";i:522;s:2:\"id\";i:5729;s:5:\"title\";s:5:\"FAQ 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_3.png\";s:12:\"tmpl_created\";i:1520443575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:126;s:16:\"popularity_index\";i:319;s:11:\"trend_index\";i:327;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:464;a:16:{s:4:\"tmpl\";i:881;s:2:\"id\";i:11478;s:5:\"title\";s:17:\"Gym &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/About_Small.png\";s:12:\"tmpl_created\";i:1567392939;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:99:\"https://library.elementor.com/gym-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:126;s:16:\"popularity_index\";i:481;s:11:\"trend_index\";i:579;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:465;a:16:{s:4:\"tmpl\";i:525;s:2:\"id\";i:5755;s:5:\"title\";s:5:\"FAQ 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_5.png\";s:12:\"tmpl_created\";i:1520443580;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:127;s:16:\"popularity_index\";i:112;s:11:\"trend_index\";i:180;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:466;a:16:{s:4:\"tmpl\";i:877;s:2:\"id\";i:11563;s:5:\"title\";s:19:\"Gym &#8211; Pricing\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Pricing_Small.png\";s:12:\"tmpl_created\";i:1567392923;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-pricing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:127;s:16:\"popularity_index\";i:577;s:11:\"trend_index\";i:736;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:467;a:16:{s:4:\"tmpl\";i:526;s:2:\"id\";i:5764;s:5:\"title\";s:5:\"FAQ 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_5.png\";s:12:\"tmpl_created\";i:1520443582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:128;s:16:\"popularity_index\";i:338;s:11:\"trend_index\";i:474;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:468;a:16:{s:4:\"tmpl\";i:867;s:2:\"id\";i:11034;s:5:\"title\";s:30:\"Digital Agency &#8211; Contact\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/07/Contsct-Us_small.png\";s:12:\"tmpl_created\";i:1564641881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/contact-digital-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:128;s:16:\"popularity_index\";i:191;s:11:\"trend_index\";i:156;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:469;a:16:{s:4:\"tmpl\";i:517;s:2:\"id\";i:5684;s:5:\"title\";s:5:\"FAQ 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_1.png\";s:12:\"tmpl_created\";i:1520443565;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:129;s:16:\"popularity_index\";i:74;s:11:\"trend_index\";i:193;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:470;a:16:{s:4:\"tmpl\";i:876;s:2:\"id\";i:11528;s:5:\"title\";s:19:\"Gym &#8211; Contact\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Contact_Small.png\";s:12:\"tmpl_created\";i:1567392917;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:129;s:16:\"popularity_index\";i:505;s:11:\"trend_index\";i:624;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:471;a:16:{s:4:\"tmpl\";i:518;s:2:\"id\";i:5693;s:5:\"title\";s:5:\"FAQ 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_1.png\";s:12:\"tmpl_created\";i:1520443567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:130;s:16:\"popularity_index\";i:224;s:11:\"trend_index\";i:515;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:472;a:16:{s:4:\"tmpl\";i:548;s:2:\"id\";i:6053;s:5:\"title\";s:10:\"Features 1\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_5.png\";s:12:\"tmpl_created\";i:1520443645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:131;s:16:\"popularity_index\";i:179;s:11:\"trend_index\";i:463;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:473;a:16:{s:4:\"tmpl\";i:542;s:2:\"id\";i:5991;s:5:\"title\";s:11:\"Features 10\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_4.png\";s:12:\"tmpl_created\";i:1520443632;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:132;s:16:\"popularity_index\";i:135;s:11:\"trend_index\";i:265;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:474;a:16:{s:4:\"tmpl\";i:547;s:2:\"id\";i:6044;s:5:\"title\";s:11:\"Features 11\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_5.png\";s:12:\"tmpl_created\";i:1520443643;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:133;s:16:\"popularity_index\";i:70;s:11:\"trend_index\";i:163;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:475;a:16:{s:4:\"tmpl\";i:566;s:2:\"id\";i:6212;s:5:\"title\";s:11:\"Features 12\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_7.png\";s:12:\"tmpl_created\";i:1520443684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:134;s:16:\"popularity_index\";i:81;s:11:\"trend_index\";i:98;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:476;a:16:{s:4:\"tmpl\";i:567;s:2:\"id\";i:6220;s:5:\"title\";s:10:\"Features 2\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_8.png\";s:12:\"tmpl_created\";i:1520443685;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:135;s:16:\"popularity_index\";i:88;s:11:\"trend_index\";i:189;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:477;a:16:{s:4:\"tmpl\";i:541;s:2:\"id\";i:5983;s:5:\"title\";s:10:\"Features 3\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_3.png\";s:12:\"tmpl_created\";i:1520443630;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:11:\"[\"featues\"]\";s:10:\"menu_order\";i:136;s:16:\"popularity_index\";i:231;s:11:\"trend_index\";i:351;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:478;a:16:{s:4:\"tmpl\";i:540;s:2:\"id\";i:5974;s:5:\"title\";s:10:\"Features 4\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_3.png\";s:12:\"tmpl_created\";i:1520443629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:137;s:16:\"popularity_index\";i:69;s:11:\"trend_index\";i:181;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:479;a:16:{s:4:\"tmpl\";i:516;s:2:\"id\";i:5624;s:5:\"title\";s:10:\"Features 5\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_1.png\";s:12:\"tmpl_created\";i:1520443553;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:138;s:16:\"popularity_index\";i:93;s:11:\"trend_index\";i:352;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:480;a:16:{s:4:\"tmpl\";i:515;s:2:\"id\";i:5615;s:5:\"title\";s:10:\"Features 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_5.png\";s:12:\"tmpl_created\";i:1520443551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:139;s:16:\"popularity_index\";i:41;s:11:\"trend_index\";i:119;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:481;a:16:{s:4:\"tmpl\";i:539;s:2:\"id\";i:5963;s:5:\"title\";s:10:\"Features 7\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_2.png\";s:12:\"tmpl_created\";i:1520443626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:140;s:16:\"popularity_index\";i:67;s:11:\"trend_index\";i:133;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:482;a:16:{s:4:\"tmpl\";i:565;s:2:\"id\";i:6204;s:5:\"title\";s:10:\"Features 8\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_6.png\";s:12:\"tmpl_created\";i:1520443681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:141;s:16:\"popularity_index\";i:217;s:11:\"trend_index\";i:223;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:483;a:16:{s:4:\"tmpl\";i:564;s:2:\"id\";i:6196;s:5:\"title\";s:10:\"Features 9\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_6.png\";s:12:\"tmpl_created\";i:1520443680;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:106;s:11:\"trend_index\";i:113;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:484;a:16:{s:4:\"tmpl\";i:1033;s:2:\"id\";i:15033;s:5:\"title\";s:28:\"Flooring Company &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/08/404.png\";s:12:\"tmpl_created\";i:1597739459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/flooring-company-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:45:\"[\"404\",\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:143;s:16:\"popularity_index\";i:655;s:11:\"trend_index\";i:671;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:485;a:16:{s:4:\"tmpl\";i:1032;s:2:\"id\";i:15042;s:5:\"title\";s:32:\"Flooring Company &#8211; Archive\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/08/Blog.png\";s:12:\"tmpl_created\";i:1597739084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/flooring-company-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:144;s:16:\"popularity_index\";i:320;s:11:\"trend_index\";i:275;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:486;a:16:{s:4:\"tmpl\";i:1031;s:2:\"id\";i:15017;s:5:\"title\";s:31:\"Flooring Company &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Footer.png\";s:12:\"tmpl_created\";i:1597738933;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/flooring-company-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:48:\"[\"Flooring company\",\"Flooring website\",\"Footer\"]\";s:10:\"menu_order\";i:145;s:16:\"popularity_index\";i:323;s:11:\"trend_index\";i:192;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:487;a:16:{s:4:\"tmpl\";i:1030;s:2:\"id\";i:15007;s:5:\"title\";s:31:\"Flooring Company &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Header.png\";s:12:\"tmpl_created\";i:1597738896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/flooring-company-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:48:\"[\"Flooring company\",\"Flooring website\",\"Header\"]\";s:10:\"menu_order\";i:146;s:16:\"popularity_index\";i:459;s:11:\"trend_index\";i:333;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:488;a:16:{s:4:\"tmpl\";i:1029;s:2:\"id\";i:15052;s:5:\"title\";s:36:\"Flooring Company &#8211; Single post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Single.png\";s:12:\"tmpl_created\";i:1597738858;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/flooring-company-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:147;s:16:\"popularity_index\";i:392;s:11:\"trend_index\";i:226;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:489;a:16:{s:4:\"tmpl\";i:651;s:2:\"id\";i:7837;s:5:\"title\";s:9:\"footer 01\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.14.jpg\";s:12:\"tmpl_created\";i:1524582852;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:148;s:16:\"popularity_index\";i:495;s:11:\"trend_index\";i:539;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:490;a:16:{s:4:\"tmpl\";i:647;s:2:\"id\";i:7937;s:5:\"title\";s:10:\"footer 010\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.5.jpg\";s:12:\"tmpl_created\";i:1524582665;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-010/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:149;s:16:\"popularity_index\";i:185;s:11:\"trend_index\";i:115;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:491;a:16:{s:4:\"tmpl\";i:646;s:2:\"id\";i:7950;s:5:\"title\";s:10:\"footer 011\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.4.jpg\";s:12:\"tmpl_created\";i:1524582631;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-011/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:150;s:16:\"popularity_index\";i:244;s:11:\"trend_index\";i:203;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:492;a:16:{s:4:\"tmpl\";i:645;s:2:\"id\";i:7959;s:5:\"title\";s:10:\"footer 012\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.3.jpg\";s:12:\"tmpl_created\";i:1524582605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-012/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:151;s:16:\"popularity_index\";i:177;s:11:\"trend_index\";i:140;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:493;a:16:{s:4:\"tmpl\";i:644;s:2:\"id\";i:7982;s:5:\"title\";s:10:\"footer 013\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.2.jpg\";s:12:\"tmpl_created\";i:1524582468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-013/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:152;s:16:\"popularity_index\";i:209;s:11:\"trend_index\";i:212;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:494;a:16:{s:4:\"tmpl\";i:643;s:2:\"id\";i:7997;s:5:\"title\";s:10:\"footer 014\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.1.jpg\";s:12:\"tmpl_created\";i:1524582343;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-014/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:153;s:16:\"popularity_index\";i:64;s:11:\"trend_index\";i:41;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:495;a:16:{s:4:\"tmpl\";i:693;s:2:\"id\";i:9119;s:5:\"title\";s:10:\"footer 015\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/Footer_GetStarted_350.png\";s:12:\"tmpl_created\";i:1532428138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/blocks/demo/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:154;s:16:\"popularity_index\";i:240;s:11:\"trend_index\";i:154;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:496;a:16:{s:4:\"tmpl\";i:652;s:2:\"id\";i:7852;s:5:\"title\";s:9:\"footer 02\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.13.jpg\";s:12:\"tmpl_created\";i:1524582875;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:155;s:16:\"popularity_index\";i:199;s:11:\"trend_index\";i:96;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:497;a:16:{s:4:\"tmpl\";i:653;s:2:\"id\";i:7862;s:5:\"title\";s:9:\"footer 03\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.12.jpg\";s:12:\"tmpl_created\";i:1524582903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:156;s:16:\"popularity_index\";i:137;s:11:\"trend_index\";i:91;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:498;a:16:{s:4:\"tmpl\";i:654;s:2:\"id\";i:7871;s:5:\"title\";s:9:\"footer 04\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.11.jpg\";s:12:\"tmpl_created\";i:1524582927;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:157;s:16:\"popularity_index\";i:97;s:11:\"trend_index\";i:55;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:499;a:16:{s:4:\"tmpl\";i:655;s:2:\"id\";i:7884;s:5:\"title\";s:9:\"footer 05\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.10.jpg\";s:12:\"tmpl_created\";i:1524582944;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-05/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:158;s:16:\"popularity_index\";i:92;s:11:\"trend_index\";i:109;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:500;a:16:{s:4:\"tmpl\";i:656;s:2:\"id\";i:7892;s:5:\"title\";s:9:\"footer 06\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.9.jpg\";s:12:\"tmpl_created\";i:1524583015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-06/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:159;s:16:\"popularity_index\";i:132;s:11:\"trend_index\";i:146;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:501;a:16:{s:4:\"tmpl\";i:650;s:2:\"id\";i:7904;s:5:\"title\";s:9:\"footer 07\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.8.jpg\";s:12:\"tmpl_created\";i:1524582814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-07/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:160;s:16:\"popularity_index\";i:203;s:11:\"trend_index\";i:186;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:502;a:16:{s:4:\"tmpl\";i:649;s:2:\"id\";i:7917;s:5:\"title\";s:9:\"footer 08\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.7.jpg\";s:12:\"tmpl_created\";i:1524582788;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-08/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:161;s:16:\"popularity_index\";i:89;s:11:\"trend_index\";i:144;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:503;a:16:{s:4:\"tmpl\";i:648;s:2:\"id\";i:7927;s:5:\"title\";s:9:\"footer 09\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.6.jpg\";s:12:\"tmpl_created\";i:1524582691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-09/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:162;s:16:\"popularity_index\";i:178;s:11:\"trend_index\";i:100;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:504;a:16:{s:4:\"tmpl\";i:642;s:2:\"id\";i:4676;s:5:\"title\";s:8:\"Footer 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_7.png\";s:12:\"tmpl_created\";i:1522014215;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer_7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"Footer\"]\";s:10:\"menu_order\";i:169;s:16:\"popularity_index\";i:237;s:11:\"trend_index\";i:346;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:505;a:16:{s:4:\"tmpl\";i:637;s:2:\"id\";i:7627;s:5:\"title\";s:8:\"Footer 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_1.png\";s:12:\"tmpl_created\";i:1521547332;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"Footer\"]\";s:10:\"menu_order\";i:170;s:16:\"popularity_index\";i:100;s:11:\"trend_index\";i:83;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:506;a:16:{s:4:\"tmpl\";i:638;s:2:\"id\";i:7638;s:5:\"title\";s:8:\"Footer 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_2.png\";s:12:\"tmpl_created\";i:1521547502;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"Footer\"]\";s:10:\"menu_order\";i:171;s:16:\"popularity_index\";i:124;s:11:\"trend_index\";i:147;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:507;a:16:{s:4:\"tmpl\";i:888;s:2:\"id\";i:11424;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/08/404_Small.png\";s:12:\"tmpl_created\";i:1567393309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:13:\"[\"404\",\"Gym\"]\";s:10:\"menu_order\";i:172;s:16:\"popularity_index\";i:679;s:11:\"trend_index\";i:769;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:508;a:16:{s:4:\"tmpl\";i:887;s:2:\"id\";i:11435;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/08/Archiv_Small.png\";s:12:\"tmpl_created\";i:1567393296;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:173;s:16:\"popularity_index\";i:441;s:11:\"trend_index\";i:507;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:509;a:16:{s:4:\"tmpl\";i:886;s:2:\"id\";i:11445;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/08/Post_Small.png\";s:12:\"tmpl_created\";i:1567393229;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:174;s:16:\"popularity_index\";i:452;s:11:\"trend_index\";i:479;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:510;a:16:{s:4:\"tmpl\";i:885;s:2:\"id\";i:11453;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/08/Footer_Small.png\";s:12:\"tmpl_created\";i:1567393224;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:16:\"[\"Footer\",\"Gym\"]\";s:10:\"menu_order\";i:175;s:16:\"popularity_index\";i:270;s:11:\"trend_index\";i:331;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:511;a:16:{s:4:\"tmpl\";i:884;s:2:\"id\";i:11461;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-gym-and-fitness.png\";s:12:\"tmpl_created\";i:1567393219;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:100:\"https://library.elementor.com/blocks/gym/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:16:\"[\"Gym\",\"Header\"]\";s:10:\"menu_order\";i:176;s:16:\"popularity_index\";i:201;s:11:\"trend_index\";i:135;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:512;a:16:{s:4:\"tmpl\";i:635;s:2:\"id\";i:7596;s:5:\"title\";s:8:\"Header 1\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.12.jpg\";s:12:\"tmpl_created\";i:1521546999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:10:\"[\"Header\"]\";s:10:\"menu_order\";i:177;s:16:\"popularity_index\";i:33;s:11:\"trend_index\";i:17;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:513;a:16:{s:4:\"tmpl\";i:663;s:2:\"id\";i:7801;s:5:\"title\";s:9:\"header 10\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.9.jpg\";s:12:\"tmpl_created\";i:1524583659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:178;s:16:\"popularity_index\";i:51;s:11:\"trend_index\";i:14;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:514;a:16:{s:4:\"tmpl\";i:658;s:2:\"id\";i:7812;s:5:\"title\";s:9:\"header 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.10.jpg\";s:12:\"tmpl_created\";i:1524583298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:179;s:16:\"popularity_index\";i:96;s:11:\"trend_index\";i:103;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:515;a:16:{s:4:\"tmpl\";i:657;s:2:\"id\";i:7825;s:5:\"title\";s:9:\"header 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.11.jpg\";s:12:\"tmpl_created\";i:1524583273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:180;s:16:\"popularity_index\";i:63;s:11:\"trend_index\";i:75;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:516;a:16:{s:4:\"tmpl\";i:694;s:2:\"id\";i:9127;s:5:\"title\";s:9:\"header 13\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2018/07/Header_get_started_1200V3.png\";s:12:\"tmpl_created\";i:1532428699;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:181;s:16:\"popularity_index\";i:61;s:11:\"trend_index\";i:58;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:517;a:16:{s:4:\"tmpl\";i:636;s:2:\"id\";i:7615;s:5:\"title\";s:8:\"Header 2\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.1.jpg\";s:12:\"tmpl_created\";i:1521547237;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:10:\"[\"Header\"]\";s:10:\"menu_order\";i:182;s:16:\"popularity_index\";i:30;s:11:\"trend_index\";i:33;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:518;a:16:{s:4:\"tmpl\";i:665;s:2:\"id\";i:7713;s:5:\"title\";s:8:\"header 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.2.jpg\";s:12:\"tmpl_created\";i:1524584780;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:183;s:16:\"popularity_index\";i:43;s:11:\"trend_index\";i:28;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:519;a:16:{s:4:\"tmpl\";i:659;s:2:\"id\";i:7724;s:5:\"title\";s:8:\"header 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.3.jpg\";s:12:\"tmpl_created\";i:1524583367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:184;s:16:\"popularity_index\";i:24;s:11:\"trend_index\";i:13;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:520;a:16:{s:4:\"tmpl\";i:660;s:2:\"id\";i:7734;s:5:\"title\";s:8:\"header 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.4.jpg\";s:12:\"tmpl_created\";i:1524583436;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:185;s:16:\"popularity_index\";i:36;s:11:\"trend_index\";i:18;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:521;a:16:{s:4:\"tmpl\";i:666;s:2:\"id\";i:7744;s:5:\"title\";s:8:\"Header 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.5.jpg\";s:12:\"tmpl_created\";i:1524584784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:186;s:16:\"popularity_index\";i:65;s:11:\"trend_index\";i:94;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:522;a:16:{s:4:\"tmpl\";i:664;s:2:\"id\";i:7754;s:5:\"title\";s:8:\"header 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.6.jpg\";s:12:\"tmpl_created\";i:1524583712;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:187;s:16:\"popularity_index\";i:111;s:11:\"trend_index\";i:143;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:523;a:16:{s:4:\"tmpl\";i:661;s:2:\"id\";i:7771;s:5:\"title\";s:8:\"header 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.7.jpg\";s:12:\"tmpl_created\";i:1524583540;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:188;s:16:\"popularity_index\";i:91;s:11:\"trend_index\";i:60;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:524;a:16:{s:4:\"tmpl\";i:662;s:2:\"id\";i:7787;s:5:\"title\";s:8:\"header 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.8.jpg\";s:12:\"tmpl_created\";i:1524583598;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:189;s:16:\"popularity_index\";i:102;s:11:\"trend_index\";i:78;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:525;a:16:{s:4:\"tmpl\";i:572;s:2:\"id\";i:6266;s:5:\"title\";s:6:\"Hero 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_4.png\";s:12:\"tmpl_created\";i:1520443695;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:190;s:16:\"popularity_index\";i:52;s:11:\"trend_index\";i:35;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:526;a:16:{s:4:\"tmpl\";i:528;s:2:\"id\";i:5783;s:5:\"title\";s:7:\"Hero 10\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_2.png\";s:12:\"tmpl_created\";i:1520443586;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:191;s:16:\"popularity_index\";i:365;s:11:\"trend_index\";i:567;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:527;a:16:{s:4:\"tmpl\";i:527;s:2:\"id\";i:5773;s:5:\"title\";s:7:\"Hero 11\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_1.png\";s:12:\"tmpl_created\";i:1520443584;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:192;s:16:\"popularity_index\";i:39;s:11:\"trend_index\";i:179;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:528;a:16:{s:4:\"tmpl\";i:479;s:2:\"id\";i:5238;s:5:\"title\";s:7:\"Hero 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4.png\";s:12:\"tmpl_created\";i:1520443468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:193;s:16:\"popularity_index\";i:611;s:11:\"trend_index\";i:555;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:529;a:16:{s:4:\"tmpl\";i:573;s:2:\"id\";i:6274;s:5:\"title\";s:6:\"Hero 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_5.png\";s:12:\"tmpl_created\";i:1520443698;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:194;s:16:\"popularity_index\";i:87;s:11:\"trend_index\";i:88;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:530;a:16:{s:4:\"tmpl\";i:569;s:2:\"id\";i:6239;s:5:\"title\";s:6:\"Hero 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_1.png\";s:12:\"tmpl_created\";i:1520443689;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:195;s:16:\"popularity_index\";i:23;s:11:\"trend_index\";i:34;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:531;a:16:{s:4:\"tmpl\";i:571;s:2:\"id\";i:6258;s:5:\"title\";s:6:\"Hero 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_3.png\";s:12:\"tmpl_created\";i:1520443693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:196;s:16:\"popularity_index\";i:479;s:11:\"trend_index\";i:470;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:532;a:16:{s:4:\"tmpl\";i:570;s:2:\"id\";i:6249;s:5:\"title\";s:6:\"Hero 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_2.png\";s:12:\"tmpl_created\";i:1520443691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:197;s:16:\"popularity_index\";i:56;s:11:\"trend_index\";i:85;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:533;a:16:{s:4:\"tmpl\";i:568;s:2:\"id\";i:6230;s:5:\"title\";s:6:\"Hero 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_white_1.png\";s:12:\"tmpl_created\";i:1520443687;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:198;s:16:\"popularity_index\";i:406;s:11:\"trend_index\";i:542;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:534;a:16:{s:4:\"tmpl\";i:530;s:2:\"id\";i:5801;s:5:\"title\";s:6:\"Hero 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_4.png\";s:12:\"tmpl_created\";i:1520443589;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:199;s:16:\"popularity_index\";i:15;s:11:\"trend_index\";i:37;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:535;a:16:{s:4:\"tmpl\";i:531;s:2:\"id\";i:5811;s:5:\"title\";s:6:\"Hero 8\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_5.png\";s:12:\"tmpl_created\";i:1520443591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:200;s:16:\"popularity_index\";i:105;s:11:\"trend_index\";i:86;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:536;a:16:{s:4:\"tmpl\";i:529;s:2:\"id\";i:5792;s:5:\"title\";s:6:\"Hero 9\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_3.png\";s:12:\"tmpl_created\";i:1520443588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:201;s:16:\"popularity_index\";i:225;s:11:\"trend_index\";i:244;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:537;a:16:{s:4:\"tmpl\";i:978;s:2:\"id\";i:13251;s:5:\"title\";s:27:\"Interior Design &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/04/404.png\";s:12:\"tmpl_created\";i:1586148737;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/interior-design-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:30:\"[\"Business\",\"interior design\"]\";s:10:\"menu_order\";i:202;s:16:\"popularity_index\";i:730;s:11:\"trend_index\";i:795;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:538;a:16:{s:4:\"tmpl\";i:979;s:2:\"id\";i:13244;s:5:\"title\";s:30:\"Interior Design &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/04/Footer.png\";s:12:\"tmpl_created\";i:1586148742;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/interior-design-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:39:\"[\"Business\",\"Footer\",\"interior design\"]\";s:10:\"menu_order\";i:203;s:16:\"popularity_index\";i:322;s:11:\"trend_index\";i:178;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:539;a:16:{s:4:\"tmpl\";i:980;s:2:\"id\";i:13236;s:5:\"title\";s:30:\"Interior Design &#8211; Header\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-interior-design.png\";s:12:\"tmpl_created\";i:1586148746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/interior-design-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:39:\"[\"Business\",\"Header\",\"interior design\"]\";s:10:\"menu_order\";i:204;s:16:\"popularity_index\";i:146;s:11:\"trend_index\";i:64;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:540;a:16:{s:4:\"tmpl\";i:977;s:2:\"id\";i:13259;s:5:\"title\";s:36:\"Interior Design &#8211; News Archive\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Archiv-Blog.png\";s:12:\"tmpl_created\";i:1586148733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/interior-design-news-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:30:\"[\"Business\",\"interior design\"]\";s:10:\"menu_order\";i:205;s:16:\"popularity_index\";i:436;s:11:\"trend_index\";i:132;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:541;a:16:{s:4:\"tmpl\";i:976;s:2:\"id\";i:13267;s:5:\"title\";s:35:\"Interior Design &#8211; Single News\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Post.png\";s:12:\"tmpl_created\";i:1586148728;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/interior-design-single-news/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"Business\",\"interior design\"]\";s:10:\"menu_order\";i:206;s:16:\"popularity_index\";i:402;s:11:\"trend_index\";i:108;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:542;a:16:{s:4:\"tmpl\";i:975;s:2:\"id\";i:13274;s:5:\"title\";s:38:\"Interior Design &#8211; Single Project\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/04/Single-Project-.png\";s:12:\"tmpl_created\";i:1586148723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/blocks/interior-design-single-project/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"Business\",\"interior design\"]\";s:10:\"menu_order\";i:207;s:16:\"popularity_index\";i:601;s:11:\"trend_index\";i:324;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:543;a:16:{s:4:\"tmpl\";i:1011;s:2:\"id\";i:14058;s:5:\"title\";s:36:\"Japanese restaurant &#8211; 404 page\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/06/404-Page.jpg\";s:12:\"tmpl_created\";i:1592290211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/japanese-restaurant-404-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:38:\"[\"404\",\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:208;s:16:\"popularity_index\";i:724;s:11:\"trend_index\";i:647;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:544;a:16:{s:4:\"tmpl\";i:1012;s:2:\"id\";i:14050;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Footer\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/Footer-Small.jpg\";s:12:\"tmpl_created\";i:1592290247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/japanese-restaurant-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:41:\"[\"Food\",\"Footer\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:209;s:16:\"popularity_index\";i:317;s:11:\"trend_index\";i:238;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:545;a:16:{s:4:\"tmpl\";i:1013;s:2:\"id\";i:14042;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Header\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2020/06/japanese-restaurant-header.jpg\";s:12:\"tmpl_created\";i:1592290277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/japanese-restaurant-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:41:\"[\"Food\",\"Header\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:210;s:16:\"popularity_index\";i:411;s:11:\"trend_index\";i:274;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:546;a:16:{s:4:\"tmpl\";i:914;s:2:\"id\";i:12164;s:5:\"title\";s:20:\"Law Firm &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/11/404.png\";s:12:\"tmpl_created\";i:1572846979;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/law-firm-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:24:\"[\"404\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:211;s:16:\"popularity_index\";i:704;s:11:\"trend_index\";i:716;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:547;a:16:{s:4:\"tmpl\";i:913;s:2:\"id\";i:12170;s:5:\"title\";s:23:\"Law Firm &#8211; Archiv\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/archiv.png\";s:12:\"tmpl_created\";i:1572846967;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-archiv/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:212;s:16:\"popularity_index\";i:431;s:11:\"trend_index\";i:294;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:548;a:16:{s:4:\"tmpl\";i:912;s:2:\"id\";i:12179;s:5:\"title\";s:23:\"Law Firm &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/footer.png\";s:12:\"tmpl_created\";i:1572846958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:27:\"[\"Footer\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:213;s:16:\"popularity_index\";i:388;s:11:\"trend_index\";i:240;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:549;a:16:{s:4:\"tmpl\";i:911;s:2:\"id\";i:12194;s:5:\"title\";s:23:\"Law Firm &#8211; Header\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-law-firm.png\";s:12:\"tmpl_created\";i:1572846935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:27:\"[\"Header\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:214;s:16:\"popularity_index\";i:80;s:11:\"trend_index\";i:39;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:550;a:16:{s:4:\"tmpl\";i:910;s:2:\"id\";i:12203;s:5:\"title\";s:30:\"Law Firm &#8211; Search Archiv\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/11/search_result.png\";s:12:\"tmpl_created\";i:1572846925;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/law-firm-search-archiv/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:215;s:16:\"popularity_index\";i:493;s:11:\"trend_index\";i:433;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:551;a:16:{s:4:\"tmpl\";i:909;s:2:\"id\";i:12212;s:5:\"title\";s:28:\"Law Firm &#8211; Single Post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/single.png\";s:12:\"tmpl_created\";i:1572846914;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/law-firm-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:216;s:16:\"popularity_index\";i:326;s:11:\"trend_index\";i:214;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:552;a:16:{s:4:\"tmpl\";i:1022;s:2:\"id\";i:14772;s:5:\"title\";s:35:\"Luxury Real Estate &#8211; 404 page\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/07/404.png\";s:12:\"tmpl_created\";i:1595315728;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/luxury-real-estate-404-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:34:\"[\"404\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:217;s:16:\"popularity_index\";i:759;s:11:\"trend_index\";i:720;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:553;a:16:{s:4:\"tmpl\";i:1023;s:2:\"id\";i:14779;s:5:\"title\";s:33:\"Luxury Real Estate &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/07/Footer.png\";s:12:\"tmpl_created\";i:1595315743;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/luxury-real-estate-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:37:\"[\"Footer\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:218;s:16:\"popularity_index\";i:536;s:11:\"trend_index\";i:505;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:554;a:16:{s:4:\"tmpl\";i:1024;s:2:\"id\";i:14790;s:5:\"title\";s:33:\"Luxury Real Estate &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/07/Header.png\";s:12:\"tmpl_created\";i:1595315760;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/luxury-real-estate-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:37:\"[\"Header\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:219;s:16:\"popularity_index\";i:101;s:11:\"trend_index\";i:157;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:555;a:16:{s:4:\"tmpl\";i:1026;s:2:\"id\";i:14809;s:5:\"title\";s:45:\"Luxury Real Estate &#8211; Properties Archive\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/07/Properties.png\";s:12:\"tmpl_created\";i:1595315826;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/blocks/luxury-real-estate-properties-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:220;s:16:\"popularity_index\";i:414;s:11:\"trend_index\";i:420;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:556;a:16:{s:4:\"tmpl\";i:1027;s:2:\"id\";i:14816;s:5:\"title\";s:47:\"Luxury Real Estate &#8211; Property single post\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/07/Single-Property-.png\";s:12:\"tmpl_created\";i:1595315847;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/blocks/luxury-real-estate-property-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:221;s:16:\"popularity_index\";i:541;s:11:\"trend_index\";i:665;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:557;a:16:{s:4:\"tmpl\";i:1025;s:2:\"id\";i:14799;s:5:\"title\";s:38:\"Luxury Real Estate &#8211; single post\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/07/Post.png\";s:12:\"tmpl_created\";i:1595315792;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/blocks/luxury-real-estate-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:222;s:16:\"popularity_index\";i:369;s:11:\"trend_index\";i:441;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:558;a:16:{s:4:\"tmpl\";i:950;s:2:\"id\";i:12635;s:5:\"title\";s:20:\"Magazine &#8211; 404\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/01/404_s.png\";s:12:\"tmpl_created\";i:1579060746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/magazine-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:25:\"[\"404\",\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:223;s:16:\"popularity_index\";i:645;s:11:\"trend_index\";i:734;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:559;a:16:{s:4:\"tmpl\";i:949;s:2:\"id\";i:12643;s:5:\"title\";s:24:\"Magazine &#8211; Archiv1\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/01/Archiv1_s.png\";s:12:\"tmpl_created\";i:1579060737;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/magazine-archiv1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:224;s:16:\"popularity_index\";i:346;s:11:\"trend_index\";i:272;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:560;a:16:{s:4:\"tmpl\";i:946;s:2:\"id\";i:12669;s:5:\"title\";s:23:\"Magazine &#8211; Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/01/Footer_s.png\";s:12:\"tmpl_created\";i:1579060715;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:28:\"[\"Blog\",\"Footer\",\"Magazine\"]\";s:10:\"menu_order\";i:225;s:16:\"popularity_index\";i:442;s:11:\"trend_index\";i:349;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:561;a:16:{s:4:\"tmpl\";i:945;s:2:\"id\";i:12678;s:5:\"title\";s:23:\"Magazine &#8211; Header\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-magazine.png\";s:12:\"tmpl_created\";i:1579060701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:28:\"[\"Blog\",\"Header\",\"Magazine\"]\";s:10:\"menu_order\";i:226;s:16:\"popularity_index\";i:295;s:11:\"trend_index\";i:197;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:562;a:16:{s:4:\"tmpl\";i:947;s:2:\"id\";i:12661;s:5:\"title\";s:23:\"Magazine &#8211; Search\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/01/Search_s.png\";s:12:\"tmpl_created\";i:1579060722;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-search/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:227;s:16:\"popularity_index\";i:396;s:11:\"trend_index\";i:509;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:563;a:16:{s:4:\"tmpl\";i:944;s:2:\"id\";i:12688;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 1\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post2_s.png\";s:12:\"tmpl_created\";i:1579060692;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:228;s:16:\"popularity_index\";i:342;s:11:\"trend_index\";i:175;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:564;a:16:{s:4:\"tmpl\";i:943;s:2:\"id\";i:12699;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 2\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post3_s.png\";s:12:\"tmpl_created\";i:1579060680;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:229;s:16:\"popularity_index\";i:348;s:11:\"trend_index\";i:129;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:565;a:16:{s:4:\"tmpl\";i:942;s:2:\"id\";i:12707;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 3\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post1_s.png\";s:12:\"tmpl_created\";i:1579060669;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:230;s:16:\"popularity_index\";i:476;s:11:\"trend_index\";i:246;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:566;a:16:{s:4:\"tmpl\";i:941;s:2:\"id\";i:12716;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 3\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post4_s.png\";s:12:\"tmpl_created\";i:1579060659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/magazine-single-post-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:231;s:16:\"popularity_index\";i:513;s:11:\"trend_index\";i:489;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:567;a:16:{s:4:\"tmpl\";i:948;s:2:\"id\";i:12652;s:5:\"title\";s:17:\"Magazine- Archiv2\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/01/Archiv2_s.png\";s:12:\"tmpl_created\";i:1579060730;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/magazine-archiv2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:232;s:16:\"popularity_index\";i:525;s:11:\"trend_index\";i:585;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:568;a:16:{s:4:\"tmpl\";i:990;s:2:\"id\";i:13361;s:5:\"title\";s:25:\"Online Course &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/04/404.jpg\";s:12:\"tmpl_created\";i:1587474710;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/online-course-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:35:\"[\"404\",\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:233;s:16:\"popularity_index\";i:682;s:11:\"trend_index\";i:498;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:569;a:16:{s:4:\"tmpl\";i:987;s:2:\"id\";i:13387;s:5:\"title\";s:32:\"Online Course &#8211; End Lesson\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Lesson-End-.jpg\";s:12:\"tmpl_created\";i:1587474682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/online-course-end-lesson/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:234;s:16:\"popularity_index\";i:653;s:11:\"trend_index\";i:408;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:570;a:16:{s:4:\"tmpl\";i:989;s:2:\"id\";i:13369;s:5:\"title\";s:28:\"Online Course &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/04/Footer.jpg\";s:12:\"tmpl_created\";i:1587474701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/online-course-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:38:\"[\"Course Online\",\"Education\",\"Footer\"]\";s:10:\"menu_order\";i:235;s:16:\"popularity_index\";i:389;s:11:\"trend_index\";i:308;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:571;a:16:{s:4:\"tmpl\";i:988;s:2:\"id\";i:13378;s:5:\"title\";s:28:\"Online Course &#8211; Header\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-education-online-courses.jpg\";s:12:\"tmpl_created\";i:1587474693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/online-course-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:38:\"[\"Course Online\",\"Education\",\"Header\"]\";s:10:\"menu_order\";i:236;s:16:\"popularity_index\";i:492;s:11:\"trend_index\";i:519;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:572;a:16:{s:4:\"tmpl\";i:986;s:2:\"id\";i:13395;s:5:\"title\";s:34:\"Online Course &#8211; Start Lesson\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/04/Lesson-Start.jpg\";s:12:\"tmpl_created\";i:1587474673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/online-course-start-lesson/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:237;s:16:\"popularity_index\";i:672;s:11:\"trend_index\";i:578;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:573;a:16:{s:4:\"tmpl\";i:953;s:2:\"id\";i:13089;s:5:\"title\";s:23:\"Photography &#8211; 404\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/02/404_s.png\";s:12:\"tmpl_created\";i:1582091623;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/photography-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:33:\"[\"404\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:238;s:16:\"popularity_index\";i:702;s:11:\"trend_index\";i:706;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:574;a:16:{s:4:\"tmpl\";i:954;s:2:\"id\";i:13096;s:5:\"title\";s:32:\"Photography &#8211; Archiv Media\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Archiv_s.png\";s:12:\"tmpl_created\";i:1582091742;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/photography-archiv-media/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:239;s:16:\"popularity_index\";i:631;s:11:\"trend_index\";i:405;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:575;a:16:{s:4:\"tmpl\";i:955;s:2:\"id\";i:13103;s:5:\"title\";s:26:\"Photography &#8211; Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Footer_s.png\";s:12:\"tmpl_created\";i:1582091903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/photography-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:36:\"[\"Footer\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:240;s:16:\"popularity_index\";i:422;s:11:\"trend_index\";i:230;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:576;a:16:{s:4:\"tmpl\";i:957;s:2:\"id\";i:13112;s:5:\"title\";s:26:\"Photography &#8211; Header\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-photography-portfolio.png\";s:12:\"tmpl_created\";i:1582092483;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/photography-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:36:\"[\"Header\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:241;s:16:\"popularity_index\";i:325;s:11:\"trend_index\";i:205;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:577;a:16:{s:4:\"tmpl\";i:956;s:2:\"id\";i:13120;s:5:\"title\";s:31:\"Photography &#8211; Single Post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Post_s.png\";s:12:\"tmpl_created\";i:1582092351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/photography-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:242;s:16:\"popularity_index\";i:671;s:11:\"trend_index\";i:645;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:578;a:16:{s:4:\"tmpl\";i:901;s:2:\"id\";i:11807;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/09/404_small.png\";s:12:\"tmpl_created\";i:1569430070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:40:\"[\"404\",\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:243;s:16:\"popularity_index\";i:480;s:11:\"trend_index\";i:497;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:579;a:16:{s:4:\"tmpl\";i:900;s:2:\"id\";i:11832;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Footer_small.png\";s:12:\"tmpl_created\";i:1569430019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"Footer\",\"portfolio\"]\";s:10:\"menu_order\";i:244;s:16:\"popularity_index\";i:246;s:11:\"trend_index\";i:102;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:580;a:16:{s:4:\"tmpl\";i:898;s:2:\"id\";i:11847;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Archiv_small.png\";s:12:\"tmpl_created\";i:1569430010;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:245;s:16:\"popularity_index\";i:336;s:11:\"trend_index\";i:455;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:581;a:16:{s:4:\"tmpl\";i:897;s:2:\"id\";i:11854;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/09/Post_small.png\";s:12:\"tmpl_created\";i:1569429983;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/portfolio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:246;s:16:\"popularity_index\";i:482;s:11:\"trend_index\";i:609;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:582;a:16:{s:4:\"tmpl\";i:904;s:2:\"id\";i:11890;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-design-portfolio.png\";s:12:\"tmpl_created\";i:1571907344;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"Header\",\"portfolio\"]\";s:10:\"menu_order\";i:247;s:16:\"popularity_index\";i:306;s:11:\"trend_index\";i:364;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:583;a:16:{s:4:\"tmpl\";i:896;s:2:\"id\";i:11861;s:5:\"title\";s:27:\"Portfolio &#8211; Project 1\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project1_small.png\";s:12:\"tmpl_created\";i:1569429975;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:248;s:16:\"popularity_index\";i:643;s:11:\"trend_index\";i:764;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:584;a:16:{s:4:\"tmpl\";i:895;s:2:\"id\";i:11870;s:5:\"title\";s:27:\"Portfolio &#8211; Project 2\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png\";s:12:\"tmpl_created\";i:1569429964;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:249;s:16:\"popularity_index\";i:662;s:11:\"trend_index\";i:816;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:585;a:16:{s:4:\"tmpl\";i:903;s:2:\"id\";i:11897;s:5:\"title\";s:27:\"Portfolio &#8211; Project 2\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png\";s:12:\"tmpl_created\";i:1569494236;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-project-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:250;s:16:\"popularity_index\";i:733;s:11:\"trend_index\";i:744;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:586;a:16:{s:4:\"tmpl\";i:894;s:2:\"id\";i:11877;s:5:\"title\";s:27:\"Portfolio &#8211; Project 3\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project3_small.png\";s:12:\"tmpl_created\";i:1569429954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:251;s:16:\"popularity_index\";i:692;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:587;a:16:{s:4:\"tmpl\";i:597;s:2:\"id\";i:5019;s:5:\"title\";s:11:\"Portfolio 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_1.png\";s:12:\"tmpl_created\";i:1520520580;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:252;s:16:\"popularity_index\";i:170;s:11:\"trend_index\";i:236;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:588;a:16:{s:4:\"tmpl\";i:609;s:2:\"id\";i:5141;s:5:\"title\";s:12:\"Portfolio 10\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_10.png\";s:12:\"tmpl_created\";i:1520520601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:253;s:16:\"popularity_index\";i:416;s:11:\"trend_index\";i:478;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:589;a:16:{s:4:\"tmpl\";i:598;s:2:\"id\";i:5027;s:5:\"title\";s:12:\"Portfolio 11\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_2.png\";s:12:\"tmpl_created\";i:1520520581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:254;s:16:\"popularity_index\";i:304;s:11:\"trend_index\";i:421;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:590;a:16:{s:4:\"tmpl\";i:599;s:2:\"id\";i:5037;s:5:\"title\";s:12:\"Portfolio 12\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_3.png\";s:12:\"tmpl_created\";i:1520520583;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:255;s:16:\"popularity_index\";i:279;s:11:\"trend_index\";i:399;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:591;a:16:{s:4:\"tmpl\";i:600;s:2:\"id\";i:5057;s:5:\"title\";s:12:\"Portfolio 13\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_4.png\";s:12:\"tmpl_created\";i:1520520586;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:256;s:16:\"popularity_index\";i:239;s:11:\"trend_index\";i:288;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:592;a:16:{s:4:\"tmpl\";i:601;s:2:\"id\";i:5071;s:5:\"title\";s:12:\"Portfolio 14\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_5.png\";s:12:\"tmpl_created\";i:1520520588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:257;s:16:\"popularity_index\";i:276;s:11:\"trend_index\";i:329;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:593;a:16:{s:4:\"tmpl\";i:603;s:2:\"id\";i:5090;s:5:\"title\";s:12:\"Portfolio 15\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_6.png\";s:12:\"tmpl_created\";i:1520520591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:258;s:16:\"popularity_index\";i:186;s:11:\"trend_index\";i:283;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:594;a:16:{s:4:\"tmpl\";i:604;s:2:\"id\";i:5098;s:5:\"title\";s:12:\"Portfolio 16\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_7.png\";s:12:\"tmpl_created\";i:1520520593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:259;s:16:\"popularity_index\";i:156;s:11:\"trend_index\";i:211;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:595;a:16:{s:4:\"tmpl\";i:606;s:2:\"id\";i:5115;s:5:\"title\";s:12:\"Portfolio 17\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_8.png\";s:12:\"tmpl_created\";i:1520520596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:260;s:16:\"popularity_index\";i:19;s:11:\"trend_index\";i:22;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:596;a:16:{s:4:\"tmpl\";i:608;s:2:\"id\";i:5133;s:5:\"title\";s:12:\"Portfolio 18\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_9.png\";s:12:\"tmpl_created\";i:1520520599;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:261;s:16:\"popularity_index\";i:180;s:11:\"trend_index\";i:280;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:597;a:16:{s:4:\"tmpl\";i:610;s:2:\"id\";i:5149;s:5:\"title\";s:11:\"Portfolio 2\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_10.png\";s:12:\"tmpl_created\";i:1520520602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:262;s:16:\"popularity_index\";i:413;s:11:\"trend_index\";i:635;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:598;a:16:{s:4:\"tmpl\";i:468;s:2:\"id\";i:5045;s:5:\"title\";s:11:\"Portfolio 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_2.png\";s:12:\"tmpl_created\";i:1520443423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:263;s:16:\"popularity_index\";i:636;s:11:\"trend_index\";i:608;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:599;a:16:{s:4:\"tmpl\";i:602;s:2:\"id\";i:5082;s:5:\"title\";s:11:\"Portfolio 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_4.png\";s:12:\"tmpl_created\";i:1520520589;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:264;s:16:\"popularity_index\";i:558;s:11:\"trend_index\";i:654;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:600;a:16:{s:4:\"tmpl\";i:605;s:2:\"id\";i:5107;s:5:\"title\";s:11:\"Portfolio 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_7.png\";s:12:\"tmpl_created\";i:1520520594;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:265;s:16:\"popularity_index\";i:380;s:11:\"trend_index\";i:347;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:601;a:16:{s:4:\"tmpl\";i:607;s:2:\"id\";i:5125;s:5:\"title\";s:11:\"Portfolio 6\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_8.png\";s:12:\"tmpl_created\";i:1520520597;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:266;s:16:\"popularity_index\";i:236;s:11:\"trend_index\";i:386;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:602;a:16:{s:4:\"tmpl\";i:596;s:2:\"id\";i:5007;s:5:\"title\";s:11:\"Portfolio 7\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_1.png\";s:12:\"tmpl_created\";i:1520520578;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:267;s:16:\"popularity_index\";i:44;s:11:\"trend_index\";i:183;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:603;a:16:{s:4:\"tmpl\";i:434;s:2:\"id\";i:4509;s:5:\"title\";s:9:\"Pricing 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_1.png\";s:12:\"tmpl_created\";i:1520443310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:268;s:16:\"popularity_index\";i:703;s:11:\"trend_index\";i:641;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:604;a:16:{s:4:\"tmpl\";i:439;s:2:\"id\";i:4553;s:5:\"title\";s:10:\"Pricing 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_4.png\";s:12:\"tmpl_created\";i:1520443319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:269;s:16:\"popularity_index\";i:511;s:11:\"trend_index\";i:506;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:605;a:16:{s:4:\"tmpl\";i:441;s:2:\"id\";i:4572;s:5:\"title\";s:10:\"Pricing 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_5.png\";s:12:\"tmpl_created\";i:1520443324;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:270;s:16:\"popularity_index\";i:308;s:11:\"trend_index\";i:248;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:606;a:16:{s:4:\"tmpl\";i:442;s:2:\"id\";i:4580;s:5:\"title\";s:10:\"Pricing 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_6.png\";s:12:\"tmpl_created\";i:1520443326;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:271;s:16:\"popularity_index\";i:576;s:11:\"trend_index\";i:526;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:607;a:16:{s:4:\"tmpl\";i:444;s:2:\"id\";i:4597;s:5:\"title\";s:10:\"Pricing 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_7.png\";s:12:\"tmpl_created\";i:1520443330;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:272;s:16:\"popularity_index\";i:613;s:11:\"trend_index\";i:450;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:608;a:16:{s:4:\"tmpl\";i:446;s:2:\"id\";i:4613;s:5:\"title\";s:10:\"Pricing 14\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_8.png\";s:12:\"tmpl_created\";i:1520443334;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:273;s:16:\"popularity_index\";i:581;s:11:\"trend_index\";i:568;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:609;a:16:{s:4:\"tmpl\";i:436;s:2:\"id\";i:4529;s:5:\"title\";s:9:\"Pricing 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_2.png\";s:12:\"tmpl_created\";i:1520443314;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:274;s:16:\"popularity_index\";i:609;s:11:\"trend_index\";i:613;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:610;a:16:{s:4:\"tmpl\";i:438;s:2:\"id\";i:4545;s:5:\"title\";s:9:\"Pricing 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_3.png\";s:12:\"tmpl_created\";i:1520443317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:275;s:16:\"popularity_index\";i:707;s:11:\"trend_index\";i:825;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:611;a:16:{s:4:\"tmpl\";i:440;s:2:\"id\";i:4562;s:5:\"title\";s:9:\"Pricing 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_4.png\";s:12:\"tmpl_created\";i:1520443322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:276;s:16:\"popularity_index\";i:697;s:11:\"trend_index\";i:821;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:612;a:16:{s:4:\"tmpl\";i:443;s:2:\"id\";i:4589;s:5:\"title\";s:9:\"Pricing 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_6.png\";s:12:\"tmpl_created\";i:1520443327;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:277;s:16:\"popularity_index\";i:716;s:11:\"trend_index\";i:639;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:613;a:16:{s:4:\"tmpl\";i:445;s:2:\"id\";i:4605;s:5:\"title\";s:9:\"Pricing 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_7.png\";s:12:\"tmpl_created\";i:1520443332;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:278;s:16:\"popularity_index\";i:738;s:11:\"trend_index\";i:773;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:614;a:16:{s:4:\"tmpl\";i:433;s:2:\"id\";i:4500;s:5:\"title\";s:9:\"Pricing 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_1.png\";s:12:\"tmpl_created\";i:1520443308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:279;s:16:\"popularity_index\";i:500;s:11:\"trend_index\";i:451;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:615;a:16:{s:4:\"tmpl\";i:435;s:2:\"id\";i:4521;s:5:\"title\";s:9:\"Pricing 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_2.png\";s:12:\"tmpl_created\";i:1520443312;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:280;s:16:\"popularity_index\";i:311;s:11:\"trend_index\";i:372;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:616;a:16:{s:4:\"tmpl\";i:437;s:2:\"id\";i:4537;s:5:\"title\";s:9:\"Pricing 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_3.png\";s:12:\"tmpl_created\";i:1520443315;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:281;s:16:\"popularity_index\";i:589;s:11:\"trend_index\";i:841;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:617;a:16:{s:4:\"tmpl\";i:701;s:2:\"id\";i:9239;s:5:\"title\";s:17:\"product archive 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-1.png\";s:12:\"tmpl_created\";i:1532953482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:282;s:16:\"popularity_index\";i:60;s:11:\"trend_index\";i:25;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:618;a:16:{s:4:\"tmpl\";i:702;s:2:\"id\";i:9247;s:5:\"title\";s:17:\"product archive 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-2.png\";s:12:\"tmpl_created\";i:1532953793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:283;s:16:\"popularity_index\";i:71;s:11:\"trend_index\";i:30;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:619;a:16:{s:4:\"tmpl\";i:703;s:2:\"id\";i:9254;s:5:\"title\";s:17:\"product archive 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-3.png\";s:12:\"tmpl_created\";i:1532954032;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:284;s:16:\"popularity_index\";i:73;s:11:\"trend_index\";i:44;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:620;a:16:{s:4:\"tmpl\";i:1046;s:2:\"id\";i:15204;s:5:\"title\";s:24:\"Psychologist &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/09/404.jpg\";s:12:\"tmpl_created\";i:1600161419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/psychologist-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:40:\"[\"404\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:285;s:16:\"popularity_index\";i:574;s:11:\"trend_index\";i:493;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:621;a:16:{s:4:\"tmpl\";i:1047;s:2:\"id\";i:15212;s:5:\"title\";s:28:\"Psychologist &#8211; Archive\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/09/Blog.jpg\";s:12:\"tmpl_created\";i:1600162340;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/psychologist-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:286;s:16:\"popularity_index\";i:379;s:11:\"trend_index\";i:358;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:622;a:16:{s:4:\"tmpl\";i:1048;s:2:\"id\";i:15219;s:5:\"title\";s:27:\"Psychologist &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/09/Footer.jpg\";s:12:\"tmpl_created\";i:1600163069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/psychologist-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:43:\"[\"Footer\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:287;s:16:\"popularity_index\";i:599;s:11:\"trend_index\";i:500;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:623;a:16:{s:4:\"tmpl\";i:1049;s:2:\"id\";i:15230;s:5:\"title\";s:27:\"Psychologist &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/09/Header.png\";s:12:\"tmpl_created\";i:1600163444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/psychologist-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"Header\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:288;s:16:\"popularity_index\";i:429;s:11:\"trend_index\";i:423;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:624;a:16:{s:4:\"tmpl\";i:1050;s:2:\"id\";i:15240;s:5:\"title\";s:34:\"Psychologist &#8211; single post 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/09/Single-Post.png\";s:12:\"tmpl_created\";i:1600164087;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/psychologist-single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:289;s:16:\"popularity_index\";i:562;s:11:\"trend_index\";i:570;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:625;a:16:{s:4:\"tmpl\";i:1051;s:2:\"id\";i:15251;s:5:\"title\";s:34:\"Psychologist &#8211; single post 2\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2020/09/Single-Service-Page.png\";s:12:\"tmpl_created\";i:1600165179;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/psychologist-single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:290;s:16:\"popularity_index\";i:507;s:11:\"trend_index\";i:368;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:626;a:16:{s:4:\"tmpl\";i:412;s:2:\"id\";i:4313;s:5:\"title\";s:11:\"Services 13\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_8.png\";s:12:\"tmpl_created\";i:1520443268;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:291;s:16:\"popularity_index\";i:115;s:11:\"trend_index\";i:53;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:627;a:16:{s:4:\"tmpl\";i:413;s:2:\"id\";i:4324;s:5:\"title\";s:11:\"Services 14\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_9.png\";s:12:\"tmpl_created\";i:1520443270;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:292;s:16:\"popularity_index\";i:277;s:11:\"trend_index\";i:138;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:628;a:16:{s:4:\"tmpl\";i:418;s:2:\"id\";i:4368;s:5:\"title\";s:11:\"Services 16\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_13.png\";s:12:\"tmpl_created\";i:1520443279;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:293;s:16:\"popularity_index\";i:62;s:11:\"trend_index\";i:59;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:629;a:16:{s:4:\"tmpl\";i:420;s:2:\"id\";i:4391;s:5:\"title\";s:11:\"Services 17\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_14.png\";s:12:\"tmpl_created\";i:1520443283;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:294;s:16:\"popularity_index\";i:153;s:11:\"trend_index\";i:120;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:630;a:16:{s:4:\"tmpl\";i:403;s:2:\"id\";i:4235;s:5:\"title\";s:11:\"Services 18\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_2.png\";s:12:\"tmpl_created\";i:1520443251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:295;s:16:\"popularity_index\";i:273;s:11:\"trend_index\";i:172;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:631;a:16:{s:4:\"tmpl\";i:417;s:2:\"id\";i:4357;s:5:\"title\";s:11:\"Services 20\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_12.png\";s:12:\"tmpl_created\";i:1520443277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:296;s:16:\"popularity_index\";i:45;s:11:\"trend_index\";i:45;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:632;a:16:{s:4:\"tmpl\";i:415;s:2:\"id\";i:4341;s:5:\"title\";s:11:\"Services 21\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_11.png\";s:12:\"tmpl_created\";i:1520443274;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:297;s:16:\"popularity_index\";i:142;s:11:\"trend_index\";i:114;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:633;a:16:{s:4:\"tmpl\";i:414;s:2:\"id\";i:4332;s:5:\"title\";s:11:\"Services 22\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_10.png\";s:12:\"tmpl_created\";i:1520443272;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:298;s:16:\"popularity_index\";i:138;s:11:\"trend_index\";i:149;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:634;a:16:{s:4:\"tmpl\";i:401;s:2:\"id\";i:4212;s:5:\"title\";s:11:\"Services 23\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_1.png\";s:12:\"tmpl_created\";i:1520443248;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:299;s:16:\"popularity_index\";i:136;s:11:\"trend_index\";i:302;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:635;a:16:{s:4:\"tmpl\";i:408;s:2:\"id\";i:4276;s:5:\"title\";s:11:\"Services 24\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_4.png\";s:12:\"tmpl_created\";i:1520443261;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:300;s:16:\"popularity_index\";i:353;s:11:\"trend_index\";i:514;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:636;a:16:{s:4:\"tmpl\";i:406;s:2:\"id\";i:4260;s:5:\"title\";s:11:\"Services 25\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_3.png\";s:12:\"tmpl_created\";i:1520443257;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-25/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:301;s:16:\"popularity_index\";i:184;s:11:\"trend_index\";i:209;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:637;a:16:{s:4:\"tmpl\";i:404;s:2:\"id\";i:4244;s:5:\"title\";s:11:\"Services 26\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_2.png\";s:12:\"tmpl_created\";i:1520443253;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:302;s:16:\"popularity_index\";i:544;s:11:\"trend_index\";i:596;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:638;a:16:{s:4:\"tmpl\";i:421;s:2:\"id\";i:4400;s:5:\"title\";s:11:\"Services 27\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_13.png\";s:12:\"tmpl_created\";i:1520443285;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:303;s:16:\"popularity_index\";i:286;s:11:\"trend_index\";i:438;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:639;a:16:{s:4:\"tmpl\";i:419;s:2:\"id\";i:4376;s:5:\"title\";s:11:\"Services 28\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_12.png\";s:12:\"tmpl_created\";i:1520443281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-28/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:304;s:16:\"popularity_index\";i:151;s:11:\"trend_index\";i:249;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:640;a:16:{s:4:\"tmpl\";i:416;s:2:\"id\";i:4349;s:5:\"title\";s:11:\"Services 29\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_11.png\";s:12:\"tmpl_created\";i:1520443275;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:305;s:16:\"popularity_index\";i:330;s:11:\"trend_index\";i:483;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:641;a:16:{s:4:\"tmpl\";i:402;s:2:\"id\";i:4227;s:5:\"title\";s:11:\"Services 30\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_1.png\";s:12:\"tmpl_created\";i:1520443250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-30/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:306;s:16:\"popularity_index\";i:351;s:11:\"trend_index\";i:553;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:642;a:16:{s:4:\"tmpl\";i:560;s:2:\"id\";i:6162;s:5:\"title\";s:11:\"Services 31\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_1.png\";s:12:\"tmpl_created\";i:1520443668;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-31/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:307;s:16:\"popularity_index\";i:372;s:11:\"trend_index\";i:550;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:643;a:16:{s:4:\"tmpl\";i:411;s:2:\"id\";i:4302;s:5:\"title\";s:10:\"Services 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_7.png\";s:12:\"tmpl_created\";i:1520443266;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:308;s:16:\"popularity_index\";i:58;s:11:\"trend_index\";i:97;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:644;a:16:{s:4:\"tmpl\";i:410;s:2:\"id\";i:4293;s:5:\"title\";s:10:\"Services 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_6.png\";s:12:\"tmpl_created\";i:1520443265;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:309;s:16:\"popularity_index\";i:288;s:11:\"trend_index\";i:269;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:645;a:16:{s:4:\"tmpl\";i:409;s:2:\"id\";i:4284;s:5:\"title\";s:10:\"Services 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_5.png\";s:12:\"tmpl_created\";i:1520443263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:310;s:16:\"popularity_index\";i:27;s:11:\"trend_index\";i:21;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:646;a:16:{s:4:\"tmpl\";i:407;s:2:\"id\";i:4268;s:5:\"title\";s:10:\"Services 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_4.png\";s:12:\"tmpl_created\";i:1520443259;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:311;s:16:\"popularity_index\";i:173;s:11:\"trend_index\";i:213;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:647;a:16:{s:4:\"tmpl\";i:405;s:2:\"id\";i:4252;s:5:\"title\";s:10:\"Services 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_3.png\";s:12:\"tmpl_created\";i:1520443255;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:312;s:16:\"popularity_index\";i:46;s:11:\"trend_index\";i:99;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:648;a:16:{s:4:\"tmpl\";i:677;s:2:\"id\";i:8676;s:5:\"title\";s:13:\"single page 1\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.6.jpg\";s:12:\"tmpl_created\";i:1527682423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:313;s:16:\"popularity_index\";i:285;s:11:\"trend_index\";i:145;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:649;a:16:{s:4:\"tmpl\";i:678;s:2:\"id\";i:8678;s:5:\"title\";s:13:\"single page 2\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.2.jpg\";s:12:\"tmpl_created\";i:1527682780;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:314;s:16:\"popularity_index\";i:140;s:11:\"trend_index\";i:82;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:650;a:16:{s:4:\"tmpl\";i:679;s:2:\"id\";i:8679;s:5:\"title\";s:13:\"single page 3\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.3.jpg\";s:12:\"tmpl_created\";i:1527682847;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:315;s:16:\"popularity_index\";i:122;s:11:\"trend_index\";i:23;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:651;a:16:{s:4:\"tmpl\";i:680;s:2:\"id\";i:8680;s:5:\"title\";s:13:\"single page 4\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.1.jpg\";s:12:\"tmpl_created\";i:1527682896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:316;s:16:\"popularity_index\";i:373;s:11:\"trend_index\";i:190;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:652;a:16:{s:4:\"tmpl\";i:681;s:2:\"id\";i:8681;s:5:\"title\";s:13:\"single page 5\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.5.jpg\";s:12:\"tmpl_created\";i:1527682969;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:317;s:16:\"popularity_index\";i:287;s:11:\"trend_index\";i:218;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:653;a:16:{s:4:\"tmpl\";i:682;s:2:\"id\";i:8682;s:5:\"title\";s:13:\"single page 6\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.4.jpg\";s:12:\"tmpl_created\";i:1527683026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:318;s:16:\"popularity_index\";i:412;s:11:\"trend_index\";i:227;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:654;a:16:{s:4:\"tmpl\";i:683;s:2:\"id\";i:8703;s:5:\"title\";s:13:\"single page 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.7.jpg\";s:12:\"tmpl_created\";i:1527683072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:319;s:16:\"popularity_index\";i:401;s:11:\"trend_index\";i:316;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:655;a:16:{s:4:\"tmpl\";i:640;s:2:\"id\";i:7650;s:5:\"title\";s:13:\"Single Post 1\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/single_post_1_v2.jpg\";s:12:\"tmpl_created\";i:1521557736;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:24:\"[\"Blog\",\"Post\",\"Single\"]\";s:10:\"menu_order\";i:320;s:16:\"popularity_index\";i:119;s:11:\"trend_index\";i:266;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:656;a:16:{s:4:\"tmpl\";i:639;s:2:\"id\";i:7663;s:5:\"title\";s:13:\"Single Post 2\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/single_post_2_v2.jpg\";s:12:\"tmpl_created\";i:1521547761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:24:\"[\"Blog\",\"Post\",\"Single\"]\";s:10:\"menu_order\";i:321;s:16:\"popularity_index\";i:50;s:11:\"trend_index\";i:139;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:657;a:16:{s:4:\"tmpl\";i:705;s:2:\"id\";i:9296;s:5:\"title\";s:13:\"Single Post 3\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3002.jpg\";s:12:\"tmpl_created\";i:1537440673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:322;s:16:\"popularity_index\";i:213;s:11:\"trend_index\";i:204;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:658;a:16:{s:4:\"tmpl\";i:704;s:2:\"id\";i:9301;s:5:\"title\";s:13:\"Single Post 4\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3003.jpg\";s:12:\"tmpl_created\";i:1537440661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:323;s:16:\"popularity_index\";i:248;s:11:\"trend_index\";i:336;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:659;a:16:{s:4:\"tmpl\";i:706;s:2:\"id\";i:9313;s:5:\"title\";s:13:\"Single Post 5\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3001.jpg\";s:12:\"tmpl_created\";i:1537440798;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:324;s:16:\"popularity_index\";i:197;s:11:\"trend_index\";i:177;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:660;a:16:{s:4:\"tmpl\";i:707;s:2:\"id\";i:9343;s:5:\"title\";s:13:\"Single Post 6\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3004.jpg\";s:12:\"tmpl_created\";i:1537443531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:325;s:16:\"popularity_index\";i:228;s:11:\"trend_index\";i:279;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:661;a:16:{s:4:\"tmpl\";i:708;s:2:\"id\";i:9349;s:5:\"title\";s:13:\"Single Post 7\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3005.jpg\";s:12:\"tmpl_created\";i:1537443903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:326;s:16:\"popularity_index\";i:158;s:11:\"trend_index\";i:253;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:662;a:16:{s:4:\"tmpl\";i:697;s:2:\"id\";i:9174;s:5:\"title\";s:17:\"single product 01\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product01_350.png\";s:12:\"tmpl_created\";i:1532950125;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:327;s:16:\"popularity_index\";i:31;s:11:\"trend_index\";i:6;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:663;a:16:{s:4:\"tmpl\";i:698;s:2:\"id\";i:9178;s:5:\"title\";s:17:\"single product 02\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product02_350new.png\";s:12:\"tmpl_created\";i:1532951997;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:328;s:16:\"popularity_index\";i:66;s:11:\"trend_index\";i:42;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:664;a:16:{s:4:\"tmpl\";i:699;s:2:\"id\";i:9180;s:5:\"title\";s:17:\"single product 03\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product03_350.png\";s:12:\"tmpl_created\";i:1532952302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:329;s:16:\"popularity_index\";i:108;s:11:\"trend_index\";i:66;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:665;a:16:{s:4:\"tmpl\";i:700;s:2:\"id\";i:9182;s:5:\"title\";s:17:\"single product 04\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product040_350.png\";s:12:\"tmpl_created\";i:1532952606;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:330;s:16:\"popularity_index\";i:123;s:11:\"trend_index\";i:81;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:666;a:16:{s:4:\"tmpl\";i:555;s:2:\"id\";i:6114;s:5:\"title\";s:7:\"Stats 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_6.png\";s:12:\"tmpl_created\";i:1520443659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:331;s:16:\"popularity_index\";i:434;s:11:\"trend_index\";i:692;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:667;a:16:{s:4:\"tmpl\";i:562;s:2:\"id\";i:6178;s:5:\"title\";s:8:\"Stats 10\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_2.png\";s:12:\"tmpl_created\";i:1520443676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:332;s:16:\"popularity_index\";i:435;s:11:\"trend_index\";i:755;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:668;a:16:{s:4:\"tmpl\";i:561;s:2:\"id\";i:6170;s:5:\"title\";s:8:\"Stats 11\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_2.png\";s:12:\"tmpl_created\";i:1520443670;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:333;s:16:\"popularity_index\";i:366;s:11:\"trend_index\";i:552;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:669;a:16:{s:4:\"tmpl\";i:563;s:2:\"id\";i:6186;s:5:\"title\";s:8:\"Stats 12\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_3.png\";s:12:\"tmpl_created\";i:1520443678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:334;s:16:\"popularity_index\";i:569;s:11:\"trend_index\";i:811;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:670;a:16:{s:4:\"tmpl\";i:550;s:2:\"id\";i:6071;s:5:\"title\";s:8:\"Stats 13\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_3.png\";s:12:\"tmpl_created\";i:1520443649;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:335;s:16:\"popularity_index\";i:168;s:11:\"trend_index\";i:328;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:671;a:16:{s:4:\"tmpl\";i:554;s:2:\"id\";i:6106;s:5:\"title\";s:7:\"Stats 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_6.png\";s:12:\"tmpl_created\";i:1520443657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:336;s:16:\"popularity_index\";i:361;s:11:\"trend_index\";i:784;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:672;a:16:{s:4:\"tmpl\";i:551;s:2:\"id\";i:6079;s:5:\"title\";s:7:\"Stats 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_4.png\";s:12:\"tmpl_created\";i:1520443651;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:337;s:16:\"popularity_index\";i:284;s:11:\"trend_index\";i:385;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:673;a:16:{s:4:\"tmpl\";i:552;s:2:\"id\";i:6089;s:5:\"title\";s:7:\"Stats 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_5.png\";s:12:\"tmpl_created\";i:1520443653;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:338;s:16:\"popularity_index\";i:205;s:11:\"trend_index\";i:452;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:674;a:16:{s:4:\"tmpl\";i:549;s:2:\"id\";i:6063;s:5:\"title\";s:7:\"Stats 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_2.png\";s:12:\"tmpl_created\";i:1520443647;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:339;s:16:\"popularity_index\";i:181;s:11:\"trend_index\";i:419;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:675;a:16:{s:4:\"tmpl\";i:553;s:2:\"id\";i:6097;s:5:\"title\";s:7:\"Stats 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_2.png\";s:12:\"tmpl_created\";i:1520443655;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:340;s:16:\"popularity_index\";i:264;s:11:\"trend_index\";i:492;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:676;a:16:{s:4:\"tmpl\";i:538;s:2:\"id\";i:5956;s:5:\"title\";s:7:\"Stats 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_1.png\";s:12:\"tmpl_created\";i:1520443623;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:341;s:16:\"popularity_index\";i:532;s:11:\"trend_index\";i:541;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:677;a:16:{s:4:\"tmpl\";i:537;s:2:\"id\";i:5947;s:5:\"title\";s:7:\"Stats 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_1.png\";s:12:\"tmpl_created\";i:1520443621;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:342;s:16:\"popularity_index\";i:368;s:11:\"trend_index\";i:531;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:678;a:16:{s:4:\"tmpl\";i:559;s:2:\"id\";i:6152;s:5:\"title\";s:7:\"Stats 9\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_1.png\";s:12:\"tmpl_created\";i:1520443666;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:343;s:16:\"popularity_index\";i:272;s:11:\"trend_index\";i:557;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:679;a:16:{s:4:\"tmpl\";i:469;s:2:\"id\";i:5157;s:5:\"title\";s:11:\"Subscribe 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_1.png\";s:12:\"tmpl_created\";i:1520443448;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:344;s:16:\"popularity_index\";i:340;s:11:\"trend_index\";i:293;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:680;a:16:{s:4:\"tmpl\";i:472;s:2:\"id\";i:5181;s:5:\"title\";s:11:\"Subscribe 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_2.png\";s:12:\"tmpl_created\";i:1520443454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/subscribe-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:345;s:16:\"popularity_index\";i:451;s:11:\"trend_index\";i:340;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:681;a:16:{s:4:\"tmpl\";i:470;s:2:\"id\";i:5165;s:5:\"title\";s:11:\"Subscribe 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_1.png\";s:12:\"tmpl_created\";i:1520443450;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:346;s:16:\"popularity_index\";i:520;s:11:\"trend_index\";i:620;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:682;a:16:{s:4:\"tmpl\";i:477;s:2:\"id\";i:5222;s:5:\"title\";s:11:\"Subscribe 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_3.png\";s:12:\"tmpl_created\";i:1520443464;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:347;s:16:\"popularity_index\";i:397;s:11:\"trend_index\";i:427;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:683;a:16:{s:4:\"tmpl\";i:471;s:2:\"id\";i:5173;s:5:\"title\";s:11:\"Subscribe 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_2.png\";s:12:\"tmpl_created\";i:1520443452;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:348;s:16:\"popularity_index\";i:261;s:11:\"trend_index\";i:237;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:684;a:16:{s:4:\"tmpl\";i:465;s:2:\"id\";i:4801;s:5:\"title\";s:7:\"Team 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_8.png\";s:12:\"tmpl_created\";i:1520443369;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:349;s:16:\"popularity_index\";i:332;s:11:\"trend_index\";i:188;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:685;a:16:{s:4:\"tmpl\";i:462;s:2:\"id\";i:4770;s:5:\"title\";s:7:\"Team 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_6.png\";s:12:\"tmpl_created\";i:1520443364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/team-12-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:350;s:16:\"popularity_index\";i:432;s:11:\"trend_index\";i:488;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:686;a:16:{s:4:\"tmpl\";i:458;s:2:\"id\";i:4727;s:5:\"title\";s:7:\"Team 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_2.png\";s:12:\"tmpl_created\";i:1520443356;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:351;s:16:\"popularity_index\";i:375;s:11:\"trend_index\";i:345;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:687;a:16:{s:4:\"tmpl\";i:543;s:2:\"id\";i:5999;s:5:\"title\";s:7:\"Team 14\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_10.png\";s:12:\"tmpl_created\";i:1520443634;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:352;s:16:\"popularity_index\";i:110;s:11:\"trend_index\";i:318;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:688;a:16:{s:4:\"tmpl\";i:455;s:2:\"id\";i:4698;s:5:\"title\";s:7:\"Team 15\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_1.png\";s:12:\"tmpl_created\";i:1520443350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:353;s:16:\"popularity_index\";i:449;s:11:\"trend_index\";i:410;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:689;a:16:{s:4:\"tmpl\";i:463;s:2:\"id\";i:4781;s:5:\"title\";s:7:\"Team 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_7.png\";s:12:\"tmpl_created\";i:1520443365;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:354;s:16:\"popularity_index\";i:267;s:11:\"trend_index\";i:330;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:690;a:16:{s:4:\"tmpl\";i:558;s:2:\"id\";i:6144;s:5:\"title\";s:7:\"Team 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_11.png\";s:12:\"tmpl_created\";i:1520443664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:355;s:16:\"popularity_index\";i:166;s:11:\"trend_index\";i:365;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:691;a:16:{s:4:\"tmpl\";i:464;s:2:\"id\";i:4793;s:5:\"title\";s:7:\"Team 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_8.png\";s:12:\"tmpl_created\";i:1520443367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:356;s:16:\"popularity_index\";i:207;s:11:\"trend_index\";i:173;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:692;a:16:{s:4:\"tmpl\";i:466;s:2:\"id\";i:4809;s:5:\"title\";s:7:\"Team 19\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_9.png\";s:12:\"tmpl_created\";i:1520443371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:357;s:16:\"popularity_index\";i:300;s:11:\"trend_index\";i:465;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:693;a:16:{s:4:\"tmpl\";i:459;s:2:\"id\";i:4736;s:5:\"title\";s:7:\"Team 20\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_4.png\";s:12:\"tmpl_created\";i:1520443358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:358;s:16:\"popularity_index\";i:144;s:11:\"trend_index\";i:159;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:694;a:16:{s:4:\"tmpl\";i:467;s:2:\"id\";i:4818;s:5:\"title\";s:7:\"Team 21\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_9.png\";s:12:\"tmpl_created\";i:1520443373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:359;s:16:\"popularity_index\";i:515;s:11:\"trend_index\";i:606;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:695;a:16:{s:4:\"tmpl\";i:461;s:2:\"id\";i:4759;s:5:\"title\";s:7:\"Team 22\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_5.png\";s:12:\"tmpl_created\";i:1520443362;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:360;s:16:\"popularity_index\";i:299;s:11:\"trend_index\";i:376;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:696;a:16:{s:4:\"tmpl\";i:460;s:2:\"id\";i:4746;s:5:\"title\";s:7:\"Team 23\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_4.png\";s:12:\"tmpl_created\";i:1520443360;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:361;s:16:\"popularity_index\";i:282;s:11:\"trend_index\";i:378;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:697;a:16:{s:4:\"tmpl\";i:457;s:2:\"id\";i:4718;s:5:\"title\";s:6:\"Team 4\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_3.png\";s:12:\"tmpl_created\";i:1520443354;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:362;s:16:\"popularity_index\";i:192;s:11:\"trend_index\";i:359;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:698;a:16:{s:4:\"tmpl\";i:456;s:2:\"id\";i:4706;s:5:\"title\";s:6:\"Team 5\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_2.png\";s:12:\"tmpl_created\";i:1520443352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:363;s:16:\"popularity_index\";i:149;s:11:\"trend_index\";i:299;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:699;a:16:{s:4:\"tmpl\";i:544;s:2:\"id\";i:6008;s:5:\"title\";s:6:\"Team 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_10.png\";s:12:\"tmpl_created\";i:1520443636;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:364;s:16:\"popularity_index\";i:75;s:11:\"trend_index\";i:277;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:700;a:16:{s:4:\"tmpl\";i:454;s:2:\"id\";i:4690;s:5:\"title\";s:6:\"Team 7\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_1.png\";s:12:\"tmpl_created\";i:1520443348;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:365;s:16:\"popularity_index\";i:243;s:11:\"trend_index\";i:402;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:701;a:16:{s:4:\"tmpl\";i:586;s:2:\"id\";i:4921;s:5:\"title\";s:14:\"Testimonial 10\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_5.png\";s:12:\"tmpl_created\";i:1520520562;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:366;s:16:\"popularity_index\";i:219;s:11:\"trend_index\";i:198;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:702;a:16:{s:4:\"tmpl\";i:582;s:2:\"id\";i:4889;s:5:\"title\";s:14:\"Testimonial 11\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/customers-2.jpg\";s:12:\"tmpl_created\";i:1520520556;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:367;s:16:\"popularity_index\";i:557;s:11:\"trend_index\";i:522;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:703;a:16:{s:4:\"tmpl\";i:580;s:2:\"id\";i:4871;s:5:\"title\";s:14:\"Testimonial 12\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_3.png\";s:12:\"tmpl_created\";i:1520520552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:368;s:16:\"popularity_index\";i:262;s:11:\"trend_index\";i:391;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:704;a:16:{s:4:\"tmpl\";i:578;s:2:\"id\";i:4854;s:5:\"title\";s:14:\"Testimonial 13\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_2.png\";s:12:\"tmpl_created\";i:1520520549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:369;s:16:\"popularity_index\";i:637;s:11:\"trend_index\";i:741;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:705;a:16:{s:4:\"tmpl\";i:595;s:2:\"id\";i:4995;s:5:\"title\";s:14:\"Testimonial 14\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_12.png\";s:12:\"tmpl_created\";i:1520520577;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:370;s:16:\"popularity_index\";i:400;s:11:\"trend_index\";i:411;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:706;a:16:{s:4:\"tmpl\";i:593;s:2:\"id\";i:4979;s:5:\"title\";s:14:\"Testimonial 15\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_10.png\";s:12:\"tmpl_created\";i:1520520573;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:371;s:16:\"popularity_index\";i:568;s:11:\"trend_index\";i:544;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:707;a:16:{s:4:\"tmpl\";i:576;s:2:\"id\";i:4835;s:5:\"title\";s:14:\"Testimonial 16\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_1.png\";s:12:\"tmpl_created\";i:1520520546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:372;s:16:\"popularity_index\";i:399;s:11:\"trend_index\";i:401;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:708;a:16:{s:4:\"tmpl\";i:594;s:2:\"id\";i:4987;s:5:\"title\";s:14:\"Testimonial 17\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_12-1.png\";s:12:\"tmpl_created\";i:1520520575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:373;s:16:\"popularity_index\";i:159;s:11:\"trend_index\";i:199;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:709;a:16:{s:4:\"tmpl\";i:577;s:2:\"id\";i:4843;s:5:\"title\";s:14:\"Testimonial 18\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_2.png\";s:12:\"tmpl_created\";i:1520520548;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:374;s:16:\"popularity_index\";i:457;s:11:\"trend_index\";i:780;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:710;a:16:{s:4:\"tmpl\";i:579;s:2:\"id\";i:4863;s:5:\"title\";s:14:\"Testimonial 19\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_3.png\";s:12:\"tmpl_created\";i:1520520551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:375;s:16:\"popularity_index\";i:245;s:11:\"trend_index\";i:599;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:711;a:16:{s:4:\"tmpl\";i:581;s:2:\"id\";i:4880;s:5:\"title\";s:14:\"Testimonial 20\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/customers-1.jpg\";s:12:\"tmpl_created\";i:1520520554;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:376;s:16:\"popularity_index\";i:446;s:11:\"trend_index\";i:653;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:712;a:16:{s:4:\"tmpl\";i:583;s:2:\"id\";i:4897;s:5:\"title\";s:14:\"Testimonial 21\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_5.png\";s:12:\"tmpl_created\";i:1520520557;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:377;s:16:\"popularity_index\";i:78;s:11:\"trend_index\";i:289;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:713;a:16:{s:4:\"tmpl\";i:584;s:2:\"id\";i:4905;s:5:\"title\";s:14:\"Testimonial 22\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_6.png\";s:12:\"tmpl_created\";i:1520520559;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:378;s:16:\"popularity_index\";i:121;s:11:\"trend_index\";i:221;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:714;a:16:{s:4:\"tmpl\";i:585;s:2:\"id\";i:4913;s:5:\"title\";s:14:\"Testimonial 23\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_7.png\";s:12:\"tmpl_created\";i:1520520561;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:379;s:16:\"popularity_index\";i:247;s:11:\"trend_index\";i:566;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:715;a:16:{s:4:\"tmpl\";i:575;s:2:\"id\";i:4826;s:5:\"title\";s:14:\"Testimonial 24\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_1.png\";s:12:\"tmpl_created\";i:1520520544;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/testimonial-24-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:380;s:16:\"popularity_index\";i:256;s:11:\"trend_index\";i:395;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:716;a:16:{s:4:\"tmpl\";i:587;s:2:\"id\";i:4929;s:5:\"title\";s:14:\"Testimonial 24\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_8.png\";s:12:\"tmpl_created\";i:1520520564;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:381;s:16:\"popularity_index\";i:49;s:11:\"trend_index\";i:206;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:717;a:16:{s:4:\"tmpl\";i:591;s:2:\"id\";i:4963;s:5:\"title\";s:14:\"Testimonial 25\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_10.png\";s:12:\"tmpl_created\";i:1520520570;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/testimonial-25-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:382;s:16:\"popularity_index\";i:417;s:11:\"trend_index\";i:546;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:718;a:16:{s:4:\"tmpl\";i:592;s:2:\"id\";i:4971;s:5:\"title\";s:14:\"Testimonial 26\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_11.png\";s:12:\"tmpl_created\";i:1520520572;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:383;s:16:\"popularity_index\";i:649;s:11:\"trend_index\";i:718;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:719;a:16:{s:4:\"tmpl\";i:589;s:2:\"id\";i:4947;s:5:\"title\";s:14:\"Testimonial 27\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_9.png\";s:12:\"tmpl_created\";i:1520520567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:384;s:16:\"popularity_index\";i:221;s:11:\"trend_index\";i:496;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:720;a:16:{s:4:\"tmpl\";i:590;s:2:\"id\";i:4955;s:5:\"title\";s:14:\"Testimonial 29\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_9.png\";s:12:\"tmpl_created\";i:1520520569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:385;s:16:\"popularity_index\";i:378;s:11:\"trend_index\";i:695;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:721;a:16:{s:4:\"tmpl\";i:588;s:2:\"id\";i:4939;s:5:\"title\";s:13:\"Testimonial 9\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_8.png\";s:12:\"tmpl_created\";i:1520520565;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/testimonial-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:386;s:16:\"popularity_index\";i:103;s:11:\"trend_index\";i:341;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:722;a:16:{s:4:\"tmpl\";i:928;s:2:\"id\";i:12509;s:5:\"title\";s:18:\"Travel &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/12/404.png\";s:12:\"tmpl_created\";i:1575960378;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/travel-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:24:\"[\"404\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:387;s:16:\"popularity_index\";i:747;s:11:\"trend_index\";i:712;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:723;a:16:{s:4:\"tmpl\";i:929;s:2:\"id\";i:12516;s:5:\"title\";s:27:\"Travel &#8211; Archive Blog\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/12/Archiv_s.png\";s:12:\"tmpl_created\";i:1575960387;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/travel-archive-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:388;s:16:\"popularity_index\";i:496;s:11:\"trend_index\";i:487;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:724;a:16:{s:4:\"tmpl\";i:927;s:2:\"id\";i:12500;s:5:\"title\";s:21:\"Travel &#8211; Header\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-travel-and-tours.png\";s:12:\"tmpl_created\";i:1575960371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/travel-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:27:\"[\"Header\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:389;s:16:\"popularity_index\";i:443;s:11:\"trend_index\";i:434;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:725;a:16:{s:4:\"tmpl\";i:930;s:2:\"id\";i:12524;s:5:\"title\";s:26:\"Travel &#8211; Single Post\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/12/Single_Post_s.png\";s:12:\"tmpl_created\";i:1575960397;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/travel-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:390;s:16:\"popularity_index\";i:591;s:11:\"trend_index\";i:663;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:726;a:16:{s:4:\"tmpl\";i:931;s:2:\"id\";i:12531;s:5:\"title\";s:31:\"Travel &#8211; Single Post Tour\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/12/Single_Tour_s.png\";s:12:\"tmpl_created\";i:1575960404;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/travel-single-post-tour/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:391;s:16:\"popularity_index\";i:630;s:11:\"trend_index\";i:548;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:727;a:16:{s:4:\"tmpl\";i:926;s:2:\"id\";i:12492;s:5:\"title\";s:14:\"Travel -Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/12/Footer_s.png\";s:12:\"tmpl_created\";i:1575960358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/travel-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:27:\"[\"Footer\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:392;s:16:\"popularity_index\";i:453;s:11:\"trend_index\";i:322;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:728;a:16:{s:4:\"tmpl\";i:1068;s:2:\"id\";i:15498;s:5:\"title\";s:23:\"Travel Blog &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/11/404.jpg\";s:12:\"tmpl_created\";i:1606215636;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/travel-blog-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:23:\"[\"404\",\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:393;s:16:\"popularity_index\";i:749;s:11:\"trend_index\";i:759;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:729;a:16:{s:4:\"tmpl\";i:1069;s:2:\"id\";i:15508;s:5:\"title\";s:29:\"Travel Blog &#8211; Archive 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/11/Archive-1-350.jpg\";s:12:\"tmpl_created\";i:1606215649;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/travel-blog-archive-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:394;s:16:\"popularity_index\";i:659;s:11:\"trend_index\";i:468;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:730;a:16:{s:4:\"tmpl\";i:1070;s:2:\"id\";i:15518;s:5:\"title\";s:29:\"Travel Blog &#8211; Archive 2\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/11/Archive-2-350-Copy.jpg\";s:12:\"tmpl_created\";i:1606215663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/travel-blog-archive-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:395;s:16:\"popularity_index\";i:688;s:11:\"trend_index\";i:431;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:731;a:16:{s:4:\"tmpl\";i:1071;s:2:\"id\";i:15528;s:5:\"title\";s:26:\"Travel Blog &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/11/Footer.jpg\";s:12:\"tmpl_created\";i:1606215673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/travel-blog-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:26:\"[\"Blog\",\"Footer\",\"Travel\"]\";s:10:\"menu_order\";i:396;s:16:\"popularity_index\";i:656;s:11:\"trend_index\";i:377;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:732;a:16:{s:4:\"tmpl\";i:1067;s:2:\"id\";i:15536;s:5:\"title\";s:26:\"Travel Blog &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/11/Header.jpg\";s:12:\"tmpl_created\";i:1606215625;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/travel-blog-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:26:\"[\"Blog\",\"Header\",\"Travel\"]\";s:10:\"menu_order\";i:397;s:16:\"popularity_index\";i:584;s:11:\"trend_index\";i:228;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:733;a:16:{s:4:\"tmpl\";i:1072;s:2:\"id\";i:15545;s:5:\"title\";s:33:\"Travel Blog &#8211; Single Post 1\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/11/Single-1-350.jpg\";s:12:\"tmpl_created\";i:1606215684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/travel-blog-single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:398;s:16:\"popularity_index\";i:669;s:11:\"trend_index\";i:482;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:734;a:16:{s:4:\"tmpl\";i:1066;s:2:\"id\";i:15556;s:5:\"title\";s:33:\"Travel Blog &#8211; Single Post 2\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/11/Single-2-350.jpg\";s:12:\"tmpl_created\";i:1606215613;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/travel-blog-single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:399;s:16:\"popularity_index\";i:652;s:11:\"trend_index\";i:454;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}","no");
INSERT INTO `wp_options` VALUES("979","wp_mail_smtp_migration_version","4","yes");
INSERT INTO `wp_options` VALUES("980","wp_mail_smtp_review_notice","a:2:{s:4:\"time\";i:1637028785;s:9:\"dismissed\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("981","action_scheduler_lock_async-request-runner","1661066593","yes");
INSERT INTO `wp_options` VALUES("982","wp_mail_smtp_debug","a:0:{}","no");
INSERT INTO `wp_options` VALUES("202","widget_edu_two_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("203","widget_skill_one_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("1741","category_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("2723","auto_update_core_dev","enabled","yes");
INSERT INTO `wp_options` VALUES("2724","auto_update_core_minor","enabled","yes");
INSERT INTO `wp_options` VALUES("2725","auto_update_core_major","unset","yes");
INSERT INTO `wp_options` VALUES("13012","litespeed.optimize.timestamp_purge_css","1641310132","yes");
INSERT INTO `wp_options` VALUES("15650","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:5:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.0.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.0.1.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.0.1-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.0.1-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.0.1\";s:7:\"version\";s:5:\"6.0.1\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.0.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.0.1.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.0.1-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.0.1-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.0.1\";s:7:\"version\";s:5:\"6.0.1\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:2;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:57:\"https://downloads.wordpress.org/release/wordpress-6.0.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:57:\"https://downloads.wordpress.org/release/wordpress-6.0.zip\";s:10:\"no_content\";s:68:\"https://downloads.wordpress.org/release/wordpress-6.0-no-content.zip\";s:11:\"new_bundled\";s:69:\"https://downloads.wordpress.org/release/wordpress-6.0-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:3:\"6.0\";s:7:\"version\";s:3:\"6.0\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:3;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.9.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.9.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.9.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.9.3-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"5.9.3\";s:7:\"version\";s:5:\"5.9.3\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:4;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.9.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.9.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.9.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.9.2-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"5.9.2\";s:7:\"version\";s:5:\"5.9.2\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}}s:12:\"last_checked\";i:1661296682;s:15:\"version_checked\";s:5:\"5.8.4\";s:12:\"translations\";a:0:{}}","no");
INSERT INTO `wp_options` VALUES("11757","litespeed.gui._summary","a:2:{s:11:\"new_version\";i:1630308674;s:5:\"score\";i:1630654274;}","yes");
INSERT INTO `wp_options` VALUES("6865","aiowpsec_db_version","1.9","yes");
INSERT INTO `wp_options` VALUES("6866","aio_wp_security_configs","a:98:{s:19:\"aiowps_enable_debug\";s:0:\"\";s:36:\"aiowps_remove_wp_generator_meta_info\";s:1:\"1\";s:25:\"aiowps_prevent_hotlinking\";s:1:\"1\";s:28:\"aiowps_enable_login_lockdown\";s:1:\"1\";s:28:\"aiowps_allow_unlock_requests\";s:0:\"\";s:25:\"aiowps_max_login_attempts\";i:3;s:24:\"aiowps_retry_time_period\";i:5;s:26:\"aiowps_lockout_time_length\";i:60;s:28:\"aiowps_set_generic_login_msg\";s:1:\"1\";s:26:\"aiowps_enable_email_notify\";s:1:\"1\";s:20:\"aiowps_email_address\";s:25:\"amr.elarabi.egy@gmail.com\";s:27:\"aiowps_enable_forced_logout\";s:0:\"\";s:25:\"aiowps_logout_time_period\";s:2:\"60\";s:39:\"aiowps_enable_invalid_username_lockdown\";s:0:\"\";s:43:\"aiowps_instantly_lockout_specific_usernames\";a:0:{}s:32:\"aiowps_unlock_request_secret_key\";s:20:\"l0nsh7dm9kpzze6kdtvi\";s:35:\"aiowps_lockdown_enable_whitelisting\";s:0:\"\";s:36:\"aiowps_lockdown_allowed_ip_addresses\";s:0:\"\";s:26:\"aiowps_enable_whitelisting\";s:0:\"\";s:27:\"aiowps_allowed_ip_addresses\";s:0:\"\";s:27:\"aiowps_enable_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_custom_login_captcha\";s:0:\"\";s:31:\"aiowps_enable_woo_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_woo_register_captcha\";s:0:\"\";s:25:\"aiowps_captcha_secret_key\";s:20:\"28pd36pm4410n1ac7u9v\";s:42:\"aiowps_enable_manual_registration_approval\";s:1:\"1\";s:39:\"aiowps_enable_registration_page_captcha\";s:1:\"1\";s:35:\"aiowps_enable_registration_honeypot\";s:0:\"\";s:27:\"aiowps_enable_random_prefix\";s:0:\"\";s:31:\"aiowps_enable_automated_backups\";s:1:\"1\";s:26:\"aiowps_db_backup_frequency\";i:4;s:25:\"aiowps_db_backup_interval\";s:1:\"2\";s:26:\"aiowps_backup_files_stored\";i:2;s:32:\"aiowps_send_backup_email_address\";s:1:\"1\";s:27:\"aiowps_backup_email_address\";s:25:\"amr.elarabi.egy@gmail.com\";s:27:\"aiowps_disable_file_editing\";s:1:\"1\";s:37:\"aiowps_prevent_default_wp_file_access\";s:1:\"1\";s:22:\"aiowps_system_log_file\";s:9:\"error_log\";s:26:\"aiowps_enable_blacklisting\";s:0:\"\";s:26:\"aiowps_banned_ip_addresses\";s:0:\"\";s:28:\"aiowps_enable_basic_firewall\";s:1:\"1\";s:31:\"aiowps_enable_pingback_firewall\";s:1:\"1\";s:38:\"aiowps_disable_xmlrpc_pingback_methods\";s:1:\"1\";s:34:\"aiowps_block_debug_log_file_access\";s:1:\"1\";s:26:\"aiowps_disable_index_views\";s:1:\"1\";s:30:\"aiowps_disable_trace_and_track\";s:1:\"1\";s:28:\"aiowps_forbid_proxy_comments\";s:1:\"1\";s:29:\"aiowps_deny_bad_query_strings\";s:1:\"1\";s:34:\"aiowps_advanced_char_string_filter\";s:1:\"1\";s:25:\"aiowps_enable_5g_firewall\";s:1:\"1\";s:25:\"aiowps_enable_6g_firewall\";s:1:\"1\";s:26:\"aiowps_enable_custom_rules\";s:0:\"\";s:32:\"aiowps_place_custom_rules_at_top\";s:0:\"\";s:19:\"aiowps_custom_rules\";s:0:\"\";s:25:\"aiowps_enable_404_logging\";s:0:\"\";s:28:\"aiowps_enable_404_IP_lockout\";s:0:\"\";s:30:\"aiowps_404_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_404_lock_redirect_url\";s:16:\"http://127.0.0.1\";s:31:\"aiowps_enable_rename_login_page\";s:1:\"1\";s:28:\"aiowps_enable_login_honeypot\";s:0:\"\";s:43:\"aiowps_enable_brute_force_attack_prevention\";s:0:\"\";s:30:\"aiowps_brute_force_secret_word\";s:0:\"\";s:24:\"aiowps_cookie_brute_test\";s:0:\"\";s:44:\"aiowps_cookie_based_brute_force_redirect_url\";s:16:\"http://127.0.0.1\";s:59:\"aiowps_brute_force_attack_prevention_pw_protected_exception\";s:0:\"\";s:51:\"aiowps_brute_force_attack_prevention_ajax_exception\";s:0:\"\";s:19:\"aiowps_site_lockout\";s:0:\"\";s:23:\"aiowps_site_lockout_msg\";s:0:\"\";s:30:\"aiowps_enable_spambot_blocking\";s:1:\"1\";s:29:\"aiowps_enable_comment_captcha\";s:0:\"\";s:31:\"aiowps_enable_autoblock_spam_ip\";s:1:\"1\";s:33:\"aiowps_spam_ip_min_comments_block\";i:3;s:33:\"aiowps_enable_bp_register_captcha\";s:0:\"\";s:35:\"aiowps_enable_bbp_new_topic_captcha\";s:0:\"\";s:32:\"aiowps_enable_automated_fcd_scan\";s:1:\"1\";s:25:\"aiowps_fcd_scan_frequency\";i:1;s:24:\"aiowps_fcd_scan_interval\";s:1:\"2\";s:28:\"aiowps_fcd_exclude_filetypes\";s:13:\"jpg
png
bmp\";s:24:\"aiowps_fcd_exclude_files\";s:0:\"\";s:26:\"aiowps_send_fcd_scan_email\";s:1:\"1\";s:29:\"aiowps_fcd_scan_email_address\";s:25:\"amr.elarabi.egy@gmail.com\";s:27:\"aiowps_fcds_change_detected\";b:1;s:22:\"aiowps_copy_protection\";s:0:\"\";s:40:\"aiowps_prevent_site_display_inside_frame\";s:0:\"\";s:32:\"aiowps_prevent_users_enumeration\";s:0:\"\";s:25:\"aiowps_ip_retrieve_method\";s:1:\"0\";s:22:\"aiowps_login_page_slug\";s:10:\"letmelogin\";s:23:\"aiowps_last_backup_time\";s:19:\"2022-07-27 01:06:21\";s:42:\"aiowps_disallow_unauthorized_rest_requests\";s:1:\"1\";s:25:\"aiowps_recaptcha_site_key\";s:40:\"6Lfiz5MaAAAAANQr9iOlUrCMcTy3P43MEd_Mz07T\";s:27:\"aiowps_recaptcha_secret_key\";s:40:\"6Lfiz5MaAAAAAJO7tFlEWaWSY6s09IErxPHTrPaa\";s:24:\"aiowps_default_recaptcha\";s:0:\"\";s:38:\"aiowps_enable_woo_lostpassword_captcha\";s:0:\"\";s:27:\"aiowps_max_file_upload_size\";i:10;s:28:\"aiowps_block_fake_googlebots\";s:1:\"1\";s:35:\"aiowps_enable_lost_password_captcha\";s:0:\"\";s:19:\"aiowps_fcd_filename\";s:26:\"aiowps_fcd_data_st63thh31f\";s:25:\"aiowps_last_fcd_scan_time\";s:19:\"2022-08-20 07:23:32\";}","yes");
INSERT INTO `wp_options` VALUES("13010","widget_block","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("14114","action_scheduler_migration_status","complete","yes");
INSERT INTO `wp_options` VALUES("14122","bsr_data","a:8:{s:13:\"select_tables\";a:32:{i:0;s:26:\"wp_actionscheduler_actions\";i:1;s:25:\"wp_actionscheduler_claims\";i:2;s:25:\"wp_actionscheduler_groups\";i:3;s:23:\"wp_actionscheduler_logs\";i:4;s:16:\"wp_aiowps_events\";i:5;s:23:\"wp_aiowps_failed_logins\";i:6;s:21:\"wp_aiowps_global_meta\";i:7;s:24:\"wp_aiowps_login_activity\";i:8;s:24:\"wp_aiowps_login_lockdown\";i:9;s:25:\"wp_aiowps_permanent_block\";i:10;s:14:\"wp_commentmeta\";i:11;s:11:\"wp_comments\";i:12;s:8:\"wp_links\";i:13;s:16:\"wp_litespeed_url\";i:14;s:21:\"wp_litespeed_url_file\";i:15;s:10:\"wp_options\";i:16;s:11:\"wp_postmeta\";i:17;s:8:\"wp_posts\";i:18;s:15:\"wp_rtafar_rules\";i:19;s:21:\"wp_term_relationships\";i:20;s:16:\"wp_term_taxonomy\";i:21;s:11:\"wp_termmeta\";i:22;s:8:\"wp_terms\";i:23;s:11:\"wp_usermeta\";i:24;s:8:\"wp_users\";i:25;s:26:\"wp_wpmailsmtp_debug_events\";i:26;s:24:\"wp_wpmailsmtp_tasks_meta\";i:27;s:18:\"wp_yoast_indexable\";i:28;s:28:\"wp_yoast_indexable_hierarchy\";i:29;s:19:\"wp_yoast_migrations\";i:30;s:21:\"wp_yoast_primary_term\";i:31;s:18:\"wp_yoast_seo_links\";}s:16:\"case_insensitive\";s:3:\"off\";s:13:\"replace_guids\";s:3:\"off\";s:7:\"dry_run\";s:3:\"off\";s:10:\"search_for\";s:24:\"https://amrelarabi.tech/\";s:12:\"replace_with\";s:23:\"https://amrelarabi.com/\";s:15:\"completed_pages\";i:32;s:11:\"total_pages\";i:32;}","yes");
INSERT INTO `wp_options` VALUES("14108","rtafar_plugin_install_date","2022-01-04 15:26:46","yes");
INSERT INTO `wp_options` VALUES("14109","rtafar_db_version","1.0.2","yes");
INSERT INTO `wp_options` VALUES("14110","rtafar_plugin_version","1.3.2","yes");
INSERT INTO `wp_options` VALUES("20719","_transient_doing_cron","1661305887.5619530677795410156250","yes");


DROP TABLE IF EXISTS `wp_postmeta`;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2170 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_postmeta` VALUES("17","10","_elementor_edit_mode","builder");
INSERT INTO `wp_postmeta` VALUES("18","10","_elementor_template_type","kit");
INSERT INTO `wp_postmeta` VALUES("19","10","_elementor_version","3.0.14");
INSERT INTO `wp_postmeta` VALUES("22","41","_wp_attached_file","2019/11/favicon.png");
INSERT INTO `wp_postmeta` VALUES("23","41","_wp_attachment_metadata","a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:19:\"2019/11/favicon.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"favicon-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"favicon-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("24","155","_wp_attached_file","2019/11/image_blog_01.jpg");
INSERT INTO `wp_postmeta` VALUES("25","155","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1150;s:6:\"height\";i:450;s:4:\"file\";s:25:\"2019/11/image_blog_01.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"image_blog_01-300x117.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:117;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"image_blog_01-1024x401.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:401;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"image_blog_01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"image_blog_01-768x301.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:301;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("26","162","_wp_attached_file","2019/11/image_blog_02.jpg");
INSERT INTO `wp_postmeta` VALUES("27","162","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1150;s:6:\"height\";i:450;s:4:\"file\";s:25:\"2019/11/image_blog_02.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"image_blog_02-300x117.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:117;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"image_blog_02-1024x401.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:401;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"image_blog_02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"image_blog_02-768x301.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:301;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("28","465","_wp_attached_file","2019/11/blog_img_01.jpg");
INSERT INTO `wp_postmeta` VALUES("29","465","_wp_attachment_metadata","a:5:{s:5:\"width\";i:970;s:6:\"height\";i:450;s:4:\"file\";s:23:\"2019/11/blog_img_01.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"blog_img_01-300x139.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:139;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"blog_img_01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"blog_img_01-768x356.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:356;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("30","467","_wp_attached_file","2019/11/blog_img_02.jpg");
INSERT INTO `wp_postmeta` VALUES("31","467","_wp_attachment_metadata","a:5:{s:5:\"width\";i:970;s:6:\"height\";i:450;s:4:\"file\";s:23:\"2019/11/blog_img_02.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"blog_img_02-300x139.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:139;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"blog_img_02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"blog_img_02-768x356.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:356;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("32","469","_wp_attached_file","2019/11/blog_img_03.jpg");
INSERT INTO `wp_postmeta` VALUES("33","469","_wp_attachment_metadata","a:5:{s:5:\"width\";i:970;s:6:\"height\";i:450;s:4:\"file\";s:23:\"2019/11/blog_img_03.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"blog_img_03-300x139.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:139;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"blog_img_03-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"blog_img_03-768x356.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:356;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("34","471","_wp_attached_file","2019/11/blog_img_04.jpg");
INSERT INTO `wp_postmeta` VALUES("35","471","_wp_attachment_metadata","a:5:{s:5:\"width\";i:970;s:6:\"height\";i:450;s:4:\"file\";s:23:\"2019/11/blog_img_04.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"blog_img_04-300x139.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:139;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"blog_img_04-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"blog_img_04-768x356.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:356;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("36","503","_wp_attached_file","2019/11/portfolio_img_01.jpg");
INSERT INTO `wp_postmeta` VALUES("37","503","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:400;s:4:\"file\";s:28:\"2019/11/portfolio_img_01.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"portfolio_img_01-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"portfolio_img_01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:28:\"portfolio_img_01-768x384.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:384;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("38","504","_wp_attached_file","2019/11/portfolio_img_02.jpg");
INSERT INTO `wp_postmeta` VALUES("39","504","_wp_attachment_metadata","a:5:{s:5:\"width\";i:400;s:6:\"height\";i:400;s:4:\"file\";s:28:\"2019/11/portfolio_img_02.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"portfolio_img_02-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"portfolio_img_02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("40","505","_wp_attached_file","2019/11/portfolio_img_03.jpg");
INSERT INTO `wp_postmeta` VALUES("41","505","_wp_attachment_metadata","a:5:{s:5:\"width\";i:400;s:6:\"height\";i:800;s:4:\"file\";s:28:\"2019/11/portfolio_img_03.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"portfolio_img_03-150x300.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"portfolio_img_03-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("42","506","_wp_attached_file","2019/11/portfolio_img_04.jpg");
INSERT INTO `wp_postmeta` VALUES("43","506","_wp_attachment_metadata","a:5:{s:5:\"width\";i:400;s:6:\"height\";i:400;s:4:\"file\";s:28:\"2019/11/portfolio_img_04.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"portfolio_img_04-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"portfolio_img_04-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("44","513","_wp_attached_file","2020/08/main_01.jpg");
INSERT INTO `wp_postmeta` VALUES("45","513","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:760;s:4:\"file\";s:19:\"2020/08/main_01.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"main_01-237x300.jpg\";s:5:\"width\";i:237;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"main_01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("46","514","_wp_attached_file","2020/08/icon_download_cv.png");
INSERT INTO `wp_postmeta` VALUES("47","514","_wp_attachment_metadata","a:5:{s:5:\"width\";i:400;s:6:\"height\";i:360;s:4:\"file\";s:28:\"2020/08/icon_download_cv.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"icon_download_cv-300x270.png\";s:5:\"width\";i:300;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"icon_download_cv-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("48","515","_wp_attached_file","2020/08/icon_preciese.png");
INSERT INTO `wp_postmeta` VALUES("49","515","_wp_attachment_metadata","a:5:{s:5:\"width\";i:400;s:6:\"height\";i:360;s:4:\"file\";s:25:\"2020/08/icon_preciese.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"icon_preciese-300x270.png\";s:5:\"width\";i:300;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"icon_preciese-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("50","516","_wp_attached_file","2020/08/icon_responsive.png");
INSERT INTO `wp_postmeta` VALUES("51","516","_wp_attachment_metadata","a:5:{s:5:\"width\";i:400;s:6:\"height\";i:360;s:4:\"file\";s:27:\"2020/08/icon_responsive.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"icon_responsive-300x270.png\";s:5:\"width\";i:300;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"icon_responsive-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("52","517","_wp_attached_file","2020/08/icon_secure.png");
INSERT INTO `wp_postmeta` VALUES("53","517","_wp_attachment_metadata","a:5:{s:5:\"width\";i:400;s:6:\"height\";i:360;s:4:\"file\";s:23:\"2020/08/icon_secure.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"icon_secure-300x270.png\";s:5:\"width\";i:300;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"icon_secure-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("54","518","_wp_attached_file","2020/08/icon_signature.png");
INSERT INTO `wp_postmeta` VALUES("55","518","_wp_attachment_metadata","a:5:{s:5:\"width\";i:250;s:6:\"height\";i:50;s:4:\"file\";s:26:\"2020/08/icon_signature.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"icon_signature-150x50.png\";s:5:\"width\";i:150;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("56","520","_wp_attached_file","2020/08/zigzag.png");
INSERT INTO `wp_postmeta` VALUES("57","520","_wp_attachment_metadata","a:5:{s:5:\"width\";i:310;s:6:\"height\";i:70;s:4:\"file\";s:18:\"2020/08/zigzag.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"zigzag-300x68.png\";s:5:\"width\";i:300;s:6:\"height\";i:68;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"zigzag-150x70.png\";s:5:\"width\";i:150;s:6:\"height\";i:70;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("58","521","_wp_attached_file","2020/08/triangle.png");
INSERT INTO `wp_postmeta` VALUES("59","521","_wp_attachment_metadata","a:5:{s:5:\"width\";i:214;s:6:\"height\";i:164;s:4:\"file\";s:20:\"2020/08/triangle.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"triangle-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("60","522","_wp_attached_file","2020/08/circle.png");
INSERT INTO `wp_postmeta` VALUES("61","522","_wp_attachment_metadata","a:5:{s:5:\"width\";i:200;s:6:\"height\";i:200;s:4:\"file\";s:18:\"2020/08/circle.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"circle-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("62","32","_elementor_controls_usage","a:0:{}");
INSERT INTO `wp_postmeta` VALUES("63","32","_elementor_controls_usage","a:0:{}");
INSERT INTO `wp_postmeta` VALUES("64","479","_elementor_edit_mode","builder");
INSERT INTO `wp_postmeta` VALUES("65","479","_elementor_template_type","page");
INSERT INTO `wp_postmeta` VALUES("66","479","_elementor_version","2.9.14");
INSERT INTO `wp_postmeta` VALUES("67","479","_elementor_data","[{\"id\":\"6ccd5ffe\",\"elType\":\"section\",\"settings\":{\"background_background\":\"classic\",\"padding\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"30\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"22899d50\",\"elType\":\"column\",\"settings\":{\"_column_size\":100},\"elements\":[{\"id\":\"30ee043c\",\"elType\":\"section\",\"settings\":{\"content_width\":{\"unit\":\"px\",\"size\":500,\"sizes\":[]}},\"elements\":[{\"id\":\"768c551b\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null,\"align\":\"space-evenly\"},\"elements\":[{\"id\":\"35526a\",\"elType\":\"widget\",\"settings\":{\"icon\":\"fa fa-twitter\",\"primary_color\":\"#FFFFFF\",\"hover_primary_color\":\"#F393A4\",\"_element_width\":\"initial\",\"link\":{\"url\":\"#\",\"is_external\":\"\",\"nofollow\":\"\"},\"size\":{\"unit\":\"px\",\"size\":28,\"sizes\":[]},\"selected_icon\":{\"value\":\"fab fa-twitter\",\"library\":\"fa-brands\"},\"__fa4_migrated\":{\"selected_icon\":true}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"e55178\",\"elType\":\"widget\",\"settings\":{\"icon\":\"fa fa-facebook-square\",\"primary_color\":\"#FFFFFF\",\"hover_primary_color\":\"#F393A4\",\"_element_width\":\"initial\",\"link\":{\"url\":\"#\",\"is_external\":\"\",\"nofollow\":\"\"},\"size\":{\"unit\":\"px\",\"size\":28,\"sizes\":[]},\"selected_icon\":{\"value\":\"fab fa-facebook-square\",\"library\":\"fa-brands\"},\"__fa4_migrated\":{\"selected_icon\":true}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"312444eb\",\"elType\":\"widget\",\"settings\":{\"icon\":\"fa fa-dribbble\",\"primary_color\":\"#FFFFFF\",\"hover_primary_color\":\"#F393A4\",\"_element_width\":\"initial\",\"link\":{\"url\":\"#\",\"is_external\":\"\",\"nofollow\":\"\"},\"size\":{\"unit\":\"px\",\"size\":28,\"sizes\":[]},\"selected_icon\":{\"value\":\"fab fa-dribbble\",\"library\":\"fa-brands\"},\"__fa4_migrated\":{\"selected_icon\":true}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"2089bfb8\",\"elType\":\"widget\",\"settings\":{\"icon\":\"fa fa-rss\",\"primary_color\":\"#FFFFFF\",\"hover_primary_color\":\"#F393A4\",\"_element_width\":\"initial\",\"link\":{\"url\":\"#\",\"is_external\":\"\",\"nofollow\":\"\"},\"size\":{\"unit\":\"px\",\"size\":28,\"sizes\":[]},\"selected_icon\":{\"value\":\"fas fa-rss\",\"library\":\"fa-solid\"},\"__fa4_migrated\":{\"selected_icon\":true}},\"elements\":[],\"widgetType\":\"icon\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"6ef87128\",\"elType\":\"widget\",\"settings\":{\"editor\":\"\\u00a9 2020 Teoro WordPress Theme by <a href=\\\"https:\\/\\/cocobasic.com\\/\\\">CocoBasic<\\/a>\",\"align\":\"center\",\"typography_typography\":\"custom\"},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("68","479","_wp_page_template","elementor_canvas");
INSERT INTO `wp_postmeta` VALUES("69","479","_elementor_controls_usage","a:4:{s:4:\"icon\";a:3:{s:5:\"count\";i:4;s:15:\"control_percent\";i:3;s:8:\"controls\";a:3:{s:5:\"style\";a:1:{s:18:\"section_style_icon\";a:3:{s:13:\"primary_color\";i:4;s:19:\"hover_primary_color\";i:4;s:4:\"size\";i:4;}}s:8:\"advanced\";a:1:{s:17:\"_section_position\";a:1:{s:14:\"_element_width\";i:4;}}s:7:\"content\";a:1:{s:12:\"section_icon\";a:2:{s:4:\"link\";i:4;s:13:\"selected_icon\";i:4;}}}}s:6:\"column\";a:3:{s:5:\"count\";i:2;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:6:\"layout\";a:1:{s:6:\"layout\";a:2:{s:12:\"_inline_size\";i:1;s:5:\"align\";i:1;}}}}s:7:\"section\";a:3:{s:5:\"count\";i:2;s:15:\"control_percent\";i:1;s:8:\"controls\";a:3:{s:6:\"layout\";a:1:{s:14:\"section_layout\";a:1:{s:13:\"content_width\";i:1;}}s:5:\"style\";a:1:{s:18:\"section_background\";a:1:{s:21:\"background_background\";i:1;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:1:{s:7:\"padding\";i:1;}}}}s:11:\"text-editor\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:1;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:2:{s:5:\"align\";i:1;s:21:\"typography_typography\";i:1;}}}}}");
INSERT INTO `wp_postmeta` VALUES("94","526","_menu_item_type","custom");
INSERT INTO `wp_postmeta` VALUES("95","526","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("96","526","_menu_item_object_id","526");
INSERT INTO `wp_postmeta` VALUES("97","526","_menu_item_object","custom");
INSERT INTO `wp_postmeta` VALUES("98","526","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("99","526","_menu_item_classes","a:1:{i:0;s:16:\"one-page-section\";}");
INSERT INTO `wp_postmeta` VALUES("100","526","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("101","526","_menu_item_url","#home");
INSERT INTO `wp_postmeta` VALUES("730","668","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:316;s:4:\"file\";s:38:\"2019/11/fileuploder-e1607031490698.png\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"fileuploder-300x118.png\";s:5:\"width\";i:300;s:6:\"height\";i:118;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"fileuploder-1024x404.png\";s:5:\"width\";i:1024;s:6:\"height\";i:404;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"fileuploder-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"fileuploder-768x303.png\";s:5:\"width\";i:768;s:6:\"height\";i:303;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("729","668","_wp_attached_file","2019/11/fileuploder-e1607031490698.png");
INSERT INTO `wp_postmeta` VALUES("728","59","_edit_lock","1607032723:1");
INSERT INTO `wp_postmeta` VALUES("727","62","portfolio_extern_site_url","https://github.com/amrelarabi/live-chat");
INSERT INTO `wp_postmeta` VALUES("726","62","portfolio_link_item_to","link_to_extern_url");
INSERT INTO `wp_postmeta` VALUES("118","529","_wp_attached_file","2020/08/square.png");
INSERT INTO `wp_postmeta` VALUES("119","529","_wp_attachment_metadata","a:5:{s:5:\"width\";i:220;s:6:\"height\";i:220;s:4:\"file\";s:18:\"2020/08/square.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"square-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("120","530","_elementor_edit_mode","builder");
INSERT INTO `wp_postmeta` VALUES("121","530","_elementor_template_type","kit");
INSERT INTO `wp_postmeta` VALUES("122","530","_elementor_version","2.9.14");
INSERT INTO `wp_postmeta` VALUES("722","667","_wp_attachment_metadata","a:5:{s:5:\"width\";i:593;s:6:\"height\";i:585;s:4:\"file\";s:16:\"2019/11/chat.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"chat-300x296.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:296;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"chat-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("721","667","_wp_attached_file","2019/11/chat.jpg");
INSERT INTO `wp_postmeta` VALUES("720","62","_edit_lock","1607032639:1");
INSERT INTO `wp_postmeta` VALUES("770","65","_wp_old_date","2019-11-19");
INSERT INTO `wp_postmeta` VALUES("139","560","_wp_attached_file","2019/11/p_item_03.jpg");
INSERT INTO `wp_postmeta` VALUES("140","560","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:300;s:4:\"file\";s:21:\"2019/11/p_item_03.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"p_item_03-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"p_item_03-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("141","561","_wp_attached_file","2019/11/p_item_01.jpg");
INSERT INTO `wp_postmeta` VALUES("142","561","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:300;s:4:\"file\";s:21:\"2019/11/p_item_01.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"p_item_01-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"p_item_01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("143","562","_wp_attached_file","2019/11/p_item_02.jpg");
INSERT INTO `wp_postmeta` VALUES("144","562","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:300;s:4:\"file\";s:21:\"2019/11/p_item_02.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"p_item_02-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"p_item_02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("145","566","_wp_attached_file","2019/11/cropped-favicon.png");
INSERT INTO `wp_postmeta` VALUES("146","566","_wp_attachment_metadata","a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:27:\"2019/11/cropped-favicon.png\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("147","566","_wp_attachment_context","site-icon");
INSERT INTO `wp_postmeta` VALUES("148","586","_wp_attached_file","2019/11/portfolio_img_06.jpg");
INSERT INTO `wp_postmeta` VALUES("149","586","_wp_attachment_metadata","a:5:{s:5:\"width\";i:400;s:6:\"height\";i:400;s:4:\"file\";s:28:\"2019/11/portfolio_img_06.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"portfolio_img_06-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"portfolio_img_06-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("150","587","_wp_attached_file","2019/11/portfolio_img_05.jpg");
INSERT INTO `wp_postmeta` VALUES("151","587","_wp_attachment_metadata","a:5:{s:5:\"width\";i:400;s:6:\"height\";i:400;s:4:\"file\";s:28:\"2019/11/portfolio_img_05.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"portfolio_img_05-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"portfolio_img_05-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("160","53","_elementor_controls_usage","a:0:{}");
INSERT INTO `wp_postmeta` VALUES("161","53","_elementor_controls_usage","a:0:{}");
INSERT INTO `wp_postmeta` VALUES("162","53","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("163","53","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("164","53","_thumbnail_id","670");
INSERT INTO `wp_postmeta` VALUES("813","53","portfolio_thumb_image_size","p_one_half");
INSERT INTO `wp_postmeta` VALUES("814","53","portfolio_link_item_to","link_to_extern_url");
INSERT INTO `wp_postmeta` VALUES("815","53","portfolio_extern_site_url","https://github.com/amrelarabi/gym-laravel");
INSERT INTO `wp_postmeta` VALUES("816","671","_wp_attached_file","2019/11/translate-translation-web-service.jpg");
INSERT INTO `wp_postmeta` VALUES("170","56","_elementor_controls_usage","a:5:{s:7:\"heading\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:2;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:13:\"section_title\";a:1:{s:5:\"title\";i:1;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:2:{s:21:\"typography_typography\";i:1;s:20:\"typography_font_size\";i:1;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:2:{s:7:\"_margin\";i:1;s:14:\"_margin_mobile\";i:1;}}}}s:11:\"text-editor\";a:3:{s:5:\"count\";i:2;s:15:\"control_percent\";i:3;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:2;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:5:{s:21:\"typography_typography\";i:1;s:20:\"typography_font_size\";i:2;s:22:\"typography_line_height\";i:2;s:27:\"typography_font_size_mobile\";i:1;s:29:\"typography_line_height_mobile\";i:1;}}s:8:\"advanced\";a:2:{s:17:\"_section_position\";a:2:{s:14:\"_element_width\";i:2;s:21:\"_element_custom_width\";i:2;}s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:1;}}}}s:6:\"column\";a:3:{s:5:\"count\";i:5;s:15:\"control_percent\";i:0;s:8:\"controls\";a:2:{s:6:\"layout\";a:1:{s:6:\"layout\";a:2:{s:12:\"_inline_size\";i:5;s:19:\"_inline_size_tablet\";i:1;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:2:{s:13:\"margin_mobile\";i:1;s:14:\"padding_mobile\";i:1;}}}}s:7:\"section\";a:3:{s:5:\"count\";i:3;s:15:\"control_percent\";i:1;s:8:\"controls\";a:2:{s:6:\"layout\";a:2:{s:14:\"section_layout\";a:4:{s:6:\"layout\";i:1;s:3:\"gap\";i:1;s:6:\"_title\";i:1;s:13:\"content_width\";i:2;}s:17:\"section_structure\";a:1:{s:9:\"structure\";i:1;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:2:{s:7:\"padding\";i:1;s:11:\"css_classes\";i:1;}}}}s:5:\"image\";a:3:{s:5:\"count\";i:3;s:15:\"control_percent\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_image\";a:2:{s:5:\"image\";i:3;s:10:\"image_size\";i:3;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:1:{s:12:\"width_mobile\";i:3;}}}}}");
INSERT INTO `wp_postmeta` VALUES("171","56","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("172","56","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("173","56","_elementor_template_type","wp-post");
INSERT INTO `wp_postmeta` VALUES("174","56","_elementor_version","2.7.5");
INSERT INTO `wp_postmeta` VALUES("175","56","_elementor_data","[{\"id\":\"a1fa956\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"%\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_title\":\"Service\",\"content_width\":{\"unit\":\"px\",\"size\":1300,\"sizes\":[]},\"css_classes\":\"op-section\"},\"elements\":[{\"id\":\"534c271\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null,\"_inline_size_tablet\":100,\"margin_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true}},\"elements\":[{\"id\":\"636759f\",\"elType\":\"widget\",\"settings\":{\"title\":\"Photo Session\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"30\",\"left\":\"0\",\"isLinked\":false},\"_margin_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"10\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"b4632b0\",\"elType\":\"widget\",\"settings\":{\"editor\":\"Two ghostly white figures in coveralls and helmets are softly dancing.\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_line_height\":{\"unit\":\"px\",\"size\":35,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]},\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":422,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"d9dacd6\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\"},\"elements\":[{\"id\":\"24e8990\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"1520a58\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Cras pretium metus pulvinar ultricies auctor. In varius purus blandit sem mollis tristique.<br \\/>Curabitur sed lorem vel ligula pulvinar porttitor. Proin sit amet mauris eleifend amet, ullamc lacus.<\\/p>\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_line_height\":{\"unit\":\"px\",\"size\":35,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":726}},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false}],\"isInner\":false},{\"id\":\"578e80c\",\"elType\":\"section\",\"settings\":{\"content_width\":{\"unit\":\"px\",\"size\":1300,\"sizes\":[]},\"structure\":\"30\"},\"elements\":[{\"id\":\"92e6f27\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"71edd5a\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/demo.cocobasic.com\\/volos-wp\\/demo-1\\/wp-content\\/uploads\\/2019\\/11\\/portfolio1.jpg\",\"id\":66},\"image_size\":\"2048x2048\",\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"a3df587\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"b1ed5fc\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/demo.cocobasic.com\\/volos-wp\\/demo-1\\/wp-content\\/uploads\\/2019\\/11\\/portfolio3.jpg\",\"id\":60},\"image_size\":\"full\",\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"e149eef\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"bb6cd0c\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/demo.cocobasic.com\\/volos-wp\\/demo-1\\/wp-content\\/uploads\\/2019\\/11\\/portfolio6.jpg\",\"id\":51},\"image_size\":\"full\",\"width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("176","56","_elementor_controls_usage","a:5:{s:7:\"heading\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:2;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:13:\"section_title\";a:1:{s:5:\"title\";i:1;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:2:{s:21:\"typography_typography\";i:1;s:20:\"typography_font_size\";i:1;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:2:{s:7:\"_margin\";i:1;s:14:\"_margin_mobile\";i:1;}}}}s:11:\"text-editor\";a:3:{s:5:\"count\";i:2;s:15:\"control_percent\";i:3;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:2;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:5:{s:21:\"typography_typography\";i:1;s:20:\"typography_font_size\";i:2;s:22:\"typography_line_height\";i:2;s:27:\"typography_font_size_mobile\";i:1;s:29:\"typography_line_height_mobile\";i:1;}}s:8:\"advanced\";a:2:{s:17:\"_section_position\";a:2:{s:14:\"_element_width\";i:2;s:21:\"_element_custom_width\";i:2;}s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:1;}}}}s:6:\"column\";a:3:{s:5:\"count\";i:5;s:15:\"control_percent\";i:0;s:8:\"controls\";a:2:{s:6:\"layout\";a:1:{s:6:\"layout\";a:2:{s:12:\"_inline_size\";i:5;s:19:\"_inline_size_tablet\";i:1;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:2:{s:13:\"margin_mobile\";i:1;s:14:\"padding_mobile\";i:1;}}}}s:7:\"section\";a:3:{s:5:\"count\";i:3;s:15:\"control_percent\";i:1;s:8:\"controls\";a:2:{s:6:\"layout\";a:2:{s:14:\"section_layout\";a:4:{s:6:\"layout\";i:1;s:3:\"gap\";i:1;s:6:\"_title\";i:1;s:13:\"content_width\";i:2;}s:17:\"section_structure\";a:1:{s:9:\"structure\";i:1;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:2:{s:7:\"padding\";i:1;s:11:\"css_classes\";i:1;}}}}s:5:\"image\";a:3:{s:5:\"count\";i:3;s:15:\"control_percent\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_image\";a:2:{s:5:\"image\";i:3;s:10:\"image_size\";i:3;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:1:{s:12:\"width_mobile\";i:3;}}}}}");
INSERT INTO `wp_postmeta` VALUES("177","56","_oembed_6cfcbf927ed838ebdcd88030b41dc190","<iframe title=\"Paranormal - Rojo\" src=\"https://player.vimeo.com/video/155419584?dnt=1&amp;app_id=122963\" width=\"1170\" height=\"658\" frameborder=\"0\" allow=\"autoplay; fullscreen\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("178","56","_oembed_time_6cfcbf927ed838ebdcd88030b41dc190","1588874006");
INSERT INTO `wp_postmeta` VALUES("179","56","_thumbnail_id","668");
INSERT INTO `wp_postmeta` VALUES("746","56","portfolio_hover_thumb_text","By using Django");
INSERT INTO `wp_postmeta` VALUES("747","56","portfolio_thumb_image_size","p_one_half");
INSERT INTO `wp_postmeta` VALUES("748","56","portfolio_link_item_to","link_to_extern_url");
INSERT INTO `wp_postmeta` VALUES("749","56","portfolio_extern_site_url","https://github.com/amrelarabi/fileuploader");
INSERT INTO `wp_postmeta` VALUES("185","59","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("186","59","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("187","59","_elementor_template_type","wp-post");
INSERT INTO `wp_postmeta` VALUES("188","59","_elementor_version","2.9.11");
INSERT INTO `wp_postmeta` VALUES("189","59","_elementor_data","[]");
INSERT INTO `wp_postmeta` VALUES("190","59","_thumbnail_id","669");
INSERT INTO `wp_postmeta` VALUES("806","59","portfolio_link_item_to","link_to_extern_url");
INSERT INTO `wp_postmeta` VALUES("807","59","portfolio_image_popup","https://demo.cocobasic.com/teoro-wp/demo-1/wp-content/uploads/2019/11/blog_img_02.jpg");
INSERT INTO `wp_postmeta` VALUES("808","59","portfolio_extern_site_url","https://github.com/amrelarabi/Ecommerce-laravel-project");
INSERT INTO `wp_postmeta` VALUES("196","62","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("197","62","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("198","62","_elementor_edit_mode","builder");
INSERT INTO `wp_postmeta` VALUES("199","62","_elementor_template_type","wp-post");
INSERT INTO `wp_postmeta` VALUES("200","62","_elementor_version","2.9.14");
INSERT INTO `wp_postmeta` VALUES("201","62","_elementor_data","[{\"id\":\"baa9d7e\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"%\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_title\":\"Section\",\"content_width\":{\"unit\":\"px\",\"size\":1300,\"sizes\":[]},\"layout\":\"full_width\",\"gap\":\"no\"},\"elements\":[{\"id\":\"e5ccf85\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null,\"margin\":{\"unit\":\"%\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_inline_size_tablet\":100,\"padding_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"padding\":{\"unit\":\"%\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[{\"id\":\"aee508f\",\"elType\":\"widget\",\"settings\":{\"title\":\"PHOTO SESSION\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":26,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"_margin_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"10\",\"left\":\"0\",\"isLinked\":false},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":26,\"sizes\":[]},\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":5,\"sizes\":[]},\"title_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"e99728e\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Two ghostly white figures in coveralls and helmets are softly dancing lorem ipsum.<\\/p>\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_line_height\":{\"unit\":\"px\",\"size\":37,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]},\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":422,\"sizes\":[]},\"text_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"fdcd757\",\"elType\":\"widget\",\"settings\":{\"editor\":\"Cras pretium metus pulvinar ultricies auctor. In varius purus blandit sem mollis tristique. Curabitur sed lorem vel ligula pulvinar porttitor. Proin sit amet mauris eleifend amet, ullamcorper lacus vangelis rich in heavy atoms.\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_line_height\":{\"unit\":\"px\",\"size\":35,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_element_custom_width\":{\"unit\":\"px\",\"size\":726},\"text_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"283d29a\",\"elType\":\"section\",\"settings\":{\"content_width\":{\"unit\":\"px\",\"size\":1300,\"sizes\":[]},\"layout\":\"full_width\",\"gap\":\"no\",\"margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false}},\"elements\":[{\"id\":\"2ad38cc\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"cc0d488\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/demo.cocobasic.com\\/ukko-wp\\/wp-content\\/uploads\\/2019\\/11\\/image_blog_01.jpg\",\"id\":155},\"_css_classes\":\"extra-width\"},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"3b4d9c4\",\"elType\":\"widget\",\"settings\":{\"editor\":\"Cras pretium metus pulvinar ultricies auctor. In varius purus blandit sem mollis tristique. Curabitur sed lorem vel ligula pulvinar porttitor proin.\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_line_height\":{\"unit\":\"px\",\"size\":35,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_element_custom_width\":{\"unit\":\"px\",\"size\":726},\"text_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"9b672d3\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/demo.cocobasic.com\\/ukko-wp\\/wp-content\\/uploads\\/2019\\/11\\/image_blog_02.jpg\",\"id\":162},\"_css_classes\":\"extra-width\"},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"91c9f15\",\"elType\":\"widget\",\"settings\":{\"editor\":\"Veleifend amet, ullamcorper lacus vangelis rich in heavy atoms descended from astronomers dream of the mind\\u2019s cras pretium metus pulvinar.\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_line_height\":{\"unit\":\"px\",\"size\":35,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_element_custom_width\":{\"unit\":\"px\",\"size\":726},\"text_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("202","62","_thumbnail_id","667");
INSERT INTO `wp_postmeta` VALUES("203","62","_elementor_controls_usage","a:5:{s:7:\"heading\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:4;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:13:\"section_title\";a:1:{s:5:\"title\";i:1;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:6:{s:21:\"typography_typography\";i:1;s:20:\"typography_font_size\";i:1;s:22:\"typography_font_weight\";i:1;s:22:\"typography_line_height\";i:1;s:25:\"typography_letter_spacing\";i:1;s:11:\"title_color\";i:1;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:2:{s:7:\"_margin\";i:1;s:14:\"_margin_mobile\";i:1;}}}}s:11:\"text-editor\";a:3:{s:5:\"count\";i:4;s:15:\"control_percent\";i:3;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:4;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:6:{s:21:\"typography_typography\";i:1;s:20:\"typography_font_size\";i:4;s:22:\"typography_line_height\";i:4;s:27:\"typography_font_size_mobile\";i:1;s:29:\"typography_line_height_mobile\";i:1;s:10:\"text_color\";i:4;}}s:8:\"advanced\";a:2:{s:17:\"_section_position\";a:2:{s:14:\"_element_width\";i:1;s:21:\"_element_custom_width\";i:4;}s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:3;}}}}s:6:\"column\";a:3:{s:5:\"count\";i:2;s:15:\"control_percent\";i:0;s:8:\"controls\";a:2:{s:6:\"layout\";a:1:{s:6:\"layout\";a:2:{s:12:\"_inline_size\";i:2;s:19:\"_inline_size_tablet\";i:1;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:3:{s:6:\"margin\";i:1;s:14:\"padding_mobile\";i:1;s:7:\"padding\";i:1;}}}}s:7:\"section\";a:3:{s:5:\"count\";i:2;s:15:\"control_percent\";i:1;s:8:\"controls\";a:2:{s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:2:{s:7:\"padding\";i:1;s:6:\"margin\";i:1;}}s:6:\"layout\";a:1:{s:14:\"section_layout\";a:4:{s:6:\"_title\";i:1;s:13:\"content_width\";i:2;s:6:\"layout\";i:2;s:3:\"gap\";i:2;}}}}s:5:\"image\";a:3:{s:5:\"count\";i:2;s:15:\"control_percent\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_image\";a:1:{s:5:\"image\";i:2;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:12:\"_css_classes\";i:2;}}}}}");
INSERT INTO `wp_postmeta` VALUES("725","62","portfolio_thumb_image_size","p_one_half");
INSERT INTO `wp_postmeta` VALUES("724","62","portfolio_hover_thumb_text","by using Django and web sockets");
INSERT INTO `wp_postmeta` VALUES("723","62","portfolio_hover_thumb_title","Simple live chat");
INSERT INTO `wp_postmeta` VALUES("208","65","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("209","65","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("210","65","_elementor_edit_mode","builder");
INSERT INTO `wp_postmeta` VALUES("211","65","_elementor_template_type","wp-post");
INSERT INTO `wp_postmeta` VALUES("212","65","_elementor_version","2.9.14");
INSERT INTO `wp_postmeta` VALUES("213","65","_elementor_data","[{\"id\":\"e52a549\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"%\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_title\":\"Section\",\"content_width\":{\"unit\":\"px\",\"size\":1300,\"sizes\":[]},\"layout\":\"full_width\",\"gap\":\"no\"},\"elements\":[{\"id\":\"0537d74\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null,\"margin\":{\"unit\":\"%\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_inline_size_tablet\":100,\"padding_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"padding\":{\"unit\":\"%\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[{\"id\":\"40d8abb\",\"elType\":\"widget\",\"settings\":{\"items\":[{\"title\":\"Slide 1\",\"_id\":\"67b8500\",\"img\":{\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2019\\/11\\/p_item_01.jpg\",\"id\":561},\"url\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\"},\"image_text\":\"\"},{\"title\":\"Slide 2\",\"_id\":\"cca4bfa\",\"img\":{\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2019\\/11\\/p_item_02.jpg\",\"id\":562},\"url\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\"},\"image_text\":\"\"},{\"title\":\"Slide 3\",\"_id\":\"d538858\",\"img\":{\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2019\\/11\\/p_item_03.jpg\",\"id\":560},\"url\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\"},\"image_text\":\"\"}],\"speed\":\"2000\",\"_css_classes\":\"extra-width\"},\"elements\":[],\"widgetType\":\"coco-imageslider\"},{\"id\":\"4a52a73\",\"elType\":\"widget\",\"settings\":{\"title\":\"ART OF CAMERA\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":26,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"20\",\"left\":\"0\",\"isLinked\":false},\"_margin_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"10\",\"left\":\"0\",\"isLinked\":false},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":26,\"sizes\":[]},\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":5,\"sizes\":[]},\"title_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"eb09794\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Two ghostly white figures in coveralls and helmets are softly dancing lorem ipsum.<\\/p>\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_line_height\":{\"unit\":\"px\",\"size\":33,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]},\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":422,\"sizes\":[]},\"text_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"c06997e\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Cras pretium metus pulvinar ultricies auctor. In varius purus blandit sem mollis tristique. Curabitur sed lorem vel ligula pulvinar porttitor. Proin sit amet mauris eleifend amet, ullamcorper lacus. Vangelis rich in heavy atoms descended from astronomers dream of the mind\\u2019s cras pretium metus.<\\/p>\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_line_height\":{\"unit\":\"px\",\"size\":35,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_element_custom_width\":{\"unit\":\"px\",\"size\":726},\"text_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("214","65","_thumbnail_id","671");
INSERT INTO `wp_postmeta` VALUES("780","65","_wp_old_slug","item-1__trashed");
INSERT INTO `wp_postmeta` VALUES("783","53","_edit_lock","1607033000:1");
INSERT INTO `wp_postmeta` VALUES("811","53","portfolio_hover_thumb_title","Max Gym system");
INSERT INTO `wp_postmeta` VALUES("812","53","portfolio_hover_thumb_text","By using Laravel");
INSERT INTO `wp_postmeta` VALUES("224","133","_elementor_controls_usage","a:0:{}");
INSERT INTO `wp_postmeta` VALUES("225","133","_elementor_controls_usage","a:0:{}");
INSERT INTO `wp_postmeta` VALUES("1776","843","_elementor_data","[{\"id\":\"3cda06bf\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"_title\":\"Home\",\"css_classes\":\"op-section\",\"gap\":\"no\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"_element_id\":\"home\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"structure\":\"20\"},\"elements\":[{\"id\":\"589a8709\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null,\"_inline_size_tablet\":40,\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#171321\"},\"elements\":[{\"id\":\"59838137\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":791,\"url\":\"https:\\/\\/amrelarabi.tech\\/wp-content\\/uploads\\/2020\\/12\\/me-2.jpg\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width_mobile\":{\"unit\":\"px\",\"size\":220,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"a8c012a\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null,\"content_position\":\"center\",\"_inline_size_tablet\":60,\"align_mobile\":\"flex-start\",\"margin_mobile\":{\"unit\":\"px\",\"top\":\"-20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding\":{\"unit\":\"%\",\"top\":\"0\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"5\",\"bottom\":\"13\",\"left\":\"5\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#171321\"},\"elements\":[{\"id\":\"3f957272\",\"elType\":\"widget\",\"settings\":{\"title\":\"Hello <br>I\\u2019m Amr <br>Elarabi\",\"header_size\":\"h1\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":100,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_line_height\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"_element_custom_width\":{\"unit\":\"px\",\"size\":430,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":66,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"title_color\":\"#FFFFFF\",\"align_mobile\":\"center\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"7ac381db\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>A full stack web developer.<\\/p>\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":430,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"10\",\"isLinked\":false},\"text_color\":\"#C2C2C2\"},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"160c4806\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-80,\"sizes\":[]},\"_offset_orientation_v\":\"end\",\"_offset_y_end\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"hide_mobile\":\"hidden-phone\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"3c2f0808\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"About\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"21\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"about\"},\"elements\":[{\"id\":\"4e2591d8\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#F393A4\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"570ae41d\",\"elType\":\"widget\",\"settings\":{\"title\":\"About\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"1a7fbc57\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"35fa5410\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>I\'m full stack web developer, I have advanced knowledge in PHP, Python and JavaScript.<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"4cd330f8\",\"elType\":\"section\",\"settings\":{\"structure\":\"20\",\"margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"gap\":\"no\",\"layout\":\"full_width\"},\"elements\":[{\"id\":\"2d15cbe9\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":57.496,\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"_inline_size_tablet\":100},\"elements\":[{\"id\":\"52896c2\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p><strong>NAME:<\\/strong> Amr Hemida Elarabi<br \\/><strong>ADDRESS:<\\/strong> Gharbia, Egypt<br \\/><strong>BIRTHDAY:<\\/strong> 07. 06. 1996<br \\/><strong>PHONE:<\\/strong> +201557797970<br \\/><strong>EMAIL:<\\/strong> me@amrelarabi.tech<\\/p>\",\"text_color\":\"#605777\",\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-30\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":true},{\"id\":\"177ba07f\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":42.228,\"background_background\":\"classic\",\"_inline_size_tablet\":100,\"margin_tablet\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"4ec03c3a\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":514,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_download_cv.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]},\"link\":{\"url\":\"https:\\/\\/amrelarabi.tech\\/wp-content\\/uploads\\/2020\\/12\\/Amr_Hemida_Elarabi.pdf\",\"is_external\":\"on\",\"nofollow\":\"on\",\"custom_attributes\":\"\"}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"4f9bfd94\",\"elType\":\"widget\",\"settings\":{\"title\":\"DOWNLOAD CV\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#605777\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"link\":{\"url\":\"https:\\/\\/amrelarabi.tech\\/wp-content\\/uploads\\/2020\\/12\\/Amr_Hemida_Elarabi.pdf\",\"is_external\":\"on\",\"nofollow\":\"on\",\"custom_attributes\":\"\"}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false}],\"isInner\":false},{\"id\":\"2d537bad\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Portfolio\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"portfolio\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"1659d356\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\"},\"elements\":[{\"id\":\"6298d834\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":-71.4,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":92,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"139ca579\",\"elType\":\"widget\",\"settings\":{\"num\":\"4\",\"all_text\":\"All\",\"loadmore_text\":\"LOAD MORE\",\"loadmore_loading_text\":\"LOADING\",\"loadmore_nomore_text\":\"NO MORE\",\"loadmore_text_color\":\"#F4F4F4\",\"loadmore_text_hover_color\":\"#BD6272\",\"_border_width\":{\"unit\":\"px\",\"top\":\"7\",\"right\":\"7\",\"bottom\":\"7\",\"left\":\"7\",\"isLinked\":true},\"_border_color\":\"#F43B3B\"},\"elements\":[],\"widgetType\":\"coco-portfolio\"}],\"isInner\":false},{\"id\":\"ff90d72\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"57569195\",\"elType\":\"widget\",\"settings\":{\"title\":\"Projects\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"48198d00\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Skills\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"skills\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"67f9096e\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"51c9fb72\",\"elType\":\"widget\",\"settings\":{\"items\":[{\"title\":\"Web development\",\"value\":\"90%\",\"_id\":\"847e789\"},{\"title\":\"Web Design\",\"value\":\"85%\",\"_id\":\"a746d00\"},{\"title\":\"Graphic Design\",\"value\":\"85%\",\"_id\":\"eb0f2b4\"},{\"title\":\"SEO\",\"value\":\"80%\",\"_id\":\"6c9cfda\"}],\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"coco-skills-lines\"}],\"isInner\":false},{\"id\":\"696e0f2e\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#7E5A7B\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"48629353\",\"elType\":\"widget\",\"settings\":{\"title\":\"Skills\\u200b\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"1380b9f8\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":522,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/circle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-up-down\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":100,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-60,\"sizes\":[]},\"_offset_orientation_v\":\"end\",\"_offset_y_end\":{\"unit\":\"px\",\"size\":120,\"sizes\":[]},\"hide_mobile\":\"hidden-phone\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"5efece0a\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Services\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"30\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"css_classes\":\"op-section\"},\"elements\":[{\"id\":\"3bf8e8c5\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#7E5A7B\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"1fa5932f\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":515,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_preciese.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"29d71208\",\"elType\":\"widget\",\"settings\":{\"title\":\"BEST CODE PRACTICES\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#F8F3F7\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"75748f10\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#F393A4\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"42a1232c\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-75,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":-71.4,\"sizes\":[]},\"_offset_y\":{\"size\":-55,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":92,\"sizes\":[]},\"hide_mobile\":\"hidden-phone\"},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"abf718c\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":517,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_secure.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"645fc856\",\"elType\":\"widget\",\"settings\":{\"title\":\"SECURE WEB APPS\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#F8F3F7\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"3785904d\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"e2c591c\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":516,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_responsive.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"4a108d1e\",\"elType\":\"widget\",\"settings\":{\"title\":\"RESPONSIVE DESIGNS\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#F8F3F7\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"4616d8f\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Education\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"education\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"483cd999\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"30\",\"isLinked\":false}},\"elements\":[{\"id\":\"76b9110\",\"elType\":\"widget\",\"settings\":{\"items\":[{\"title\":\"<b>High School<\\/b> \\n\",\"_id\":\"291265d\",\"year\":\"2014\"},{\"title\":\"<b>University Education<\\/b> \\n\\n<br> \\n\\nI have graduated from Faculty of Engineering Tanta University Computer and Control department.\",\"year\":\"2019\",\"_id\":\"fece03c\"}],\"content_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"coco-timeline\"}],\"isInner\":false},{\"id\":\"5cf8d351\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"010\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#F393A4\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"1ff21d9b\",\"elType\":\"widget\",\"settings\":{\"title\":\"Education\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"705ff71b\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_orientation_h\":\"end\",\"_offset_orientation_v\":\"end\",\"hide_mobile\":\"hidden-phone\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"46d2c91\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Facts\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"facts\"},\"elements\":[{\"id\":\"06271c5\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"3f38a91\",\"elType\":\"widget\",\"settings\":{\"title\":\"Programming <br>\\nLanguages & Frameworks\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"971a1d5\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_orientation_h\":\"end\",\"_offset_orientation_v\":\"end\",\"hide_mobile\":\"hidden-phone\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"9cd6740\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"3c96c5b\",\"elType\":\"section\",\"settings\":{\"structure\":\"30\"},\"elements\":[{\"id\":\"154ea2d\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"7eed9c5\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fab fa-php\",\"library\":\"fa-brands\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"1728a16\",\"elType\":\"widget\",\"settings\":{\"title\":\"PHP\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true},{\"id\":\"8c3eaae\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"abe93a1\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fab fa-laravel\",\"library\":\"fa-brands\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"bc1d01b\",\"elType\":\"widget\",\"settings\":{\"title\":\"Laravel\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true},{\"id\":\"3b6a4c7\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"e634841\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fab fa-wordpress\",\"library\":\"fa-brands\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"6f58865\",\"elType\":\"widget\",\"settings\":{\"title\":\"Wordpress\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"673b900\",\"elType\":\"section\",\"settings\":{\"structure\":\"30\",\"margin\":{\"unit\":\"px\",\"top\":\"20\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false}},\"elements\":[{\"id\":\"a5e3065\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"923b4f2\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fab fa-python\",\"library\":\"fa-brands\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"269ebc6\",\"elType\":\"widget\",\"settings\":{\"title\":\"Python\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true},{\"id\":\"a248263\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"a32a5c6\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":{\"url\":\"https:\\/\\/amrelarabi.tech\\/wp-content\\/uploads\\/2020\\/12\\/custom_django-2.svg\",\"id\":619},\"library\":\"svg\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"8c4020b\",\"elType\":\"widget\",\"settings\":{\"title\":\"Django\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true},{\"id\":\"c4dbc7e\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"0f4d1d8\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-database\",\"library\":\"fa-solid\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"d41cf4f\",\"elType\":\"widget\",\"settings\":{\"title\":\"MySQL\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"bc03d11\",\"elType\":\"section\",\"settings\":{\"structure\":\"30\",\"margin\":{\"unit\":\"px\",\"top\":\"20\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false}},\"elements\":[{\"id\":\"31abe8a\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"110a9b9\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fab fa-html5\",\"library\":\"fa-brands\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"036ede4\",\"elType\":\"widget\",\"settings\":{\"title\":\"HTML5\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true},{\"id\":\"5e0cb11\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"06743bc\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fab fa-js-square\",\"library\":\"fa-brands\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"d034cd1\",\"elType\":\"widget\",\"settings\":{\"title\":\"JavaScript\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true},{\"id\":\"f1f5364\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"d5fd2de\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fab fa-vuejs\",\"library\":\"fa-brands\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"08b2245\",\"elType\":\"widget\",\"settings\":{\"title\":\"VueJS\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"eb2b737\",\"elType\":\"section\",\"settings\":{\"structure\":\"30\",\"margin\":{\"unit\":\"px\",\"top\":\"20\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false}},\"elements\":[{\"id\":\"6aeb206\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"839c0fb\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fab fa-bootstrap\",\"library\":\"fa-brands\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"0824b1c\",\"elType\":\"widget\",\"settings\":{\"title\":\"Bootstrap\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true},{\"id\":\"178ccd3\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"33bbfc5\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fab fa-sass\",\"library\":\"fa-brands\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"481538d\",\"elType\":\"widget\",\"settings\":{\"title\":\"SASS\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true},{\"id\":\"dafebf9\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"983b5e8\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fab fa-css3\",\"library\":\"fa-brands\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"3c029ef\",\"elType\":\"widget\",\"settings\":{\"title\":\"CSS3\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false}],\"isInner\":false},{\"id\":\"95591c7\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Facts\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]}},\"elements\":[{\"id\":\"75389a3\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#F393A4\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"232fbf8\",\"elType\":\"widget\",\"settings\":{\"title\":\"Others\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"c284472\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_orientation_v\":\"end\",\"_offset_orientation_h\":\"end\",\"hide_mobile\":\"hidden-phone\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"d38c926\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"f8f514b\",\"elType\":\"widget\",\"settings\":{\"icon_list\":[{\"text\":\"Git & Github\",\"_id\":\"725139e\"},{\"text\":\"Photoshop\",\"_id\":\"068f734\"},{\"_id\":\"7b53edf\",\"text\":\"SEO\"},{\"_id\":\"49cfb0a\",\"text\":\"Database Design & ORM\"},{\"text\":\"OOP\",\"_id\":\"4121fee\"},{\"text\":\"API\",\"_id\":\"2bfd4f9\"},{\"text\":\"MVC\",\"_id\":\"176c999\"},{\"text\":\"DOCKER\",\"_id\":\"52a018d\"},{\"text\":\"cPanel & Web hosting\",\"_id\":\"0f7b1f2\"}],\"icon_color\":\"#F393A4\",\"icon_typography_typography\":\"custom\",\"icon_typography_font_family\":\"Roboto\",\"icon_typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"icon_typography_font_weight\":\"400\"},\"elements\":[],\"widgetType\":\"icon-list\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"b93f393\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Experience\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"experience\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"12ba158\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#DBCBD9\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"ac823f1\",\"elType\":\"widget\",\"settings\":{\"tabs\":[{\"tab_title\":\"Freelancer WordPress Developer\",\"tab_content\":\"<strong>2017 - 2019<\\/strong>\\n<ul>\\n \\t<li>Designed and Developed WordPress custom themes.<\\/li>\\n \\t<li>Developed WordPress custom plugins.<\\/li>\\n \\t<li>Performed modifications on existing WordPress websites<\\/li>\\n<\\/ul>\",\"_id\":\"024a8c4\"},{\"tab_title\":\"Django Developer at Egyptian Armed Forces\",\"tab_content\":\"<strong>Dec 2019 - Nov 2020<\\/strong>\\n\\n<ul>\\n \\t<li>Developed A Django system to handle data of enlistees and units, generate PDF statistical reports (ReportLab), handle archive.<\\/li>\\n \\t<li>Worked on IIS server, PostgreSQL.<\\/li>\\n<\\/ul>\",\"_id\":\"8a56075\"}],\"selected_icon\":{\"value\":\"fas fa-caret-down\",\"library\":\"fa-solid\"},\"border_width\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"space_between\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"title_background\":\"#605777\",\"title_color\":\"#FFFFFF\",\"tab_active_color\":\"#FFFFFF\",\"icon_align\":\"right\",\"content_background_color\":\"#FFFFFF\",\"content_typography_line_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"content_padding\":{\"unit\":\"px\",\"top\":\"23\",\"right\":\"25\",\"bottom\":\"23\",\"left\":\"25\",\"isLinked\":false},\"content_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"toggle\"}],\"isInner\":false},{\"id\":\"fcc60c8\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#7E5A7B\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"e119716\",\"elType\":\"widget\",\"settings\":{\"title\":\"Experience\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"640cc2f\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":522,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/circle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-up-down\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":100,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-60,\"sizes\":[]},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_x\":{\"unit\":\"px\",\"size\":-45,\"sizes\":[]},\"hide_mobile\":\"hidden-phone\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"da7ba6b\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Contact\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"21\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"contact\"},\"elements\":[{\"id\":\"78db0d70\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"4cfc3491\",\"elType\":\"widget\",\"settings\":{\"title\":\"Contact\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"2a567e6\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-30,\"sizes\":[]},\"_offset_y_end\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"_offset_y\":{\"unit\":\"px\",\"size\":90,\"sizes\":[]},\"hide_mobile\":\"hidden-phone\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"359bfd64\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"3cb74d82\",\"elType\":\"widget\",\"settings\":{\"contactform\":\"[contact-form-7 id=\\\"336\\\" title=\\\"Teoro Contact Form\\\"]\",\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"content_color\":\"#605777\",\"send_button_hover_color\":\"#FFFFFF\",\"_margin_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true}},\"elements\":[],\"widgetType\":\"coco-contactform\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"4a058d0\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Education\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"708847e\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"50\",\"right\":\"10\",\"bottom\":\"50\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#403756\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"497035a\",\"elType\":\"widget\",\"settings\":{\"social_icon_list\":[{\"social_icon\":{\"value\":\"fab fa-github\",\"library\":\"fa-brands\"},\"_id\":\"a5bdd0b\",\"link\":{\"url\":\"https:\\/\\/github.com\\/amrelarabi\",\"is_external\":\"true\",\"nofollow\":\"\",\"custom_attributes\":\"\"}},{\"social_icon\":{\"value\":\"fab fa-linkedin\",\"library\":\"fa-brands\"},\"_id\":\"09030b6\",\"link\":{\"url\":\"https:\\/\\/www.linkedin.com\\/in\\/amr-elarabi\\/\",\"is_external\":\"true\",\"nofollow\":\"\",\"custom_attributes\":\"\"}},{\"_id\":\"430a288\",\"social_icon\":{\"value\":\"fab fa-behance\",\"library\":\"fa-brands\"},\"link\":{\"url\":\"https:\\/\\/www.behance.net\\/amr-elarabi\\/\",\"is_external\":\"true\",\"nofollow\":\"\",\"custom_attributes\":\"\"}}]},\"elements\":[],\"widgetType\":\"social-icons\"},{\"id\":\"c0f81fa\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/amrelarabi.tech\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_orientation_h\":\"end\",\"_offset_orientation_v\":\"end\",\"hide_mobile\":\"hidden-phone\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("237","181","_elementor_edit_mode","builder");
INSERT INTO `wp_postmeta` VALUES("238","181","_elementor_template_type","wp-page");
INSERT INTO `wp_postmeta` VALUES("239","181","_elementor_version","3.1.4");
INSERT INTO `wp_postmeta` VALUES("240","181","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("241","181","_wp_page_template","onepage.php");
INSERT INTO `wp_postmeta` VALUES("242","181","_elementor_data","[{\"id\":\"3cda06bf\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"_title\":\"Home\",\"css_classes\":\"op-section\",\"gap\":\"no\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"_element_id\":\"home\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"structure\":\"20\"},\"elements\":[{\"id\":\"589a8709\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null,\"_inline_size_tablet\":40,\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#171321\"},\"elements\":[{\"id\":\"59838137\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":791,\"url\":\"https:\\/\\/amrelarabi.tech\\/wp-content\\/uploads\\/2020\\/12\\/me-2.jpg\"},\"image_size\":\"full\",\"align_mobile\":\"center\",\"width_mobile\":{\"unit\":\"px\",\"size\":220,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"a8c012a\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null,\"content_position\":\"center\",\"_inline_size_tablet\":60,\"align_mobile\":\"flex-start\",\"margin_mobile\":{\"unit\":\"px\",\"top\":\"-20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding\":{\"unit\":\"%\",\"top\":\"0\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"5\",\"bottom\":\"13\",\"left\":\"5\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#171321\"},\"elements\":[{\"id\":\"3f957272\",\"elType\":\"widget\",\"settings\":{\"title\":\"Hello <br>I\\u2019m Amr <br>Elarabi\",\"header_size\":\"h1\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":100,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_line_height\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"_element_custom_width\":{\"unit\":\"px\",\"size\":430,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":66,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"title_color\":\"#FFFFFF\",\"align_mobile\":\"center\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"7ac381db\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>A full stack web developer.<\\/p>\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":430,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"10\",\"isLinked\":false},\"text_color\":\"#C2C2C2\"},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"160c4806\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-80,\"sizes\":[]},\"_offset_orientation_v\":\"end\",\"_offset_y_end\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"hide_mobile\":\"hidden-phone\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"3c2f0808\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"About\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"21\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"about\"},\"elements\":[{\"id\":\"4e2591d8\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#F393A4\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"570ae41d\",\"elType\":\"widget\",\"settings\":{\"title\":\"About\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"1a7fbc57\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"35fa5410\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>I\'m full stack web developer, I have advanced knowledge in PHP, Python and JavaScript.<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"4cd330f8\",\"elType\":\"section\",\"settings\":{\"structure\":\"22\",\"margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"gap\":\"no\",\"layout\":\"full_width\"},\"elements\":[{\"id\":\"2d15cbe9\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"_inline_size_tablet\":100},\"elements\":[{\"id\":\"52896c2\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p><strong>NAME:<\\/strong> Amr Hemida Elarabi<br \\/><strong>ADDRESS:<\\/strong> Cairo, Egypt<br \\/><strong>BIRTHDAY:<\\/strong> 07. 06. 1996<br \\/><strong>PHONE:<\\/strong> +201557797970<br \\/><strong>EMAIL:<\\/strong> contact@amrelarabi.com<\\/p>\",\"text_color\":\"#605777\",\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-30\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":true},{\"id\":\"177ba07f\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"background_background\":\"classic\",\"_inline_size_tablet\":100,\"margin_tablet\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"4ec03c3a\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":514,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_download_cv.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]},\"link\":{\"url\":\"\\/wp-content\\/uploads\\/2022\\/01\\/Amr-Abd-Elkarem.pdf\",\"is_external\":\"on\",\"nofollow\":\"on\",\"custom_attributes\":\"\"}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"4f9bfd94\",\"elType\":\"widget\",\"settings\":{\"title\":\"DOWNLOAD CV\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#605777\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"link\":{\"url\":\"https:\\/\\/amrelarabi.tech\\/wp-content\\/uploads\\/2021\\/01\\/Amr-Abd-Elkarem.pdf\",\"is_external\":\"on\",\"nofollow\":\"on\",\"custom_attributes\":\"\"}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false}],\"isInner\":false},{\"id\":\"2d537bad\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Portfolio\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"portfolio\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"1659d356\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\"},\"elements\":[{\"id\":\"6298d834\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":-71.4,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":92,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"139ca579\",\"elType\":\"widget\",\"settings\":{\"num\":\"4\",\"all_text\":\"All\",\"loadmore_text\":\"LOAD MORE\",\"loadmore_loading_text\":\"LOADING\",\"loadmore_nomore_text\":\"NO MORE\",\"loadmore_text_color\":\"#F4F4F4\",\"loadmore_text_hover_color\":\"#BD6272\",\"_border_width\":{\"unit\":\"px\",\"top\":\"7\",\"right\":\"7\",\"bottom\":\"7\",\"left\":\"7\",\"isLinked\":true},\"_border_color\":\"#F43B3B\"},\"elements\":[],\"widgetType\":\"coco-portfolio\"}],\"isInner\":false},{\"id\":\"ff90d72\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"57569195\",\"elType\":\"widget\",\"settings\":{\"title\":\"Projects\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"48198d00\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Skills\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"skills\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"67f9096e\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"51c9fb72\",\"elType\":\"widget\",\"settings\":{\"items\":[{\"title\":\"Web development\",\"value\":\"90%\",\"_id\":\"847e789\"},{\"title\":\"Web Design\",\"value\":\"85%\",\"_id\":\"a746d00\"},{\"title\":\"Graphic Design\",\"value\":\"85%\",\"_id\":\"eb0f2b4\"},{\"title\":\"SEO\",\"value\":\"80%\",\"_id\":\"6c9cfda\"}],\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"coco-skills-lines\"}],\"isInner\":false},{\"id\":\"696e0f2e\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#7E5A7B\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"48629353\",\"elType\":\"widget\",\"settings\":{\"title\":\"Skills\\u200b\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"1380b9f8\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":522,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/circle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-up-down\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":100,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-60,\"sizes\":[]},\"_offset_orientation_v\":\"end\",\"_offset_y_end\":{\"unit\":\"px\",\"size\":120,\"sizes\":[]},\"hide_mobile\":\"hidden-phone\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"5efece0a\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Services\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"30\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"css_classes\":\"op-section\"},\"elements\":[{\"id\":\"3bf8e8c5\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#7E5A7B\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"1fa5932f\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":515,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_preciese.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"29d71208\",\"elType\":\"widget\",\"settings\":{\"title\":\"BEST CODE PRACTICES\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#F8F3F7\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"75748f10\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#F393A4\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"42a1232c\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-75,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":-71.4,\"sizes\":[]},\"_offset_y\":{\"size\":-55,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":92,\"sizes\":[]},\"hide_mobile\":\"hidden-phone\"},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"abf718c\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":517,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_secure.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"645fc856\",\"elType\":\"widget\",\"settings\":{\"title\":\"SECURE WEB APPS\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#F8F3F7\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"3785904d\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"e2c591c\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":516,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_responsive.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"4a108d1e\",\"elType\":\"widget\",\"settings\":{\"title\":\"RESPONSIVE DESIGNS\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#F8F3F7\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"4616d8f\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Education\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"education\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"483cd999\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"30\",\"isLinked\":false}},\"elements\":[{\"id\":\"76b9110\",\"elType\":\"widget\",\"settings\":{\"items\":[{\"title\":\"<b>High School<\\/b> \\n\",\"_id\":\"291265d\",\"year\":\"2014\"},{\"title\":\"<b>University Education<\\/b> \\n\\n<br> \\n\\nI have graduated from Faculty of Engineering Tanta University Computer and Control department.\",\"year\":\"2019\",\"_id\":\"fece03c\"}],\"content_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"coco-timeline\"}],\"isInner\":false},{\"id\":\"5cf8d351\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"010\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#F393A4\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"1ff21d9b\",\"elType\":\"widget\",\"settings\":{\"title\":\"Education\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"705ff71b\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_orientation_h\":\"end\",\"_offset_orientation_v\":\"end\",\"hide_mobile\":\"hidden-phone\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"46d2c91\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Facts\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"facts\"},\"elements\":[{\"id\":\"06271c5\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"3f38a91\",\"elType\":\"widget\",\"settings\":{\"title\":\"Programming <br>\\nLanguages & Frameworks\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"971a1d5\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_orientation_h\":\"end\",\"_offset_orientation_v\":\"end\",\"hide_mobile\":\"hidden-phone\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"9cd6740\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"3c96c5b\",\"elType\":\"section\",\"settings\":{\"structure\":\"30\"},\"elements\":[{\"id\":\"154ea2d\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"7eed9c5\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fab fa-php\",\"library\":\"fa-brands\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"1728a16\",\"elType\":\"widget\",\"settings\":{\"title\":\"PHP\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true},{\"id\":\"8c3eaae\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"abe93a1\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fab fa-laravel\",\"library\":\"fa-brands\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"bc1d01b\",\"elType\":\"widget\",\"settings\":{\"title\":\"Laravel\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true},{\"id\":\"3b6a4c7\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"e634841\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fab fa-wordpress\",\"library\":\"fa-brands\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"6f58865\",\"elType\":\"widget\",\"settings\":{\"title\":\"Wordpress\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"673b900\",\"elType\":\"section\",\"settings\":{\"structure\":\"30\",\"margin\":{\"unit\":\"px\",\"top\":\"20\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false}},\"elements\":[{\"id\":\"a5e3065\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"923b4f2\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fab fa-python\",\"library\":\"fa-brands\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"269ebc6\",\"elType\":\"widget\",\"settings\":{\"title\":\"Python\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true},{\"id\":\"a248263\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"a32a5c6\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":{\"url\":\"https:\\/\\/amrelarabi.tech\\/wp-content\\/uploads\\/2020\\/12\\/custom_django-2.svg\",\"id\":619},\"library\":\"svg\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"8c4020b\",\"elType\":\"widget\",\"settings\":{\"title\":\"Django\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true},{\"id\":\"c4dbc7e\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"0f4d1d8\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-database\",\"library\":\"fa-solid\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"d41cf4f\",\"elType\":\"widget\",\"settings\":{\"title\":\"MySQL\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"bc03d11\",\"elType\":\"section\",\"settings\":{\"structure\":\"30\",\"margin\":{\"unit\":\"px\",\"top\":\"20\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false}},\"elements\":[{\"id\":\"31abe8a\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"110a9b9\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fab fa-html5\",\"library\":\"fa-brands\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"036ede4\",\"elType\":\"widget\",\"settings\":{\"title\":\"HTML5\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true},{\"id\":\"5e0cb11\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"06743bc\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fab fa-js-square\",\"library\":\"fa-brands\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"d034cd1\",\"elType\":\"widget\",\"settings\":{\"title\":\"JavaScript\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true},{\"id\":\"f1f5364\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"d5fd2de\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fab fa-vuejs\",\"library\":\"fa-brands\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"08b2245\",\"elType\":\"widget\",\"settings\":{\"title\":\"VueJS\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"eb2b737\",\"elType\":\"section\",\"settings\":{\"structure\":\"30\",\"margin\":{\"unit\":\"px\",\"top\":\"20\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false}},\"elements\":[{\"id\":\"6aeb206\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"839c0fb\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fab fa-bootstrap\",\"library\":\"fa-brands\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"0824b1c\",\"elType\":\"widget\",\"settings\":{\"title\":\"Bootstrap\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true},{\"id\":\"178ccd3\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"33bbfc5\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fab fa-sass\",\"library\":\"fa-brands\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"481538d\",\"elType\":\"widget\",\"settings\":{\"title\":\"SASS\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true},{\"id\":\"dafebf9\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"983b5e8\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fab fa-css3\",\"library\":\"fa-brands\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"3c029ef\",\"elType\":\"widget\",\"settings\":{\"title\":\"CSS3\",\"align\":\"center\",\"title_color\":\"#605777\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Roboto\",\"typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"typography_font_weight\":\"600\",\"_animation\":\"fadeIn\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false}],\"isInner\":false},{\"id\":\"95591c7\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Facts\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]}},\"elements\":[{\"id\":\"75389a3\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#F393A4\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"232fbf8\",\"elType\":\"widget\",\"settings\":{\"title\":\"Others\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"c284472\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_orientation_v\":\"end\",\"_offset_orientation_h\":\"end\",\"hide_mobile\":\"hidden-phone\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"d38c926\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"f8f514b\",\"elType\":\"widget\",\"settings\":{\"icon_list\":[{\"text\":\"Git & Github\",\"_id\":\"725139e\"},{\"text\":\"Photoshop\",\"_id\":\"068f734\"},{\"_id\":\"7b53edf\",\"text\":\"SEO\"},{\"_id\":\"49cfb0a\",\"text\":\"Database Design & ORM\"},{\"text\":\"OOP\",\"_id\":\"4121fee\"},{\"text\":\"API\",\"_id\":\"2bfd4f9\"},{\"text\":\"MVC\",\"_id\":\"176c999\"},{\"text\":\"DOCKER\",\"_id\":\"52a018d\"},{\"text\":\"cPanel & Web hosting\",\"_id\":\"0f7b1f2\"},{\"_id\":\"ac2f7f6\",\"text\":\"App development using Flutter\"}],\"icon_color\":\"#F393A4\",\"icon_typography_typography\":\"custom\",\"icon_typography_font_family\":\"Roboto\",\"icon_typography_font_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"icon_typography_font_weight\":\"400\"},\"elements\":[],\"widgetType\":\"icon-list\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"b93f393\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Experience\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"experience\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"12ba158\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#DBCBD9\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"ac823f1\",\"elType\":\"widget\",\"settings\":{\"tabs\":[{\"_id\":\"3280426\",\"tab_title\":\"Full stack web developer at WP-Spins\",\"tab_content\":\"<p><strong style=\\\"font-size: 15px; font-family: var( --e-global-typography-text-font-family ), Sans-serif;\\\">May 2020 - Now<\\/strong><\\/p><ul><li>Developed custom WordPress plugins.<\\/li><li>Customize and maintain exist WordPress themes and Plugins.<\\/li><\\/ul>\"},{\"_id\":\"b510b6b\",\"tab_title\":\"Full Stack PHP Developer at JMI\",\"tab_content\":\"<p><strong>Jan 2020 - May 2020<\\/strong><\\/p><ul><li>Responsible of building PHP solutions using Laravel, Wordpress and Native PHP.<\\/li><\\/ul>\"},{\"tab_title\":\"Django Developer at Egyptian Armed Forces\",\"tab_content\":\"<p><strong>Dec 2019 - Nov 2020<\\/strong><\\/p><ul><li>Developed A Django system to handle data of enlistees and units, generate PDF statistical reports (ReportLab), handle archive.<\\/li><li>Worked on IIS server, PostgreSQL.<\\/li><\\/ul>\",\"_id\":\"8a56075\"},{\"tab_title\":\"Freelancer WordPress Developer\",\"tab_content\":\"<strong>2017 - 2019<\\/strong>\\n<ul>\\n \\t<li>Designed and Developed WordPress custom themes.<\\/li>\\n \\t<li>Developed WordPress custom plugins.<\\/li>\\n \\t<li>Performed modifications on existing WordPress websites<\\/li>\\n<\\/ul>\",\"_id\":\"024a8c4\"}],\"selected_icon\":{\"value\":\"fas fa-caret-down\",\"library\":\"fa-solid\"},\"border_width\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"space_between\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"title_background\":\"#605777\",\"title_color\":\"#FFFFFF\",\"tab_active_color\":\"#FFFFFF\",\"icon_align\":\"right\",\"content_background_color\":\"#FFFFFF\",\"content_typography_line_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"content_padding\":{\"unit\":\"px\",\"top\":\"23\",\"right\":\"25\",\"bottom\":\"23\",\"left\":\"25\",\"isLinked\":false},\"content_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"toggle\"}],\"isInner\":false},{\"id\":\"fcc60c8\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#7E5A7B\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"e119716\",\"elType\":\"widget\",\"settings\":{\"title\":\"Experience\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"640cc2f\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":522,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/circle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-up-down\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":100,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-60,\"sizes\":[]},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_x\":{\"unit\":\"px\",\"size\":-45,\"sizes\":[]},\"hide_mobile\":\"hidden-phone\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"da7ba6b\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Contact\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"21\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"contact\"},\"elements\":[{\"id\":\"78db0d70\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"4cfc3491\",\"elType\":\"widget\",\"settings\":{\"title\":\"Contact\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"2a567e6\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-30,\"sizes\":[]},\"_offset_y_end\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"_offset_y\":{\"unit\":\"px\",\"size\":90,\"sizes\":[]},\"hide_mobile\":\"hidden-phone\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"359bfd64\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"3cb74d82\",\"elType\":\"widget\",\"settings\":{\"contactform\":\"[contact-form-7 id=\\\"336\\\" title=\\\"Teoro Contact Form\\\"]\",\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"content_color\":\"#605777\",\"send_button_hover_color\":\"#FFFFFF\",\"_margin_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true}},\"elements\":[],\"widgetType\":\"coco-contactform\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"4a058d0\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Education\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"708847e\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"50\",\"right\":\"10\",\"bottom\":\"50\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#403756\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"497035a\",\"elType\":\"widget\",\"settings\":{\"social_icon_list\":[{\"social_icon\":{\"value\":\"fab fa-github\",\"library\":\"fa-brands\"},\"_id\":\"a5bdd0b\",\"link\":{\"url\":\"https:\\/\\/github.com\\/amrelarabi\",\"is_external\":\"true\",\"nofollow\":\"\",\"custom_attributes\":\"\"}},{\"social_icon\":{\"value\":\"fab fa-linkedin\",\"library\":\"fa-brands\"},\"_id\":\"09030b6\",\"link\":{\"url\":\"https:\\/\\/www.linkedin.com\\/in\\/amr-elarabi\\/\",\"is_external\":\"true\",\"nofollow\":\"\",\"custom_attributes\":\"\"}},{\"_id\":\"430a288\",\"social_icon\":{\"value\":\"fab fa-behance\",\"library\":\"fa-brands\"},\"link\":{\"url\":\"https:\\/\\/www.behance.net\\/amr-elarabi\\/\",\"is_external\":\"true\",\"nofollow\":\"\",\"custom_attributes\":\"\"}}]},\"elements\":[],\"widgetType\":\"social-icons\"},{\"id\":\"c0f81fa\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/amrelarabi.tech\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_orientation_h\":\"end\",\"_offset_orientation_v\":\"end\",\"hide_mobile\":\"hidden-phone\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("399","614","_elementor_edit_mode","builder");
INSERT INTO `wp_postmeta` VALUES("400","614","_elementor_template_type","wp-page");
INSERT INTO `wp_postmeta` VALUES("401","614","_elementor_version","3.0.14");
INSERT INTO `wp_postmeta` VALUES("402","614","_wp_page_template","onepage.php");
INSERT INTO `wp_postmeta` VALUES("403","614","_elementor_data","[{\"id\":\"3cda06bf\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"_title\":\"Home\",\"css_classes\":\"op-section\",\"gap\":\"no\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"_element_id\":\"home\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"structure\":\"20\"},\"elements\":[{\"id\":\"589a8709\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null,\"_inline_size_tablet\":40,\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"content_position\":\"center\"},\"elements\":[{\"id\":\"59838137\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":597,\"url\":\"https:\\/\\/amrelarabi.tech\\/wp-content\\/uploads\\/2020\\/12\\/me-1.jpg\"},\"image_size\":\"full\",\"align_mobile\":\"left\",\"width_mobile\":{\"unit\":\"px\",\"size\":220,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"a8c012a\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null,\"content_position\":\"center\",\"_inline_size_tablet\":60,\"align_mobile\":\"flex-start\",\"margin_mobile\":{\"unit\":\"px\",\"top\":\"-20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding\":{\"unit\":\"%\",\"top\":\"10\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"5\",\"bottom\":\"13\",\"left\":\"5\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"3f957272\",\"elType\":\"widget\",\"settings\":{\"title\":\"Hello <br>I\\u2019m Amr <br>Elarabi\",\"header_size\":\"h1\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":100,\"sizes\":[]},\"typography_font_weight\":\"200\",\"typography_line_height\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"_element_custom_width\":{\"unit\":\"px\",\"size\":430,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":66,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"7ac381db\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>A full stack web developer.<\\/p>\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":430,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"160c4806\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-80,\"sizes\":[]},\"_offset_orientation_v\":\"end\",\"_offset_y_end\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"3c2f0808\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"About\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"21\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"about\"},\"elements\":[{\"id\":\"4e2591d8\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#F393A4\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"570ae41d\",\"elType\":\"widget\",\"settings\":{\"title\":\"About\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"1a7fbc57\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"35fa5410\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>I\'m full stack web developer, I have advanced knowledge in PHP, Python and JavaScript.<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"4cd330f8\",\"elType\":\"section\",\"settings\":{\"structure\":\"20\",\"margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"gap\":\"no\",\"layout\":\"full_width\"},\"elements\":[{\"id\":\"2d15cbe9\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":57.496,\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"_inline_size_tablet\":100},\"elements\":[{\"id\":\"52896c2\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p><strong>NAME:<\\/strong> Amr Hemida Elarabi<br \\/><strong>CITY:<\\/strong> Gharbia, Egypt<br \\/><strong>BIRTHDAY:<\\/strong> 07. 06. 1996<br \\/><strong>PHONE:<\\/strong> +201557797970<br \\/><strong>EMAIL:<\\/strong> me@amrelarabi.tech<br \\/><strong>WEBSITE:<\\/strong> amrelarabi.tech<\\/p>\",\"text_color\":\"#605777\",\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-30\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":true},{\"id\":\"177ba07f\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":42.228,\"background_background\":\"classic\",\"_inline_size_tablet\":100,\"margin_tablet\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"4ec03c3a\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":514,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_download_cv.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]},\"link\":{\"url\":\"https:\\/\\/amrelarabi.tech\\/wp-content\\/uploads\\/2020\\/12\\/Amr_Hemida_Elarabi.pdf\",\"is_external\":\"on\",\"nofollow\":\"on\",\"custom_attributes\":\"\"}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"4f9bfd94\",\"elType\":\"widget\",\"settings\":{\"title\":\"DOWNLOAD CV\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#605777\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"link\":{\"url\":\"https:\\/\\/demo.cocobasic.com\\/documentation\\/MANUAL-TeoroWP.pdf\",\"is_external\":\"on\",\"nofollow\":\"on\",\"custom_attributes\":\"\"}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false}],\"isInner\":false},{\"id\":\"2d537bad\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Portfolio\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"portfolio\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"1659d356\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\"},\"elements\":[{\"id\":\"6298d834\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":-71.4,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":92,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"139ca579\",\"elType\":\"widget\",\"settings\":{\"num\":\"4\",\"all_text\":\"All\",\"loadmore_text\":\"LOAD MORE\",\"loadmore_loading_text\":\"LOADING\",\"loadmore_nomore_text\":\"NO MORE\",\"loadmore_text_color\":\"#F4F4F4\",\"loadmore_text_hover_color\":\"#BD6272\"},\"elements\":[],\"widgetType\":\"coco-portfolio\"}],\"isInner\":false},{\"id\":\"ff90d72\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"57569195\",\"elType\":\"widget\",\"settings\":{\"title\":\"Portfolio\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"48198d00\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Skills\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"skills\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"67f9096e\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"51c9fb72\",\"elType\":\"widget\",\"settings\":{\"items\":[{\"title\":\"Web development\",\"value\":\"90%\",\"_id\":\"847e789\"},{\"title\":\"Web Design\",\"value\":\"85%\",\"_id\":\"a746d00\"},{\"title\":\"Graphic Design\",\"value\":\"85%\",\"_id\":\"eb0f2b4\"},{\"title\":\"SEO\",\"value\":\"80%\",\"_id\":\"6c9cfda\"}],\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"coco-skills-lines\"}],\"isInner\":false},{\"id\":\"696e0f2e\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#7E5A7B\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"48629353\",\"elType\":\"widget\",\"settings\":{\"title\":\"Skills\\u200b\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"1380b9f8\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":522,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/circle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-up-down\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":100,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-60,\"sizes\":[]},\"_offset_orientation_v\":\"end\",\"_offset_y_end\":{\"unit\":\"px\",\"size\":120,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"5efece0a\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Services\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"30\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"css_classes\":\"op-section\"},\"elements\":[{\"id\":\"3bf8e8c5\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#7E5A7B\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"1fa5932f\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":515,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_preciese.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"29d71208\",\"elType\":\"widget\",\"settings\":{\"title\":\"BEST CODE PRACTICES\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#F8F3F7\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"75748f10\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#F393A4\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"42a1232c\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-75,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":-71.4,\"sizes\":[]},\"_offset_y\":{\"size\":-55,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":92,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"abf718c\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":517,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_secure.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"645fc856\",\"elType\":\"widget\",\"settings\":{\"title\":\"SECURE WEB APPS\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#F8F3F7\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"3785904d\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"e2c591c\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":516,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_responsive.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"4a108d1e\",\"elType\":\"widget\",\"settings\":{\"title\":\"RESPONSIVE DESIGNS\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#F8F3F7\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"20d8bfb3\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Cover Letter\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"21\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"cover-letter\"},\"elements\":[{\"id\":\"7bbb1bfe\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"7310c760\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-75,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":-71.4,\"sizes\":[]},\"_offset_y\":{\"size\":-55,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":92,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"3024b7c7\",\"elType\":\"widget\",\"settings\":{\"title\":\"Education\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"32c3cde7\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"64321d12\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Bachelor of Computer and Control Engineering.<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"1d1b257a\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>I have graduated from Faculty of Engineering Tanta University Computer and Control department.<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"22d6fdac\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":523,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/square.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-rotate\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":110,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"size\":-190,\"unit\":\"px\"},\"_offset_orientation_v\":\"end\",\"_offset_y_end\":{\"size\":-40,\"unit\":\"px\"}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"4616d8f\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Education\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"education\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"483cd999\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"30\",\"isLinked\":false}},\"elements\":[{\"id\":\"76b9110\",\"elType\":\"widget\",\"settings\":{\"items\":[{\"title\":\"<b>High School<\\/b> \\n\",\"_id\":\"291265d\",\"year\":\"2014\"},{\"title\":\"<b>University Education<\\/b> \\n\\n<br> \\n\\nI have graduated from Faculty of Engineering Tanta University Computer and Control department.\",\"year\":\"2019\",\"_id\":\"fece03c\"}],\"content_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"coco-timeline\"}],\"isInner\":false},{\"id\":\"5cf8d351\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"010\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#F393A4\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"1ff21d9b\",\"elType\":\"widget\",\"settings\":{\"title\":\"Education\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"705ff71b\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_orientation_h\":\"end\",\"_offset_orientation_v\":\"end\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"46d2c91\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Facts\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"facts\"},\"elements\":[{\"id\":\"06271c5\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"3f38a91\",\"elType\":\"widget\",\"settings\":{\"title\":\"Programming <br>\\nLanguages\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"971a1d5\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_orientation_h\":\"end\",\"_offset_orientation_v\":\"end\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"9cd6740\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"866f96b\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Dolor sit amet, consectetur adipiscing elit viverra tristique placerat in massa consectetur quisque nunc ac fames lorem ipsum dolormo<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"3c96c5b\",\"elType\":\"section\",\"settings\":{\"structure\":\"20\"},\"elements\":[{\"id\":\"154ea2d\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null},\"elements\":[{\"id\":\"923b4f2\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-coffee\",\"library\":\"fa-solid\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"87b2c09\",\"elType\":\"widget\",\"settings\":{\"starting_number\":9,\"ending_number\":13,\"title\":\"Cups of Coffee\",\"number_color\":\"#605777\",\"typography_number_typography\":\"custom\",\"typography_number_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"typography_number_font_weight\":\"700\",\"title_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"counter\"}],\"isInner\":true},{\"id\":\"8c3eaae\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null},\"elements\":[{\"id\":\"7eed9c5\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-cloud-download-alt\",\"library\":\"fa-solid\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"f40d9f2\",\"elType\":\"widget\",\"settings\":{\"starting_number\":200,\"ending_number\":250,\"title\":\"GB Download\",\"number_color\":\"#605777\",\"typography_number_typography\":\"custom\",\"typography_number_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"typography_number_font_weight\":\"700\",\"title_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"counter\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"673b900\",\"elType\":\"section\",\"settings\":{\"structure\":\"20\",\"margin\":{\"unit\":\"px\",\"top\":\"20\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false}},\"elements\":[{\"id\":\"c4dbc7e\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null},\"elements\":[{\"id\":\"abe93a1\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-code\",\"library\":\"fa-solid\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"af5bd78\",\"elType\":\"widget\",\"settings\":{\"starting_number\":2,\"ending_number\":3.3,\"suffix\":\"K\",\"title\":\"Lines of Code\",\"number_color\":\"#605777\",\"typography_number_typography\":\"custom\",\"typography_number_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"typography_number_font_weight\":\"700\",\"title_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"counter\"}],\"isInner\":true},{\"id\":\"3b6a4c7\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null},\"elements\":[{\"id\":\"a32a5c6\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-images\",\"library\":\"fa-solid\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"7311bfd\",\"elType\":\"widget\",\"settings\":{\"starting_number\":730,\"ending_number\":743,\"title\":\"Photos  \\/ Week\",\"number_color\":\"#605777\",\"typography_number_typography\":\"custom\",\"typography_number_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"typography_number_font_weight\":\"700\",\"title_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"counter\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false}],\"isInner\":false},{\"id\":\"b93f393\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Experience\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"experience\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"12ba158\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"c0a09d4\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Dolor sit amet, consectetur adipiscing elit viverra tristique placerat in massa consectetur<\\/p>\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]},\"text_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"b714e6a\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Faucibus sed tristique fames sed aliquet ultricies eget viverra arcu. Vitae faucibus diam consequat maecenas. Turpis metus sit diam purus leo in varius ac quam. Nunc amet tristique volutpat adipiscing vulputate phasellus. Volutpat faucibus praesent acolo.<\\/p>\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"text_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"ac823f1\",\"elType\":\"widget\",\"settings\":{\"tabs\":[{\"tab_title\":\"Photography Assistant\",\"tab_content\":\"<p><strong>2012 - 2014<\\/strong><\\/p><p>In sodales suscipit velit sagittis tristique aliquam consectetur eros at viverra aliquet suspendisse potenti lorem ipsum dolo colomose positive aratovi del nenosico.<\\/p>\",\"_id\":\"024a8c4\"},{\"tab_title\":\"Junior Designer\",\"tab_content\":\"<p><strong>2014 - 2016<\\/strong><\\/p><p>Nulla tristique nulla eget nibh lobortis porta quisque posuere iaculis maximus. Aliquam quis hendrerit dui lore.<\\/p>\",\"_id\":\"8a56075\"},{\"tab_title\":\"Senior Designer\",\"tab_content\":\"<p><strong>2016 - 2017<\\/strong><\\/p><p>Proin mollis sapien quis elit aliquam, vitae placerat neque aliquam suspendisse dapibus elit nec pretium gravida. Sed gravida, libero ac tristique tristique, elit quam dignom.<\\/p>\",\"_id\":\"072e6f7\"},{\"tab_title\":\"Team Leader \",\"tab_content\":\"<p><strong>2017 - 2020<\\/strong><\\/p><p>Ksem, non porta lorem dolor eget augue aliquam eu ante tincidunt, tincidunt nibh quis, accumsan metus doloe.<\\/p>\",\"_id\":\"27dcc94\"}],\"selected_icon\":{\"value\":\"fas fa-caret-down\",\"library\":\"fa-solid\"},\"border_width\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"space_between\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"title_background\":\"#605777\",\"title_color\":\"#FFFFFF\",\"tab_active_color\":\"#FFFFFF\",\"icon_align\":\"right\",\"content_background_color\":\"#FFFFFF\",\"content_typography_line_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"content_padding\":{\"unit\":\"px\",\"top\":\"23\",\"right\":\"25\",\"bottom\":\"23\",\"left\":\"25\",\"isLinked\":false},\"content_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"toggle\"}],\"isInner\":false},{\"id\":\"fcc60c8\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#7E5A7B\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"e119716\",\"elType\":\"widget\",\"settings\":{\"title\":\"Experience\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"640cc2f\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":522,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/circle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-up-down\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":100,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-60,\"sizes\":[]},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_x\":{\"unit\":\"px\",\"size\":-45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"da7ba6b\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Contact\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"21\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"contact\"},\"elements\":[{\"id\":\"78db0d70\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"4cfc3491\",\"elType\":\"widget\",\"settings\":{\"title\":\"Contact\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"2a567e6\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-30,\"sizes\":[]},\"_offset_y_end\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"_offset_y\":{\"unit\":\"px\",\"size\":90,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"359bfd64\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"51c97412\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Dolor sit amet, consectetur adipiscing elit viverra tristique placerat in massa consectetur<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"39c22072\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Faucibus sed tristique fames sed aliquet ultricies eget viverra arcu. Vitae faucibus diam consequat maecenas. Turpis metus sit diam purus leo in varius ac quam. Nunc amet tristique volutpat adipiscing vulputate phasellus. Volutpat faucibus praesent acolo.<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"3cb74d82\",\"elType\":\"widget\",\"settings\":{\"contactform\":\"[contact-form-7 id=\\\"336\\\" title=\\\"Teoro Contact Form\\\"]\",\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"content_color\":\"#605777\",\"send_button_hover_color\":\"#FFFFFF\",\"_margin_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true}},\"elements\":[],\"widgetType\":\"coco-contactform\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("384","611","_elementor_template_type","wp-page");
INSERT INTO `wp_postmeta` VALUES("385","611","_elementor_version","3.0.14");
INSERT INTO `wp_postmeta` VALUES("386","611","_wp_page_template","onepage.php");
INSERT INTO `wp_postmeta` VALUES("387","611","_elementor_data","[{\"id\":\"3cda06bf\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"_title\":\"Home\",\"css_classes\":\"op-section\",\"gap\":\"no\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"_element_id\":\"home\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"structure\":\"20\"},\"elements\":[{\"id\":\"589a8709\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null,\"_inline_size_tablet\":40,\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"content_position\":\"center\"},\"elements\":[{\"id\":\"59838137\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":597,\"url\":\"https:\\/\\/amrelarabi.tech\\/wp-content\\/uploads\\/2020\\/12\\/me-1.jpg\"},\"image_size\":\"full\",\"align_mobile\":\"left\",\"width_mobile\":{\"unit\":\"px\",\"size\":220,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"a8c012a\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null,\"content_position\":\"center\",\"_inline_size_tablet\":60,\"align_mobile\":\"flex-start\",\"margin_mobile\":{\"unit\":\"px\",\"top\":\"-20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding\":{\"unit\":\"%\",\"top\":\"10\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"5\",\"bottom\":\"13\",\"left\":\"5\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"3f957272\",\"elType\":\"widget\",\"settings\":{\"title\":\"Hello <br>I\\u2019m Amr <br>Elarabi\",\"header_size\":\"h1\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":100,\"sizes\":[]},\"typography_font_weight\":\"200\",\"typography_line_height\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"_element_custom_width\":{\"unit\":\"px\",\"size\":430,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":66,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"7ac381db\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>A full stack web developer.<\\/p>\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":430,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"160c4806\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-80,\"sizes\":[]},\"_offset_orientation_v\":\"end\",\"_offset_y_end\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"3c2f0808\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"About\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"21\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"about\"},\"elements\":[{\"id\":\"4e2591d8\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#F393A4\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"570ae41d\",\"elType\":\"widget\",\"settings\":{\"title\":\"About\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"1a7fbc57\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"35fa5410\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>I\'m full stack web developer, I have advanced knowledge in PHP, Python and JavaScript.<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"4cd330f8\",\"elType\":\"section\",\"settings\":{\"structure\":\"20\",\"margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"gap\":\"no\",\"layout\":\"full_width\"},\"elements\":[{\"id\":\"2d15cbe9\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":57.496,\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"_inline_size_tablet\":100},\"elements\":[{\"id\":\"52896c2\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p><strong>NAME:<\\/strong> Amr Hemida Elarabi<br \\/><strong>CITY:<\\/strong> Gharbia, Egypt<br \\/><strong>BIRTHDAY:<\\/strong> 07. 06. 1996<br \\/><strong>PHONE:<\\/strong> +201557797970<br \\/><strong>EMAIL:<\\/strong> me@amrelarabi.tech<br \\/><strong>WEBSITE:<\\/strong> amrelarabi.tech<\\/p>\",\"text_color\":\"#605777\",\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-30\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":true},{\"id\":\"177ba07f\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":42.228,\"background_background\":\"classic\",\"_inline_size_tablet\":100,\"margin_tablet\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"4ec03c3a\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":514,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_download_cv.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]},\"link\":{\"url\":\"https:\\/\\/amrelarabi.tech\\/wp-content\\/uploads\\/2020\\/12\\/Amr_Hemida_Elarabi.pdf\",\"is_external\":\"on\",\"nofollow\":\"on\",\"custom_attributes\":\"\"}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"4f9bfd94\",\"elType\":\"widget\",\"settings\":{\"title\":\"DOWNLOAD CV\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#605777\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"link\":{\"url\":\"https:\\/\\/demo.cocobasic.com\\/documentation\\/MANUAL-TeoroWP.pdf\",\"is_external\":\"on\",\"nofollow\":\"on\",\"custom_attributes\":\"\"}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false}],\"isInner\":false},{\"id\":\"2d537bad\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Portfolio\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"portfolio\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"1659d356\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\"},\"elements\":[{\"id\":\"6298d834\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":-71.4,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":92,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"139ca579\",\"elType\":\"widget\",\"settings\":{\"num\":\"4\",\"all_text\":\"All\",\"loadmore_text\":\"LOAD MORE\",\"loadmore_loading_text\":\"LOADING\",\"loadmore_nomore_text\":\"NO MORE\",\"loadmore_text_color\":\"#F4F4F4\",\"loadmore_text_hover_color\":\"#BD6272\"},\"elements\":[],\"widgetType\":\"coco-portfolio\"}],\"isInner\":false},{\"id\":\"ff90d72\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"57569195\",\"elType\":\"widget\",\"settings\":{\"title\":\"Portfolio\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"48198d00\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Skills\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"skills\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"67f9096e\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"51c9fb72\",\"elType\":\"widget\",\"settings\":{\"items\":[{\"title\":\"Web development\",\"value\":\"90%\",\"_id\":\"847e789\"},{\"title\":\"Web Design\",\"value\":\"85%\",\"_id\":\"a746d00\"},{\"title\":\"Graphic Design\",\"value\":\"85%\",\"_id\":\"eb0f2b4\"},{\"title\":\"SEO\",\"value\":\"80%\",\"_id\":\"6c9cfda\"}],\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"coco-skills-lines\"}],\"isInner\":false},{\"id\":\"696e0f2e\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#7E5A7B\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"48629353\",\"elType\":\"widget\",\"settings\":{\"title\":\"Skills\\u200b\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"1380b9f8\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":522,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/circle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-up-down\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":100,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-60,\"sizes\":[]},\"_offset_orientation_v\":\"end\",\"_offset_y_end\":{\"unit\":\"px\",\"size\":120,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"5efece0a\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Services\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"30\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"css_classes\":\"op-section\"},\"elements\":[{\"id\":\"3bf8e8c5\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#7E5A7B\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"1fa5932f\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":515,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_preciese.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"29d71208\",\"elType\":\"widget\",\"settings\":{\"title\":\"BEST CODE PRACTICES\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#F8F3F7\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"75748f10\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#F393A4\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"42a1232c\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-75,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":-71.4,\"sizes\":[]},\"_offset_y\":{\"size\":-55,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":92,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"abf718c\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":517,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_secure.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"645fc856\",\"elType\":\"widget\",\"settings\":{\"title\":\"SECURE WEB APPS\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#F8F3F7\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"3785904d\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"e2c591c\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":516,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_responsive.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"4a108d1e\",\"elType\":\"widget\",\"settings\":{\"title\":\"RESPONSIVE DESIGNS\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#F8F3F7\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"20d8bfb3\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Cover Letter\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"21\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"cover-letter\"},\"elements\":[{\"id\":\"7bbb1bfe\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"7310c760\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-75,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":-71.4,\"sizes\":[]},\"_offset_y\":{\"size\":-55,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":92,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"3024b7c7\",\"elType\":\"widget\",\"settings\":{\"title\":\"Education\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"32c3cde7\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"64321d12\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Bachelor of Computer and Control Engineering.<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"1d1b257a\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>I have graduated from Faculty of Engineering Tanta University Computer and Control department.<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"22d6fdac\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":523,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/square.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-rotate\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":110,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"size\":-190,\"unit\":\"px\"},\"_offset_orientation_v\":\"end\",\"_offset_y_end\":{\"size\":-40,\"unit\":\"px\"}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"4616d8f\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Education\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"education\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"483cd999\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"30\",\"isLinked\":false}},\"elements\":[{\"id\":\"76b9110\",\"elType\":\"widget\",\"settings\":{\"items\":[{\"title\":\"<b>Start<\\/b> \\n\\n<br> \\n\\nNunc amet tristique volutpat adipiscing vulputate phasellus eget enim aliquam euismod lorem ispum teoro muniote lore.\",\"_id\":\"291265d\",\"year\":\"2015\"},{\"title\":\"<b>Basic Level<\\/b> \\n\\n<br> \\n\\nTurpis metus sit diam purus leo in varius ac quam nunc amet tristique volutpat adipisc vulputate phasellus eget enim aliquam euismod mauris in vitae viverra kolomisu.\",\"year\":\"2016\",\"_id\":\"fece03c\"},{\"title\":\"<b>Master Level<\\/b> \\n\\n<br> \\n\\nPlacerat in massa consectetur quisque nunc ac fames lectus in libero aliquet estlo.\",\"year\":\"2017\",\"_id\":\"d2c1904\"},{\"title\":\"<b>Pro Level<\\/b> \\n\\n<br> \\n\\nEget enim aliquam euismod mauris in vitae viverra blandit lectus faucibus diam consequat maecenas turpis metus sitomo.\",\"year\":\"2018\",\"_id\":\"926a437\"}],\"content_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"coco-timeline\"}],\"isInner\":false},{\"id\":\"5cf8d351\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"010\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#F393A4\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"1ff21d9b\",\"elType\":\"widget\",\"settings\":{\"title\":\"Education\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"705ff71b\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_orientation_h\":\"end\",\"_offset_orientation_v\":\"end\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"46d2c91\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Facts\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"facts\"},\"elements\":[{\"id\":\"06271c5\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"3f38a91\",\"elType\":\"widget\",\"settings\":{\"title\":\"Programming <br>\\nLanguages\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"971a1d5\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_orientation_h\":\"end\",\"_offset_orientation_v\":\"end\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"9cd6740\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"866f96b\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Dolor sit amet, consectetur adipiscing elit viverra tristique placerat in massa consectetur quisque nunc ac fames lorem ipsum dolormo<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"3c96c5b\",\"elType\":\"section\",\"settings\":{\"structure\":\"20\"},\"elements\":[{\"id\":\"154ea2d\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null},\"elements\":[{\"id\":\"923b4f2\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-coffee\",\"library\":\"fa-solid\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"87b2c09\",\"elType\":\"widget\",\"settings\":{\"starting_number\":9,\"ending_number\":13,\"title\":\"Cups of Coffee\",\"number_color\":\"#605777\",\"typography_number_typography\":\"custom\",\"typography_number_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"typography_number_font_weight\":\"700\",\"title_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"counter\"}],\"isInner\":true},{\"id\":\"8c3eaae\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null},\"elements\":[{\"id\":\"7eed9c5\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-cloud-download-alt\",\"library\":\"fa-solid\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"f40d9f2\",\"elType\":\"widget\",\"settings\":{\"starting_number\":200,\"ending_number\":250,\"title\":\"GB Download\",\"number_color\":\"#605777\",\"typography_number_typography\":\"custom\",\"typography_number_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"typography_number_font_weight\":\"700\",\"title_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"counter\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"673b900\",\"elType\":\"section\",\"settings\":{\"structure\":\"20\",\"margin\":{\"unit\":\"px\",\"top\":\"20\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false}},\"elements\":[{\"id\":\"c4dbc7e\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null},\"elements\":[{\"id\":\"abe93a1\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-code\",\"library\":\"fa-solid\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"af5bd78\",\"elType\":\"widget\",\"settings\":{\"starting_number\":2,\"ending_number\":3.3,\"suffix\":\"K\",\"title\":\"Lines of Code\",\"number_color\":\"#605777\",\"typography_number_typography\":\"custom\",\"typography_number_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"typography_number_font_weight\":\"700\",\"title_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"counter\"}],\"isInner\":true},{\"id\":\"3b6a4c7\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null},\"elements\":[{\"id\":\"a32a5c6\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-images\",\"library\":\"fa-solid\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"7311bfd\",\"elType\":\"widget\",\"settings\":{\"starting_number\":730,\"ending_number\":743,\"title\":\"Photos  \\/ Week\",\"number_color\":\"#605777\",\"typography_number_typography\":\"custom\",\"typography_number_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"typography_number_font_weight\":\"700\",\"title_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"counter\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false}],\"isInner\":false},{\"id\":\"b93f393\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Experience\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"experience\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"12ba158\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"c0a09d4\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Dolor sit amet, consectetur adipiscing elit viverra tristique placerat in massa consectetur<\\/p>\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]},\"text_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"b714e6a\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Faucibus sed tristique fames sed aliquet ultricies eget viverra arcu. Vitae faucibus diam consequat maecenas. Turpis metus sit diam purus leo in varius ac quam. Nunc amet tristique volutpat adipiscing vulputate phasellus. Volutpat faucibus praesent acolo.<\\/p>\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"text_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"ac823f1\",\"elType\":\"widget\",\"settings\":{\"tabs\":[{\"tab_title\":\"Photography Assistant\",\"tab_content\":\"<p><strong>2012 - 2014<\\/strong><\\/p><p>In sodales suscipit velit sagittis tristique aliquam consectetur eros at viverra aliquet suspendisse potenti lorem ipsum dolo colomose positive aratovi del nenosico.<\\/p>\",\"_id\":\"024a8c4\"},{\"tab_title\":\"Junior Designer\",\"tab_content\":\"<p><strong>2014 - 2016<\\/strong><\\/p><p>Nulla tristique nulla eget nibh lobortis porta quisque posuere iaculis maximus. Aliquam quis hendrerit dui lore.<\\/p>\",\"_id\":\"8a56075\"},{\"tab_title\":\"Senior Designer\",\"tab_content\":\"<p><strong>2016 - 2017<\\/strong><\\/p><p>Proin mollis sapien quis elit aliquam, vitae placerat neque aliquam suspendisse dapibus elit nec pretium gravida. Sed gravida, libero ac tristique tristique, elit quam dignom.<\\/p>\",\"_id\":\"072e6f7\"},{\"tab_title\":\"Team Leader \",\"tab_content\":\"<p><strong>2017 - 2020<\\/strong><\\/p><p>Ksem, non porta lorem dolor eget augue aliquam eu ante tincidunt, tincidunt nibh quis, accumsan metus doloe.<\\/p>\",\"_id\":\"27dcc94\"}],\"selected_icon\":{\"value\":\"fas fa-caret-down\",\"library\":\"fa-solid\"},\"border_width\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"space_between\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"title_background\":\"#605777\",\"title_color\":\"#FFFFFF\",\"tab_active_color\":\"#FFFFFF\",\"icon_align\":\"right\",\"content_background_color\":\"#FFFFFF\",\"content_typography_line_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"content_padding\":{\"unit\":\"px\",\"top\":\"23\",\"right\":\"25\",\"bottom\":\"23\",\"left\":\"25\",\"isLinked\":false},\"content_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"toggle\"}],\"isInner\":false},{\"id\":\"fcc60c8\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#7E5A7B\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"e119716\",\"elType\":\"widget\",\"settings\":{\"title\":\"Experience\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"640cc2f\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":522,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/circle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-up-down\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":100,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-60,\"sizes\":[]},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_x\":{\"unit\":\"px\",\"size\":-45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"da7ba6b\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Contact\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"21\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"contact\"},\"elements\":[{\"id\":\"78db0d70\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"4cfc3491\",\"elType\":\"widget\",\"settings\":{\"title\":\"Contact\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"2a567e6\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-30,\"sizes\":[]},\"_offset_y_end\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"_offset_y\":{\"unit\":\"px\",\"size\":90,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"359bfd64\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"51c97412\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Dolor sit amet, consectetur adipiscing elit viverra tristique placerat in massa consectetur<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"39c22072\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Faucibus sed tristique fames sed aliquet ultricies eget viverra arcu. Vitae faucibus diam consequat maecenas. Turpis metus sit diam purus leo in varius ac quam. Nunc amet tristique volutpat adipiscing vulputate phasellus. Volutpat faucibus praesent acolo.<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"3cb74d82\",\"elType\":\"widget\",\"settings\":{\"contactform\":\"[contact-form-7 id=\\\"336\\\" title=\\\"Teoro Contact Form\\\"]\",\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"content_color\":\"#605777\",\"send_button_hover_color\":\"#FFFFFF\",\"_margin_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true}},\"elements\":[],\"widgetType\":\"coco-contactform\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("322","601","_elementor_edit_mode","builder");
INSERT INTO `wp_postmeta` VALUES("323","601","_elementor_template_type","wp-page");
INSERT INTO `wp_postmeta` VALUES("324","601","_elementor_version","2.9.14");
INSERT INTO `wp_postmeta` VALUES("325","601","_wp_page_template","onepage.php");
INSERT INTO `wp_postmeta` VALUES("326","601","_elementor_data","[{\"id\":\"3cda06bf\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"_title\":\"Home\",\"css_classes\":\"op-section\",\"gap\":\"no\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"_element_id\":\"home\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"structure\":\"20\"},\"elements\":[{\"id\":\"589a8709\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null,\"_inline_size_tablet\":40,\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"content_position\":\"center\"},\"elements\":[{\"id\":\"59838137\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":597,\"url\":\"https:\\/\\/amrelarabi.tech\\/wp-content\\/uploads\\/2020\\/12\\/me-1.jpg\"},\"image_size\":\"full\",\"align_mobile\":\"left\",\"width_mobile\":{\"unit\":\"px\",\"size\":220,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"a8c012a\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null,\"content_position\":\"center\",\"_inline_size_tablet\":60,\"align_mobile\":\"flex-start\",\"margin_mobile\":{\"unit\":\"px\",\"top\":\"-20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding\":{\"unit\":\"%\",\"top\":\"10\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"5\",\"bottom\":\"13\",\"left\":\"5\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"3f957272\",\"elType\":\"widget\",\"settings\":{\"title\":\"Hello <br>I\\u2019m Amr <br>Elarabi\",\"header_size\":\"h1\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":100,\"sizes\":[]},\"typography_font_weight\":\"200\",\"typography_line_height\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"_element_custom_width\":{\"unit\":\"px\",\"size\":430,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":66,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"7ac381db\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>A full stack web developer.<\\/p>\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":430,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"160c4806\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-80,\"sizes\":[]},\"_offset_orientation_v\":\"end\",\"_offset_y_end\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"3c2f0808\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"About\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"21\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"about\"},\"elements\":[{\"id\":\"4e2591d8\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#F393A4\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"570ae41d\",\"elType\":\"widget\",\"settings\":{\"title\":\"About\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"1a7fbc57\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"35fa5410\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>I\'m full stack web developer, I have advanced knowledge in PHP, Python and JavaScript.<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"4cd330f8\",\"elType\":\"section\",\"settings\":{\"structure\":\"20\",\"margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"gap\":\"no\",\"layout\":\"full_width\"},\"elements\":[{\"id\":\"2d15cbe9\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":57.496,\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"_inline_size_tablet\":100},\"elements\":[{\"id\":\"52896c2\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p><strong>NAME:<\\/strong> Amr Hemida Elarabi<br \\/><strong>CITY:<\\/strong> Gharbia, Egypt<br \\/><strong>BIRTHDAY:<\\/strong> 07. 06. 1996<br \\/><strong>PHONE:<\\/strong> +201557797970<br \\/><strong>EMAIL:<\\/strong> me@amrelarabi.tech<br \\/><strong>WEBSITE:<\\/strong> amrelarabi.tech<\\/p>\",\"text_color\":\"#605777\",\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-30\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":true},{\"id\":\"177ba07f\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":42.228,\"background_background\":\"classic\",\"_inline_size_tablet\":100,\"margin_tablet\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"4ec03c3a\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":514,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_download_cv.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]},\"link\":{\"url\":\"https:\\/\\/amrelarabi.tech\\/wp-content\\/uploads\\/2020\\/12\\/Amr_Hemida_Elarabi.pdf\",\"is_external\":\"on\",\"nofollow\":\"on\",\"custom_attributes\":\"\"}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"4f9bfd94\",\"elType\":\"widget\",\"settings\":{\"title\":\"DOWNLOAD CV\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#605777\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"link\":{\"url\":\"https:\\/\\/demo.cocobasic.com\\/documentation\\/MANUAL-TeoroWP.pdf\",\"is_external\":\"on\",\"nofollow\":\"on\",\"custom_attributes\":\"\"}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false}],\"isInner\":false},{\"id\":\"2d537bad\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Portfolio\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"portfolio\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"1659d356\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\"},\"elements\":[{\"id\":\"6298d834\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":-71.4,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":92,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"139ca579\",\"elType\":\"widget\",\"settings\":{\"num\":\"4\",\"all_text\":\"All\",\"loadmore_text\":\"LOAD MORE\",\"loadmore_loading_text\":\"LOADING\",\"loadmore_nomore_text\":\"NO MORE\",\"loadmore_text_color\":\"#F4F4F4\",\"loadmore_text_hover_color\":\"#BD6272\"},\"elements\":[],\"widgetType\":\"coco-portfolio\"}],\"isInner\":false},{\"id\":\"ff90d72\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"57569195\",\"elType\":\"widget\",\"settings\":{\"title\":\"Portfolio\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"48198d00\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Skills\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"skills\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"67f9096e\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"51c9fb72\",\"elType\":\"widget\",\"settings\":{\"items\":[{\"title\":\"Web development\",\"value\":\"90%\",\"_id\":\"847e789\"},{\"title\":\"Web Design\",\"value\":\"85%\",\"_id\":\"a746d00\"},{\"title\":\"Graphic Design\",\"value\":\"85%\",\"_id\":\"eb0f2b4\"},{\"title\":\"SEO\",\"value\":\"75%\",\"_id\":\"6c9cfda\"}],\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"coco-skills-lines\"}],\"isInner\":false},{\"id\":\"696e0f2e\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#7E5A7B\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"48629353\",\"elType\":\"widget\",\"settings\":{\"title\":\"Skills\\u200b\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"1380b9f8\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":522,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/circle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-up-down\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":100,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-60,\"sizes\":[]},\"_offset_orientation_v\":\"end\",\"_offset_y_end\":{\"unit\":\"px\",\"size\":120,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"5efece0a\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Services\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"30\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"css_classes\":\"op-section\"},\"elements\":[{\"id\":\"3bf8e8c5\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#7E5A7B\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"1fa5932f\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":515,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_preciese.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"29d71208\",\"elType\":\"widget\",\"settings\":{\"title\":\"PIXEL PRECISE\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#F8F3F7\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"75748f10\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#F393A4\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"42a1232c\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-75,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":-71.4,\"sizes\":[]},\"_offset_y\":{\"size\":-55,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":92,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"abf718c\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":517,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_secure.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"645fc856\",\"elType\":\"widget\",\"settings\":{\"title\":\"SECURE\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#F8F3F7\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"3785904d\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"e2c591c\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":516,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_responsive.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"4a108d1e\",\"elType\":\"widget\",\"settings\":{\"title\":\"RESPONSIVE\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#F8F3F7\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"20d8bfb3\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Cover Letter\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"21\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"cover-letter\"},\"elements\":[{\"id\":\"7bbb1bfe\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"7310c760\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-75,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":-71.4,\"sizes\":[]},\"_offset_y\":{\"size\":-55,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":92,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"3024b7c7\",\"elType\":\"widget\",\"settings\":{\"title\":\"Cover <br>Letter\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"32c3cde7\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"64321d12\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Dolor sit amet, consectetur adipiscing elit viverra tristique placerat in massa consectetur quisque nunc ac fames lorem ipsum dolormo<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"1d1b257a\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Faucibus sed tristique fames sed aliquet ultricies eget viverra arcu. Vitae faucibus diam consequat maecenas. Turpis metus sit diam purus leo in varius ac quam. Nunc amet tristique volutpat adipiscing vulputate phasellus. Volutpat faucibus praesent ac lobortis aliquam dolor. Eget enim aliquam euismod mauris in vitae viverra blandit lectus diam feugiat mattis metus, parturient ipsum id nibh tortor tincidunt quam facilisi nunc faucib.<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"64666b64\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Vitae faucibus diam consequat maecenas. Turpis metus sit diam purus leo in varius ac quam. Nunc amet tristique volutpat piscing vulputate phasellus lorem ipsum poterius holutiko lorem ipsum.<\\/p>\",\"text_color\":\"#605777\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"5d2df679\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":518,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_signature.png\"},\"image_size\":\"full\",\"align\":\"right\",\"width\":{\"unit\":\"px\",\"size\":125,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"22d6fdac\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":523,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/square.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-rotate\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":110,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"size\":-190,\"unit\":\"px\"},\"_offset_orientation_v\":\"end\",\"_offset_y_end\":{\"size\":-40,\"unit\":\"px\"}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"4616d8f\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Education\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"education\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"483cd999\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"30\",\"isLinked\":false}},\"elements\":[{\"id\":\"76b9110\",\"elType\":\"widget\",\"settings\":{\"items\":[{\"title\":\"<b>Start<\\/b> \\n\\n<br> \\n\\nNunc amet tristique volutpat adipiscing vulputate phasellus eget enim aliquam euismod lorem ispum teoro muniote lore.\",\"_id\":\"291265d\",\"year\":\"2015\"},{\"title\":\"<b>Basic Level<\\/b> \\n\\n<br> \\n\\nTurpis metus sit diam purus leo in varius ac quam nunc amet tristique volutpat adipisc vulputate phasellus eget enim aliquam euismod mauris in vitae viverra kolomisu.\",\"year\":\"2016\",\"_id\":\"fece03c\"},{\"title\":\"<b>Master Level<\\/b> \\n\\n<br> \\n\\nPlacerat in massa consectetur quisque nunc ac fames lectus in libero aliquet estlo.\",\"year\":\"2017\",\"_id\":\"d2c1904\"},{\"title\":\"<b>Pro Level<\\/b> \\n\\n<br> \\n\\nEget enim aliquam euismod mauris in vitae viverra blandit lectus faucibus diam consequat maecenas turpis metus sitomo.\",\"year\":\"2018\",\"_id\":\"926a437\"}],\"content_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"coco-timeline\"}],\"isInner\":false},{\"id\":\"5cf8d351\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"010\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#F393A4\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"1ff21d9b\",\"elType\":\"widget\",\"settings\":{\"title\":\"Education\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"705ff71b\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_orientation_h\":\"end\",\"_offset_orientation_v\":\"end\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"46d2c91\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Facts\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"facts\"},\"elements\":[{\"id\":\"06271c5\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"3f38a91\",\"elType\":\"widget\",\"settings\":{\"title\":\"Facts\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"971a1d5\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_orientation_h\":\"end\",\"_offset_orientation_v\":\"end\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"9cd6740\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"866f96b\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Dolor sit amet, consectetur adipiscing elit viverra tristique placerat in massa consectetur quisque nunc ac fames lorem ipsum dolormo<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"3c96c5b\",\"elType\":\"section\",\"settings\":{\"structure\":\"20\"},\"elements\":[{\"id\":\"154ea2d\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null},\"elements\":[{\"id\":\"923b4f2\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-coffee\",\"library\":\"fa-solid\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"87b2c09\",\"elType\":\"widget\",\"settings\":{\"starting_number\":9,\"ending_number\":13,\"title\":\"Cups of Coffee\",\"number_color\":\"#605777\",\"typography_number_typography\":\"custom\",\"typography_number_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"typography_number_font_weight\":\"700\",\"title_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"counter\"}],\"isInner\":true},{\"id\":\"8c3eaae\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null},\"elements\":[{\"id\":\"7eed9c5\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-cloud-download-alt\",\"library\":\"fa-solid\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"f40d9f2\",\"elType\":\"widget\",\"settings\":{\"starting_number\":200,\"ending_number\":250,\"title\":\"GB Download\",\"number_color\":\"#605777\",\"typography_number_typography\":\"custom\",\"typography_number_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"typography_number_font_weight\":\"700\",\"title_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"counter\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"673b900\",\"elType\":\"section\",\"settings\":{\"structure\":\"20\",\"margin\":{\"unit\":\"px\",\"top\":\"20\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false}},\"elements\":[{\"id\":\"c4dbc7e\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null},\"elements\":[{\"id\":\"abe93a1\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-code\",\"library\":\"fa-solid\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"af5bd78\",\"elType\":\"widget\",\"settings\":{\"starting_number\":2,\"ending_number\":3.3,\"suffix\":\"K\",\"title\":\"Lines of Code\",\"number_color\":\"#605777\",\"typography_number_typography\":\"custom\",\"typography_number_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"typography_number_font_weight\":\"700\",\"title_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"counter\"}],\"isInner\":true},{\"id\":\"3b6a4c7\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null},\"elements\":[{\"id\":\"a32a5c6\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-images\",\"library\":\"fa-solid\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"7311bfd\",\"elType\":\"widget\",\"settings\":{\"starting_number\":730,\"ending_number\":743,\"title\":\"Photos  \\/ Week\",\"number_color\":\"#605777\",\"typography_number_typography\":\"custom\",\"typography_number_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"typography_number_font_weight\":\"700\",\"title_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"counter\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false}],\"isInner\":false},{\"id\":\"b93f393\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Experience\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"experience\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"12ba158\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"c0a09d4\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Dolor sit amet, consectetur adipiscing elit viverra tristique placerat in massa consectetur<\\/p>\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]},\"text_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"b714e6a\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Faucibus sed tristique fames sed aliquet ultricies eget viverra arcu. Vitae faucibus diam consequat maecenas. Turpis metus sit diam purus leo in varius ac quam. Nunc amet tristique volutpat adipiscing vulputate phasellus. Volutpat faucibus praesent acolo.<\\/p>\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"text_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"ac823f1\",\"elType\":\"widget\",\"settings\":{\"tabs\":[{\"tab_title\":\"Photography Assistant\",\"tab_content\":\"<p><strong>2012 - 2014<\\/strong><\\/p><p>In sodales suscipit velit sagittis tristique aliquam consectetur eros at viverra aliquet suspendisse potenti lorem ipsum dolo colomose positive aratovi del nenosico.<\\/p>\",\"_id\":\"024a8c4\"},{\"tab_title\":\"Junior Designer\",\"tab_content\":\"<p><strong>2014 - 2016<\\/strong><\\/p><p>Nulla tristique nulla eget nibh lobortis porta quisque posuere iaculis maximus. Aliquam quis hendrerit dui lore.<\\/p>\",\"_id\":\"8a56075\"},{\"tab_title\":\"Senior Designer\",\"tab_content\":\"<p><strong>2016 - 2017<\\/strong><\\/p><p>Proin mollis sapien quis elit aliquam, vitae placerat neque aliquam suspendisse dapibus elit nec pretium gravida. Sed gravida, libero ac tristique tristique, elit quam dignom.<\\/p>\",\"_id\":\"072e6f7\"},{\"tab_title\":\"Team Leader \",\"tab_content\":\"<p><strong>2017 - 2020<\\/strong><\\/p><p>Ksem, non porta lorem dolor eget augue aliquam eu ante tincidunt, tincidunt nibh quis, accumsan metus doloe.<\\/p>\",\"_id\":\"27dcc94\"}],\"selected_icon\":{\"value\":\"fas fa-caret-down\",\"library\":\"fa-solid\"},\"border_width\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"space_between\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"title_background\":\"#605777\",\"title_color\":\"#FFFFFF\",\"tab_active_color\":\"#FFFFFF\",\"icon_align\":\"right\",\"content_background_color\":\"#FFFFFF\",\"content_typography_line_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"content_padding\":{\"unit\":\"px\",\"top\":\"23\",\"right\":\"25\",\"bottom\":\"23\",\"left\":\"25\",\"isLinked\":false},\"content_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"toggle\"}],\"isInner\":false},{\"id\":\"fcc60c8\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#7E5A7B\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"e119716\",\"elType\":\"widget\",\"settings\":{\"title\":\"Experience\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"640cc2f\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":522,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/circle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-up-down\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":100,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-60,\"sizes\":[]},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_x\":{\"unit\":\"px\",\"size\":-45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"da7ba6b\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Contact\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"21\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"contact\"},\"elements\":[{\"id\":\"78db0d70\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"4cfc3491\",\"elType\":\"widget\",\"settings\":{\"title\":\"Contact\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"2a567e6\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-30,\"sizes\":[]},\"_offset_y_end\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"_offset_y\":{\"unit\":\"px\",\"size\":90,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"359bfd64\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"51c97412\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Dolor sit amet, consectetur adipiscing elit viverra tristique placerat in massa consectetur<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"39c22072\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Faucibus sed tristique fames sed aliquet ultricies eget viverra arcu. Vitae faucibus diam consequat maecenas. Turpis metus sit diam purus leo in varius ac quam. Nunc amet tristique volutpat adipiscing vulputate phasellus. Volutpat faucibus praesent acolo.<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"3cb74d82\",\"elType\":\"widget\",\"settings\":{\"contactform\":\"[contact-form-7 id=\\\"336\\\" title=\\\"Teoro Contact Form\\\"]\",\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"content_color\":\"#605777\",\"send_button_hover_color\":\"#FFFFFF\",\"_margin_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true}},\"elements\":[],\"widgetType\":\"coco-contactform\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("243","181","_oembed_6cfcbf927ed838ebdcd88030b41dc190","<iframe title=\"Paranormal - Rojo\" src=\"https://player.vimeo.com/video/155419584?dnt=1&amp;app_id=122963\" width=\"1170\" height=\"658\" frameborder=\"0\" allow=\"autoplay; fullscreen\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("244","181","_oembed_time_6cfcbf927ed838ebdcd88030b41dc190","1588452832");
INSERT INTO `wp_postmeta` VALUES("310","599","_elementor_edit_mode","builder");
INSERT INTO `wp_postmeta` VALUES("311","599","_elementor_template_type","wp-page");
INSERT INTO `wp_postmeta` VALUES("312","599","_elementor_version","2.9.14");
INSERT INTO `wp_postmeta` VALUES("313","599","_wp_page_template","onepage.php");
INSERT INTO `wp_postmeta` VALUES("314","599","_elementor_data","[{\"id\":\"3cda06bf\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"_title\":\"Home\",\"css_classes\":\"op-section\",\"gap\":\"no\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"_element_id\":\"home\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"structure\":\"20\"},\"elements\":[{\"id\":\"589a8709\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null,\"_inline_size_tablet\":40,\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"content_position\":\"center\"},\"elements\":[{\"id\":\"59838137\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":513,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/main_01.jpg\"},\"image_size\":\"full\",\"align_mobile\":\"left\",\"width_mobile\":{\"unit\":\"px\",\"size\":220,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"a8c012a\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null,\"content_position\":\"center\",\"_inline_size_tablet\":60,\"align_mobile\":\"flex-start\",\"margin_mobile\":{\"unit\":\"px\",\"top\":\"-20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding\":{\"unit\":\"%\",\"top\":\"10\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"5\",\"bottom\":\"13\",\"left\":\"5\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"3f957272\",\"elType\":\"widget\",\"settings\":{\"title\":\"Hello <br>I\\u2019m Anna <br>Peterson\",\"header_size\":\"h1\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":100,\"sizes\":[]},\"typography_font_weight\":\"200\",\"typography_line_height\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"_element_custom_width\":{\"unit\":\"px\",\"size\":430,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":66,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"7ac381db\",\"elType\":\"widget\",\"settings\":{\"editor\":\"A full stack allaround designer that tristique est placerat in massa consectetur quisque lobortis vitae faucibus diam consequat maecenas turpis metus sit diam purus leo in varius ac quam est lorem ipsum.\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":430,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"160c4806\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-80,\"sizes\":[]},\"_offset_orientation_v\":\"end\",\"_offset_y_end\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"3c2f0808\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"About\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"21\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"about\"},\"elements\":[{\"id\":\"4e2591d8\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#F393A4\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"570ae41d\",\"elType\":\"widget\",\"settings\":{\"title\":\"About\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"1a7fbc57\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"35fa5410\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Dolor sit amet, consectetur adipiscing elit viverra tristique placerat in massa consectetur<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"53601618\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Faucibus sed tristique fames sed aliquet ultricies eget viverra arcu vitae faucibus diam consequat maecenas turpis metus sit diam purus leo in varius ac quam nunc amet tristique volutpat.<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"4cd330f8\",\"elType\":\"section\",\"settings\":{\"structure\":\"20\",\"margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"gap\":\"no\",\"layout\":\"full_width\"},\"elements\":[{\"id\":\"2d15cbe9\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":57.49600000000000221689333557151257991790771484375,\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"_inline_size_tablet\":100},\"elements\":[{\"id\":\"52896c2\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p><strong>NAME:<\\/strong> Anna Peterson<br \\/><strong>CITY:<\\/strong> New York<br \\/><strong>BIRTHDAY:<\\/strong> 25. 03. 1987<br \\/><strong>INTEREST:<\\/strong> Basketball, Photo<br \\/><strong>PHONE:<\\/strong> (+123) 456 - 789<br \\/><strong>EMAIL:<\\/strong> company@youremail.com<br \\/><strong>WEBSITE:<\\/strong> www.yourwebsite.com<\\/p>\",\"text_color\":\"#605777\",\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-30\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":true},{\"id\":\"177ba07f\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":42.22800000000000153477230924181640148162841796875,\"background_background\":\"classic\",\"_inline_size_tablet\":100,\"margin_tablet\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"4ec03c3a\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":514,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_download_cv.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]},\"link\":{\"url\":\"https:\\/\\/demo.cocobasic.com\\/documentation\\/MANUAL-TeoroWP.pdf\",\"is_external\":\"on\",\"nofollow\":\"on\",\"custom_attributes\":\"\"}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"4f9bfd94\",\"elType\":\"widget\",\"settings\":{\"title\":\"DOWNLOAD CV\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#605777\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"link\":{\"url\":\"https:\\/\\/demo.cocobasic.com\\/documentation\\/MANUAL-TeoroWP.pdf\",\"is_external\":\"on\",\"nofollow\":\"on\",\"custom_attributes\":\"\"}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false}],\"isInner\":false},{\"id\":\"2d537bad\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Portfolio\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"portfolio\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"1659d356\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\"},\"elements\":[{\"id\":\"6298d834\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":-71.400000000000005684341886080801486968994140625,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":92,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"139ca579\",\"elType\":\"widget\",\"settings\":{\"num\":\"4\",\"all_text\":\"All\",\"loadmore_text\":\"LOAD MORE\",\"loadmore_loading_text\":\"LOADING\",\"loadmore_nomore_text\":\"NO MORE\",\"loadmore_text_color\":\"#F4F4F4\",\"loadmore_text_hover_color\":\"#BD6272\"},\"elements\":[],\"widgetType\":\"coco-portfolio\"}],\"isInner\":false},{\"id\":\"ff90d72\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"57569195\",\"elType\":\"widget\",\"settings\":{\"title\":\"Portfolio\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"48198d00\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Skills\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"skills\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"67f9096e\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"51c9fb72\",\"elType\":\"widget\",\"settings\":{\"items\":[{\"title\":\"PHOTOSHOP\",\"_id\":\"1939268\",\"value\":\"62%\"},{\"title\":\"ILLUSTRATOR\",\"value\":\"84%\",\"_id\":\"847e789\"},{\"title\":\"MARKETING\",\"value\":\"78%\",\"_id\":\"f7d0003\"},{\"title\":\"SUPER MARIO\",\"value\":\"92%\",\"_id\":\"a746d00\"},{\"title\":\"FIGMA\",\"value\":\"85%\",\"_id\":\"eb0f2b4\"},{\"title\":\"DIGITAL PAINTING\",\"value\":\"69%\",\"_id\":\"6c9cfda\"}],\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"coco-skills-lines\"}],\"isInner\":false},{\"id\":\"696e0f2e\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#7E5A7B\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"48629353\",\"elType\":\"widget\",\"settings\":{\"title\":\"Skills\\u200b\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"1380b9f8\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":522,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/circle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-up-down\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":100,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-60,\"sizes\":[]},\"_offset_orientation_v\":\"end\",\"_offset_y_end\":{\"unit\":\"px\",\"size\":120,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"5efece0a\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Services\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"30\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"css_classes\":\"op-section\"},\"elements\":[{\"id\":\"3bf8e8c5\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#7E5A7B\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"1fa5932f\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":515,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_preciese.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"29d71208\",\"elType\":\"widget\",\"settings\":{\"title\":\"PIXEL PRECISE\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#F8F3F7\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"75748f10\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#F393A4\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"42a1232c\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-75,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":-71.400000000000005684341886080801486968994140625,\"sizes\":[]},\"_offset_y\":{\"size\":-55,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":92,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"abf718c\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":517,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_secure.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"645fc856\",\"elType\":\"widget\",\"settings\":{\"title\":\"SECURE\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#F8F3F7\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"3785904d\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"e2c591c\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":516,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_responsive.png\"},\"image_size\":\"full\",\"link_to\":\"custom\",\"width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"4a108d1e\",\"elType\":\"widget\",\"settings\":{\"title\":\"RESPONSIVE\",\"header_size\":\"div\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_font_weight\":\"700\",\"title_color\":\"#F8F3F7\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"20d8bfb3\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Cover Letter\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"21\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"cover-letter\"},\"elements\":[{\"id\":\"7bbb1bfe\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"7310c760\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-75,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":-71.400000000000005684341886080801486968994140625,\"sizes\":[]},\"_offset_y\":{\"size\":-55,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":92,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"3024b7c7\",\"elType\":\"widget\",\"settings\":{\"title\":\"Cover <br>Letter\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false},{\"id\":\"32c3cde7\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"64321d12\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Dolor sit amet, consectetur adipiscing elit viverra tristique placerat in massa consectetur quisque nunc ac fames lorem ipsum dolormo<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"1d1b257a\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Faucibus sed tristique fames sed aliquet ultricies eget viverra arcu. Vitae faucibus diam consequat maecenas. Turpis metus sit diam purus leo in varius ac quam. Nunc amet tristique volutpat adipiscing vulputate phasellus. Volutpat faucibus praesent ac lobortis aliquam dolor. Eget enim aliquam euismod mauris in vitae viverra blandit lectus diam feugiat mattis metus, parturient ipsum id nibh tortor tincidunt quam facilisi nunc faucib.<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"64666b64\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Vitae faucibus diam consequat maecenas. Turpis metus sit diam purus leo in varius ac quam. Nunc amet tristique volutpat piscing vulputate phasellus lorem ipsum poterius holutiko lorem ipsum.<\\/p>\",\"text_color\":\"#605777\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"5d2df679\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":518,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/icon_signature.png\"},\"image_size\":\"full\",\"align\":\"right\",\"width\":{\"unit\":\"px\",\"size\":125,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"22d6fdac\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":523,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/square.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-rotate\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":110,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"size\":-190,\"unit\":\"px\"},\"_offset_orientation_v\":\"end\",\"_offset_y_end\":{\"size\":-40,\"unit\":\"px\"}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"4616d8f\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Education\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"education\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"483cd999\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"30\",\"isLinked\":false}},\"elements\":[{\"id\":\"76b9110\",\"elType\":\"widget\",\"settings\":{\"items\":[{\"title\":\"<b>Start<\\/b> \\n\\n<br> \\n\\nNunc amet tristique volutpat adipiscing vulputate phasellus eget enim aliquam euismod lorem ispum teoro muniote lore.\",\"_id\":\"291265d\",\"year\":\"2015\"},{\"title\":\"<b>Basic Level<\\/b> \\n\\n<br> \\n\\nTurpis metus sit diam purus leo in varius ac quam nunc amet tristique volutpat adipisc vulputate phasellus eget enim aliquam euismod mauris in vitae viverra kolomisu.\",\"year\":\"2016\",\"_id\":\"fece03c\"},{\"title\":\"<b>Master Level<\\/b> \\n\\n<br> \\n\\nPlacerat in massa consectetur quisque nunc ac fames lectus in libero aliquet estlo.\",\"year\":\"2017\",\"_id\":\"d2c1904\"},{\"title\":\"<b>Pro Level<\\/b> \\n\\n<br> \\n\\nEget enim aliquam euismod mauris in vitae viverra blandit lectus faucibus diam consequat maecenas turpis metus sitomo.\",\"year\":\"2018\",\"_id\":\"926a437\"}],\"content_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"coco-timeline\"}],\"isInner\":false},{\"id\":\"5cf8d351\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"010\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#F393A4\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"1ff21d9b\",\"elType\":\"widget\",\"settings\":{\"title\":\"Education\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"705ff71b\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_orientation_h\":\"end\",\"_offset_orientation_v\":\"end\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"46d2c91\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Facts\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"facts\"},\"elements\":[{\"id\":\"06271c5\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"3f38a91\",\"elType\":\"widget\",\"settings\":{\"title\":\"Facts\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"971a1d5\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":521,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/triangle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-down-rigt-up\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":94,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x\":{\"size\":-100,\"unit\":\"px\"},\"_offset_x_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_y\":{\"size\":30,\"unit\":\"px\"},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_orientation_h\":\"end\",\"_offset_orientation_v\":\"end\"},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"9cd6740\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"866f96b\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Dolor sit amet, consectetur adipiscing elit viverra tristique placerat in massa consectetur quisque nunc ac fames lorem ipsum dolormo<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"3c96c5b\",\"elType\":\"section\",\"settings\":{\"structure\":\"20\"},\"elements\":[{\"id\":\"154ea2d\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null},\"elements\":[{\"id\":\"923b4f2\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-coffee\",\"library\":\"fa-solid\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"87b2c09\",\"elType\":\"widget\",\"settings\":{\"starting_number\":9,\"ending_number\":13,\"title\":\"Cups of Coffee\",\"number_color\":\"#605777\",\"typography_number_typography\":\"custom\",\"typography_number_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"typography_number_font_weight\":\"700\",\"title_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"counter\"}],\"isInner\":true},{\"id\":\"8c3eaae\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null},\"elements\":[{\"id\":\"7eed9c5\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-cloud-download-alt\",\"library\":\"fa-solid\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"f40d9f2\",\"elType\":\"widget\",\"settings\":{\"starting_number\":200,\"ending_number\":250,\"title\":\"GB Download\",\"number_color\":\"#605777\",\"typography_number_typography\":\"custom\",\"typography_number_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"typography_number_font_weight\":\"700\",\"title_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"counter\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"673b900\",\"elType\":\"section\",\"settings\":{\"structure\":\"20\",\"margin\":{\"unit\":\"px\",\"top\":\"20\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false}},\"elements\":[{\"id\":\"c4dbc7e\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null},\"elements\":[{\"id\":\"abe93a1\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-code\",\"library\":\"fa-solid\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"af5bd78\",\"elType\":\"widget\",\"settings\":{\"starting_number\":2,\"ending_number\":3.29999999999999982236431605997495353221893310546875,\"suffix\":\"K\",\"title\":\"Lines of Code\",\"number_color\":\"#605777\",\"typography_number_typography\":\"custom\",\"typography_number_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"typography_number_font_weight\":\"700\",\"title_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"counter\"}],\"isInner\":true},{\"id\":\"3b6a4c7\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":null},\"elements\":[{\"id\":\"a32a5c6\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"fas fa-images\",\"library\":\"fa-solid\"},\"primary_color\":\"#F393A4\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"7311bfd\",\"elType\":\"widget\",\"settings\":{\"starting_number\":730,\"ending_number\":743,\"title\":\"Photos  \\/ Week\",\"number_color\":\"#605777\",\"typography_number_typography\":\"custom\",\"typography_number_font_size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"typography_number_font_weight\":\"700\",\"title_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"counter\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false}],\"isInner\":false},{\"id\":\"b93f393\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Experience\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"22\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"experience\",\"reverse_order_mobile\":\"reverse-mobile\"},\"elements\":[{\"id\":\"12ba158\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#F8F3F7\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"c0a09d4\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Dolor sit amet, consectetur adipiscing elit viverra tristique placerat in massa consectetur<\\/p>\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]},\"text_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"b714e6a\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Faucibus sed tristique fames sed aliquet ultricies eget viverra arcu. Vitae faucibus diam consequat maecenas. Turpis metus sit diam purus leo in varius ac quam. Nunc amet tristique volutpat adipiscing vulputate phasellus. Volutpat faucibus praesent acolo.<\\/p>\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"text_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"ac823f1\",\"elType\":\"widget\",\"settings\":{\"tabs\":[{\"tab_title\":\"Photography Assistant\",\"tab_content\":\"<p><strong>2012 - 2014<\\/strong><\\/p><p>In sodales suscipit velit sagittis tristique aliquam consectetur eros at viverra aliquet suspendisse potenti lorem ipsum dolo colomose positive aratovi del nenosico.<\\/p>\",\"_id\":\"024a8c4\"},{\"tab_title\":\"Junior Designer\",\"tab_content\":\"<p><strong>2014 - 2016<\\/strong><\\/p><p>Nulla tristique nulla eget nibh lobortis porta quisque posuere iaculis maximus. Aliquam quis hendrerit dui lore.<\\/p>\",\"_id\":\"8a56075\"},{\"tab_title\":\"Senior Designer\",\"tab_content\":\"<p><strong>2016 - 2017<\\/strong><\\/p><p>Proin mollis sapien quis elit aliquam, vitae placerat neque aliquam suspendisse dapibus elit nec pretium gravida. Sed gravida, libero ac tristique tristique, elit quam dignom.<\\/p>\",\"_id\":\"072e6f7\"},{\"tab_title\":\"Team Leader \",\"tab_content\":\"<p><strong>2017 - 2020<\\/strong><\\/p><p>Ksem, non porta lorem dolor eget augue aliquam eu ante tincidunt, tincidunt nibh quis, accumsan metus doloe.<\\/p>\",\"_id\":\"27dcc94\"}],\"selected_icon\":{\"value\":\"fas fa-caret-down\",\"library\":\"fa-solid\"},\"border_width\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"space_between\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"title_background\":\"#605777\",\"title_color\":\"#FFFFFF\",\"tab_active_color\":\"#FFFFFF\",\"icon_align\":\"right\",\"content_background_color\":\"#FFFFFF\",\"content_typography_line_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"content_padding\":{\"unit\":\"px\",\"top\":\"23\",\"right\":\"25\",\"bottom\":\"23\",\"left\":\"25\",\"isLinked\":false},\"content_color\":\"#605777\"},\"elements\":[],\"widgetType\":\"toggle\"}],\"isInner\":false},{\"id\":\"fcc60c8\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#7E5A7B\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"e119716\",\"elType\":\"widget\",\"settings\":{\"title\":\"Experience\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"640cc2f\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":522,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/circle.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-up-down\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":100,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-60,\"sizes\":[]},\"_offset_y_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_x\":{\"unit\":\"px\",\"size\":-45,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"da7ba6b\",\"elType\":\"section\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":false},\"_title\":\"Contact\",\"css_classes\":\"op-section\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false},\"margin_tablet\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true},\"background_background\":\"classic\",\"custom_height\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"column_position\":\"stretch\",\"structure\":\"21\",\"content_width\":{\"unit\":\"px\",\"size\":1150,\"sizes\":[]},\"_element_id\":\"contact\"},\"elements\":[{\"id\":\"78db0d70\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null,\"padding\":{\"unit\":\"px\",\"top\":\"150\",\"right\":\"10\",\"bottom\":\"150\",\"left\":\"10\",\"isLinked\":false},\"content_position\":\"center\",\"background_background\":\"classic\",\"background_color\":\"#362F47\",\"space_between_widgets_mobile\":0,\"padding_tablet\":{\"unit\":\"px\",\"top\":\"100\",\"right\":\"10\",\"bottom\":\"100\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"4cfc3491\",\"elType\":\"widget\",\"settings\":{\"title\":\"Contact\",\"align\":\"center\",\"title_color\":\"#F4F4F4\",\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":54,\"sizes\":[]},\"typography_font_weight\":\"300\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-4,\"sizes\":[]},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":40,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"2a567e6\",\"elType\":\"widget\",\"settings\":{\"image\":{\"id\":520,\"url\":\"https:\\/\\/demo.cocobasic.com\\/teoro-wp\\/demo-1\\/wp-content\\/uploads\\/2020\\/08\\/zigzag.png\"},\"image_size\":\"full\",\"_css_classes\":\"cocobasic-left-rigt\",\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"unit\":\"px\",\"size\":-30,\"sizes\":[]},\"_offset_y_end\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"_offset_y\":{\"unit\":\"px\",\"size\":90,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"359bfd64\",\"elType\":\"column\",\"settings\":{\"_column_size\":66,\"_inline_size\":null,\"padding\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"18\",\"bottom\":\"13\",\"left\":\"18\",\"isLinked\":false},\"background_background\":\"classic\",\"background_color\":\"#EAE0E9\",\"padding_tablet\":{\"unit\":\"%\",\"top\":\"13\",\"right\":\"10\",\"bottom\":\"13\",\"left\":\"10\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"15\",\"bottom\":\"30\",\"left\":\"15\",\"isLinked\":false}},\"elements\":[{\"id\":\"51c97412\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Dolor sit amet, consectetur adipiscing elit viverra tristique placerat in massa consectetur<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]},\"typography_typography\":\"custom\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"600\",\"typography_line_height\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"39c22072\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Faucibus sed tristique fames sed aliquet ultricies eget viverra arcu. Vitae faucibus diam consequat maecenas. Turpis metus sit diam purus leo in varius ac quam. Nunc amet tristique volutpat adipiscing vulputate phasellus. Volutpat faucibus praesent acolo.<\\/p>\",\"text_color\":\"#605777\",\"_element_custom_width\":{\"unit\":\"px\",\"size\":560,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"3cb74d82\",\"elType\":\"widget\",\"settings\":{\"contactform\":\"[contact-form-7 id=\\\"336\\\" title=\\\"Teoro Contact Form\\\"]\",\"_margin\":{\"unit\":\"px\",\"top\":\"30\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"content_color\":\"#605777\",\"send_button_hover_color\":\"#FFFFFF\",\"_margin_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true}},\"elements\":[],\"widgetType\":\"coco-contactform\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `wp_postmeta` VALUES("246","216","_elementor_controls_usage","a:0:{}");
INSERT INTO `wp_postmeta` VALUES("247","216","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("253","336","_elementor_controls_usage","a:0:{}");
INSERT INTO `wp_postmeta` VALUES("254","336","_mail","a:9:{s:6:\"active\";b:1;s:7:\"subject\";s:30:\"[_site_title] \"[your-subject]\"\";s:6:\"sender\";s:38:\"[_site_title] <contact@amrelarabi.com>\";s:9:\"recipient\";s:43:\"[_site_admin_email], contact@amrelarabi.com\";s:4:\"body\";s:163:\"From: [your-name] <[your-email]>
Subject: [your-subject]

Message Body:
[your-message]

-- 
This e-mail was sent from a contact form on [_site_title] ([_site_url])\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("255","336","_form","<p class=\"relative\">
[text* your-name] <span class=\"input-default-text\">Name</span>
</p>

<p class=\"relative\">
[email* your-email] <span class=\"input-default-text\">Email</span>
</p>

<p class=\"relative\">
[text your-subject] <span class=\"input-default-text\">Subject</span>
</p>

<p class=\"relative\">
[textarea your-message] <span class=\"input-default-text\">Message</span>
</p>

<p class=\"contact-submit-holder\">[submit \"Send Message\"]</p>");
INSERT INTO `wp_postmeta` VALUES("256","336","_mail_2","a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:22:\"Volos \"[your-subject]\"\";s:6:\"sender\";s:36:\"Volos <wordpress@demo.cocobasic.com>\";s:9:\"recipient\";s:12:\"[your-email]\";s:4:\"body\";s:128:\"Message Body:
[your-message]

-- 
This e-mail was sent from a contact form on Volos (https://demo.cocobasic.com/volos-wp/demo-1)\";s:18:\"additional_headers\";s:35:\"Reply-To: cocobasicthemes@gmail.com\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("257","336","_messages","a:22:{s:12:\"mail_sent_ok\";s:45:\"Thank you for your message. It has been sent.\";s:12:\"mail_sent_ng\";s:71:\"There was an error trying to send your message. Please try again later.\";s:16:\"validation_error\";s:61:\"One or more fields have an error. Please check and try again.\";s:4:\"spam\";s:71:\"There was an error trying to send your message. Please try again later.\";s:12:\"accept_terms\";s:69:\"You must accept the terms and conditions before sending your message.\";s:16:\"invalid_required\";s:22:\"The field is required.\";s:16:\"invalid_too_long\";s:22:\"The field is too long.\";s:17:\"invalid_too_short\";s:23:\"The field is too short.\";s:13:\"upload_failed\";s:46:\"There was an unknown error uploading the file.\";s:24:\"upload_file_type_invalid\";s:49:\"You are not allowed to upload files of this type.\";s:21:\"upload_file_too_large\";s:20:\"The file is too big.\";s:23:\"upload_failed_php_error\";s:38:\"There was an error uploading the file.\";s:12:\"invalid_date\";s:29:\"The date format is incorrect.\";s:14:\"date_too_early\";s:44:\"The date is before the earliest one allowed.\";s:13:\"date_too_late\";s:41:\"The date is after the latest one allowed.\";s:14:\"invalid_number\";s:29:\"The number format is invalid.\";s:16:\"number_too_small\";s:47:\"The number is smaller than the minimum allowed.\";s:16:\"number_too_large\";s:46:\"The number is larger than the maximum allowed.\";s:23:\"quiz_answer_not_correct\";s:36:\"The answer to the quiz is incorrect.\";s:13:\"invalid_email\";s:38:\"The e-mail address entered is invalid.\";s:11:\"invalid_url\";s:19:\"The URL is invalid.\";s:11:\"invalid_tel\";s:32:\"The telephone number is invalid.\";}");
INSERT INTO `wp_postmeta` VALUES("258","336","_additional_settings","");
INSERT INTO `wp_postmeta` VALUES("259","336","_locale","en_US");
INSERT INTO `wp_postmeta` VALUES("822","65","portfolio_hover_thumb_text","By using python");
INSERT INTO `wp_postmeta` VALUES("823","65","portfolio_thumb_image_size","p_one_half");
INSERT INTO `wp_postmeta` VALUES("801","669","_wp_attached_file","2019/11/istockphoto-961335672-612x612-1.jpg");
INSERT INTO `wp_postmeta` VALUES("802","669","_wp_attachment_metadata","a:5:{s:5:\"width\";i:612;s:6:\"height\";i:266;s:4:\"file\";s:43:\"2019/11/istockphoto-961335672-612x612-1.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:43:\"istockphoto-961335672-612x612-1-300x130.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:130;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:43:\"istockphoto-961335672-612x612-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:24:\"Getty Images/iStockphoto\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:65:\"Businessman holding a phone with a shopping icon. Online shopping\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:65:\"Businessman holding a phone with a shopping icon. Online shopping\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("809","670","_wp_attached_file","2019/11/Workout-Wallpaper-01-1600-x-843.jpg");
INSERT INTO `wp_postmeta` VALUES("810","670","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1600;s:6:\"height\";i:843;s:4:\"file\";s:43:\"2019/11/Workout-Wallpaper-01-1600-x-843.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:43:\"Workout-Wallpaper-01-1600-x-843-300x158.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:158;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:44:\"Workout-Wallpaper-01-1600-x-843-1024x540.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:540;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:43:\"Workout-Wallpaper-01-1600-x-843-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:43:\"Workout-Wallpaper-01-1600-x-843-768x405.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:405;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:44:\"Workout-Wallpaper-01-1600-x-843-1536x809.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:809;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("273","589","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("274","589","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("275","589","_menu_item_object_id","216");
INSERT INTO `wp_postmeta` VALUES("276","589","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("277","589","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("278","589","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("279","589","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("280","589","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("305","597","_wp_attached_file","2020/12/me-1.jpg");
INSERT INTO `wp_postmeta` VALUES("306","597","_wp_attachment_metadata","a:5:{s:5:\"width\";i:600;s:6:\"height\";i:760;s:4:\"file\";s:16:\"2020/12/me-1.jpg\";s:5:\"sizes\";a:2:{s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"me-1-237x300.jpg\";s:5:\"width\";i:237;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"me-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("287","592","_wp_attached_file","2020/12/4233171cc00d9e46d3ff26822e17e6b0.png");
INSERT INTO `wp_postmeta` VALUES("288","592","_wp_attachment_metadata","a:5:{s:5:\"width\";i:64;s:6:\"height\";i:64;s:4:\"file\";s:44:\"2020/12/4233171cc00d9e46d3ff26822e17e6b0.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("289","593","_wp_attached_file","2020/12/cropped-4233171cc00d9e46d3ff26822e17e6b0.png");
INSERT INTO `wp_postmeta` VALUES("290","593","_wp_attachment_context","site-icon");
INSERT INTO `wp_postmeta` VALUES("291","593","_wp_attachment_metadata","a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:52:\"2020/12/cropped-4233171cc00d9e46d3ff26822e17e6b0.png\";s:5:\"sizes\";a:6:{s:6:\"medium\";a:4:{s:4:\"file\";s:52:\"cropped-4233171cc00d9e46d3ff26822e17e6b0-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:52:\"cropped-4233171cc00d9e46d3ff26822e17e6b0-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-270\";a:4:{s:4:\"file\";s:52:\"cropped-4233171cc00d9e46d3ff26822e17e6b0-270x270.png\";s:5:\"width\";i:270;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-192\";a:4:{s:4:\"file\";s:52:\"cropped-4233171cc00d9e46d3ff26822e17e6b0-192x192.png\";s:5:\"width\";i:192;s:6:\"height\";i:192;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-180\";a:4:{s:4:\"file\";s:52:\"cropped-4233171cc00d9e46d3ff26822e17