<?php
/**
 * AI Assistant for the WPadmin  plugin settings class.
 *
 * @package AI_Assistant_For_The_WPadmin
 * @since 1.0.0
 */

/**
 * Settings for AI Assistant for the WPadmin  plugin.
 */
defined( 'ABSPATH' ) || exit;

/**
 * Register settings class for the plugin.
 */
class Ai_Assistant_For_Wpadmin_Settings {
	/**
	 * Constructor method for the class.
	 * Hooks into WordPress actions to register settings and add settings page.
	 */
	public function __construct() {
		add_action( 'admin_init', array( $this, 'register_settings' ) );
		add_action( 'admin_menu', array( $this, 'add_settings_page' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
	}

	/**
	 * Enqueues the necessary scripts and styles for the settings page.
	 * Only enqueues them for users with the 'manage_options' capability.
	 *
	 * @return void
	 */
	public function enqueue_scripts() {
		if ( ! isset( $_GET['page'] ) || 'ai-assistant-for-wpadmin-settings' !== $_GET['page'] ) {//phpcs:ignore
			return;
		}
		wp_enqueue_script( 'ai-assistant-for-wpadmin-settings', AI_ASSISTANT_URL . 'assets/js/settings.js', array( 'jquery' ), AI_ASSISTANT_VERSION, true );
		wp_enqueue_style( 'ai-assistant-for-wpadmin-settings-style', AI_ASSISTANT_URL . 'assets/css/settings.css', array(), AI_ASSISTANT_VERSION );
	}

	/**
	 * Registers the settings for the plugin.
	 * This method is called on the 'admin_init' action.
	 *
	 * @return void
	 */
	public function register_settings() {
		register_setting(
			'ai_assistant_for_the_wpadmin_group',
			'ai_assistant_for_the_wpadmin',
			array(
				'type'              => 'string',
				'description'       => 'AI Assistant for the WPadmin settings',
				'show_in_rest'      => true,
				'default'           => '',
				'sanitize_callback' => array( $this, 'sanitize_settings' ),
			)
		);
	}

	/**
	 * Sanitizes the settings input.
	 * This method is called when saving the settings.
	 *
	 * @param mixed $input The input value to sanitize.
	 * @return mixed The sanitized value.
	 */
	public function sanitize_settings( $input ) {
		// Sanitize the input value here.
		$sanitized_input = sanitize_text_field( $input );
		return $sanitized_input;
	}

	/**
	 * Adds the settings page to the WordPress admin menu.
	 * This method is called on the 'admin_menu' action.
	 *
	 * @return void
	 */
	public function add_settings_page() {
		add_options_page(
			'AI Assistant for the WPadmin  Settings',
			'AI Assistant for the WPadmin ',
			'manage_options',
			'ai-assistant-for-wpadmin-settings',
			array( $this, 'settings_page_callback' )
		);
	}

	/**
	 * Callback function for rendering the settings page.
	 * This method is called when the settings page is accessed.
	 *
	 * @return void
	 */
	public function settings_page_callback() {
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}
		$subscription_details = Ai_Assistant_For_Wpadmin_Subscription::get_subscription_details();
		$subscription_status  = $subscription_details['subscription_status'];
		$plan_name            = $subscription_details['plan_name'];
		$billing_frequency    = $subscription_details['billing_frequency'];
		$renewal_date         = $subscription_details['renewal_date'];
		$status               = $subscription_details['status'];
		$last_payment         = $subscription_details['last_payment'];
		include AI_ASSISTANT_DIR . 'templates/ai-assistant-for-wpadmin-settings.php';
	}
}
new Ai_Assistant_For_Wpadmin_Settings();
