<?php
/**
 * AI Assistant for the WPadmin chatbox template.
 *
 * @package AI_Assistant_For_The_WPadmin
 * @since 1.0.0
 */

defined( 'ABSPATH' ) || exit;
if ( ! current_user_can( 'manage_options' ) ) {
	return;
}
$current_path = isset( $_SERVER['REQUEST_URI'] ) ? sanitize_url( wp_unslash( $_SERVER['REQUEST_URI'] ) ) : '';
$current_path = site_url( $current_path );
?>
<div class="ai-assistant-for-wpadmin-chatbox-container" id="ai-assistant-for-wpadmin-chatbox-container">
	<span>
		<button id="ai-assistant-for-wpadmin-chatbox-close" class="ai-assistant-for-wpadmin-chatbox-close hidden">
			<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon-2xl"><path fill-rule="evenodd" clip-rule="evenodd" d="M16.0001 14.8284L21.6569 9.17157C22.0125 8.81595 22.0125 8.18405 21.6569 7.82843C21.3013 7.47281 20.6694 7.47281 20.3138 7.82843L14.9999 13.1423L9.68604 7.82843C9.33042 7.47281 8.69853 7.47281 8.34291 7.82843C7.98729 8.18405 7.98729 8.81595 8.34291 9.17157L13.9997 14.8284L8.34386 20.4842C7.98824 20.8398 7.98824 21.4717 8.34386 21.8273C8.69948 22.1829 9.33137 22.1829 9.68699 21.8273L15.0001 16.5144L20.3139 21.8273C20.6695 22.1829 21.3014 22.1829 21.6571 21.8273C22.0127 21.4717 22.0127 20.8398 21.6571 20.4842L16,14Z" fill="currentColor"></path></svg>
		</button>
	</span>
	<div id="ai-assistant-for-wpadmin-results" class="ai-assistant-for-wpadmin-results hidden">
	</div>
	<div id="ai-assistant-for-wpadmin-chatbox" class="ai-assistant-for-wpadmin-chatbox">
		<div class="ai-assistant-for-wpadmin-chatbox-textarea">
			<textarea id="ai-assistant-for-wpadmin-chatbox-input" placeholder="<?php esc_html_e( 'Ask anything', 'ai-assistant-for-wpadmin' ); ?>"></textarea>
		</div>
		<div class="ai-assistant-for-wpadmin-chatbox-actions">
			<div class="ai-assistant-for-wpadmin-chatbox-actions-left">
				<a id="ai-assistant-for-wpadmin-chatbox-settings" class="ai-assistant-for-wpadmin-chatbox-button outline" href="<?php echo esc_url( admin_url( 'options-general.php?page=ai-assistant-for-wpadmin-settings' ) ); ?>">
					<img src="<?php echo esc_url( AI_ASSISTANT_URL . 'assets/images/logo.png' ); ?>" alt="<?php esc_html_e( 'Settings', 'ai-assistant-for-wpadmin' ); ?>" class="icon-2xl" /><?php // phpcs:disable PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage ?>
				</a>
			</div>
			<div class="ai-assistant-for-wpadmin-chatbox-actions-right">
				<input type="hidden" id="ai_assistant_for_the_wpadmin_nonce" value="<?php echo esc_attr( wp_create_nonce( 'ai_assistant_for_the_wpadmin_nonce' ) ); ?>" />
				<input type="hidden" id="ai-assistant-for-wpadmin-chatbox-context" value="<?php echo esc_attr( get_admin_page_title() ); ?>" />
				<input type="hidden" id="ai-assistant-for-wpadmin-chatbox-path-url" value="<?php echo esc_url( $current_path ); ?>" />
				<button id="ai-assistant-for-wpadmin-chatbox-send" class="ai-assistant-for-wpadmin-chatbox-button disabled">
					<svg class="play" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M15.1918 8.90615C15.6381 8.45983 16.3618 8.45983 16.8081 8.90615L21.9509 14.049C22.3972 14.4953 22.3972 15.2189 21.9509 15.6652C21.5046 16.1116 20.781 16.1116 20.3347 15.6652L17.1428 12.4734V22.2857C17.1428 22.9169 16.6311 23.4286 15.9999 23.4286C15.3688 23.4286 14.8571 22.9169 14.8571 22.2857V12.4734L11.6652 15.6652C11.2189 16.1116 10.4953 16.1116 10.049 15.6652C9.60265 15.2189 9.60265 14.4953 10.049 14.049L15.1918 8.90615Z" fill="currentColor"></path></svg>
					<svg class="stop" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path d="M304 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm0 416a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM48 304a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm464-48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM142.9 437A48 48 0 1 0 75 369.1 48 48 0 1 0 142.9 437zm0-294.2A48 48 0 1 0 75 75a48 48 0 1 0 67.9 67.9zM369.1 437A48 48 0 1 0 437 369.1 48 48 0 1 0 369.1 437z"/></svg>
				</button>
			</div>
		</div>
	</div>
</div>
