<?php
/**
 * AI Assistant for the WPadmin  settings page.
 *
 * @package AI_Assistant_For_The_WPadmin
 * @since 1.0.0
 */

defined( 'ABSPATH' ) || exit;

if ( ! current_user_can( 'manage_options' ) ) {
	return;
}
$free_subscription_url    = Ai_Assistant_For_Wpadmin_Subscription::get_subscription_url( 'free' );
$premium_subscription_url = Ai_Assistant_For_Wpadmin_Subscription::get_subscription_url( 'premium' );
$premium_subscription_url = '#';
?>
<div class="ai-assistant-for-wpadmin-settings">
	<div class="wrap">
		<h1><?php esc_html_e( 'AI Assistant for the WPadmin  Settings', 'ai-assistant-for-wpadmin' ); ?></h1>
		<p class="ai-assistant-for-wpadmin-manage"><?php esc_html_e( 'Manage your AI Assistant for the WPadmin  subscription and settings.', 'ai-assistant-for-wpadmin' ); ?></p>
	<?php
	if ( 'active' === $subscription_status || 'pending-cancel' === $subscription_status ) :
		?>
		<div class="ai-assistant-for-wpadmin-subscription-status active">
			<h2><?php esc_html_e( 'Subscription Status', 'ai-assistant-for-wpadmin' ); ?></h2>
			<p><?php echo esc_html( 'Your subscription is ' . ( 'active' === $subscription_status ? 'Active.' : 'Pending Cancel.' ) . '' ); ?></p>
			<ul>
				<li><strong><?php esc_html_e( 'Plan Name:', 'ai-assistant-for-wpadmin' ); ?></strong> <?php echo esc_html( $plan_name ); ?></li>
				<li><strong><?php esc_html_e( 'Billing Frequency:', 'ai-assistant-for-wpadmin' ); ?></strong> <?php echo esc_html( $billing_frequency ); ?></li>
				<li><strong><?php esc_html_e( 'Renewal Date:', 'ai-assistant-for-wpadmin' ); ?></strong> <?php echo esc_html( $renewal_date ); ?></li>
				<li><strong><?php esc_html_e( 'Status:', 'ai-assistant-for-wpadmin' ); ?></strong> <?php echo esc_html( $status ); ?></li>
				<li><strong><?php esc_html_e( 'Last Payment:', 'ai-assistant-for-wpadmin' ); ?></strong> <?php echo esc_html( $last_payment ); ?></li>
			</ul>
			<div class="ai-assistant-for-wpadmin-action-btns">
				<?php
				if ( 'pending-cancel' !== $subscription_status ) :
					?>
					<a target="_blank" href="<?php echo esc_url( AI_ASSISTANT_SUBSCRIPTIONS ); ?>" class="button"><?php esc_html_e( 'Upgrade or Downgrade Plan', 'ai-assistant-for-wpadmin' ); ?></a>
					<?php
				endif;
				if ( 'pending-cancel' === $subscription_status ) :
					?>
					<a target="_blank" href="<?php echo esc_url( AI_ASSISTANT_SUBSCRIPTIONS ); ?>" class="button green"><?php esc_html_e( 'Resume Subscription', 'ai-assistant-for-wpadmin' ); ?></a>
					<?php
				else :
					?>
					<a target="_blank" href="<?php echo esc_url( AI_ASSISTANT_SUBSCRIPTIONS ); ?>" class="button cancel"><?php esc_html_e( 'Cancel Subscription', 'ai-assistant-for-wpadmin' ); ?></a>
					<?php
				endif;
				?>
			</div>
		</div>
		<?php
	else :
		?>
		<div class="ai-assistant-for-wpadmin-no-subscription">
			<?php
			if ( 'expired' === $subscription_status ) {
				echo '<h2>' . esc_html__( 'Subscription Expired', 'ai-assistant-for-wpadmin' ) . '</h2>';
				echo '<p>' . esc_html__( 'Your subscription has expired. Please renew your subscription to continue using AI Assistant for the WPadmin .', 'ai-assistant-for-wpadmin' ) . '</p>';
			} elseif ( 'cancelled' === $subscription_status ) {
				echo '<h2>' . esc_html__( 'Subscription Cancelled', 'ai-assistant-for-wpadmin' ) . '</h2>';
				echo '<p>' . esc_html__( 'Your subscription has been cancelled. Please renew your subscription to continue using AI Assistant for the WPadmin .', 'ai-assistant-for-wpadmin' ) . '</p>';
			} elseif ( 'on-hold' === $subscription_status ) {
				echo '<h2>' . esc_html__( 'Subscription On Hold', 'ai-assistant-for-wpadmin' ) . '</h2>';
				echo '<p>' . esc_html__( 'Your subscription is on hold. Please check your payment method or contact support.', 'ai-assistant-for-wpadmin' ) . '</p>';
			} else {
				echo '<h2>' . esc_html__( 'No Subscription Found', 'ai-assistant-for-wpadmin' ) . '</h2>';
				echo '<p>' . esc_html__( 'You do not have an active subscription. Please choose a plan below:', 'ai-assistant-for-wpadmin' ) . '</p>';
			}

			?>
			<div class="ai-assistant-for-wpadmin-subscription-plans">
				<div class="ai-assistant-for-wpadmin-subscription-plan">
					<h2><?php esc_html_e( 'Free Plan', 'ai-assistant-for-wpadmin' ); ?></h2>
					<span class="price"><span class="currence">$</span><span class="price-value"><?php esc_html_e( '0.00', 'ai-assistant-for-wpadmin' ); ?></span><span class="frequence">/<?php esc_html_e( 'month', 'ai-assistant-for-wpadmin' ); ?></span></span>
					<ul>
						<li><?php esc_html_e( '30 questions limit', 'ai-assistant-for-wpadmin' ); ?></li>
						<li><?php esc_html_e( 'Step-by-step Instructions', 'ai-assistant-for-wpadmin' ); ?></li>
						<li><?php esc_html_e( 'troubleshooting help', 'ai-assistant-for-wpadmin' ); ?></li>
						<li><?php esc_html_e( 'plugin assistance', 'ai-assistant-for-wpadmin' ); ?></li>
					</ul>
					<a href="<?php echo esc_url( $free_subscription_url ); ?>" class="button"><?php esc_html_e( 'Choose Free Plan', 'ai-assistant-for-wpadmin' ); ?></a>
				</div>
				<div class="ai-assistant-for-wpadmin-subscription-plan active">
					<h2><?php esc_html_e( 'Premium Plan', 'ai-assistant-for-wpadmin' ); ?></h2>
					<span class="price"><span class="currence">$</span><span class="price-value"><?php esc_html_e( '9.00', 'ai-assistant-for-wpadmin' ); ?></span><span class="price-value-discounted"><?php esc_html_e( '19.00', 'ai-assistant-for-wpadmin' ); ?></span><span class="frequence">/<?php esc_html_e( 'month', 'ai-assistant-for-wpadmin' ); ?></span></span>
					<ul>
						<li><?php esc_html_e( 'Everything in Free plan', 'ai-assistant-for-wpadmin' ); ?></li>
						<li><?php esc_html_e( '150 questions Limit', 'ai-assistant-for-wpadmin' ); ?></li>
						<li><?php esc_html_e( 'No Ads/Sponsor Content', 'ai-assistant-for-wpadmin' ); ?></li>
						<li><?php esc_html_e( 'Data Analysis', 'ai-assistant-for-wpadmin' ); ?></li>
						<li><?php esc_html_e( 'Early access to new features', 'ai-assistant-for-wpadmin' ); ?></li>
						<li><?php esc_html_e( 'Premium Support', 'ai-assistant-for-wpadmin' ); ?></li>
					</ul>
					<a href="<?php echo esc_url( $premium_subscription_url ); ?>" class="button"><?php esc_html_e( 'Comming Soon', 'ai-assistant-for-wpadmin' ); ?></a>
				</div>
			</div>
		</div>
		<?php
	endif;
	?>
</div>
