<?php

namespace CocoBasicElements\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\utils;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class coco_portfolio extends Widget_Base {

    public function get_name() {
        return 'coco-portfolio';
    }

    public function get_title() {
        return __('Portfolio', 'cocobasic-elementor');
    }

    public function get_icon() {
        return 'fa fa-th';
    }

    public function get_categories() {
        return array('coco-element');
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'section_process_1', [
            'label' => __('Content', 'cocobasic-elementor'),
                ]
        );

        $this->add_control(
                'num', [
            'label' => __('Number of items to show before "Load More"', 'cocobasic-elementor'),
            'type' => Controls_Manager::TEXT,
            'label_block' => true,
            'default' => esc_attr__('4', 'cocobasic-elementor'),
                ]
        );

        $this->add_control(
                'loadmore_text', [
            'label' => __('Load More text', 'cocobasic-elementor'),
            'type' => Controls_Manager::TEXT,
            'label_block' => true,
            'default' => 'LOAD MORE',
                ]
        );

        $this->add_control(
                'loadmore_loading_text', [
            'label' => __('Loading text', 'cocobasic-elementor'),
            'type' => Controls_Manager::TEXT,
            'label_block' => true,
            'default' => 'LOADING',
                ]
        );

        $this->add_control(
                'loadmore_nomore_text', [
            'label' => __('No more text', 'cocobasic-elementor'),
            'type' => Controls_Manager::TEXT,
            'label_block' => true,
            'default' => 'NO MORE',
                ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
                'section_general', [
            'label' => esc_attr__('General', 'cocobasic-elementor'),
            'tab' => Controls_Manager::TAB_STYLE,
                ]
        );

        $this->add_control(
                'overlay_color', [
            'label' => __('Item overlay color', 'cocobasic-elementor'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .portfolio-text-holder' => 'background-color: {{VALUE}};',
            ],
                ]
        );

        $this->add_control(
                'title_color', [
            'label' => __('Title color', 'cocobasic-elementor'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .portfolio-text' => 'color: {{VALUE}};',
            ],
                ]
        );

        $this->add_group_control(
                Group_Control_Typography::get_type(), [
            'name' => 'title_typography',
            'label' => __('Text typography', 'cocobasic-elementor'),
            'selector' => '{{WRAPPER}} .portfolio-text',
                ]
        );

        $this->add_control(
                'title_sec_color', [
            'label' => __('Title second line color', 'cocobasic-elementor'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .portfolio-cat' => 'color: {{VALUE}};',
                '{{WRAPPER}} .portfolio-cat:before' => 'background-color: {{VALUE}};',
            ],
                ]
        );

        $this->add_group_control(
                Group_Control_Typography::get_type(), [
            'name' => 'title_sec_typography',
            'label' => __('Title second line typography', 'cocobasic-elementor'),
            'selector' => '{{WRAPPER}} .portfolio-cat',
                ]
        );

        $this->add_control(
                'go_back_background', [
            'label' => __('Go Back Background Color', 'cocobasic-elementor'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .close-icon' => 'background-color: {{VALUE}};',
            ],
                ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
                'section_loadmore_button', [
            'label' => esc_attr__('Load More Button', 'cocobasic-elementor'),
            'tab' => Controls_Manager::TAB_STYLE,
                ]
        );

        $this->add_control(
                'loadmore_text_backgroundcolor', [
            'label' => __('Load more background color', 'cocobasic-elementor'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .more-posts-portfolio-holder' => 'background-color: {{VALUE}};',
            ],
                ]
        );

        $this->add_control(
                'loadmore_text_color', [
            'label' => __('Load more text color', 'cocobasic-elementor'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .more-posts-portfolio' => 'color: {{VALUE}};',
                '{{WRAPPER}} .no-more-posts-portfolio' => 'color: {{VALUE}};',
                '{{WRAPPER}} .more-posts-portfolio-loading' => 'color: {{VALUE}};',
            ],
                ]
        );

        $this->add_control(
                'loadmore_text_hover_color', [
            'label' => __('Load more text hover color', 'cocobasic-elementor'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .more-posts-portfolio:hover' => 'color: {{VALUE}};',
            ],
                ]
        );

        $this->add_group_control(
                Group_Control_Typography::get_type(), [
            'name' => 'loadmore_text_typography',
            'label' => __('Load more typography', 'cocobasic-elementor'),
            'selector' =>
            '{{WRAPPER}} .more-posts-portfolio',
            '{{WRAPPER}} .no-more-posts-portfolio',
            '{{WRAPPER}} .more-posts-portfolio-loading',
                ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();
        require dirname(__FILE__) . '/view.php';
    }

}

$widgets_manager->register_widget_type(new \CocoBasicElements\Widgets\coco_portfolio());
