<?php
/*
 * Register Theme Customizer
 */

add_action('customize_register', 'cocobasic_customize_register');
add_action('customize_controls_enqueue_scripts', 'cocobasic_customize_control_js');

function cocobasic_customize_register($wp_customize) {

    function cocobasic_clean_html($value) {
        $allowed_html_array = cocobasic_allowed_html();
        $value = wp_kses($value, $allowed_html_array);
        return $value;
    }

    function cocobasic_sanitize_select($input, $setting) {
        $input = sanitize_key($input);
        $choices = $setting->manager->get_control($setting->id)->choices;
        return ( array_key_exists($input, $choices) ? $input : $setting->default );
    }

    class Cocobasic_Customize_Textarea_Control extends WP_Customize_Control {

        public $type = 'textarea';

        public function render_content() {
            ?>
            <label>
                <span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
                <textarea rows="5"  <?php $this->link(); ?>><?php echo esc_textarea($this->value()); ?></textarea>
            </label>
            <?php
        }

    }

    //------------------------- MENU SECTION ---------------------------------------------

    $wp_customize->add_section('cocobasic_menu_settings', array(
        'title' => esc_html__('Menu Horizontal Text', 'teoro-wp'),
        'priority' => 30
    ));


    $wp_customize->add_setting('cocobasic_custom_sitetitle', array(
        'default' => '',
        'sanitize_callback' => 'cocobasic_clean_html'
    ));

    $wp_customize->add_control('cocobasic_custom_sitetitle', array(
        'label' => esc_html__('Custom Site Title:', 'teoro-wp'),
        'section' => 'cocobasic_menu_settings',
        'settings' => 'cocobasic_custom_sitetitle'
    ));

    $wp_customize->add_setting('cocobasic_menu_text', array(
        'default' => '',
        'sanitize_callback' => 'cocobasic_clean_html'
    ));

    $wp_customize->add_control(new Cocobasic_Customize_Textarea_Control($wp_customize, 'cocobasic_menu_text', array(
        'label' => esc_html__('Social Text', 'teoro-wp'),
        'section' => 'cocobasic_menu_settings',
        'settings' => 'cocobasic_menu_text'
    )));

    //------------------------- END MENU SECTION ---------------------------------------------
    //
    //    
    //            
    //----------------------------- IMAGE SECTION  ---------------------------------------------

    $wp_customize->add_section('cocobasic_image_section', array(
        'title' => esc_html__('Images Section', 'teoro-wp'),
        'priority' => 33
    ));

    $wp_customize->add_setting('cocobasic_preloader', array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'type' => 'option',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'cocobasic_preloader', array(
        'label' => esc_html__('Preloader Gif', 'teoro-wp'),
        'section' => 'cocobasic_image_section',
        'settings' => 'cocobasic_preloader'
    )));


    $wp_customize->add_setting('cocobasic_preloader_width', array(
        'default' => "50px",
        'sanitize_callback' => 'cocobasic_clean_html'
    ));
    $wp_customize->add_control('cocobasic_preloader_width', array(
        'label' => esc_html__('Preloader Width:', 'teoro-wp'),
        'section' => 'cocobasic_image_section',
        'settings' => 'cocobasic_preloader_width'
    ));

    //----------------------------- END IMAGE SECTION  ---------------------------------------------
    //
    //
    //
    //---------------------------------- COLORS SECTION --------------------

    function cocobasic_get_color_scheme_choices() {
        $color_schemes = cocobasic_get_color_schemes();
        $color_scheme_control_options = array();

        foreach ($color_schemes as $color_scheme => $value) {
            $color_scheme_control_options[$color_scheme] = $value['label'];
        }

        return $color_scheme_control_options;
    }

    function cocobasic_get_color_schemes() {
        return apply_filters('cocobasic_color_schemes', array(
            'demo1' => array(
                'label' => __('Demo 1', 'teoro-wp'),
                'colors' => array(
                    '#1b212c',
                    '#10141B',
                    '#ffffff',
                    '#f393a4',
                    '#ffffff',
                    '#f393a4',
                    '#eae0e9',
                    '#333a48'
                ),
            ),
            'demo2' => array(
                'label' => __('Demo 2', 'teoro-wp'),
                'colors' => array(
                    '#f0deca',
                    '#faeddf',
                    '#7a5932',
                    '#198597',
                    '#7a5932',
                    '#198597',
                    '#f0deca',
                    '#f1dfcd'
                ),
            ),
            'demo3' => array(
                'label' => __('Demo 3', 'teoro-wp'),
                'colors' => array(
                    '#fff4e0',
                    '#fff4e0',
                    '#052123',
                    '#114E53',
                    '#052123',
                    '#114E53',
                    '#052123',
                    '#f5e9d3'
                )
            ),
        ));
    }

    $wp_customize->add_setting('cocobasic_color_scheme_selector', array(
        'default' => 'demo1',
        'sanitize_callback' => 'cocobasic_clean_html',
        'transport' => 'postMessage',
    ));

    $wp_customize->add_control('cocobasic_color_scheme_selector', array(
        'label' => __('Base Color Scheme', 'teoro-wp'),
        'section' => 'colors',
        'type' => 'select',
        'choices' => cocobasic_get_color_scheme_choices(),
        'priority' => 1,
    ));

    $wp_customize->add_setting('cocobasic_preloader_background_color', array(
        'default' => '#1b212c',
        'type' => 'option',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'cocobasic_preloader_background_color', array(
        'label' => esc_html__('Preloader Background Color', 'teoro-wp'),
        'section' => 'colors',
        'settings' => 'cocobasic_preloader_background_color'
    )));


    $wp_customize->add_setting('cocobasic_body_background_color', array(
        'default' => '#10141B',
        'type' => 'option',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'cocobasic_body_background_color', array(
        'label' => esc_html__('Body Background Color', 'teoro-wp'),
        'section' => 'colors',
        'settings' => 'cocobasic_body_background_color'
    )));

    $wp_customize->add_setting('cocobasic_body_color', array(
        'default' => '#ffffff',
        'type' => 'option',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'cocobasic_body_color', array(
        'label' => esc_html__('Body Color', 'teoro-wp'),
        'section' => 'colors',
        'settings' => 'cocobasic_body_color'
    )));


    $wp_customize->add_setting('cocobasic_body_link_color', array(
        'default' => '#f393a4',
        'type' => 'option',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'cocobasic_body_link_color', array(
        'label' => esc_html__('Body Link Color', 'teoro-wp'),
        'section' => 'colors',
        'settings' => 'cocobasic_body_link_color'
    )));


    $wp_customize->add_setting('cocobasic_menu_color', array(
        'default' => '#ffffff',
        'type' => 'option',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'cocobasic_menu_color', array(
        'label' => esc_html__('Menu Color', 'teoro-wp'),
        'section' => 'colors',
        'settings' => 'cocobasic_menu_color'
    )));


    $wp_customize->add_setting('cocobasic_menu_hover_color', array(
        'default' => '#f393a4',
        'type' => 'option',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'cocobasic_menu_hover_color', array(
        'label' => esc_html__('Menu Active Color', 'teoro-wp'),
        'section' => 'colors',
        'settings' => 'cocobasic_menu_hover_color'
    )));


    $wp_customize->add_setting('cocobasic_single_portfolio_background_color', array(
        'default' => '#eae0e9',
        'type' => 'option',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'cocobasic_single_portfolio_background_color', array(
        'label' => esc_html__('Single Portfolio Background Color', 'teoro-wp'),
        'section' => 'colors',
        'settings' => 'cocobasic_single_portfolio_background_color'
    )));


    $wp_customize->add_setting('cocobasic_comments_background_color', array(
        'default' => '#333a48',
        'type' => 'option',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'cocobasic_comments_background_color', array(
        'label' => esc_html__('Comments Background Color', 'teoro-wp'),
        'section' => 'colors',
        'settings' => 'cocobasic_comments_background_color'
    )));


    //---------------------------------------- END COLORS SECTION ------------------------------------------------------
    //
    //
    //
    //---------------------------------- FOOTER SECTION --------------------

    if (function_exists('elementor_fail_php_version')) {

        $wp_customize->add_section('cocobasic_footer_section', array(
            'title' => esc_html__('Footer', 'teoro-wp'),
            'priority' => 99
        ));

        $wp_customize->add_setting('cocobasic_select_footer', array(
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'cocobasic_sanitize_select',
            'default' => '',
        ));


        $wp_customize->add_control('cocobasic_select_footer', array(
            'type' => 'select',
            'section' => 'cocobasic_footer_section',
            'label' => esc_html__('Custom footer layout', 'teoro-wp'),
            'description' => esc_html__('select one of Elementor templates', 'teoro-wp'),
            'choices' => cocobasic_create_elementor_library_list()
        ));
    }


    //---------------------------------------- END FOOTER SECTION ------------------------------------------------------
    //
    //
    //
    //
    //--------------------------------------------------------------------------
    $wp_customize->get_setting('cocobasic_preloader_background_color')->transport = 'postMessage';
    $wp_customize->get_setting('cocobasic_body_background_color')->transport = 'postMessage';
    $wp_customize->get_setting('cocobasic_body_color')->transport = 'postMessage';
    $wp_customize->get_setting('cocobasic_body_link_color')->transport = 'postMessage';
    $wp_customize->get_setting('cocobasic_menu_color')->transport = 'postMessage';
    $wp_customize->get_setting('cocobasic_menu_hover_color')->transport = 'postMessage';
    $wp_customize->get_setting('cocobasic_single_portfolio_background_color')->transport = 'postMessage';
    $wp_customize->get_setting('cocobasic_comments_background_color')->transport = 'postMessage';

    //--------------------------------------------------------------------------
    /*
     * If preview mode is active, hook JavaScript to preview changes
     */
    if ($wp_customize->is_preview() && !is_admin()) {
        add_action('customize_preview_init', 'cocobasic_customize_preview_js');
    }
}

/**
 * Bind Theme Customizer JavaScript
 */
function cocobasic_customize_preview_js() {
    wp_enqueue_script('cocobasic-customizer', get_template_directory_uri() . '/admin/js/custom-admin.js', array('customize-preview'), '', true);
}

function cocobasic_customize_control_js() {
    wp_enqueue_script('color-scheme-control', get_template_directory_uri() . '/admin/js/color-scheme-control.js', array('customize-controls'), '', true);
    wp_localize_script('color-scheme-control', 'colorScheme', cocobasic_get_color_schemes());
}

/*
 * Generate CSS Styles
 */

class Cocobasic_Css {

    public static function cocobasic_theme_customized_style() {
        echo '<style id="cocobasic-customizer-style" type="text/css">' .
        cocobasic_generate_css('body .doc-loader', 'background-color', 'cocobasic_preloader_background_color') .
        cocobasic_generate_css('html body, body .header-left-part, body .menu-holder, body .sm-clean ul', 'background-color', 'cocobasic_body_background_color') .
        cocobasic_generate_css('html body, body h1, body h2, body h3, body h4, body h5, body h6, body .blog-item-holder .entry-title a, body .nav-previous a, body .nav-next a, body #commentform #email, body #commentform #author, body #commentform #comment, body .form-submit input[type=submit], body .wpcf7-form input[type=text], body .wpcf7-form input[type=email], body .wpcf7-form textarea, body .wpcf7-form input[type=submit], body.search .nav-links a, body.archive .nav-links a, body .footer a, body select, body .search-field, body .elementor-element .elementor-widget-container .elementor-icon-wrapper a.elementor-icon', 'color', 'cocobasic_body_color') .
        cocobasic_generate_css('body .more-posts:before, body.single .nav-links:before, body .more-posts-portfolio:before, body .form-submit:before', 'background-color', 'cocobasic_body_color') .
        cocobasic_generate_css('body select, body .search-field:focus', 'border-color', 'cocobasic_body_color') .
        cocobasic_generate_css('body .search-field::-webkit-input-placeholder', 'color', 'cocobasic_body_color') .
        cocobasic_generate_css('body .search-field:-ms-input-placeholder', 'color', 'cocobasic_body_color') .
        cocobasic_generate_css('body .search-field::placeholder', 'color', 'cocobasic_body_color') .
        cocobasic_generate_css('html body a, html body a:hover, body .entry-info a, body .blog-item-holder .entry-title a:hover, body .error-text-404, body .footer a:hover, body .elementor-element .elementor-widget-container .elementor-icon-wrapper a.elementor-icon:hover, body .logged-in-as, body .form-submit input[type=submit]:hover', 'color', 'cocobasic_body_link_color') .
        cocobasic_generate_css('body .home-blog-list h4 a:hover', 'color', 'cocobasic_body_link_color', '', ' !important') .
        cocobasic_generate_css('body blockquote, body .archive-title', 'background-color', 'cocobasic_body_link_color') .
        cocobasic_generate_css('body .sm-clean a, body .menu-social, body .menu-social a, body .site-title', 'color', 'cocobasic_menu_color') .
        cocobasic_generate_css('html body .site-title a', 'color', 'cocobasic_menu_color', '', ' !important') .
        cocobasic_generate_css('body #toggle div', 'background-color', 'cocobasic_menu_color') .
        cocobasic_generate_css('html body .sm-clean a:hover, html body .main-menu.sm-clean .sub-menu li a:hover, html body .sm-clean li.active a, html body .sm-clean li.current-page-ancestor > a, html body .sm-clean li.current_page_ancestor > a, html body .sm-clean li.current_page_item > a, body .menu-social a:hover', 'color', 'cocobasic_menu_hover_color') .
        cocobasic_generate_css('body.single-portfolio .content-holder', 'background-color', 'cocobasic_single_portfolio_background_color') .
        cocobasic_generate_css('body #comments, body .wp-block-file .wp-block-file__button, body .wp-block-button__link, body .img-caption, body .alignfull > figcaption, body .alignfull > .wp-caption-text, body .post-password-form input[type="submit"], body .blog-holder article.sticky, body .wp-block-table.is-style-stripes tbody tr:nth-child(odd), body code, body pre', 'background-color', 'cocobasic_comments_background_color') .
        cocobasic_generate_additional_css() .
        '</style>';
    }

}

/*
 * Generate CSS Class - Helper Method
 */

function cocobasic_generate_css($selector, $style, $mod_name, $prefix = '', $postfix = '') {
    $return = '';
    $mod = get_option($mod_name);
    if (!empty($mod)) {
        $return = sprintf('%s { %s:%s; }', $selector, $style, $prefix . $mod . $postfix);
    }
    return $return;
}

function cocobasic_generate_additional_css() {
    $allowed_html_array = cocobasic_allowed_html();
    $return = '';
    if (get_theme_mod('cocobasic_preloader_width') != ''):
        $return .= 'body .doc-loader img{width: ' . get_theme_mod('cocobasic_preloader_width') . ';}';
    endif;

    if (get_theme_mod('cocobasic_color_scheme_selector') === 'demo3'):
        $return .= 'h1,h2,h3,h4,h5,h6 {font-family: "Prata", serif; font-weight: 400;}';
        $return .= 'body .portfolio-load-content-holder.show {padding: 5% 13%;}';
    endif;

    $return = wp_strip_all_tags($return);
    return $return;
}

function cocobasic_create_elementor_library_list() {
    $listArray = ['' => ''];
    global $post;

    $elementorLoop = new WP_Query(array(
        'post_type' => 'elementor_library',
        'post_status' => 'publish',
        'posts_per_page' => '-1'
    ));

    while ($elementorLoop->have_posts()) : $elementorLoop->the_post();
        $listArray += [ $post->ID => $post->post_name];
    endwhile;

    wp_reset_postdata();
    return $listArray;
}
?>