<?php

namespace CocoBasicElements\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\utils;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class coco_carouselslider extends Widget_Base {

    public function get_name() {
        return 'coco-carouselslider';
    }

    public function get_title() {
        return __('Carousel Slider', 'cocobasic-elementor');
    }

    public function get_icon() {
        return 'fa fa-th';
    }

    public function get_categories() {
        return array('coco-element');
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'section_process_1', [
            'label' => __('Content', 'cocobasic-elementor'),
                ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
                'title', [
            'label' => __('Slide Name', 'cocobasic-elementor'),
            'type' => Controls_Manager::TEXT,
            'label_block' => true,
            'default' => esc_attr__('Slide Name', 'cocobasic-elementor'),
                ]
        );

        $repeater->add_control(
                'img', [
            'label' => esc_html__('Image', 'cocobasic-elementor'),
            'type' => Controls_Manager::MEDIA,
            'default' => [
                'url' => Utils::get_placeholder_image_src(),
            ],
            'label_block' => true,
                ]
        );
        $repeater->add_control(
                'url', [
            'label' => esc_html__('Image Link (optional)', 'cocobasic-elementor'),
            'type' => Controls_Manager::URL,
            'label_block' => true,
            'placeholder' => esc_html__('http://your-link.com', 'cocobasic-elementor'),
                ]
        );

        $repeater->add_control(
                'image_num', [
            'label' => esc_attr__('Image Number', 'cocobasic-elementor'),
            'type' => Controls_Manager::TEXT,
            'label_block' => true,
            'default' => '',
                ]
        );

        $repeater->add_control(
                'image_text', [
            'label' => esc_attr__('Image Text', 'cocobasic-elementor'),
            'type' => Controls_Manager::TEXTAREA,
            'label_block' => true,
            'default' => '',
                ]
        );

        $this->add_control(
                'items', [
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'prevent_empty' => false,
            'default' => [
                [
                    'title' => esc_attr__('Content', 'cocobasic-elementor'),
                ]
            ],
            'title_field' => '{{{ title }}}',
                ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
                'section_process_2', [
            'label' => __('Settings', 'cocobasic-elementor'),
                ]
        );


        $this->add_control(
                'name', [
            'label' => __('Unique Carousel Name', 'cocobasic-elementor'),
            'type' => Controls_Manager::TEXT,
            'label_block' => true,
            'default' => esc_attr__('Carousel-1', 'cocobasic-elementor'),
                ]
        );

        $this->add_control(
                'speed', [
            'label' => __('Speed (ms)', 'cocobasic-elementor'),
            'type' => Controls_Manager::TEXT,
            'label_block' => true,
            'default' => esc_attr__('2000', 'cocobasic-elementor'),
                ]
        );

        $this->add_control(
                'auto_start', [
            'label' => __('Auto Start', 'cocobasic-elementor'),
            'type' => Controls_Manager::SELECT,
            'label_block' => true,
            'options' => [
                'true' => __('True', 'cocobasic-elementor'),
                'false' => __('Fasle', 'cocobasic-elementor'),
            ],
            'default' => 'true',
                ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
                'section_general', [
            'label' => __('General', 'cocobasic-elementor'),
            'tab' => Controls_Manager::TAB_STYLE,
                ]
        );

        $this->add_control(
                'scrollbar_color', [
            'label' => __('Scrollbar Color', 'cocobasic-elementor'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .swiper-scrollbar' => 'background-color: {{VALUE}};',
            ],
                ]
        );

        $this->add_control(
                'scrollbar_drag_color', [
            'label' => __('Scrollbar Drag Color', 'cocobasic-elementor'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .swiper-scrollbar-drag' => 'background-color: {{VALUE}};',
            ],
                ]
        );

        $this->add_control(
                'scrollbar_drag_gap_color', [
            'label' => __('Scrollbar Drag Gap Color', 'cocobasic-elementor'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .swiper-scrollbar-drag' => 'border-color: {{VALUE}};',
            ],
                ]
        );

        $this->add_control(
                'image_number_color', [
            'label' => __('Image Number Color', 'cocobasic-elementor'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .swiper-slide-number' => 'color: {{VALUE}};',
            ],
                ]
        );

        $this->add_group_control(
                Group_Control_Typography::get_type(), [
            'name' => 'image_number_typography',
            'label' => __('Image Number Typography', 'cocobasic-elementor'),
            'selector' => '{{WRAPPER}} .swiper-slide-number',
                ]
        );

        $this->add_control(
                'image_caption_color', [
            'label' => __('Image Text Color', 'cocobasic-elementor'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .swiper-slide-caption-text' => 'color: {{VALUE}};',
            ],
                ]
        );

        $this->add_group_control(
                Group_Control_Typography::get_type(), [
            'name' => 'image_caption_typography',
            'label' => __('Image Text Typography', 'cocobasic-elementor'),
            'selector' => '{{WRAPPER}} .swiper-slide-caption-text',
                ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();
        require dirname(__FILE__) . '/view.php';
    }

    private function content($content) {

        $out = '';

        foreach ($content as $item) {
            $img = $item['img']['id'] ? wp_get_attachment_image($item['img']['id'], '', '', ["class" => "image-slide-img"]) : '';
            $imgNumber = $item['image_num'];
            $imgText = $item['image_text'];
            $url = $item['url']['url'];
            $ext = $item['url']['is_external'];
            $nofollow = $item['url']['nofollow'];
            $url = ( isset($url) && $url ) ? 'href=' . esc_url($url) . '' : '';
            $ext = ( isset($ext) && $ext ) ? 'target= _blank' : '';
            $nofollow = ( isset($url) && $url ) ? 'rel=nofollow' : '';
            $link = $url . ' ' . $ext . ' ' . $nofollow;

            if ($img != ''):
                if ($url != ''):
                    $out .= '<div class="swiper-slide">';
                    $out .= '<div class="swiper-slide-img-holder"><a ' . $link . '>' . $img . '</a></div>';
                    if ($imgNumber !== ''):
                        $out .= '<p class="swiper-slide-number">' . $imgNumber . '</p>';
                    endif;
                    if ($imgText !== ''):
                        $out .= '<p class="swiper-slide-caption-text">' . $imgText . '</p>';
                    endif;
                    $out .= '</div>';
                else:
                    $out .= '<div class="swiper-slide">';
                    $out .= '<div class="swiper-slide-img-holder no-link">' . $img . '</div>';
                    if ($imgNumber !== ''):
                        $out .= '<p class="swiper-slide-number">' . $imgNumber . '</p>';
                    endif;
                    if ($imgText !== ''):
                        $out .= '<p class="swiper-slide-caption-text">' . $imgText . '</p>';
                    endif;
                    $out .= '</div>';
                endif;
            endif;
        }

        return $out;
    }

}

$widgets_manager->register_widget_type(new \CocoBasicElements\Widgets\coco_carouselslider());
